/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.validation.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.OracleHome;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingHome;
import oracle.osysmodel.validation.causes.MissingHost;
import oracle.osysmodel.validation.causes.SharedHomes;
import oracle.osysmodel.validation.rules.BaseRule;

public class HomeNotShared
extends BaseRule {
    String homeType = "crs";
    Logger logger = Logger.getLogger(HomeNotShared.class.getName());
    Map<String, String> descriptionMap = new HashMap<String, String>();

    public HomeNotShared(SystemInstance systemInstance, String string) {
        super(systemInstance);
        this.homeType = string;
        this.successMessage = "Ensures that home of the give home type is not shared.";
        this.descriptionMap.put("crs", "Grid Infrastructure ");
        this.descriptionMap.put("rac", "RAC Database ");
    }

    public RuleResult invoke() throws ConfigValidationException {
        Object object32;
        Object object222;
        this.logger.log(Level.FINE, "Invoking rule to ensure that the homes of the given type are not shared.");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = this.config.getTargetsOfType(OracleHome.class);
        if (list == null || list.isEmpty()) {
            this.logger.log(Level.FINE, "The system instance contains no homes.");
            arrayList.add(new MissingHome(null, BundleUtils.getMessage(HomeNotShared.class, (String)"NO_HOMES_IN_SYSTEM_INSTANCE", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, arrayList);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Object object222 : list) {
            object32 = (OracleHome)object222;
            if (!object32.getHomeType().equals(this.homeType)) continue;
            this.logger.log(Level.FINEST, "Found home of type " + this.homeType + "  at" + object32.getPath());
            arrayList2.add(object32);
        }
        if (arrayList2 == null || arrayList2.isEmpty()) {
            this.logger.log(Level.FINE, "The configuration contains no home of type " + this.homeType);
            arrayList.add(new MissingHome(null, BundleUtils.getMessage(HomeNotShared.class, (String)"NO_GIVEN_HOMETYPE_HOMES_IN_SYSTEM_INSTANCE", (Object[])new Object[]{this.descriptionMap.get(this.homeType)})));
            return new RuleResult((Rule)this, null, arrayList);
        }
        ArrayList arrayList3 = new ArrayList();
        for (Object object32 : arrayList2) {
            List list2 = object32.getHosts();
            if (list2 != null && !list2.isEmpty()) continue;
            this.logger.log(Level.FINE, "Home at path " + object32.getPath() + " doesn't have the host information set.");
            arrayList3.add(object32);
        }
        if (arrayList3 != null && !arrayList3.isEmpty()) {
            arrayList.add(new MissingHost((List)arrayList3, BundleUtils.getMessage(HomeNotShared.class, (String)"MISSING_HOST", (Object[])new Object[]{BundleUtils.makeStringOutOfList((List)arrayList3)})));
            return new RuleResult((Rule)this, null, arrayList);
        }
        object222 = new ArrayList();
        for (OracleHome oracleHome : arrayList2) {
            List list2 = oracleHome.getHosts();
            if (list2.size() == 1) continue;
            this.logger.log(Level.FINE, "Home at path " + oracleHome.getPath() + " is shared.");
            object222.add(oracleHome);
        }
        object32 = new ArrayList();
        if (object222 != null && !object222.isEmpty()) {
            this.logger.log(Level.FINE, "One or more homes in this configuration are shared");
            object32.add(new SharedHomes((List)object222, BundleUtils.getMessage(HomeNotShared.class, (String)"HOMES_SHARED", (Object[])new Object[]{BundleUtils.makeStringOutOfList((List)object222)})));
            return new RuleResult((Rule)this, new Boolean(false), (List)object32);
        }
        return new RuleResult((Rule)this);
    }
}

