/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.validation;

import java.util.List;
import oracle.osysmodel.validation.Cause;
import oracle.osysmodel.validation.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleResult {
    public Boolean passed = false;
    public List<Cause> failureCauses = null;
    public List<Cause> nullCauses = null;
    public String message = null;

    public RuleResult(Rule rule, Boolean bl, List<Cause> list, List<Cause> list2) {
        this.passed = bl;
        this.failureCauses = list;
        this.nullCauses = list2;
        this.message = rule.getSuccessMessage();
    }

    public RuleResult(Rule rule) {
        this.passed = true;
        this.message = rule.getSuccessMessage();
    }

    public RuleResult(Rule rule, Boolean bl, List<Cause> list) {
        this.passed = bl;
        this.message = rule.getSuccessMessage();
        if (bl == null) {
            this.nullCauses = list;
        } else if (!bl.booleanValue()) {
            this.failureCauses = list;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.message).append(" :: " + this.passed);
        if (this.nullCauses != null && this.nullCauses.size() != 0) {
            for (Cause cause : this.nullCauses) {
                stringBuffer.append("          " + cause);
            }
        }
        if (this.failureCauses != null && this.failureCauses.size() != 0) {
            for (Cause cause : this.failureCauses) {
                stringBuffer.append("          " + cause);
            }
        }
        return stringBuffer.toString();
    }

    public Boolean getPassed() {
        return this.passed;
    }

    public List<? extends Cause> getFailureCauses() {
        return this.failureCauses;
    }

    public List<? extends Cause> getMissingDataCauses() {
        return this.nullCauses;
    }
}

