/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.rest.GavcSearchResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/vnd.org.jfrog.artifactory.search.GavcSearchResult+json"})
public class SearchGavcSearchResult
implements MessageBodyReader<GavcSearchResult> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.artifactory.search.GavcSearchResult+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public GavcSearchResult readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        return (GavcSearchResult)mapper.readValue(baos.toByteArray(), GavcSearchResultImpl.class);
    }

    public static class GavcSearchResultImpl
    extends HashMap
    implements GavcSearchResult {
        private Map<Artifact, Map> _artifactMap;

        @Override
        public List<Map> getResults() {
            return (List)this.get("results");
        }

        @Override
        public Map<Artifact, Map> getArtifactMap() {
            if (this._artifactMap == null) {
                this._artifactMap = new HashMap<Artifact, Map>();
                List<Map> results = this.getResults();
                if (results != null && !results.isEmpty()) {
                    for (Map result : results) {
                        try {
                            Artifact artifact = DependencyManagementHelper.getArtifactFromPath((String)result.get("path"));
                            if (artifact == null) continue;
                            this._artifactMap.put(artifact, result);
                        }
                        catch (DependencyManagementException e) {
                            throw new IllegalStateException("Unable to process result " + result, e);
                        }
                    }
                }
            }
            return this._artifactMap;
        }

        @Override
        public Set<Artifact> getArtifacts() {
            return new HashSet<Artifact>(this.getArtifactMap().keySet());
        }

        @Override
        public String toString() {
            return "" + this.getResults();
        }
    }
}

