/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.rest.PromotionRequest;
import com.oracle.cie.rest.PromotionResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/vnd.org.jfrog.artifactory.build.PromotionRequest+json"})
@Consumes(value={"application/vnd.org.jfrog.artifactory.build.PromotionResult+json"})
public class BuildPromotionRequest
implements MessageBodyWriter<PromotionRequest>,
MessageBodyReader<PromotionResult> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.artifactory.build.PromotionRequest+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public long getSize(PromotionRequest promotionRequest, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(PromotionRequest promotionRequest, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> stringObjectMultivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        mapper.writeValue(outputStream, (Object)promotionRequest);
    }

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.artifactory.build.PromotionResult+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public PromotionResult readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        return (PromotionResult)mapper.readValue(baos.toByteArray(), PromotionResultImpl.class);
    }

    public static class PromotionResultImpl
    extends HashMap
    implements PromotionResult {
        @Override
        public List<PromotionResult.Message> getMessages() {
            ArrayList<PromotionResult.Message> messages = new ArrayList<PromotionResult.Message>();
            List msgs = (List)this.get("messages");
            if (msgs != null) {
                for (Map m : msgs) {
                    String level = (String)m.get("level");
                    String message = (String)m.get("message");
                    messages.add(new MessageImpl(level, message));
                }
            }
            return messages;
        }

        @Override
        public String toString() {
            return "" + this.getMessages();
        }

        public class MessageImpl
        implements PromotionResult.Message {
            private String _level;
            private String _message;

            public MessageImpl(String level, String message) {
                this._level = level;
                this._message = message;
            }

            @Override
            public String getLevel() {
                return this._level;
            }

            @Override
            public String getMessage() {
                return this._message;
            }

            public String toString() {
                return this.getLevel() + " : " + this.getMessage();
            }
        }
    }

    public static class PromotionRequestImpl
    extends HashMap
    implements PromotionRequest {
        @Override
        public void setTargetRepo(String targetRepo) {
            if (!StringUtil.isNullOrEmpty((String)targetRepo, (boolean)true)) {
                this.put("targetRepo", targetRepo);
            }
        }

        @Override
        public void setSourceRepo(String sourceRepo) {
            if (!StringUtil.isNullOrEmpty((String)sourceRepo, (boolean)true)) {
                this.put("sourceRepo", sourceRepo);
            }
        }

        @Override
        public void setStatus(String status) {
            if (!StringUtil.isNullOrEmpty((String)status, (boolean)true)) {
                this.put("status", status);
            }
        }

        @Override
        public void setComment(String comment) {
            if (!StringUtil.isNullOrEmpty((String)comment, (boolean)true)) {
                this.put("comment", comment);
            }
        }

        @Override
        public void setDryRun(boolean dryRun) {
            this.put("dryRun", dryRun);
        }

        @Override
        public void setCopy(boolean copy) {
            this.put("copy", copy);
        }

        @Override
        public void setProperties(Properties properties) {
            if (properties != null && !properties.isEmpty()) {
                HashMap props = new HashMap();
                for (String name : properties.stringPropertyNames()) {
                    ArrayList<String> valueList = new ArrayList<String>();
                    valueList.add(properties.getProperty(name));
                    props.put(name, valueList);
                }
                this.put("properties", props);
            }
        }
    }
}

