/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.rest.Builds;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/vnd.org.jfrog.build.Builds+json"})
public class BuildBuilds
implements MessageBodyReader<Builds> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.build.Builds+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public Builds readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        return (Builds)mapper.readValue(baos.toByteArray(), BuildsImpl.class);
    }

    public static class BuildsImpl
    extends HashMap
    implements Builds {
        private String _uri;
        private Collection<String> _buildNames;

        @Override
        public String getURI() {
            Object o;
            if (this._uri == null && (o = this.get("uri")) instanceof String) {
                this._uri = (String)o;
            }
            return this._uri;
        }

        @Override
        public Collection<String> getBuildNames() {
            if (this._buildNames == null) {
                this._buildNames = new ArrayList<String>();
                Object o = this.get("builds");
                if (o instanceof List) {
                    List builds = (List)o;
                    for (Map buildsMap : builds) {
                        String uri = (String)buildsMap.get("uri");
                        if (uri == null) continue;
                        if (uri.startsWith("/")) {
                            uri = uri.substring(1);
                        }
                        this._buildNames.add(uri);
                    }
                }
            }
            return this._buildNames;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("uri:").append(this.getURI());
            buf.append(", builds:").append(this.getBuildNames());
            return buf.toString();
        }
    }
}

