/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.Wildcard;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyFileHandler;
import com.oracle.cie.dependency.mgmt.DependencyFileHandlerCallBack;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.rest.ChecksumSearchResult;
import com.oracle.cie.rest.FileInfo;
import com.oracle.cie.rest.FolderInfo;
import com.oracle.cie.rest.GavcSearchResult;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import com.oracle.cie.rest.RestHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestHelperImpl
implements RestHelper {
    private static final Logger _log = Logger.getLogger(RestHelperImpl.class.getName());
    private RestHandler _restHandler;
    private boolean _useFolderInfo = Boolean.getBoolean("RestHelper.use.folder.info.versions");
    private boolean _useGavcSearch = Boolean.getBoolean("RestHelper.use.gavc.versions");
    private String _versionWildcardSuffix = System.getProperty("RestHelper.version.wildcard.suffix", "-*");

    public RestHelperImpl(RestHandler restHandler) {
        this._restHandler = restHandler;
    }

    @Override
    public RestHandler getRestHandler() {
        return this._restHandler;
    }

    @Override
    public Version getLatestVersion(Repository[] repositories, String groupId, String artifactName, String baseVersion, String type) throws RestException, IOException {
        return this.getLatestVersion(repositories, groupId, artifactName, baseVersion, type, null);
    }

    @Override
    public Version getLatestVersion(Collection<Repository> repositories, String groupId, String artifactName, String baseVersion, String type) throws RestException, IOException {
        return this.getLatestVersion(this.getRepositoryList(repositories, null), groupId, artifactName, baseVersion, type, null, null);
    }

    @Override
    public Version getLatestVersionWithPropertyValue(Collection<Repository> repositories, String groupId, String artifactName, String baseVersion, String type, String propertyName, String propertyValue) throws RestException, IOException {
        return this.getLatestVersionWithPropertyValue(this.getRepositoryArray(repositories), groupId, artifactName, baseVersion, type, null, null, propertyName, propertyValue);
    }

    @Override
    public Version getLatestVersionWithPropertyValue(Repository[] repositories, String groupId, String artifactName, String baseVersion, String type, String classifier, String qualifier, String propertyName, String propertyValue) throws RestException, IOException {
        ArrayList<String> propertyValues = null;
        if (propertyValue != null) {
            propertyValues = new ArrayList<String>();
            propertyValues.add(propertyValue);
        }
        return this.getLatestVersionWithPropertyValue(repositories, groupId, artifactName, baseVersion, type, classifier, qualifier, propertyName, propertyValues);
    }

    @Override
    public Version getLatestVersionWithPropertyValue(Collection<Repository> repositories, String groupId, String artifactName, String baseVersion, String type, String propertyName, List<String> propertyValues) throws RestException, IOException {
        return this.getLatestVersionWithPropertyValue(this.getRepositoryArray(repositories), groupId, artifactName, baseVersion, type, null, null, propertyName, propertyValues);
    }

    @Override
    public Version getLatestVersion(Collection<Repository> repositories, Repository localCacheRepository, String groupId, String artifactName, String baseVersion, String type) throws RestException, IOException {
        return this.getLatestVersion(this.getRepositoryList(repositories, localCacheRepository), groupId, artifactName, baseVersion, type, null, null);
    }

    @Override
    public Version getLatestVersion(Repository[] repositories, String groupId, String artifactName, String baseVersion, String type, String qualifier) throws RestException, IOException {
        return this.getLatestVersion(repositories, groupId, artifactName, baseVersion, type, null, qualifier);
    }

    @Override
    public Version getLatestVersion(Repository[] repositories, String groupId, String artifactName, String baseVersion, String type, String classifier, String qualifier) throws RestException, IOException {
        List<Repository> repositoryList = repositories != null ? Arrays.asList(repositories) : null;
        return this.getLatestVersion(repositoryList, groupId, artifactName, baseVersion, type, classifier, qualifier);
    }

    public Version getLatestVersion(List<Repository> repositories, String groupId, String artifactName, String baseVersion, String type, String classifier, String qualifier) throws RestException, IOException {
        if (!this._useFolderInfo && !this._useGavcSearch && StringUtil.isNullOrEmpty((String)type, (boolean)true)) {
            return this._restHandler.latestVersionSearch(groupId, artifactName, this.getWildcardVersionString(baseVersion, qualifier), repositories);
        }
        Version[] versions = this.getVersionsArray(repositories, groupId, artifactName, baseVersion, qualifier);
        if (versions != null && versions.length > 0) {
            if (!StringUtil.isNullOrEmpty((String)type, (boolean)true)) {
                for (int x = versions.length - 1; x >= 0; --x) {
                    Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(groupId, artifactName, versions[x], type);
                    if (!StringUtil.isNullOrEmpty((String)classifier, (boolean)true)) {
                        artifact.setClassifier(classifier);
                    }
                    if (!this._restHandler.artifactExists(artifact, repositories)) continue;
                    return versions[x];
                }
            } else {
                return versions[versions.length - 1];
            }
        }
        return null;
    }

    @Override
    public Version getLatestVersionWithPropertyValue(Repository[] repositories, String groupId, String artifactName, String baseVersion, String type, String classifier, String qualifier, String propertyName, List<String> propertyValues) throws RestException, IOException {
        Version[] versions = this.getVersionsArray(repositories, groupId, artifactName, baseVersion, qualifier);
        if (versions != null && versions.length > 0) {
            if (!StringUtil.isNullOrEmpty((String)type, (boolean)true)) {
                List<Repository> repositoryList = Arrays.asList(repositories);
                for (int x = versions.length - 1; x >= 0; --x) {
                    Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(groupId, artifactName, versions[x], type);
                    if (!StringUtil.isNullOrEmpty((String)classifier, (boolean)true)) {
                        artifact.setClassifier(classifier);
                    }
                    if (!StringUtil.isNullOrEmpty((String)propertyName)) {
                        Properties properties = this._restHandler.getArtifactProperties(artifact, repositoryList);
                        if (properties == null) continue;
                        String value = properties.getProperty(propertyName);
                        if ((propertyValues != null || value != null) && (propertyValues == null || !propertyValues.contains(value))) continue;
                        return versions[x];
                    }
                    if (!this._restHandler.artifactExists(artifact, repositoryList)) continue;
                    return versions[x];
                }
            } else {
                return versions[versions.length - 1];
            }
        }
        return null;
    }

    @Override
    public Version getLatestVersion(Collection<Repository> repositories, String groupId, String artifactName, String baseVersion, String type, String qualifier) throws RestException, IOException {
        return this.getLatestVersion(this.getRepositoryList(repositories, null), groupId, artifactName, baseVersion, type, null, qualifier);
    }

    @Override
    public Version getLatestVersion(Collection<Repository> repositories, Repository localCacheRepository, String groupId, String artifactName, String baseVersion, String type, String qualifier) throws RestException, IOException {
        return this.getLatestVersion(this.getRepositoryList(repositories, localCacheRepository), groupId, artifactName, baseVersion, type, null, qualifier);
    }

    private List<Repository> getRepositoryList(Collection<Repository> repositories, Repository localCacheRepository) {
        ArrayList<Repository> repositoryList = new ArrayList<Repository>();
        if (localCacheRepository != null) {
            repositoryList.add(localCacheRepository);
        }
        if (repositories != null) {
            repositoryList.addAll(repositories);
        }
        return repositoryList;
    }

    private String getWildcardVersionString(String baseVersion, String qualifier) {
        String version = "";
        if (!StringUtil.isNullOrEmpty((String)baseVersion, (boolean)true)) {
            version = version + baseVersion.trim();
        }
        if (!StringUtil.isNullOrEmpty((String)qualifier, (boolean)true)) {
            if (version.isEmpty()) {
                version = version + "*";
            }
            version = version + "-" + qualifier.trim();
        }
        if (!version.isEmpty()) {
            return version + this._versionWildcardSuffix.trim();
        }
        return null;
    }

    @Override
    public Collection<Version> getVersions(Repository[] repositories, String groupId, String artifactName, String baseVersion) throws RestException, IOException {
        return this.getVersions(repositories, groupId, artifactName, baseVersion, null);
    }

    @Override
    public Collection<Version> getVersions(Collection<Repository> repositories, String groupId, String artifactName, String baseVersion) throws RestException, IOException {
        return this.getVersions(this.getRepositoryArray(repositories), groupId, artifactName, baseVersion);
    }

    @Override
    public Collection<Version> getVersions(Repository[] repositories, String groupId, String artifactName, String baseVersion, String qualifier) throws RestException, IOException {
        TreeSet<Version> versions;
        String version = this.getWildcardVersionString(baseVersion, qualifier);
        if (this._useGavcSearch) {
            versions = new TreeSet();
            for (Repository repository : repositories) {
                Set<Artifact> artifacts;
                if (!this._restHandler.repositoryExists(repository)) continue;
                GavcSearchResult gavcSearchResult = this._restHandler.gavcSearch(groupId, artifactName, version, null, repository, repository.getType().isVirtual());
                Set<Artifact> set = artifacts = gavcSearchResult != null ? gavcSearchResult.getArtifacts() : null;
                if (artifacts == null) continue;
                for (Artifact artifact : artifacts) {
                    versions.add(artifact.getVersion());
                }
            }
        } else if (this._useFolderInfo) {
            versions = new TreeSet();
            for (Repository repository : repositories) {
                versions.addAll(RestHelperImpl.getVersionsUsingFolderInfo(this._restHandler, repository, groupId, artifactName, version));
            }
        } else {
            versions = this._restHandler.artifactVersionsSearch(groupId, artifactName, version, repositories != null ? Arrays.asList(repositories) : null, false);
        }
        return versions;
    }

    public static Collection<Version> getVersionsUsingFolderInfo(RestHandler restHandler, Repository repository, String groupId, String artifactName, String version) throws RestException, IOException {
        TreeSet<Version> versions;
        block3: {
            version = version != null ? version.trim() : null;
            versions = new TreeSet<Version>();
            try {
                List<String> repoVersions;
                String repoPath = RestFactory.getRestHandlerConfig(repository.getRestHandlerType()).getGroupIdPath(groupId) + "/" + RestFactory.getRestHandlerConfig(repository.getRestHandlerType()).getArtifactId(artifactName);
                FolderInfo folderInfo = restHandler.getFolderInfo(repository, repoPath);
                List<String> list = repoVersions = folderInfo != null ? folderInfo.getFolders() : null;
                if (repoVersions != null && !repoVersions.isEmpty()) {
                    versions.addAll(RestHelperImpl.getFilteredVersions(repoVersions, version));
                }
            }
            catch (RestException e) {
                if (!_log.isLoggable(Level.FINE)) break block3;
                _log.fine("Unable to get versions info for " + groupId + ":" + artifactName + " from repository " + repository);
            }
        }
        return versions;
    }

    @Override
    public Collection<Version> getVersions(Collection<Repository> repositories, String groupId, String artifactName, String baseVersion, String qualifier) throws RestException, IOException {
        return this.getVersions(this.getRepositoryArray(repositories), groupId, artifactName, baseVersion, qualifier);
    }

    @Override
    public Version[] getVersionsArray(Repository[] repositories, String groupId, String artifactName, String baseVersion) throws RestException, IOException {
        return this.getVersionsArray(repositories, groupId, artifactName, baseVersion, null);
    }

    @Override
    public Version[] getVersionsArray(Collection<Repository> repositories, String groupId, String artifactName, String baseVersion) throws RestException, IOException {
        return this.getVersionsArray(this.getRepositoryArray(repositories), groupId, artifactName, baseVersion);
    }

    @Override
    public Version[] getVersionsArray(Repository[] repositories, String groupId, String artifactName, String baseVersion, String qualifier) throws RestException, IOException {
        Collection<Version> versions = this.getVersions(repositories, groupId, artifactName, baseVersion, qualifier);
        return versions.toArray(new Version[versions.size()]);
    }

    @Override
    public Version[] getVersionsArray(Collection<Repository> repositories, String groupId, String artifactName, String baseVersion, String qualifier) throws RestException, IOException {
        return this.getVersionsArray(this.getRepositoryArray(repositories), groupId, artifactName, baseVersion, qualifier);
    }

    @Override
    public List<Module> getModulesTransitively(Module baseModule, List<Repository> repositories) throws IOException, DependencyManagementException, RestException {
        ArrayList<Module> baseModules = new ArrayList<Module>();
        baseModules.add(baseModule);
        return this.getModulesTransitively(baseModules, repositories);
    }

    @Override
    public List<Module> getModulesTransitively(List<Module> baseModules, List<Repository> repositories) throws IOException, DependencyManagementException, RestException {
        return this.getModulesTransitively(baseModules, repositories, null, null);
    }

    @Override
    public List<Module> getModulesTransitively(Module baseModule, List<Repository> repositories, Collection<String> groupIds, Collection<String> types) throws IOException, DependencyManagementException, RestException {
        ArrayList<Module> baseModules = new ArrayList<Module>();
        baseModules.add(baseModule);
        return this.getModulesTransitively(baseModules, repositories, groupIds, types);
    }

    @Override
    public List<Module> getModulesTransitively(List<Module> baseModules, List<Repository> repositories, Collection<String> groupIds, Collection<String> types) throws IOException, DependencyManagementException, RestException {
        return this.getModulesTransitively(baseModules, repositories, groupIds, types, null, true);
    }

    private List<Module> getModulesTransitively(List<Module> baseModules, List<Repository> repositories, Collection<String> groupIds, Collection<String> types, List<Artifact> moduleArtifacts, boolean recursive) throws IOException, DependencyManagementException, RestException {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (baseModules != null && !baseModules.isEmpty()) {
            if (moduleArtifacts == null) {
                moduleArtifacts = new ArrayList<Artifact>();
            }
            for (Module overrideModule : baseModules) {
                moduleArtifacts.add(overrideModule.getArtifact());
            }
            if (types == null) {
                types = new ArrayList<String>();
            }
            if (types.isEmpty()) {
                types.add(DependencyFileType.pom.name());
                types.add(DependencyFileType.ivy.name());
            }
            for (Module baseModule : baseModules) {
                List<Dependency> dependencies = baseModule.getDependencies();
                if (dependencies == null || dependencies.isEmpty()) continue;
                ArrayList<Module> transitiveModules = new ArrayList<Module>();
                for (Dependency dependency : dependencies) {
                    if (!this.isModuleDependency(dependency, types) || groupIds != null && !groupIds.contains(dependency.getGroup()) || moduleArtifacts.contains(dependency)) continue;
                    File f = this.getRestHandler().retrieveArtifact((Artifact)dependency, repositories, true);
                    DependencyFileType type = DependencyManagementHelper.detectDependencyFileType(f);
                    DependencyFileHandler fileHandler = DependencyManagementFactory.getInstance().getDependencyFileHandler(type);
                    transitiveModules.add(fileHandler.readDependenciesFile(f));
                }
                if (transitiveModules.isEmpty()) continue;
                modules.addAll(transitiveModules);
                if (!recursive) continue;
                modules.addAll(this.getModulesTransitively(transitiveModules, repositories, groupIds, types, moduleArtifacts, recursive));
            }
        }
        return modules;
    }

    private boolean isModuleDependency(Dependency dependency, Collection<String> types) {
        if (types == null) {
            types = new ArrayList<String>();
        }
        if (types.isEmpty()) {
            types.add(DependencyFileType.pom.name());
            types.add(DependencyFileType.ivy.name());
        }
        return types.contains(dependency.getType()) && (!DependencyFileType.pom.name().equals(dependency.getType()) || "import".equals(dependency.getScope()));
    }

    @Override
    public List<Dependency> getTransitiveDependencies(List<File> baseModuleFiles, List<Repository> repositories) throws IOException, DependencyManagementException, RestException {
        return this.getTransitiveDependencies(baseModuleFiles, repositories, false);
    }

    @Override
    public List<Dependency> getTransitiveDependencies(List<File> baseModuleFiles, List<Repository> repositories, boolean includeBaseModules) throws IOException, DependencyManagementException, RestException {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (baseModuleFiles != null && !baseModuleFiles.isEmpty()) {
            for (File baseModuleFile : baseModuleFiles) {
                dependencies.addAll(this.getTransitiveDependencies(baseModuleFile, repositories, includeBaseModules));
            }
        }
        return dependencies;
    }

    @Override
    public List<Dependency> getTransitiveDependencies(File baseModuleFile, List<Repository> repositories) throws IOException, DependencyManagementException, RestException {
        return this.getTransitiveDependencies(baseModuleFile, repositories, false);
    }

    @Override
    public List<Dependency> getTransitiveDependencies(File baseModuleFile, List<Repository> repositories, boolean includeBaseModules) throws IOException, DependencyManagementException, RestException {
        return this.getTransitiveDependencies(baseModuleFile, null, repositories, null, includeBaseModules);
    }

    public List<Dependency> getTransitiveDependencies(File baseModuleFile, Dependency referencingDependency, List<Repository> repositories, Collection<Artifact> cyclicCheck, boolean includeBaseModules) throws IOException, DependencyManagementException, RestException {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (baseModuleFile != null) {
            Module parentModule;
            if (!baseModuleFile.exists()) {
                throw new FileNotFoundException("The module file specified does not exist " + baseModuleFile);
            }
            DependencyFileType type = DependencyManagementHelper.detectDependencyFileType(baseModuleFile);
            if (type == null) {
                throw new RestException("Failed to determine dependencyRepositoryReleaseVersionResolver file type for " + baseModuleFile);
            }
            DependencyFileHandler fileHandler = DependencyManagementFactory.getInstance().getDependencyFileHandler(type);
            DependencyFileHandlerCallBackImpl callBack = new DependencyFileHandlerCallBackImpl(baseModuleFile, repositories, fileHandler);
            Module module = fileHandler.readDependenciesFile(baseModuleFile, (DependencyFileHandlerCallBack)callBack);
            module.setReferencingDependency(referencingDependency);
            if (includeBaseModules) {
                dependencies.add(DependencyManagementFactory.getInstance().getDependency(module.getArtifact()));
            }
            if (cyclicCheck == null) {
                cyclicCheck = new ArrayList<Artifact>();
            }
            cyclicCheck.add(module.getArtifact());
            List<Dependency> deps = module.getDependencies();
            if (deps != null) {
                for (Dependency dependency : deps) {
                    if (this.isModuleDependency(dependency, null)) {
                        if (cyclicCheck.contains(dependency)) continue;
                        dependencies.addAll(this.getTransitiveDependencies(this.getRestHandler().retrieveArtifact((Artifact)dependency, repositories, true), dependency, repositories, cyclicCheck, includeBaseModules));
                        continue;
                    }
                    dependencies.add(dependency);
                }
            }
            if ((parentModule = module.getParent()) != null) {
                cyclicCheck.add(parentModule.getArtifact());
                ArrayList<Module> parentModules = new ArrayList<Module>();
                while (parentModule != null) {
                    deps = parentModule.getDependencies();
                    if (deps != null) {
                        for (Dependency dependency : deps) {
                            if (this.isModuleDependency(dependency, null)) {
                                if (cyclicCheck.contains(dependency)) continue;
                                dependencies.addAll(this.getTransitiveDependencies(this.getRestHandler().retrieveArtifact((Artifact)dependency, repositories, true), dependency, repositories, cyclicCheck, includeBaseModules));
                                continue;
                            }
                            dependencies.add(dependency);
                        }
                    }
                    parentModules.add(parentModule);
                    if ((parentModule = parentModule.getParent()) == null || !parentModules.contains(parentModule)) continue;
                    break;
                }
            }
        }
        return dependencies;
    }

    private static List<Version> getFilteredVersions(List<String> repoVersions, String version) {
        ArrayList<Version> versions = new ArrayList<Version>();
        if (repoVersions != null && !repoVersions.isEmpty()) {
            Wildcard wildcard = !StringUtil.isNullOrEmpty((String)version) ? new Wildcard(version) : null;
            for (String repoVersion : repoVersions) {
                if (repoVersion == null || repoVersion.isEmpty() || !Character.isDigit(repoVersion.charAt(0))) {
                    if (!_log.isLoggable(Level.FINEST)) continue;
                    _log.finest("Skipping folder from list which is not a version string " + repoVersion);
                    continue;
                }
                Version filteredVersion = RestHelperImpl.getFilteredVersion(repoVersion, wildcard);
                if (filteredVersion == null) continue;
                versions.add(filteredVersion);
            }
        }
        return versions;
    }

    private static Version getFilteredVersion(String version, Wildcard wildcard) {
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            return null;
        }
        Version v = RestHelperImpl.getVersion(version);
        if (v == null) {
            return null;
        }
        if (wildcard != null && !wildcard.matches(v.getVersion())) {
            return null;
        }
        return v;
    }

    private static Version getVersion(String f) {
        try {
            Version v = DependencyManagementFactory.getInstance().getVersion(f);
            Version test = DependencyManagementFactory.getInstance().getVersion(v.getBaseVersion(), "1", "2");
            test.compareTo(v);
            return v;
        }
        catch (NumberFormatException nfe) {
            if (_log.isLoggable(Level.FINE)) {
                _log.fine("Invalid version string : " + f + "  " + nfe.getLocalizedMessage());
            }
            return null;
        }
    }

    private Repository[] getRepositoryArray(Collection<Repository> repositories) {
        int size = repositories != null ? repositories.size() : 0;
        Repository[] repositoryArray = new Repository[size];
        if (repositories != null) {
            repositories.toArray(repositoryArray);
        }
        return repositoryArray;
    }

    @Override
    public Repository getLocalRepository(Artifact artifact, FileInfo fileInfo, String repoRegex) throws RestException {
        return this.getLocalRepository(artifact, fileInfo, true, repoRegex);
    }

    @Override
    public Repository getLocalRepository(Artifact artifact, FileInfo fileInfo, boolean deterministically, String repoRegex) throws RestException {
        Repository repository = fileInfo.getRepository();
        if (repository == null) {
            throw new RestException("The FileInfo [" + fileInfo + "] did have its source Repository was not set.");
        }
        if (!this.getRestHandler().repositoryExists(repository)) {
            throw new RestException("Unable to get local repository for artifact [" + artifact + "] because the repository [" + repository + "] could not be found.");
        }
        if (repository.getType().isVirtual()) {
            Map<String, String> uriToRepoMap;
            ChecksumSearchResult result = this.getRestHandler().checksumSearch(fileInfo.getChecksum(), fileInfo.getRepository());
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Found artifacts [" + result + "] matching checksum for file info [" + fileInfo + "]");
            }
            if (result == null || (uriToRepoMap = result.getUriToRepoMap()).isEmpty()) {
                throw new RestException("Unable to find any artifacts matching checksum in file info [" + fileInfo + "]");
            }
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Found " + uriToRepoMap.size() + " artifacts matching checksum for file info [" + fileInfo + "]");
            }
            String artifactPath = artifact.getRepoPath();
            for (String uri : new HashSet<String>(uriToRepoMap.keySet())) {
                if (!uri.endsWith(artifactPath)) {
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Filtering unmatched checksum artifact [" + uri + "] since its path did not match the artifact's path [" + artifactPath + "]");
                    }
                    uriToRepoMap.remove(uri);
                    continue;
                }
                if (StringUtil.isNullOrEmpty((String)repoRegex, (boolean)true) || uriToRepoMap.get(uri).matches(repoRegex)) continue;
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Filtering artifact [" + uri + "] since its repository did not match the specified repository regex [" + repoRegex + "]");
                }
                uriToRepoMap.remove(uri);
            }
            if (uriToRepoMap.isEmpty()) {
                throw new RestException("Unable to locate any unfiltered artifacts with matching checksum and matching artifact path for artifact [" + artifact + "] file info [" + fileInfo + "]");
            }
            if (deterministically && uriToRepoMap.size() > 1) {
                throw new RestException("Unable to find local repository deterministically for artifact at virtual repository uri [" + fileInfo.getDownloadUri() + "] unfiltered local repository uris [" + uriToRepoMap + "]");
            }
            String repoName = uriToRepoMap.get(uriToRepoMap.keySet().iterator().next());
            String originalURL = repository.getURL().toString();
            String newURL = originalURL.substring(0, originalURL.lastIndexOf("/") + 1) + repoName;
            repository = RestFactory.getRepository(null, newURL, repository.getUsername(), repository.getPassword());
        }
        return repository;
    }

    @Override
    public Collection<Dependency> findDependencies(Artifact moduleArtifact, List<Repository> repositories, String group, String name, String baseVersion, String type, String classifier, String ... qualifiers) throws RestException {
        File moduleFile;
        if (moduleArtifact == null) {
            throw new RestException("The module artifact provided was null.");
        }
        try {
            moduleFile = RestFactory.getRestHandler().retrieveArtifact(moduleArtifact, repositories, true);
        }
        catch (Exception e) {
            throw new RestException("Failed to retrieve module " + moduleArtifact, e);
        }
        return this.findDependencies(moduleFile, repositories, group, name, baseVersion, type, classifier, qualifiers);
    }

    @Override
    public Collection<Dependency> findDependencies(File moduleFile, List<Repository> repositories, String group, String name, String baseVersion, String type, String classifier, String ... qualifiers) throws RestException {
        Module module;
        if (moduleFile == null) {
            throw new RestException("The module file provided was null.");
        }
        try {
            DependencyFileType dependencyFileType = DependencyManagementHelper.detectDependencyFileType(moduleFile);
            module = DependencyManagementFactory.getInstance().getDependencyFileHandler(dependencyFileType).readDependenciesFile(moduleFile);
        }
        catch (Exception e) {
            throw new RestException("Failed to load module " + moduleFile, e);
        }
        return this.findDependencies(module, repositories, group, name, baseVersion, type, classifier, qualifiers);
    }

    @Override
    public Collection<Dependency> findDependencies(Module module, List<Repository> repositories, String group, String name, String baseVersion, String type, String classifier, String ... qualifiers) throws RestException {
        List<Module> modules;
        if (module == null) {
            throw new RestException("The module provided was null.");
        }
        try {
            modules = this.getModulesTransitively(module, repositories);
        }
        catch (Exception e) {
            throw new RestException("Failed to get modules transitively.", e);
        }
        if (modules == null) {
            modules = new ArrayList<Module>();
        }
        modules.add(module);
        return DependencyManagementHelper.getFilteredDependencies(modules, group, name, baseVersion, type, classifier, qualifiers);
    }

    class DependencyFileHandlerCallBackImpl
    implements DependencyFileHandlerCallBack {
        private File _baseModuleFile;
        private List<Repository> _repositories;
        private DependencyFileHandler _dependencyFileHandler;

        DependencyFileHandlerCallBackImpl(File baseModuleFile, List<Repository> repositories, DependencyFileHandler dependencyFileHandler) {
            this._baseModuleFile = baseModuleFile;
            this._repositories = repositories;
            this._dependencyFileHandler = dependencyFileHandler;
        }

        @Override
        public Module loadParentModule(String groupId, String artifactId, String version, String relativePath) throws IOException, DependencyManagementException {
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Loading parent module groupId [" + groupId + "] artifactId [" + artifactId + "] version [" + version + "] relativePath [" + relativePath + "] for file [" + this._baseModuleFile + "]");
            }
            if (StringUtil.isNullOrEmpty((String)groupId, (boolean)true)) {
                throw new DependencyManagementException("The parent group id value was not defined in file " + this._baseModuleFile);
            }
            if (StringUtil.isNullOrEmpty((String)artifactId, (boolean)true)) {
                throw new DependencyManagementException("The parent artifact id value was not defined in file " + this._baseModuleFile);
            }
            if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                throw new DependencyManagementException("The parent version value was not defined in file " + this._baseModuleFile);
            }
            File parentFile = null;
            if (!StringUtil.isNullOrEmpty((String)relativePath, (boolean)true)) {
                parentFile = new File(this._baseModuleFile.getParentFile(), relativePath);
            }
            if (parentFile == null || !parentFile.exists()) {
                Artifact parentArtifact = DependencyManagementFactory.getInstance().getArtifact(groupId, artifactId, version, this._dependencyFileHandler.getType().name());
                try {
                    parentFile = RestHelperImpl.this.getRestHandler().retrieveArtifact(parentArtifact, this._repositories, true);
                }
                catch (RestException e) {
                    throw new DependencyManagementException("Failed to retrieve parent artifact " + parentArtifact, e);
                }
            }
            return this._dependencyFileHandler.readDependenciesFile(parentFile, (DependencyFileHandlerCallBack)new DependencyFileHandlerCallBackImpl(parentFile, this._repositories, this._dependencyFileHandler));
        }
    }
}

