/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.impl;

import com.oracle.cie.rest.impl.DownloadProgressStatusHolder;
import com.oracle.cie.rest.impl.RestConnectionConfig;
import com.oracle.cie.rest.impl.RestConnectionProxy;
import com.oracle.cie.rest.impl.RestQuery;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestConnection {
    private static final Logger _log = Logger.getLogger(RestConnection.class.getName());
    private static Client _client;
    private static RestConnection _instance;

    private RestConnection() {
    }

    public static RestConnection getInstance() {
        if (_instance == null) {
            _instance = new RestConnection();
            _client = Client.create();
            _client.setConnectTimeout(Integer.valueOf(60000));
        }
        return _instance;
    }

    private void updateConfiguration(RestConnectionConfig config) {
        _client.addFilter((ClientFilter)new HTTPBasicAuthFilter(config.getUserName(), config.getUserPassword()));
        if (config.isProxyEnabled()) {
            ProxySelector.setDefault(new RestConnectionProxy(config.getProxyHost(), config.getProxyPort()));
            if (config.isProxyAuthenticationEnabled()) {
                Authenticator.setDefault(new BasicAuthenticator(config.getUserProxy(), config.getUserPasswordProxy()));
            }
        }
    }

    private InputStream executeRequest(String urlString) {
        InputStream responseResult = null;
        WebResource resource = _client.resource(urlString);
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            responseResult = response.getEntityInputStream();
        } else {
            _log.warning("Unsuccesful HTTP response: " + response.getClientResponseStatus().getStatusCode() + " " + response.getClientResponseStatus().getReasonPhrase() + "/nwhile attempting to access to the resource " + resource.getURI().toString());
        }
        return responseResult;
    }

    public InputStream getInputstream(RestQuery query, RestConnectionConfig config) {
        this.updateConfiguration(config);
        return this.executeRequest(query.toString());
    }

    public void downloadFiles(Map<RestQuery, String> restQueries, RestConnectionConfig config, DownloadProgressStatusHolder progressHolder) throws Exception {
        this.updateConfiguration(config);
        for (Map.Entry<RestQuery, String> entry : restQueries.entrySet()) {
            this.downloadFile(entry.getKey(), entry.getValue(), config, progressHolder);
        }
    }

    public String downloadFile(RestQuery query, String fileName, RestConnectionConfig config, DownloadProgressStatusHolder progressHolder) throws Exception {
        this.updateConfiguration(config);
        File downloadLoc = new File(config.getDownloadLocation());
        if (!downloadLoc.exists()) {
            downloadLoc.mkdirs();
        }
        String filePath = config.getDownloadLocation() + File.separatorChar + fileName;
        InputStream responseResult = this.executeRequest(query.toString());
        if (responseResult == null) {
            progressHolder.setStatus(5);
            throw new Exception("Unable to retrieve the resource " + query.toString());
        }
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Starting download " + fileName);
        }
        try {
            this.copy(responseResult, filePath, progressHolder);
        }
        catch (Exception e) {
            _log.throwing("RestConnection", "downloadFile", e);
            throw e;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Donwload Completed - > " + fileName);
        }
        return filePath;
    }

    private void copy(InputStream is, String filePath, DownloadProgressStatusHolder progressHolder) throws Exception {
        FileOutputStream output = null;
        int BUFFER_SIZE = 4096;
        byte[] buffer = new byte[4096];
        try {
            int count;
            output = new FileOutputStream(filePath);
            while (-1 != (count = is.read(buffer, 0, 4096))) {
                output.write(buffer, 0, count);
                progressHolder.addBytesDownloaded(count);
            }
            output.flush();
        }
        catch (Exception e) {
            progressHolder.setStatus(4);
            _log.throwing("RestConnection", "copy", e);
            throw e;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class BasicAuthenticator
    extends Authenticator {
        String _baName;
        String _baPassword;

        private BasicAuthenticator(String baName, String baPassword) {
            this._baName = baName;
            this._baPassword = baPassword;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            _log.finest("Generating PasswordAuthentitcation for proxy authentication");
            return new PasswordAuthentication(this._baName, this._baPassword.toCharArray());
        }
    }
}

