/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.remote;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.CommonSshConnectionHandlerImpl;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.SshRemoteConnectionHost;
import java.net.InetSocketAddress;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.eclipse.jgit.internal.transport.sshd.proxy.HttpClientConnector;

public class SshUserEquivalenceConnHandlerImpl
extends CommonSshConnectionHandlerImpl {
    private static final Logger _logger = Logger.getLogger(SshUserEquivalenceConnHandlerImpl.class.getName());

    @Override
    public String getType() {
        return "sshuserequivalence";
    }

    @Override
    public void connect() throws RemoteConnectionException {
        if (!this.isConnected()) {
            SshRemoteConnectionHost hostInfo = (SshRemoteConnectionHost)this.getHost();
            try {
                Logger.getLogger("org.apache.sshd.common").setUseParentHandlers(false);
                this._sshClient = SshClient.setUpDefaultClient();
                this._sshClient.setKeyIdentityProvider((KeyIdentityProvider)new FileKeyPairProvider(Arrays.asList(Paths.get(hostInfo.getSSHPrivateKeyLocation(), new String[0]))));
                String userName = hostInfo.getUsername();
                if (StringUtil.isNullOrEmpty((String)userName)) {
                    userName = System.getProperty("user.name");
                    _logger.info("Using default user i.e. user.name=" + userName + " for connection.");
                }
                String host = hostInfo.getHost();
                int port = hostInfo.getPort() == null ? 22 : hostInfo.getPort();
                String proxyHost = hostInfo.getProxyHost();
                int proxyPort = hostInfo.getProxyPort() == null ? 80 : hostInfo.getProxyPort();
                this._sshClient.start();
                this._clientSession = (ClientSession)((ConnectFuture)this._sshClient.connect(userName, host, port).verify(7L, TimeUnit.SECONDS, new CancelOption[]{CancelOption.CANCEL_ON_TIMEOUT})).getSession();
                if (!StringUtil.isNullOrEmpty((String)proxyHost, (boolean)true)) {
                    InetSocketAddress proxyAddress = new InetSocketAddress(hostInfo.getProxyHost(), proxyPort);
                    InetSocketAddress remoteAddress = new InetSocketAddress(host, port);
                    HttpClientConnector proxyConnector = new HttpClientConnector(proxyAddress, remoteAddress);
                    this._clientSession.setClientProxyConnector((ClientProxyConnector)proxyConnector);
                }
                this._clientSession.auth().verify(11L, TimeUnit.SECONDS, new CancelOption[]{CancelOption.CANCEL_ON_TIMEOUT});
            }
            catch (Exception e) {
                throw new RemoteConnectionException("Failed to connect to remote host " + this.getHost(), e);
            }
        }
    }
}

