/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import com.oracle.cie.common.util.logging.Destination;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.logging.LogFilePermissionHandler;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogPostProcessor
extends Thread {
    private Map<String, Destination> destinationMap;
    private Properties props;

    public LogPostProcessor(Map<String, Destination> destinationMap, Properties props) {
        this.destinationMap = destinationMap;
        this.props = props;
    }

    @Override
    public void run() {
        if (this.destinationMap != null) {
            for (Destination dest : this.destinationMap.values()) {
                if (dest.getDestType() != Destination.DestinationType.file) continue;
                LogFactory.addLogRecord(new LogRecord(Level.FINE, "Checking whether to restore the ownership/permission of log file :" + dest.getDestName()));
                LogFilePermissionHandler.changeOwnership(dest.getDestName());
                LogFilePermissionHandler.changePermission(dest.getDestName(), this.props);
            }
        }
        LogFactory.printLogs();
    }
}

