/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import com.oracle.cie.common.util.logging.EnvironmentUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.logging.LogStringUtil;
import com.oracle.cie.common.util.logging.UnixLogFilePermissionHandler;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFilePermissionHandler {
    public static void changePermission(String filepath, Properties props) {
        if (EnvironmentUtil.getOsName() == EnvironmentUtil.OsName.LINUX) {
            String propValue = props.getProperty("UNIX_LOG_DIR_PERMISSION");
            String permission = LogStringUtil.isEmpty(propValue) ? "750" : propValue;
            String parent = new File(filepath).getParent();
            LogFactory.addLogRecord(new LogRecord(Level.FINE, "Changing the log file's parent dir " + parent + " permission to " + permission));
            UnixLogFilePermissionHandler.changePermission(parent, permission);
            propValue = props.getProperty("UNIX_LOG_FILE_PERMISSION");
            permission = LogStringUtil.isEmpty(propValue) ? "640" : propValue;
            LogFactory.addLogRecord(new LogRecord(Level.FINE, "Changing the log file " + filepath + " permission to " + permission));
            UnixLogFilePermissionHandler.changePermission(filepath, permission);
        }
    }

    public static void changeOwnership(String filepath) {
        if (EnvironmentUtil.getOsName() == EnvironmentUtil.OsName.LINUX) {
            String parent = new File(filepath).getParent();
            LogFactory.addLogRecord(new LogRecord(Level.FINE, "Checking whether to restore the ownership of log file's parent dir " + parent));
            UnixLogFilePermissionHandler.changeOwnership(parent);
            LogFactory.addLogRecord(new LogRecord(Level.FINE, "Checking whether to restore the ownership of log file " + filepath));
            UnixLogFilePermissionHandler.changeOwnership(filepath);
        }
    }
}

