/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import com.oracle.cie.common.logging.xml.ConsoleDestinationType;
import com.oracle.cie.common.logging.xml.FileDestinationType;
import com.oracle.cie.common.logging.xml.OutputType;
import com.oracle.cie.common.util.logging.BasicFormatter;
import com.oracle.cie.common.util.logging.DefaultFormatter;
import com.oracle.cie.common.util.logging.EnvironmentUtil;
import com.oracle.cie.common.util.logging.Jdk14LogLevelMapper;
import com.oracle.cie.common.util.logging.LogConfigurationException;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.logging.LogPropertySubstitutor;
import com.oracle.cie.common.util.logging.SystemOutConsoleHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class Destination {
    public static final String ODL_ENABLED = "oracle.cie.logging.useodl";
    private static Formatter _formatter;
    private static Map<String, Handler> _handlerCache;
    private static final String OLD_LOG_ENCODING = "UTF-8";
    private String _destName;
    private DestinationType _destType;
    private String _level;
    private OutputStream _outputStream = null;
    private static final boolean _debug;

    public static Destination createNullDestination() {
        return new Destination(null, DestinationType.nullType);
    }

    public static Destination createSystemErrDestination() {
        return new Destination(null, DestinationType.syserr);
    }

    public static Destination createSystemOutDestination() {
        return new Destination(null, DestinationType.sysout);
    }

    public static Destination createOutputStreamDestination(String name, OutputStream os) {
        return new Destination(name, os, DestinationType.outputStream);
    }

    public static Destination createFileDestination(String fileName) {
        return new Destination(fileName, DestinationType.file);
    }

    protected Destination(String destName, DestinationType destType) {
        this(destName, null, destType);
    }

    public Destination(String destName, OutputStream os, DestinationType destType) {
        this._destName = destName;
        this._destType = destType;
        this._outputStream = os;
    }

    public String getDestName() {
        return this._destName;
    }

    public DestinationType getDestType() {
        return this._destType;
    }

    public OutputStream getOutputStream() {
        return this._outputStream;
    }

    public String getLevel() {
        return this._level;
    }

    public static Destination createDestination(com.oracle.cie.common.logging.xml.DestinationType dType, LogPropertySubstitutor substiutor, String defaultLogger) {
        Destination destination = null;
        ConsoleDestinationType cType = dType.getConsoleBased();
        if (cType != null) {
            OutputType outType = cType.getOutputType();
            switch (outType) {
                case SYSERR: {
                    destination = Destination.createSystemErrDestination();
                    break;
                }
                case SYSOUT: {
                    destination = Destination.createSystemOutDestination();
                    break;
                }
                case NULL: {
                    destination = Destination.createNullDestination();
                }
            }
        } else {
            FileDestinationType fType = dType.getFileBased();
            if (fType != null) {
                destination = Destination.createFileDestination(substiutor.substitute(fType.getPath()), defaultLogger);
            }
        }
        if (destination != null && dType.getLevel() != null) {
            destination.setLevel(dType.getLevel().name());
        }
        return destination;
    }

    public void setLevel(String level) {
        this._level = level;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this._destType != null ? this._destType._type : -1) {
            case 1: {
                sb.append("FILE [").append(this._destName).append("]");
                break;
            }
            case 2: {
                sb.append("SYSERR");
                break;
            }
            case 4: {
                sb.append("SYSOUT");
                break;
            }
            case 8: {
                sb.append("NULL");
                break;
            }
            case 16: {
                sb.append("OutputStream[").append(this._destName).append("]");
                break;
            }
            default: {
                sb.append("UNKNOWN");
            }
        }
        return sb.toString();
    }

    public static Destination createDefaultDestination(Properties properties) {
        Destination dest = null;
        String fullFileName = properties.getProperty("oracle.cie.log.default.location");
        if (fullFileName != null && (fullFileName.endsWith(File.separator) || fullFileName.endsWith("\\") || fullFileName.endsWith("/"))) {
            fullFileName = fullFileName + properties.getProperty("oracle.cie.log.appid");
        }
        if ((dest = Destination.createFileDestination(fullFileName, null)) == null) {
            Destination.createFileDestination(fullFileName, null);
        }
        if (dest == null) {
            dest = Destination.createNullDestination();
        }
        return dest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Destination createFileDestination(String fileLoc, String logName) {
        File logFile;
        block14: {
            if (_debug) {
                LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: about to create file destination. Location =" + fileLoc));
            }
            if (fileLoc == null || fileLoc.length() == 0) {
                return null;
            }
            logFile = new File(fileLoc);
            try {
                logFile = logFile.getCanonicalFile();
            }
            catch (Exception ignore) {
                logFile = logFile.getAbsoluteFile();
            }
            if (!logFile.isFile()) {
                File parent;
                if (fileLoc.endsWith(File.separator) || logFile.isDirectory()) {
                    logFile = new File(logFile, logName == null ? "cie.log" : logName);
                }
                if ((parent = logFile.getParentFile()) != null && !parent.isDirectory() && !parent.mkdirs()) {
                    LogFactory.addLogRecord(new LogRecord(Level.WARNING, "WARNING - Unable to create log file parent directory <" + parent + ">."));
                    return null;
                }
                try {
                    if (!logFile.createNewFile()) {
                        if (!logFile.isFile()) {
                            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "WARNING - Unable to create log file <" + fileLoc + ">."));
                            return null;
                        }
                        if (!logFile.canWrite()) {
                            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "WARNING - The log file <" + logFile + "> is not writable."));
                            return null;
                        }
                    }
                    break block14;
                }
                catch (IOException iox) {
                    LogFactory.addLogRecord(new LogRecord(Level.WARNING, "WARNING - Unable to create log file <" + fileLoc + ">: " + iox));
                    return null;
                }
            }
            if (!logFile.canWrite()) {
                LogFactory.addLogRecord(new LogRecord(Level.WARNING, "WARNING - The default log file <" + logFile + "> is not writable."));
                return null;
            }
        }
        if (_debug) {
            LogFactory.addLogRecord(new LogRecord(Level.INFO, " creating file destination =" + logFile.getName() + " " + logFile.getPath()));
        }
        return Destination.createFileDestination(logFile.getPath());
    }

    public static void addDestination(Logger logger, Destination dest) throws LogConfigurationException {
        Handler handler;
        if (dest == null) {
            return;
        }
        if (_debug) {
            LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: adding destination logger= " + logger.getName() + " logger-level= " + logger.getLevel() + " destination= " + dest.getDestName() + ", dest-level= " + dest.getLevel()));
        }
        switch (dest.getDestType().getType()) {
            case 8: {
                handler = null;
                break;
            }
            case 4: {
                handler = _handlerCache.get("Destination.DestinationType.SYSOUT");
                if (handler != null) break;
                handler = new SystemOutConsoleHandler();
                _handlerCache.put("Destination.DestinationType.SYSOUT", handler);
                break;
            }
            case 2: {
                handler = _handlerCache.get("Destination.DestinationType.SYSERR");
                if (handler != null) break;
                handler = new ConsoleHandler();
                _handlerCache.put("Destination.DestinationType.SYSERR", handler);
                break;
            }
            case 16: {
                String destinationName = dest.getDestName();
                handler = _handlerCache.get(destinationName);
                if (handler != null) break;
                handler = new StreamHandler(dest.getOutputStream(), new BasicFormatter());
                _handlerCache.put(destinationName, handler);
                break;
            }
            case 1: {
                String fileName = dest.getDestName();
                if (fileName == null || "".equals(fileName)) {
                    throw new LogConfigurationException("Log appender filename not provided!");
                }
                try {
                    handler = _handlerCache.get(fileName);
                    if (handler != null) break;
                    handler = Destination.getFileHandler(fileName);
                    _handlerCache.put(fileName, handler);
                    break;
                }
                catch (Exception e) {
                    throw new LogConfigurationException("Unable to instantiate FileHandler", e);
                }
            }
            default: {
                throw new LogConfigurationException("Unsupported DestinationType" + dest.getDestType().getType());
            }
        }
        logger.setUseParentHandlers(false);
        if (handler == null) {
            Handler[] handlers = logger.getHandlers();
            if (handlers != null) {
                for (Handler h : handlers) {
                    logger.removeHandler(h);
                }
            }
        } else {
            handler.setFormatter(Destination.getFormatter());
            handler.setLevel(Jdk14LogLevelMapper.mapToJdkLevel(dest.getLevel(), Level.ALL));
            logger.addHandler(handler);
            if (_debug) {
                LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: adding handler with level= " + handler.getLevel() + " to logger=" + logger.getName() + ", logger-level" + logger.getLevel()));
            }
        }
    }

    public static Handler getFileHandler(String fileName) throws LogConfigurationException {
        if (EnvironmentUtil.isODLPresent()) {
            try {
                Class<?> odlFormatterClass = Class.forName("oracle.core.ojdl.ODLTextFormatter");
                Object odlFormatter = odlFormatterClass.newInstance();
                Class<?> odlHandlerClass = Class.forName("oracle.core.ojdl.logging.ODLHandler");
                Constructor<?> constructor = odlHandlerClass.getConstructor(odlFormatter.getClass().getInterfaces()[0], String.class, String.class);
                return (Handler)constructor.newInstance(odlFormatter, fileName, OLD_LOG_ENCODING);
            }
            catch (Exception e) {
                throw new LogConfigurationException("Unable to create ODL handler", e);
            }
        }
        try {
            FileHandler newFileHandler = new FileHandler(fileName);
            ((Handler)newFileHandler).setEncoding(OLD_LOG_ENCODING);
            return newFileHandler;
        }
        catch (IOException e) {
            throw new LogConfigurationException("Unable to create file handler", e);
        }
    }

    public static boolean isConsoleBased(String destinationName) {
        return (destinationName = destinationName.toLowerCase()).equalsIgnoreCase(OutputType.SYSERR.value()) || destinationName.equalsIgnoreCase(OutputType.SYSOUT.value()) || destinationName.equalsIgnoreCase(OutputType.NULL.value());
    }

    private static Formatter getFormatter() throws LogConfigurationException {
        if (_formatter == null) {
            if (EnvironmentUtil.isODLPresent()) {
                try {
                    Class<?> odlFormatterClass = Class.forName("oracle.core.ojdl.logging.ODLFormatter");
                    _formatter = (Formatter)odlFormatterClass.newInstance();
                }
                catch (Exception e) {
                    throw new LogConfigurationException("Unable to create ODL formatter", e);
                }
            } else {
                _formatter = new DefaultFormatter();
            }
        }
        return _formatter;
    }

    static {
        _handlerCache = new HashMap<String, Handler>();
        _debug = EnvironmentUtil.isDebugMode();
    }

    public static class DestinationType {
        public static final int FILE = 1;
        public static final int SYSERR = 2;
        public static final int SYSOUT = 4;
        public static final int NULLTYPE = 8;
        public static final int OUTPUTSTREAM = 16;
        private static final int UNKNOWN = -1;
        public static final DestinationType file = new DestinationType(1);
        public static final DestinationType outputStream = new DestinationType(16);
        public static final DestinationType syserr = new DestinationType(2);
        public static final DestinationType sysout = new DestinationType(4);
        public static final DestinationType nullType = new DestinationType(8);
        private int _type;

        private DestinationType(int type) {
            this._type = type;
        }

        public int getType() {
            return this._type;
        }
    }
}

