/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.samlp;

import java.util.Date;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLMessage;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ResponseType
extends SAMLMessage {
    private static final String[] nsURIs = new String[]{"http://www.w3.org/2000/09/xmldsig#"};
    private static final String[] localNames = new String[]{"Signature"};
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;

    protected ResponseType(Element element) throws DOMException {
        super(element);
    }

    protected ResponseType(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected ResponseType(Document owner, String uri, String localName) throws DOMException {
        super(owner, uri, localName);
        this.setVersion(1, 0);
    }

    public void setResponseID(String responseID) {
        this.setAttribute("ResponseID", responseID);
    }

    public String getResponseID() {
        if (this.hasAttribute("ResponseID")) {
            return this.getAttribute("ResponseID");
        }
        return null;
    }

    public void setInResponseTo(String inResponseTo) {
        this.setAttribute("InResponseTo", inResponseTo);
    }

    public String getInResponseTo() {
        if (this.hasAttribute("InResponseTo")) {
            return this.getAttribute("InResponseTo");
        }
        return null;
    }

    public void setIssueInstant(Date issueInstant) {
        this.setAttribute("IssueInstant", XMLUtils.formatDateTime((Date)issueInstant));
    }

    public Date getIssueInstant() {
        if (this.hasAttribute("IssueInstant")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("IssueInstant"));
        }
        return null;
    }

    public void setRecipient(String uri) {
        this.setAttribute("Recipient", uri);
    }

    public String getRecipient() {
        if (this.hasAttribute("Recipient")) {
            return this.getAttribute("Recipient");
        }
        return null;
    }

    @Override
    protected String[] getNSURIsPrecedeDSig() {
        return new String[0];
    }

    @Override
    protected String[] getLocalNamesPrecedeDSig() {
        return new String[0];
    }

    @Override
    protected String getID() {
        if (this.getMajorVersion() == 1 && this.getMinorVersion() == 0) {
            return null;
        }
        return this.getResponseID();
    }

    static {
        SAMLInitializer.initialize();
    }
}

