/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.VerifyException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.dsig.XSReference;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.dsig.XSSignedInfo;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLUtils;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SAMLMessage
extends XMLElement {
    protected SAMLMessage(Element element) throws DOMException {
        this(element, null);
    }

    protected SAMLMessage(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected SAMLMessage(Document owner, String uri, String localName) throws DOMException {
        super(owner, uri, localName);
    }

    public static SAMLMessage getInstance(Element element, String ns) throws DOMException {
        return (SAMLMessage)XMLUtils.getInstance((Element)element, null, (String)ns);
    }

    public void setVersion(int major, int minor) throws DOMException {
        this.setAttribute("MajorVersion", Integer.toString(major));
        this.setAttribute("MinorVersion", Integer.toString(minor));
    }

    public int getMajorVersion() {
        if (this.hasAttribute("MajorVersion")) {
            return Integer.parseInt(this.getAttribute("MajorVersion"));
        }
        return -1;
    }

    public int getMinorVersion() {
        if (this.hasAttribute("MinorVersion")) {
            return Integer.parseInt(this.getAttribute("MinorVersion"));
        }
        return -1;
    }

    protected abstract String[] getNSURIsPrecedeDSig();

    protected abstract String[] getLocalNamesPrecedeDSig();

    public XSSignature getSignature() {
        return (XSSignature)SAMLUtils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    public boolean isSigned() {
        return SAMLUtils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "Signature") != null;
    }

    public void sign(PrivateKey privateKey, X509Certificate cert) throws SigningException {
        this.sign(privateKey, cert, "http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    public void sign(String signatureMethod, PrivateKey privateKey, X509Certificate cert) throws SigningException {
        String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";
        if (signatureMethod == "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") {
            digestMethod = "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        this.sign(signatureMethod, digestMethod, privateKey, cert, "http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    public void sign(String signatureMethod, String digestMethod, PrivateKey privateKey, X509Certificate cert, String c14nMethod) throws SigningException {
        try {
            XSSignature sig = this.addSignature(signatureMethod, c14nMethod, digestMethod);
            if (cert != null) {
                XSKeyInfo ki = sig.createKeyInfo();
                ki.addKeyInfoData((XMLElement)ki.createX509Data(cert));
                sig.setKeyInfo(ki);
            }
            sig.sign(privateKey, null);
        }
        catch (TransformationException ex) {
            throw new SigningException(ex.toString());
        }
    }

    public void sign(PrivateKey privateKey, X509Certificate cert, String c14nMethod) throws SigningException {
        try {
            String keyAlgorithm = privateKey.getAlgorithm();
            String signatureMethod = null;
            if ("RSA".equals(keyAlgorithm)) {
                signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else if ("DSA".equals(keyAlgorithm)) {
                signatureMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else {
                throw new SigningException("Unsupported key algorithm.");
            }
            XSSignature sig = this.addSignature(signatureMethod, c14nMethod);
            if (cert != null) {
                XSKeyInfo ki = sig.createKeyInfo();
                ki.addKeyInfoData((XMLElement)ki.createX509Data(cert));
                sig.setKeyInfo(ki);
            }
            sig.sign(privateKey, null);
        }
        catch (TransformationException ex) {
            throw new SigningException(ex.toString());
        }
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod) {
        return this.addSignature(signatureMethod, c14nMethod, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) {
        this.clearSignature();
        XSSignature sig = XSSignature.newInstance((Document)this.getOwnerDocument(), null);
        XMLUtils.insertChild((XMLElement)this, (XMLElement)sig, (String[])this.getNSURIsPrecedeDSig(), (String[])this.getLocalNamesPrecedeDSig(), (int)(this.getLocalNamesPrecedeDSig().length - 1));
        XSSignedInfo si = sig.createSignedInfo(c14nMethod, signatureMethod, null);
        sig.setSignedInfo(si);
        XSReference ref = sig.createReference();
        ref.setDigestMethod(digestMethod);
        if (this.getID() != null && this.getID().length() != 0) {
            ref.setURI("#" + this.getID());
        } else {
            ref.setURI("");
        }
        si.addReference(ref);
        if (this.getID() == null || this.getID().length() == 0) {
            String nsURI = this.getNamespaceURI();
            String prefix = this.getPrefix();
            if (prefix == null && nsURI != null) {
                prefix = XMLElement.getDefaultNSPrefix((String)nsURI);
            }
            String elemName = (prefix != null ? prefix + ":" : "") + this.getLocalName();
            String expr = "count(ancestor-or-self::" + elemName + " | here()/ancestor::" + elemName + "[1]) = count(ancestor-or-self::" + elemName + ")";
            XSAlgorithmIdentifier xpath = sig.createXPathTransform(prefix, nsURI, expr);
            ref.addTransform(xpath);
        }
        XSAlgorithmIdentifier est = sig.createTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        ref.addTransform(est);
        if (!"http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(c14nMethod)) {
            XSAlgorithmIdentifier c14nTrans = sig.createTransform(c14nMethod);
            ref.addTransform(c14nTrans);
        }
        return sig;
    }

    public boolean verify() throws VerifyException {
        return this.verify(null);
    }

    public boolean verify(PublicKey publicKey) throws VerifyException {
        XSSignature sig = this.getSignature();
        if (sig == null) {
            throw new VerifyException("The message is not signed");
        }
        if (publicKey != null) {
            return sig.verify(publicKey, true);
        }
        return sig.verify(true);
    }

    protected void clearSignature() {
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
    }

    protected abstract String getID();

    static {
        SAMLInitializer.initialize();
    }
}

