/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.utils.JavaHomeHelper;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class JDKQueryUtils {
    private static final Logger _logger = Logger.getLogger(JDKQueryUtils.class.getName());
    private static Map<Path, JDKQueryUtils> _instances = new HashMap<Path, JDKQueryUtils>();
    private InstallerWrapper _installer;
    private String _javaLoc = null;
    private Path _oracleHomeLoc = null;
    private Map<String, String> _systemProperties = null;
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_VENDOR = "java.vendor";
    public static final String JAVA_ARCH = "java.arch";
    public static final String OS_NAME = "os.name";

    public static JDKQueryUtils getInstance(InstallerWrapper installer, String javaHome) throws GdrException {
        return JDKQueryUtils.getInstance(null, installer, javaHome);
    }

    public static JDKQueryUtils getInstance(String oracleHome, InstallerWrapper installer, String javaHome) throws GdrException {
        Path homePath;
        if (oracleHome != null) {
            homePath = NioHelper.getInstance().getPath(oracleHome, new String[0]);
        } else {
            if (installer == null) {
                throw new GdrException("Failed to create JDKQueryUtils instance since both oracleHome and installer were null.");
            }
            homePath = installer.getHome().getHomePath();
        }
        homePath = homePath.normalize();
        JDKQueryUtils instance = _instances.get(homePath);
        if (instance == null) {
            instance = new JDKQueryUtils(homePath, installer, javaHome);
            _instances.put(homePath, instance);
        }
        return instance;
    }

    public JDKQueryUtils(Path oracleHome, InstallerWrapper installer, String javaHome) throws GdrException {
        this._oracleHomeLoc = oracleHome;
        this._installer = installer;
        this.loadJVMInfo(javaHome);
    }

    protected void loadJVMInfo(String javaHome) throws GdrException {
        try {
            this.loadJDKHome(javaHome);
        }
        catch (Exception e) {
            throw new GdrException((Throwable)e);
        }
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        this._systemProperties = runtimeBean.getSystemProperties();
    }

    public String getJavaLoc() throws GdrException {
        return this._javaLoc;
    }

    public String getProperty(String property) throws GdrException {
        if (this._oracleHomeLoc != null) {
            if (this._systemProperties != null && !this._systemProperties.isEmpty()) {
                if (!StringUtil.isNullOrEmpty((String)property)) {
                    if (property.equalsIgnoreCase(JAVA_HOME)) {
                        return this.getJavaLoc();
                    }
                    if (property.equalsIgnoreCase(JAVA_VENDOR)) {
                        String javaVendor = null;
                        String vendor = this._systemProperties.get(property);
                        if (vendor != null) {
                            if ((vendor = vendor.toLowerCase()).contains("sun")) {
                                javaVendor = "Sun";
                            } else if (vendor.contains("oracle")) {
                                javaVendor = "Oracle";
                            } else if (vendor.contains("ibm")) {
                                javaVendor = "IBM";
                            } else if (vendor.contains("hp") || vendor.contains("hewlett")) {
                                javaVendor = "HP";
                            }
                        }
                        return javaVendor;
                    }
                    if (property.equalsIgnoreCase(JAVA_ARCH)) {
                        return this._systemProperties.get("sun.arch.data.model");
                    }
                    return this._systemProperties.get(property);
                }
                _logger.finest("Requested property \"" + property + "\" is null or empty");
            } else {
                _logger.finest("System properties are null or empty");
            }
        } else {
            _logger.finest("Oracle Home location is null or empty");
        }
        return null;
    }

    private void loadJDKHome(String javaHome) throws IOException, GdrException, DataHandlerException {
        Set<FeatureSet> features;
        HashMap<String, String> javaHomes = new HashMap<String, String>();
        if (!StringUtil.isNullOrEmpty((String)javaHome, (boolean)true)) {
            if (JavaHomeHelper.isJdkHome((String)(javaHome = JDKQueryUtils.getCanonicalPath(javaHome).toString()))) {
                javaHomes.put("jdk", javaHome);
            } else if (JavaHomeHelper.isJreHome((String)javaHome)) {
                javaHomes.put("jre", javaHome);
            }
        }
        if (javaHomes.isEmpty() && this._oracleHomeLoc != null && this._installer != null && (features = this._installer.getSelectedFeatures()) != null && !features.isEmpty()) {
            for (FeatureSet feature : features) {
                Set<Component> components = this._installer.getComponents(feature);
                if (components == null || components.isEmpty()) continue;
                block1: for (Component component : components) {
                    List<FileMap> fileMaps;
                    String stupidHardCodedDirectoryInTheComponent;
                    int index;
                    String name;
                    String type = component.getType();
                    if (type == null && (name = component.getName()) != null && (index = name.lastIndexOf(".")) > -1 && name.length() > index + 1) {
                        type = name.substring(index + 1);
                    }
                    if (StringUtil.isNullOrEmpty((String)type)) continue;
                    if ((type = type.toLowerCase()).equals("jrockit")) {
                        stupidHardCodedDirectoryInTheComponent = "jrockit";
                    } else if (type.equals("jre")) {
                        stupidHardCodedDirectoryInTheComponent = "jdk" + File.separator + "jre";
                    } else {
                        if (!type.equals("jdk")) continue;
                        stupidHardCodedDirectoryInTheComponent = "jdk";
                    }
                    if ((fileMaps = component.getFileMaps()) == null || fileMaps.isEmpty()) continue;
                    for (FileMap fileMap : fileMaps) {
                        Collection<String> dirs;
                        String symbol;
                        if (!fileMap.isPackaged() || (symbol = fileMap.getSymbol()) == null || (dirs = DistributionHelper.getInstance().getRootDirsForSymbol(this._installer.getDistribution().getDirectoryMap(), symbol)) == null || dirs.isEmpty()) continue;
                        String dir = dirs.iterator().next();
                        Path fileJava = this._oracleHomeLoc.resolve(dir + File.separator + stupidHardCodedDirectoryInTheComponent);
                        Path realPath = JDKQueryUtils.getCanonicalPath(fileJava);
                        if (Files.exists(realPath, new LinkOption[0])) {
                            _logger.finest("Found " + type + " in " + realPath);
                        } else {
                            _logger.finest("Java home found but does not exist: " + realPath);
                        }
                        javaHomes.put(type, realPath.toString());
                        continue block1;
                    }
                }
            }
        }
        if (javaHomes.containsKey("jdk")) {
            this._javaLoc = (String)javaHomes.get("jdk");
        } else if (javaHomes.containsKey("jrockit")) {
            this._javaLoc = (String)javaHomes.get("jrockit");
        } else if (javaHomes.containsKey("jre")) {
            this._javaLoc = (String)javaHomes.get("jre");
        } else {
            String jreLoc = System.getProperty(JAVA_HOME);
            if (!JavaHomeHelper.isExtractedJavaHome((String)jreLoc)) {
                String jdkLoc = JavaHomeHelper.getJdkHomeFromJreHome((String)jreLoc);
                this._javaLoc = jdkLoc != null ? jdkLoc : jreLoc;
            } else {
                _logger.warning("Can't determine Java Home: only candidate is the executing extracted JVM: " + jreLoc);
            }
        }
    }

    public static Path getCanonicalPath(String pathStr) {
        if (pathStr == null || pathStr.trim().isEmpty()) {
            throw new IllegalArgumentException("getCanonicalPath: null or empty path");
        }
        Path path = NioHelper.getInstance().getPath(pathStr.trim(), new String[0]);
        return JDKQueryUtils.getCanonicalPath(path);
    }

    public static Path getCanonicalPath(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("getCanonicalPath: null path");
        }
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return path.toAbsolutePath();
        }
    }
}

