/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.gdr.nio.NioHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;

public class FileUtils {
    public static void appendContents(File sourceFile, File destFile) throws IOException {
        FileUtils.appendContents(NioHelper.getInstance().getPath(sourceFile), NioHelper.getInstance().getPath(destFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendContents(Path sourcePath, Path destPath) throws IOException {
        AbstractInterruptibleChannel fcOut = null;
        FileChannel fcIn = null;
        fcIn = FileChannel.open(sourcePath, StandardOpenOption.READ);
        try {
            Path parent;
            if (!Files.exists(destPath, new LinkOption[0]) && (parent = destPath.getParent()) != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
            options.add(StandardOpenOption.CREATE);
            options.add(StandardOpenOption.APPEND);
            fcOut = FileChannel.open(destPath, options, new FileAttribute[0]);
            ByteBuffer buffer = ByteBuffer.allocate(16384);
            while (fcIn.read(buffer) != -1) {
                buffer.flip();
                ((FileChannel)fcOut).write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                ((FileChannel)fcOut).write(buffer);
            }
        }
        finally {
            if (fcIn != null) {
                fcIn.close();
            }
            if (fcOut != null) {
                fcOut.close();
            }
        }
    }

    public static String formatPath(String originalPath) {
        String newPath = originalPath.replace("\\", File.separator);
        newPath = newPath.replace("/", File.separator);
        return newPath;
    }

    public static boolean isDirectoryEmpty(File directory) throws IOException {
        return FileUtils.isDirectoryEmpty(NioHelper.getInstance().getPath(directory));
    }

    public static boolean isDirectoryEmpty(Path directory) throws IOException {
        if (directory != null) {
            if (!Files.exists(directory, new LinkOption[0])) {
                return true;
            }
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(directory);){
                boolean bl = !ds.iterator().hasNext();
                return bl;
            }
        }
        return false;
    }

    public static String removeExtension(File file) {
        int index;
        String fileName = null;
        if (file != null && (index = (fileName = file.getName()).lastIndexOf(".")) != -1) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public static String formatPath(String originalPath, String separator) {
        String newPath = originalPath.replace("\\", separator);
        newPath = newPath.replace("/", separator);
        return newPath;
    }

    public static boolean findContents(String filePath, String content) {
        try {
            File file = new File(filePath);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = "";
            while ((line = reader.readLine()) != null) {
                if (!line.contains(content)) continue;
                reader.close();
                return true;
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

