/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.DirectoryCopy;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.ManifestBuilder;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.gdr.Version;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Directory;
import com.oracle.cie.gdr.dao.cpd.FileGroup;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.cpi.ComponentInfo;
import com.oracle.cie.gdr.dao.cpi.FileMapTarget;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.ComponentInfoHelper;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import com.oracle.cie.gdr.helpers.LocaleInfoHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.locale.LocaleInfoHolder;
import com.oracle.cie.gdr.platform.InfoHolder;
import com.oracle.cie.gdr.platform.PlatformInfoHolder;
import com.oracle.cie.gdr.services.EncodingService;
import com.oracle.cie.gdr.services.RepositoryArtifact;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.common.NextGenHelperFactory;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.repository.resolver.RepositoryVersionResolverException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentArchiveUtils {
    private static final Logger _log = Logger.getLogger(ComponentArchiveUtils.class.getName());
    public static final String SPECIFICATION_TITLE = "Component Archive Repository Binary";

    public static void extractCarbs(Collection<Artifact> carbs, File outputDir, List<Repository> repositories) throws IOException, RestException {
        if (carbs != null) {
            for (Artifact a : carbs) {
                ComponentArchiveUtils.extractCarb(a, outputDir, repositories);
            }
        }
    }

    public static File extractCarb(Artifact carb, File outputDir, List<Repository> repositories) throws IOException, RestException, NullPointerException {
        if (carb == null) {
            throw new NullPointerException("The carb specified was null.");
        }
        File carbFile = carb.getLocalLocation(RestFactory.getRestHandlerConfig().getDefaultCacheRepository().getCacheLocation());
        if (!carbFile.exists() && repositories != null) {
            for (Repository repository : repositories) {
                File file;
                if (!repository.getType().isCache() || !repository.isLocalRepository() || !(file = carb.getLocalLocation(repository.getCacheLocation())).exists()) continue;
                carbFile = file;
                break;
            }
        }
        return ComponentArchiveUtils.extractCarb(carb, carbFile, outputDir);
    }

    public static File extractCarb(Artifact carb, File carbFile, File outputDir) throws IOException, RestException, NullPointerException {
        if (carb == null) {
            throw new NullPointerException("The carb specified was null.");
        }
        if (carbFile == null) {
            throw new NullPointerException("The carb file specified was null.");
        }
        if (outputDir == null) {
            throw new NullPointerException("The output dir specified was null.");
        }
        if (!carbFile.exists()) {
            throw new FileNotFoundException("The specified carb did not exist " + carbFile);
        }
        File carbDest = ComponentArchiveUtils.getComponentArchiveExtractionDirectory(carb, outputDir);
        File[] carbDestFiles = carbDest.listFiles();
        if (carbDest.exists() && carbDest.isDirectory() && carbDestFiles != null && carbDestFiles.length > 0) {
            _log.info(carbDest.getName() + " binaries already exist. Skipping extraction.");
        } else {
            _log.info("Extracting component archive to " + carbDest.getAbsolutePath());
            ComponentArchiveUtils.extractArchive(carbFile, carbDest);
        }
        return carbDest;
    }

    public static File extractArchive(File archiveFile, File archiveDest) throws IOException, NullPointerException {
        if (archiveFile == null) {
            throw new NullPointerException("The archive file specified was null.");
        }
        if (archiveDest == null) {
            throw new NullPointerException("The destination dir specified was null.");
        }
        if (!archiveFile.exists()) {
            throw new FileNotFoundException("The specified archive file did not exist " + archiveFile);
        }
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Extracting archive to " + archiveDest.getAbsolutePath());
        }
        archiveDest.mkdirs();
        JarHelper carbJarHelper = new JarHelper(archiveFile);
        carbJarHelper.extract(archiveDest);
        carbJarHelper.close();
        return archiveDest;
    }

    public static void createEmptyComponents(Collection<Reference> emptyComponents, File outputDir) throws DataHandlerException {
        if (emptyComponents != null && !emptyComponents.isEmpty()) {
            for (Reference emptyComponent : emptyComponents) {
                ComponentArchiveUtils.createEmptyComponent(emptyComponent, outputDir);
            }
        }
    }

    public static void createEmptyComponent(Reference emptyComponent, File outputDir) throws DataHandlerException {
        String version;
        if (emptyComponent == null) {
            throw new NullPointerException("The component reference specified was null.");
        }
        if (outputDir == null) {
            throw new NullPointerException("The output directory specified was null.");
        }
        String name = emptyComponent.getName();
        File tld = new File(outputDir, ComponentArchiveUtils.getComponentArchiveExtractionDirectoryName(name, version = emptyComponent.getVersion(), null));
        File componentDir = new File(ComponentHelper.getStageDir(ComponentHelper.getInstallDir(tld)), ComponentHelper.getInstance().getComponentArchivePath(name, version));
        File compDefFile = new File(componentDir, ComponentHelper.getComponentDefFileName());
        if (compDefFile.exists()) {
            _log.info("Component already exist under " + componentDir.getAbsolutePath() + ", Skipping creation.");
        } else {
            _log.info("Creating empty component under " + componentDir.getAbsolutePath());
            Component component = new Component(name, version);
            component.setDescription(name + " " + version);
            ComponentHelper.getInstance().save((IDataHandlerWrapper)component, compDefFile);
        }
    }

    public static File getComponentArchiveExtractionDirectory(Artifact artifact, File baseDir) {
        return new File(baseDir, ComponentArchiveUtils.getComponentArchiveExtractionDirectoryName(artifact));
    }

    public static String getComponentArchiveExtractionDirectoryName(Artifact artifact) {
        return ComponentArchiveUtils.getComponentArchiveExtractionDirectoryName(artifact.getName(), artifact.getVersion().getVersion(), ComponentArchiveUtils.getTargetedCarbClassifier(artifact));
    }

    public static String getComponentArchiveExtractionDirectoryName(String name, String version, String targetedCarbClassifier) {
        String directoryName = name + "-" + version;
        if (targetedCarbClassifier != null) {
            directoryName = directoryName + "-" + targetedCarbClassifier;
        }
        return directoryName;
    }

    public static Map<Reference, File> createComponentLocationMap(Collection<File> stageDirs, Collection<? extends Reference> compRefs, boolean choice, RepositoryVersionResolver versionResolver, File srchome, File tmpDir) throws IOException, RestException, RepositoryVersionResolverException, GdrException, DataHandlerException {
        if ((stageDirs == null || stageDirs.isEmpty()) && (compRefs == null || compRefs.isEmpty())) {
            throw new NullPointerException("No stage directories or component references were specified.");
        }
        HashMap<Reference, File> compMap = new HashMap<Reference, File>();
        if (stageDirs != null && !stageDirs.isEmpty()) {
            compMap.putAll(ComponentArchiveUtils.createComponentStageLocationMap(stageDirs));
            if (compRefs != null && !compRefs.isEmpty()) {
                for (Reference compRef : new HashSet(compMap.keySet())) {
                    if (compRefs.contains((Object)compRef)) continue;
                    compMap.remove((Object)compRef);
                }
                if (choice && compMap.size() > 1) {
                    ArrayList<? extends Reference> tmpList = new ArrayList<Reference>(compRefs);
                    for (int x = tmpList.size(); x > 0; --x) {
                        compMap.remove((Object)tmpList.get(x));
                        if (compMap.size() == 1) break;
                    }
                }
            }
        }
        if (versionResolver != null && compRefs != null && !compRefs.isEmpty() && compRefs.size() != compMap.size()) {
            ArrayList<File> artifactStageDirs = new ArrayList<File>();
            ArrayList<Repository> sourceRepositories = null;
            for (Reference reference : compRefs) {
                if (!compMap.containsKey((Object)reference)) {
                    com.oracle.cie.dependency.mgmt.Version version;
                    if (sourceRepositories == null) {
                        sourceRepositories = new ArrayList<Repository>();
                        Repository[] repositories = versionResolver.getRepositories();
                        if (repositories != null) {
                            sourceRepositories.addAll(Arrays.asList(repositories));
                        }
                    }
                    try {
                        version = versionResolver.getComponentArchiveVersion(reference.getName(), reference.getVersion());
                    }
                    catch (RepositoryVersionResolverException e) {
                        if (choice || reference instanceof ComponentReference && ((ComponentReference)reference).isOptional()) {
                            _log.info("Skipping unresolved component reference due to optional component or choice constraint " + (Object)((Object)reference));
                            continue;
                        }
                        throw e;
                    }
                    Artifact carbArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.carb", reference.getName(), version, "carb");
                    File carbFile = RestFactory.getRestHandler().retrieveArtifact(carbArtifact, sourceRepositories, true);
                    artifactStageDirs.add(ComponentHelper.getStageDir(new File(ComponentArchiveUtils.extractCarb(carbArtifact, carbFile, tmpDir), ComponentHelper.getInstallDir())));
                }
                if (!artifactStageDirs.isEmpty()) {
                    compMap.putAll(ComponentArchiveUtils.createComponentStageLocationMap(artifactStageDirs));
                }
                if (!choice) continue;
                break;
            }
        }
        if (srchome != null && compRefs != null && !compRefs.isEmpty() && compRefs.size() != compMap.size()) {
            File gdrDir = TopLevelDirectoryService.getGdrLabelTopLevelDirectory(srchome);
            LabelMap labelMap = LabelMapHelper.getInstance().getLabelMap(gdrDir);
            block5: for (Reference reference : compRefs) {
                Collection<File> baseTopLevelDirs;
                if (compMap.containsKey((Object)reference) || (baseTopLevelDirs = LabelMapHelper.getInstance().getBaseTopLevelDir(srchome, labelMap, reference)) == null) continue;
                if (_log.isLoggable(Level.FINE)) {
                    _log.fine("Base top level directories are " + baseTopLevelDirs);
                }
                for (File baseTopLevelDir : baseTopLevelDirs) {
                    File baseStageDir = ComponentHelper.getStageDir(ComponentHelper.getInstallDir(baseTopLevelDir));
                    if (!ComponentHelper.getInstance().getComponentArchiveDefinitionLocation(baseStageDir, reference).exists()) continue;
                    compMap.put(reference, baseStageDir);
                    continue block5;
                }
            }
        }
        if (compRefs != null && compRefs.size() != compMap.size()) {
            throw new GdrException("Failed to locate all of the required components. Stage Dirs: " + stageDirs + " Required: " + compRefs + " Found: " + compMap.keySet());
        }
        return compMap;
    }

    public static Map<Reference, File> createComponentStageLocationMap(Collection<File> stageDirs) throws IOException {
        if (stageDirs == null || stageDirs.isEmpty()) {
            throw new NullPointerException("No stage directories were specified.");
        }
        HashMap<Reference, File> compMap = new HashMap<Reference, File>();
        for (File stageDir : stageDirs) {
            Map<Reference, File> map = ComponentArchiveUtils.createComponentLocationMap(stageDir);
            Set<Map.Entry<Reference, File>> entrySet = map.entrySet();
            for (Map.Entry<Reference, File> entry : entrySet) {
                Reference reference = entry.getKey();
                if (compMap.containsKey((Object)reference)) {
                    throw new IOException("Encountered duplicate component : " + (Object)((Object)reference));
                }
                compMap.put(reference, entry.getValue());
            }
        }
        return compMap;
    }

    public static Map<Reference, File> createComponentLocationMap(Collection<Component> components) {
        HashMap<Reference, File> compMap = new HashMap<Reference, File>();
        if (components != null && !components.isEmpty()) {
            for (Component component : components) {
                ComponentArchiveUtils.updateComponentLocationMap(component, compMap);
            }
        }
        return compMap;
    }

    public static Map<Reference, File> createComponentLocationMap(Component component) {
        HashMap<Reference, File> compMap = new HashMap<Reference, File>();
        ComponentArchiveUtils.updateComponentLocationMap(component, compMap);
        return compMap;
    }

    public static void updateComponentLocationMap(Component component, Map<Reference, File> compMap) {
        if (component.isComponentArchive()) {
            File stageDir = component.getArchiveLocation().getParentFile().getParentFile().getParentFile();
            compMap.put(new QuickReference(component.getName(), component.getVersion()), stageDir);
        }
    }

    public static Map<Reference, File> createComponentLocationMap(File stageDir) throws IOException {
        HashMap<Reference, File> compMap = new HashMap<Reference, File>();
        try {
            if (stageDir == null) {
                throw new NullPointerException("The stage directory specified was null.");
            }
            if (!stageDir.exists()) {
                throw new FileNotFoundException("The stage directory specified did not exist: " + stageDir);
            }
            Set<Reference> compRefs = ComponentHelper.getInstance().findComponents(stageDir, false, true);
            if (compRefs != null) {
                for (Reference ref : compRefs) {
                    compMap.put(ref, stageDir);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return compMap;
    }

    public static File packageCarb(String groupId, String name, String version, File carbDir, File outputDir, String versionQualifier, Map<String, String> manifestEntries, boolean outputDirRepositoryLayout) throws IOException {
        return ComponentArchiveUtils.packageCarb(groupId, name, version, carbDir, outputDir, versionQualifier, manifestEntries, outputDirRepositoryLayout, null);
    }

    public static File packageCarb(String groupId, String name, String version, File carbDir, File outputDir, String versionQualifier, Map<String, String> manifestEntries, boolean outputDirRepositoryLayout, String platformLocalClassifier) throws IOException {
        return ComponentArchiveUtils.packageCarb(name, version, carbDir, outputDir, versionQualifier, manifestEntries, outputDirRepositoryLayout, groupId, "carb", platformLocalClassifier);
    }

    public static File packageCarb(String name, String version, File carbDir, File outputDir, String versionQualifier, Map<String, String> manifestEntries, boolean outputDirRepositoryLayout, String groupId, String archiveExtension) throws IOException {
        return ComponentArchiveUtils.packageCarb(name, version, carbDir, outputDir, versionQualifier, manifestEntries, outputDirRepositoryLayout, groupId, archiveExtension, null);
    }

    public static File packageCarb(String name, String version, File carbDir, File outputDir, String versionQualifier, Map<String, String> manifestEntries, boolean outputDirRepositoryLayout, String groupId, String archiveExtension, String platformLocalClassifier) throws IOException {
        File parentFile;
        File carbJar = ComponentArchiveUtils.getCarbLocation(outputDir, name, version, versionQualifier, outputDirRepositoryLayout, groupId, archiveExtension, platformLocalClassifier);
        if (carbJar.exists()) {
            carbJar.delete();
        }
        if ((parentFile = carbJar.getAbsoluteFile().getParentFile()) != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Failed to create directory " + parentFile);
        }
        File manifestFile = new File(carbDir, "META-INF/MANIFEST.MF");
        if (manifestFile.exists()) {
            manifestFile.delete();
        }
        JarHelper jar = new JarHelper(carbJar, 1, ComponentArchiveUtils.createManifest(name, version, versionQualifier, manifestEntries));
        jar.append(carbDir, false);
        jar.close();
        Delete.delete((File)carbDir);
        return carbJar;
    }

    public static String getCarbName(String compName, String compVersion, String versionQualifier) {
        return ComponentArchiveUtils.getCarbName(compName, compVersion, versionQualifier, null);
    }

    public static String getCarbName(String compName, String compVersion, String versionQualifier, String platformLocalClassifier) {
        String carbName = compName + "-" + compVersion;
        if (!StringUtil.isNullOrEmpty((String)versionQualifier)) {
            carbName = carbName + "-" + versionQualifier;
        }
        if (!StringUtil.isNullOrEmpty((String)platformLocalClassifier)) {
            carbName = carbName + "-" + platformLocalClassifier;
        }
        return carbName;
    }

    public static boolean carbExists(String name, String version, File outputDir, String versionQualifier, boolean outputDirRepositoryLayout) {
        return ComponentArchiveUtils.carbExists(name, version, outputDir, versionQualifier, outputDirRepositoryLayout, null);
    }

    public static boolean carbExists(String name, String version, File outputDir, String versionQualifier, boolean outputDirRepositoryLayout, String platformLocalClassifier) {
        File carbJar = ComponentArchiveUtils.getCarbLocation(outputDir, name, version, versionQualifier, outputDirRepositoryLayout, platformLocalClassifier);
        return carbJar.exists();
    }

    public static File getCarbLocation(File outputDir, String compName, String compVersion, String versionQualifier, boolean outputDirRepositoryLayout) {
        return ComponentArchiveUtils.getCarbLocation(outputDir, compName, compVersion, versionQualifier, outputDirRepositoryLayout, null);
    }

    public static File getCarbLocation(File outputDir, String compName, String compVersion, String versionQualifier, boolean outputDirRepositoryLayout, String platformLocalClassifier) {
        return ComponentArchiveUtils.getCarbLocation(outputDir, compName, compVersion, versionQualifier, outputDirRepositoryLayout, "com.oracle.cie.gdr.carb", "carb", platformLocalClassifier);
    }

    public static File getCarbLocation(File outputDir, String compName, String compVersion, String versionQualifier, boolean outputDirRepositoryLayout, String groupId, String archiveExtension) {
        return ComponentArchiveUtils.getCarbLocation(outputDir, compName, compVersion, versionQualifier, outputDirRepositoryLayout, groupId, archiveExtension, null);
    }

    public static File getCarbLocation(File outputDir, String compName, String compVersion, String versionQualifier, boolean outputDirRepositoryLayout, String groupId, String archiveExtension, String platformLocalClassifier) {
        if (outputDirRepositoryLayout) {
            if (!StringUtil.isNullOrEmpty((String)platformLocalClassifier, (boolean)true)) {
                groupId = groupId + "." + platformLocalClassifier;
            }
            Artifact carbArtifact = DependencyManagementFactory.getInstance().getArtifact(groupId, compName, compVersion, archiveExtension, new String[]{versionQualifier});
            return carbArtifact.getLocalLocation(outputDir);
        }
        return new File(outputDir, ComponentArchiveUtils.getCarbName(compName, compVersion, versionQualifier, platformLocalClassifier) + "." + archiveExtension);
    }

    public static Manifest createManifest(String compName, String compVersion, String versionQualifier, Map<String, String> manifestEntries) throws IOException {
        String fullVersion = compVersion;
        if (versionQualifier != null) {
            fullVersion = fullVersion + "-" + versionQualifier;
        }
        HashMap<Attributes.Name, String> attribs = new HashMap<Attributes.Name, String>();
        attribs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attribs.put(new Attributes.Name("Created-By"), System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        attribs.put(Attributes.Name.SPECIFICATION_TITLE, SPECIFICATION_TITLE);
        attribs.put(Attributes.Name.SPECIFICATION_VERSION, Version.getVersion());
        attribs.put(Attributes.Name.SPECIFICATION_VENDOR, Version.getVendor());
        attribs.put(new Attributes.Name(Attributes.Name.SPECIFICATION_VENDOR.toString() + "-Id"), Version.getVendorId());
        attribs.put(Attributes.Name.IMPLEMENTATION_TITLE, compName);
        attribs.put(Attributes.Name.IMPLEMENTATION_VERSION, fullVersion);
        attribs.put(Attributes.Name.IMPLEMENTATION_VENDOR, Version.getVendor());
        attribs.put(Attributes.Name.IMPLEMENTATION_VENDOR_ID, Version.getVendorId());
        if (manifestEntries != null && !manifestEntries.isEmpty()) {
            for (String key : manifestEntries.keySet()) {
                attribs.put(new Attributes.Name(key), manifestEntries.get(key));
            }
        }
        return ManifestBuilder.getManifest(attribs);
    }

    public static RepositoryVersionResolver getConfiguredVersionResolver(Collection<Artifact> carbArtifacts) throws RestException, RepositoryVersionResolverException {
        RepositoryVersionResolver versionResolver = null;
        if (carbArtifacts != null && !carbArtifacts.isEmpty()) {
            Repository[] repositoryArray;
            Repository remoteRepository = null;
            String repoUrl = System.getProperty("REPO_URL");
            if (!StringUtil.isNullOrEmpty((String)repoUrl, (boolean)true)) {
                remoteRepository = RestFactory.getRepository(null, (String)repoUrl, null, null);
            }
            Module overrideModule = DependencyManagementFactory.getInstance().getModule("component.archive.merger", "override-modules", "1.0.0");
            overrideModule.setDependencies(DependencyManagementHelper.convertToDependencies(carbArtifacts));
            ArrayList<Module> overrideModules = new ArrayList<Module>();
            overrideModules.add(overrideModule);
            if (remoteRepository != null) {
                Repository[] repositoryArray2 = new Repository[2];
                repositoryArray2[0] = remoteRepository;
                repositoryArray = repositoryArray2;
                repositoryArray2[1] = RestFactory.getRestHandlerConfig().getDefaultCacheRepository();
            } else {
                Repository[] repositoryArray3 = new Repository[1];
                repositoryArray = repositoryArray3;
                repositoryArray3[0] = RestFactory.getRestHandlerConfig().getDefaultCacheRepository();
            }
            Repository[] repositories = repositoryArray;
            versionResolver = new RepositoryVersionResolver(NextGenHelperFactory.getNextGenHelper((RestHandler)RestFactory.getRestHandler()), repositories, overrideModules);
        }
        return versionResolver;
    }

    public static Collection<Reference> getComponentReferencesFromArtifacts(Collection<Artifact> carbArtifacts) {
        ArrayList<QuickReference> compRefs = null;
        if (!carbArtifacts.isEmpty()) {
            compRefs = new ArrayList<QuickReference>();
            for (Artifact carbArtifact : carbArtifacts) {
                compRefs.add(new QuickReference(carbArtifact.getName(), carbArtifact.getBaseVersion()));
            }
        }
        return compRefs;
    }

    public static Map<Artifact, File> createArtifactConsumptionFiles(Map<Artifact, File> artifactMap, File outputDir, Boolean outputDirRepositoryLayout, String artifactType) throws IOException, DependencyManagementException {
        LinkedHashMap<Artifact, File> createdPoms = new LinkedHashMap<Artifact, File>();
        if (artifactMap != null && !artifactMap.isEmpty()) {
            for (Artifact artifact : artifactMap.keySet()) {
                File artifactConsumptionFile;
                File artifactFile = artifactMap.get(artifact);
                String artifactGroup = artifact.getGroup();
                Artifact pomArtifact = DependencyManagementFactory.getInstance().getArtifact(artifactGroup, artifact.getName(), artifact.getBaseVersion(), DependencyFileType.pom.name());
                String consumptionFilePath = ComponentHelper.getInstallDir() + "/" + ComponentHelper.getStageDir() + "/" + ComponentHelper.getInstance().getComponentArchivePath(artifact.getName(), artifact.getBaseVersion()) + "/" + pomArtifact.getFileName();
                Object is = null;
                Object jarFile = null;
                Module consumptionModule = DependencyManagementFactory.getInstance().getModule(artifactGroup, artifact.getName(), artifact.getVersion(), artifactType);
                consumptionModule.setModuleType(DependencyFileType.pom.name());
                Artifact consumptionModuleArtifact = consumptionModule.getModuleArtifact();
                if (outputDirRepositoryLayout.booleanValue()) {
                    artifactConsumptionFile = consumptionModuleArtifact.getLocalLocation(outputDir);
                } else {
                    consumptionModuleArtifact.setClassifier(ComponentArchiveUtils.getTargetedCarbClassifier(artifact));
                    artifactConsumptionFile = new File(outputDir, consumptionModuleArtifact.getFileName());
                    consumptionModuleArtifact.setClassifier(null);
                }
                DependencyManagementFactory.getInstance().getDependencyFileHandler(DependencyFileType.pom).writeDependenciesFile(consumptionModule, artifactConsumptionFile);
                createdPoms.put(consumptionModuleArtifact, artifactConsumptionFile);
            }
        }
        return createdPoms;
    }

    public static Map<Artifact, File> createCarbConsumptionFiles(Map<Artifact, File> carbMap, File outputDir, Boolean outputDirRepositoryLayout) throws IOException, DependencyManagementException {
        LinkedHashMap<Artifact, File> createdPoms = new LinkedHashMap<Artifact, File>();
        if (carbMap != null && !carbMap.isEmpty()) {
            for (Artifact carbArtifact : carbMap.keySet()) {
                File carbConsumptionFile;
                Module consumptionModule;
                File carbFile = carbMap.get(carbArtifact);
                String carbArtifactGroup = carbArtifact.getGroup();
                Artifact pomArtifact = DependencyManagementFactory.getInstance().getArtifact(carbArtifactGroup, carbArtifact.getName(), carbArtifact.getBaseVersion(), DependencyFileType.pom.name());
                String consumptionFilePath = ComponentHelper.getInstallDir() + "/" + ComponentHelper.getStageDir() + "/" + ComponentHelper.getInstance().getComponentArchivePath(carbArtifact.getName(), carbArtifact.getBaseVersion()) + "/" + pomArtifact.getFileName();
                InputStream is = null;
                JarFile jarFile = null;
                if (carbFile.isDirectory()) {
                    File consumptionFile = new File(carbFile, consumptionFilePath);
                    if (consumptionFile.exists()) {
                        is = new FileInputStream(consumptionFile);
                    }
                } else {
                    jarFile = new JarFile(carbFile);
                    is = jarFile.getInputStream(new JarEntry(consumptionFilePath));
                }
                if (is != null) {
                    consumptionModule = DependencyManagementFactory.getInstance().getDependencyFileHandler(DependencyFileType.pom).readDependenciesFile(is);
                    consumptionModule.setGroup(carbArtifactGroup);
                    consumptionModule.setVersion(carbArtifact.getVersion());
                } else {
                    _log.info("Unable to locate component consumption file [" + consumptionFilePath + "] in carb [" + carbFile + "], creating empty one...");
                    consumptionModule = DependencyManagementFactory.getInstance().getModule(carbArtifactGroup, carbArtifact.getName(), carbArtifact.getVersion(), "carb");
                    consumptionModule.setModuleType(DependencyFileType.pom.name());
                }
                if (is != null) {
                    is.close();
                }
                if (jarFile != null) {
                    jarFile.close();
                }
                Artifact consumptionModuleArtifact = consumptionModule.getModuleArtifact();
                if (outputDirRepositoryLayout.booleanValue()) {
                    carbConsumptionFile = consumptionModuleArtifact.getLocalLocation(outputDir);
                } else {
                    consumptionModuleArtifact.setClassifier(ComponentArchiveUtils.getTargetedCarbClassifier(carbArtifact));
                    carbConsumptionFile = new File(outputDir, consumptionModuleArtifact.getFileName());
                    consumptionModuleArtifact.setClassifier(null);
                }
                DependencyManagementFactory.getInstance().getDependencyFileHandler(DependencyFileType.pom).writeDependenciesFile(consumptionModule, carbConsumptionFile);
                createdPoms.put(consumptionModuleArtifact, carbConsumptionFile);
            }
        }
        return createdPoms;
    }

    public static Map<Artifact, File> createComponentInfos(Map<Artifact, File> carbMap, File outputDir, String versionQualifier, Boolean outputDirRepositoryLayout) throws IOException, DependencyManagementException, GdrException, DataHandlerException {
        LinkedHashMap<Artifact, File> createdInfos = new LinkedHashMap<Artifact, File>();
        if (carbMap != null && !carbMap.isEmpty()) {
            HashMap<QuickReference, ArrayList<Artifact>> componentArtifacts = new HashMap<QuickReference, ArrayList<Artifact>>();
            for (Artifact artifact : carbMap.keySet()) {
                QuickReference key = new QuickReference(artifact.getName(), artifact.getBaseVersion());
                ArrayList<Artifact> artifacts = (ArrayList<Artifact>)componentArtifacts.get((Object)key);
                if (artifacts == null) {
                    artifacts = new ArrayList<Artifact>();
                    componentArtifacts.put(key, artifacts);
                }
                artifacts.add(artifact);
            }
            for (Map.Entry entry : componentArtifacts.entrySet()) {
                ArrayList<FileMapTarget> targets = new ArrayList<FileMapTarget>();
                boolean generic = false;
                for (Artifact artifact : (List)entry.getValue()) {
                    String targetString = ComponentArchiveUtils.getTargetedCarbClassifier(artifact);
                    if (!StringUtil.isNullOrEmpty((String)targetString, (boolean)true)) {
                        LinkedHashSet<String> platforms = new LinkedHashSet<String>();
                        LinkedHashSet<String> locales = new LinkedHashSet<String>();
                        ComponentArchiveUtils.getTargetNames(targetString, platforms, locales);
                        FileMapTarget target = new FileMapTarget();
                        target.setPlatforms(platforms);
                        target.setLocales(locales);
                        targets.add(target);
                        continue;
                    }
                    generic = true;
                }
                if (targets.isEmpty()) continue;
                Artifact compInfoArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.carb.info", ((Reference)((Object)entry.getKey())).getName(), ((Reference)((Object)entry.getKey())).getVersion(), "xml", new String[]{versionQualifier});
                File compInfoFile = outputDirRepositoryLayout != false ? compInfoArtifact.getLocalLocation(outputDir) : new File(outputDir, compInfoArtifact.getFileName());
                ComponentInfo componentInfo = new ComponentInfo(((Reference)((Object)entry.getKey())).getName(), ((Reference)((Object)entry.getKey())).getVersion());
                componentInfo.setGeneric(generic);
                componentInfo.setTargets(targets);
                ComponentInfoHelper.getInstance().save((IDataHandlerWrapper)componentInfo, compInfoFile);
                createdInfos.put(compInfoArtifact, compInfoFile);
                Module compInfoPom = DependencyManagementFactory.getInstance().getModule("com.oracle.cie.gdr.carb.info", ((Reference)((Object)entry.getKey())).getName(), ((Reference)((Object)entry.getKey())).getVersion(), "xml", new String[]{versionQualifier});
                compInfoPom.setModuleType(DependencyFileType.pom.name());
                File compInfoPomFile = outputDirRepositoryLayout != false ? compInfoPom.getModuleArtifact().getLocalLocation(outputDir) : new File(outputDir, compInfoPom.getModuleArtifact().getFileName());
                DependencyManagementFactory.getInstance().getDependencyFileHandler(DependencyFileType.pom).writeDependenciesFile(compInfoPom, compInfoPomFile);
                createdInfos.put(compInfoPom.getModuleArtifact(), compInfoPomFile);
            }
        }
        return createdInfos;
    }

    public static File splitComponentDir(Artifact carbArtifact, Component component, File outputDir, File stageDir, String versionQualifier) throws IOException, DataHandlerException, DependencyManagementException {
        return ComponentArchiveUtils.splitComponentDir(carbArtifact, component, outputDir, stageDir, versionQualifier, null);
    }

    public static File splitComponentDir(Artifact carbArtifact, Component component, File outputDir, File stageDir, String versionQualifier, String patchLevel) throws IOException, DataHandlerException, DependencyManagementException {
        String[] libsLocs;
        File libsXml;
        final String name = carbArtifact.getName();
        final String version = carbArtifact.getBaseVersion();
        String componentArchivePath = ComponentHelper.getInstance().getComponentArchivePath(name, version);
        File compDir = new File(stageDir, componentArchivePath);
        File carbDir = new File(outputDir, ComponentArchiveUtils.getCarbName(name, version, versionQualifier, carbArtifact.getClassifier()));
        if (carbDir.exists()) {
            Delete.delete((File)carbDir);
        }
        File outputStage = ComponentHelper.getStageDir(ComponentHelper.getInstallDir(carbDir));
        File compOutputDir = new File(outputStage, componentArchivePath);
        compOutputDir.mkdirs();
        final FileFilter globalFilter = ComponentHelper.getInstance().getGlobalExcludeFileFilter();
        if (component != null) {
            final File compDefXmlFileSrc = new File(compDir, ComponentHelper.getComponentDefFileName());
            final File dataFilesSrc = new File(compDir, ComponentHelper.getDataFilesDir());
            final File carbPomSrc = new File(compDir, DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.carb", name, version, DependencyFileType.pom.name()).getFileName());
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.equals(compDefXmlFileSrc) && !pathname.equals(dataFilesSrc) && !pathname.equals(carbPomSrc) && globalFilter.accept(pathname);
                }
            };
            DirectoryCopy.copy((File)compDir, (File)compOutputDir, (FileFilter)filter);
            if (!StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true)) {
                component.setPatchLevel(patchLevel);
            }
            File compDefXmlFileDest = new File(compOutputDir, ComponentHelper.getComponentDefFileName());
            ComponentHelper.getInstance().save((IDataHandlerWrapper)component, compDefXmlFileDest);
            File dataFilesDest = new File(compOutputDir, ComponentHelper.getDataFilesDir());
            dataFilesDest.mkdirs();
            ArrayList<RepositoryArtifact> repositoryArtifacts = new ArrayList<RepositoryArtifact>();
            List<FileMap> fileMaps = component.getFileMaps();
            if (fileMaps != null && !fileMaps.isEmpty()) {
                for (FileMap fileMap : fileMaps) {
                    String sourceJar = fileMap.getSource();
                    FileCopy.copy((File)new File(dataFilesSrc, sourceJar), (File)new File(dataFilesDest, sourceJar));
                    repositoryArtifacts.addAll(ComponentArchiveUtils.getFileGroupRepositoryArtifacts(fileMap));
                }
            }
            if (carbPomSrc.exists()) {
                Module carbPomModule = DependencyManagementFactory.getInstance().getDependencyFileHandler(DependencyFileType.pom).readDependenciesFile(carbPomSrc);
                carbPomModule.setGroup(carbArtifact.getGroup());
                List dependencies = carbPomModule.getDependencies();
                if (dependencies != null && !dependencies.isEmpty()) {
                    ArrayList<Dependency> updatedDeps = new ArrayList<Dependency>();
                    if (fileMaps != null && !fileMaps.isEmpty()) {
                        block1: for (Dependency dependency : dependencies) {
                            for (RepositoryArtifact repositoryArtifact : repositoryArtifacts) {
                                if (!RepositoryService.equalsRepositoryArtifact(repositoryArtifact, (Artifact)dependency)) continue;
                                updatedDeps.add(dependency);
                                continue block1;
                            }
                        }
                    }
                    carbPomModule.setDependencies(updatedDeps);
                }
                File carbPomDest = new File(compOutputDir, carbPomSrc.getName());
                DependencyManagementFactory.getInstance().getDependencyFileHandler(DependencyFileType.pom).writeDependenciesFile(carbPomModule, carbPomDest);
            }
        } else {
            FileFilter filter;
            if (Boolean.getBoolean("ComponentHelper.enable.file.perms.xslt") || !StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true)) {
                File[] compDefXmlFileSrc = new File(compDir, ComponentHelper.getComponentDefFileName());
                component = ComponentHelper.getInstance().getRootWrapper((File)compDefXmlFileSrc);
                if (!StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true)) {
                    component.setPatchLevel(patchLevel);
                }
                File compDefXmlFileDest = new File(compOutputDir, ComponentHelper.getComponentDefFileName());
                ComponentHelper.getInstance().save((IDataHandlerWrapper)component, compDefXmlFileDest);
                filter = new FileFilter(){
                    final /* synthetic */ File val$compDefXmlFileSrc;
                    final /* synthetic */ FileFilter val$globalFilter;
                    {
                        this.val$compDefXmlFileSrc = file;
                        this.val$globalFilter = fileFilter;
                    }

                    @Override
                    public boolean accept(File pathname) {
                        return !pathname.equals(this.val$compDefXmlFileSrc) && this.val$globalFilter.accept(pathname);
                    }
                };
            } else {
                filter = globalFilter;
            }
            DirectoryCopy.copy((File)compDir, (File)compOutputDir, (FileFilter)filter);
        }
        File[] compXmls = stageDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.startsWith(name + "." + version.replace(".", "_"));
            }
        });
        if (compXmls != null && compXmls.length > 0) {
            for (File compXml : compXmls) {
                FileCopy.copy((File)compXml, (File)new File(outputStage, compXml.getName()));
            }
        }
        if ((libsXml = new File(stageDir, "libs.xml")).exists()) {
            FileCopy.copy((File)libsXml, (File)new File(outputStage, "libs.xml"));
        }
        for (String library : libsLocs = new String[]{"Actions", "Queries", "Dialogs"}) {
            File dir = new File(stageDir, library);
            if (!dir.exists()) continue;
            DirectoryCopy.copy((File)dir, (File)new File(outputStage, library), (FileFilter)ComponentHelper.getInstance().getGlobalExcludeFileFilter());
        }
        return carbDir;
    }

    public static List<RepositoryArtifact> getFileGroupRepositoryArtifacts(FileGroup fileGroup) {
        ArrayList<RepositoryArtifact> repositoryArtifacts = new ArrayList<RepositoryArtifact>();
        if (fileGroup != null) {
            for (RepositoryArtifact repositoryArtifact : fileGroup.getFiles()) {
                if (StringUtil.isNullOrEmpty((String)repositoryArtifact.getGroup(), (boolean)true)) continue;
                repositoryArtifacts.add(repositoryArtifact);
            }
            for (Directory directory : fileGroup.getDirectories()) {
                if (!StringUtil.isNullOrEmpty((String)directory.getGroup(), (boolean)true)) {
                    repositoryArtifacts.add(directory);
                }
                repositoryArtifacts.addAll(ComponentArchiveUtils.getFileGroupRepositoryArtifacts(directory));
            }
        }
        return repositoryArtifacts;
    }

    public static String getTargetedCarbClassifier(Artifact carbArtifact) {
        String carbArtifactGroup;
        if (carbArtifact != null && !"com.oracle.cie.gdr.carb".equals(carbArtifactGroup = carbArtifact.getGroup()) && !"com.oracle.cie.gdr.patch.carb".equals(carbArtifactGroup)) {
            String suffix;
            int index;
            if (carbArtifactGroup.startsWith("com.oracle.cie.gdr.carb")) {
                return carbArtifactGroup.substring("com.oracle.cie.gdr.carb".length() + 1);
            }
            if (carbArtifactGroup.startsWith("com.oracle.cie.gdr.patch.carb") && (index = (suffix = carbArtifactGroup.substring("com.oracle.cie.gdr.patch.carb".length() + 1)).indexOf(".")) > -1) {
                return suffix.substring(index + 1);
            }
        }
        return null;
    }

    public static boolean isTargetedCarb(Artifact carbArtifact) {
        String carbArtifactGroup;
        return carbArtifact != null && !"com.oracle.cie.gdr.carb".equals(carbArtifactGroup = carbArtifact.getGroup()) && carbArtifactGroup.startsWith("com.oracle.cie.gdr.carb");
    }

    public static void getTargetNames(String targetString, Set<String> platformNames, Set<String> localeNames) throws GdrException {
        if (!StringUtil.isNullOrEmpty((String)targetString, (boolean)true)) {
            String[] targets;
            if (platformNames == null) {
                platformNames = new HashSet<String>();
            }
            if (localeNames == null) {
                localeNames = new HashSet<String>();
            }
            for (String target : targets = targetString.split("\\.")) {
                Set targetPlatformHolders = PlatformInfoHelper.getInstance().getInfoHoldersFromTarget(target);
                Set targetLocaleHolders = LocaleInfoHelper.getInstance().getLocaleInfoHoldersFromTarget(target);
                if (targetPlatformHolders.isEmpty() && targetLocaleHolders.isEmpty()) {
                    throw new GdrException("Unable to locate platform or locale info holder for target name " + targetString);
                }
                for (InfoHolder infoHolder : targetPlatformHolders) {
                    platformNames.add(infoHolder.getName());
                }
                for (LocaleInfoHolder localeInfoHolder : targetLocaleHolders) {
                    localeNames.add(localeInfoHolder.getLocale().toString());
                }
            }
        }
    }

    public static String getTargetIdentifier(Set<String> platformNames, Set<String> localeNames) throws GdrException {
        Map platforms = PlatformInfoHelper.getInstance().getIds(platformNames);
        platforms.remove(2000);
        String id = ComponentArchiveUtils.getTargetEncoding(platforms, "p_");
        Map locales = LocaleInfoHelper.getInstance().getLocaleIds(localeNames);
        String localeId = ComponentArchiveUtils.getTargetEncoding(locales, "l_");
        if (id == null && localeId != null) {
            id = localeId;
        } else if (id != null && localeId != null) {
            id = id + "." + localeId;
        }
        return id;
    }

    public static String getTargetEncoding(Map<Integer, String> identifiers, String multiClassifierPrefix) {
        String encoding = null;
        if (identifiers != null && !identifiers.isEmpty()) {
            if (identifiers.size() > 1) {
                String multiId = EncodingService.encode(identifiers.keySet());
                encoding = multiClassifierPrefix + multiId;
            } else {
                encoding = identifiers.values().iterator().next().toLowerCase();
            }
        }
        return encoding;
    }

    public static boolean matchesTarget(Set<String> platforms, Set<String> locales, Collection<PlatformInfoHolder> targetPlatforms, Collection<LocaleInfoHolder> targetLocales) throws GdrException {
        if (targetPlatforms != null && !targetPlatforms.isEmpty() || targetLocales != null && !targetLocales.isEmpty()) {
            boolean bl;
            boolean bl2;
            boolean platformMatches;
            HashSet platformInfoHolders = new HashSet();
            HashSet<LocaleInfoHolder> localeInfoHolders = new HashSet<LocaleInfoHolder>();
            if (platforms != null && !platforms.isEmpty()) {
                block0: for (String string : platforms) {
                    Collection platformsIds;
                    if (string.startsWith("p_")) {
                        platformsIds = EncodingService.decode((String)string.substring("p_".length()));
                    } else {
                        Integer id = PlatformInfoHelper.getInstance().getId(string);
                        if (id != null) {
                            platformsIds = new ArrayList();
                            platformsIds.add(id);
                        } else {
                            throw new GdrException("Unable to locate platform or group for target name " + string);
                        }
                    }
                    if (platformsIds == null) continue;
                    for (Integer n : platformsIds) {
                        if (n == 2000) {
                            platformInfoHolders.clear();
                            continue block0;
                        }
                        platformInfoHolders.addAll(PlatformInfoHelper.getInstance().getPlatformInfoHolders(n.intValue()));
                    }
                }
            }
            if (locales != null && !locales.isEmpty()) {
                for (String string : locales) {
                    if (string.startsWith("l_")) {
                        Set localesIds = EncodingService.decode((String)string.substring("l_".length()));
                        for (Integer n : localesIds) {
                            localeInfoHolders.add(LocaleInfoHelper.getInstance().getLocaleInfoHolderById(n.intValue()));
                        }
                        continue;
                    }
                    LocaleInfoHolder localeInfoHolder = LocaleInfoHelper.getInstance().getLocaleInfoHolder(string);
                    if (localeInfoHolder != null) {
                        localeInfoHolders.add(localeInfoHolder);
                        continue;
                    }
                    throw new GdrException("Unable to locate locale for target name " + string);
                }
            }
            boolean bl3 = platformMatches = platformInfoHolders.isEmpty() || targetPlatforms == null || targetPlatforms.isEmpty() || targetPlatforms.contains(PlatformInfoHelper.getInstance().getPlatformInfoHolder(2000));
            if (!platformMatches) {
                for (PlatformInfoHolder platformInfoHolder : platformInfoHolders) {
                    if (!targetPlatforms.contains(platformInfoHolder)) continue;
                    platformMatches = true;
                    break;
                }
            }
            boolean bl4 = bl2 = localeInfoHolders.isEmpty() || targetLocales == null || targetLocales.isEmpty();
            if (!bl2) {
                for (LocaleInfoHolder localeInfoHolder : localeInfoHolders) {
                    if (!targetLocales.contains(localeInfoHolder)) continue;
                    bl = true;
                    break;
                }
            }
            return platformMatches && bl;
        }
        return true;
    }

    public static Artifact createArtifactManifest(File createdArtifactFile, Collection<? extends Artifact> artifacts, String groupId, String artifactId, com.oracle.cie.dependency.mgmt.Version version, DependencyFileType type) throws DependencyManagementException, IOException {
        return ComponentArchiveUtils.createArtifactManifest(createdArtifactFile, artifacts, groupId, artifactId, version, type, false);
    }

    public static Artifact createArtifactManifest(File createdArtifactFile, Collection<? extends Artifact> artifacts, String groupId, String artifactId, com.oracle.cie.dependency.mgmt.Version version, DependencyFileType type, boolean append) throws DependencyManagementException, IOException {
        if (createdArtifactFile == null) {
            throw new NullPointerException("The created artifact file specified was null.");
        }
        if (type == null) {
            type = DependencyFileType.pom;
        }
        ArrayList<Dependency> dependencies = null;
        if (append && createdArtifactFile.exists()) {
            dependencies = DependencyManagementFactory.getInstance().getDependencyFileHandler(type).readDependenciesFile(createdArtifactFile).getDependencies();
        }
        Module module = DependencyManagementFactory.getInstance().getModule(groupId, artifactId, version, type.name());
        if (artifacts != null && !artifacts.isEmpty()) {
            if (dependencies == null) {
                dependencies = new ArrayList<Dependency>();
            }
            for (Artifact artifact : artifacts) {
                Dependency dependency = artifact instanceof Dependency ? (Dependency)artifact : DependencyManagementFactory.getInstance().getDependency(artifact);
                dependency.setDependencyManagement(true);
                dependencies.add(dependency);
            }
            module.setDependencies(dependencies);
        }
        DependencyManagementFactory.getInstance().getDependencyFileHandler(type).writeDependenciesFile(module, createdArtifactFile);
        return module.getArtifact();
    }
}

