/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.utils.ComponentArchiveUtils;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ComponentArchiveSplitter {
    private static final Logger _log = Logger.getLogger(ComponentArchiveSplitter.class.getName());
    private Map<Reference, File> _components;
    private File _outputDir;
    private String _versionQualifier;
    private boolean _createJars = true;
    private boolean _outputDirRepositoryLayout = false;
    private boolean _createTargetedCarbs = false;
    private boolean _disableBaseCarb = false;
    private boolean _createComponentInfo = false;
    private boolean _createCarbPoms = true;
    private String _patchId = null;
    private String _patchLevel = null;
    private File _createdCarbsFile;
    private boolean _packagedOnly = false;
    private DependencyFileType _createdCarbsFileType = DependencyFileType.pom;
    private boolean _createdCarbsFileAppend = false;
    private Set<String> selectedLocales = new HashSet<String>();

    public ComponentArchiveSplitter(File stageDir, File outputDir) throws IOException {
        this(stageDir, outputDir, null);
    }

    public ComponentArchiveSplitter(File stageDir, File outputDir, String versionQualifier) throws IOException {
        this(ComponentArchiveUtils.createComponentLocationMap(stageDir), outputDir, versionQualifier);
    }

    public ComponentArchiveSplitter(Collection<Component> components, File outputDir, String versionQualifier) {
        this(ComponentArchiveUtils.createComponentLocationMap(components), outputDir, versionQualifier);
    }

    public ComponentArchiveSplitter(Component component, File outputDir, String versionQualifier) {
        this(ComponentArchiveUtils.createComponentLocationMap(component), outputDir, versionQualifier);
    }

    public ComponentArchiveSplitter(Map<Reference, File> components, File outputDir, String versionQualifier) {
        if (components == null || components.isEmpty()) {
            throw new IllegalArgumentException("No components were provided.");
        }
        if (outputDir == null) {
            throw new NullPointerException("The output directory specified was null.");
        }
        this._components = components;
        this._outputDir = outputDir;
        this._versionQualifier = versionQualifier;
    }

    public File getOutputDir() {
        return this._outputDir;
    }

    public String getVersionQualifier() {
        return this._versionQualifier;
    }

    public boolean isCreateJars() {
        return this._createJars;
    }

    public void setCreateJars(boolean createJars) {
        this._createJars = createJars;
    }

    public boolean isOutputDirRepositoryLayout() {
        return this._outputDirRepositoryLayout;
    }

    public void setOutputDirRepositoryLayout(boolean outputDirRepositoryLayout) {
        this._outputDirRepositoryLayout = outputDirRepositoryLayout;
    }

    public boolean isCreateTargetedCarbs() {
        return this._createTargetedCarbs;
    }

    public void setCreateTargetedCarbs(boolean createTargetedCarbs) {
        this._createTargetedCarbs = createTargetedCarbs;
    }

    public boolean isDisableBaseCarb() {
        return this._disableBaseCarb;
    }

    public void setDisableBaseCarb(boolean disableBaseCarb) {
        this._disableBaseCarb = disableBaseCarb;
    }

    public boolean isCreateComponentInfo() {
        return this._createComponentInfo;
    }

    public void setCreateComponentInfo(boolean createComponentInfo) {
        this._createComponentInfo = createComponentInfo;
    }

    public boolean isCreateCarbPoms() {
        return this._createCarbPoms;
    }

    public void setCreateCarbPoms(boolean createCarbPoms) {
        this._createCarbPoms = createCarbPoms;
    }

    public File getCreatedCarbsFile() {
        return this._createdCarbsFile;
    }

    public void setCreatedCarbsFile(File createdCarbsFile) {
        this._createdCarbsFile = createdCarbsFile;
    }

    public DependencyFileType getCreatedCarbsFileType() {
        return this._createdCarbsFileType;
    }

    public void setCreatedCarbsFileType(DependencyFileType createdCarbsFileType) {
        this._createdCarbsFileType = createdCarbsFileType;
    }

    public boolean isCreatedCarbsFileAppend() {
        return this._createdCarbsFileAppend;
    }

    public void setCreatedCarbsFileAppend(boolean createdCarbsFileAppend) {
        this._createdCarbsFileAppend = createdCarbsFileAppend;
    }

    public boolean isPatch() {
        return !StringUtil.isNullOrEmpty((String)this._patchId, (boolean)true);
    }

    public String getPatchId() {
        return this._patchId;
    }

    public void setPatchId(String patchId) {
        this._patchId = patchId;
    }

    public String getPatchLevel() {
        return this._patchLevel;
    }

    public void setPatchLevel(String patchLevel) {
        this._patchLevel = patchLevel;
    }

    public boolean isPackagedOnly() {
        return this._packagedOnly;
    }

    public void setPackagedOnly(boolean packagedOnly) {
        this._packagedOnly = packagedOnly;
    }

    public Map<Artifact, File> split() throws IOException, DataHandlerException, GdrException, DependencyManagementException {
        return this.split(false, (String)null);
    }

    public Map<Artifact, File> split(boolean keepExistingCarb) throws IOException, DataHandlerException, GdrException, DependencyManagementException {
        return this.split(keepExistingCarb, (String)null);
    }

    public Map<Artifact, File> split(boolean keepExistingCarb, String manifestBuildInfo) throws IOException, DataHandlerException, GdrException, DependencyManagementException {
        HashMap<String, String> manifestEntries = null;
        if (!StringUtil.isNullOrEmpty((String)manifestBuildInfo, (boolean)true)) {
            manifestEntries = new HashMap<String, String>();
            manifestEntries.put("Build-Info", manifestBuildInfo);
        }
        return this.split(keepExistingCarb, manifestEntries);
    }

    public Map<Artifact, File> split(boolean keepExistingCarb, Map<String, String> manifestEntries) throws IOException, DataHandlerException, GdrException, DependencyManagementException {
        if (!this.isCreateTargetedCarbs() && this.isDisableBaseCarb()) {
            throw new GdrException("Base carb creation can only be disabled when building targeted carbs.");
        }
        LinkedHashMap<Artifact, File> carbDirs = new LinkedHashMap<Artifact, File>();
        String groupId = this.isPatch() ? "com.oracle.cie.gdr.patch.carb." + this.getPatchId() : "com.oracle.cie.gdr.carb";
        for (Object compRef : this._components.keySet()) {
            File file = this._components.get(compRef);
            if (file == null) {
                throw new NullPointerException("The stage directory specified was null.");
            }
            if (!file.exists()) {
                throw new FileNotFoundException("The stage directory specified did not exist: " + file);
            }
            String name = compRef.getName();
            String version = compRef.getVersion();
            File compDir = new File(file + File.separator + "Components" + File.separator + name + File.separator + version);
            if (!compDir.exists()) {
                throw new FileNotFoundException("Unable to locate component under stage directory: " + (Object)compRef + ":" + file);
            }
            File compDefXml = new File(compDir, "compDef.xml");
            if (!compDefXml.exists()) {
                throw new FileNotFoundException("Component directory missing component definition: " + compDefXml);
            }
            LinkedHashMap<Artifact, Component> carbArtifacts = new LinkedHashMap<Artifact, Component>();
            if (this.isCreateTargetedCarbs()) {
                Component component = this.getComponent(file, (Reference)((Object)compRef));
                List<FileMap> fileMaps = component.getFileMaps();
                LinkedHashMap<String, ArrayList<FileMap>> idToFileMap = new LinkedHashMap<String, ArrayList<FileMap>>();
                if (fileMaps != null && !fileMaps.isEmpty()) {
                    for (FileMap fileMap : fileMaps) {
                        ArrayList<FileMap> idFileMaps;
                        Set<String> locales;
                        if (this.isPackagedOnly() && !fileMap.isPackaged() || !this.isLocaleGeneric(locales = fileMap.getLocales()) && !this.areLocalesSelected(locales)) continue;
                        String id = ComponentArchiveUtils.getTargetIdentifier(fileMap.getPlatforms(true, false), locales);
                        if (id == null) {
                            id = "generic";
                        }
                        if ((idFileMaps = (ArrayList<FileMap>)idToFileMap.get(id)) == null) {
                            idFileMaps = new ArrayList<FileMap>();
                            idToFileMap.put(id, idFileMaps);
                        }
                        idFileMaps.add(fileMap);
                    }
                }
                if (idToFileMap.isEmpty() || idToFileMap.size() == 1 && idToFileMap.containsKey("generic")) {
                    if (this.isDisableBaseCarb()) {
                        _log.warning("Skipping component because it contains no targeted file maps and base carb creation is disabled: " + component);
                        continue;
                    }
                    Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(groupId, name, version, "carb", new String[]{this.getVersionQualifier()});
                    carbArtifacts.put(artifact, null);
                } else {
                    for (String id : idToFileMap.keySet()) {
                        Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(groupId, name, version, "carb", new String[]{this.getVersionQualifier()});
                        if (!id.equals("generic")) {
                            artifact.setGroup(groupId + "." + id);
                            artifact.setClassifier(id);
                        } else if (this.isDisableBaseCarb()) {
                            _log.warning("Skipping file-map because it contains no target and base carb creation is disabled: " + component);
                            continue;
                        }
                        Component componentCopy = component.copy();
                        componentCopy.setFileMaps((List)idToFileMap.get(id));
                        carbArtifacts.put(artifact, componentCopy);
                    }
                }
            } else {
                Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(groupId, name, version, "carb", new String[]{this.getVersionQualifier()});
                carbArtifacts.put(artifact, null);
            }
            if (carbArtifacts.isEmpty()) continue;
            for (Artifact artifact : carbArtifacts.keySet()) {
                if (keepExistingCarb && ComponentArchiveUtils.carbExists(artifact.getName(), artifact.getBaseVersion(), this._outputDir, this.getVersionQualifier(), this._outputDirRepositoryLayout, artifact.getClassifier())) continue;
                File carbDir = ComponentArchiveUtils.splitComponentDir(artifact, (Component)carbArtifacts.get(artifact), this._outputDir, file, this.getVersionQualifier(), this._patchLevel);
                carbDirs.put(artifact, carbDir);
            }
        }
        LinkedHashMap<Artifact, File> createdCarbs = new LinkedHashMap<Artifact, File>();
        for (Map.Entry entry : carbDirs.entrySet()) {
            Artifact artifact = (Artifact)entry.getKey();
            File carbDir = (File)entry.getValue();
            if (this.isCreateJars()) {
                String classifier = artifact.getClassifier();
                if (!StringUtil.isNullOrEmpty((String)classifier, (boolean)true)) {
                    artifact.setClassifier(null);
                }
                createdCarbs.put(artifact, ComponentArchiveUtils.packageCarb(groupId, artifact.getName(), artifact.getBaseVersion(), carbDir, this._outputDir, this.getVersionQualifier(), manifestEntries, this._outputDirRepositoryLayout, classifier));
                continue;
            }
            createdCarbs.put(artifact, carbDir);
        }
        LinkedHashMap<Artifact, File> createdPoms = new LinkedHashMap<Artifact, File>();
        if (this.isCreateCarbPoms()) {
            createdPoms.putAll(ComponentArchiveUtils.createCarbConsumptionFiles(createdCarbs, this._outputDir, this._outputDirRepositoryLayout));
        }
        LinkedHashMap<Artifact, File> linkedHashMap = new LinkedHashMap<Artifact, File>();
        if (this.isCreateComponentInfo() && this.isCreateTargetedCarbs()) {
            linkedHashMap.putAll(ComponentArchiveUtils.createComponentInfos(createdCarbs, this._outputDir, this.getVersionQualifier(), this._outputDirRepositoryLayout));
        }
        HashMap<Artifact, File> created = new HashMap<Artifact, File>(createdCarbs);
        created.putAll(createdPoms);
        created.putAll(linkedHashMap);
        if (this.getCreatedCarbsFile() != null) {
            ComponentArchiveUtils.createArtifactManifest(this.getCreatedCarbsFile(), created.keySet(), "com.oracle.cie.gdr.carb.artifacts", "created-carbs", DependencyManagementFactory.getInstance().getVersion("1.0.0", new String[]{this.getVersionQualifier()}), this.getCreatedCarbsFileType(), this.isCreatedCarbsFileAppend());
        }
        return created;
    }

    private boolean isLocaleGeneric(Set<String> locales) {
        if (this.selectedLocales == null || this.selectedLocales.size() == 0) {
            return true;
        }
        for (String loc : this.selectedLocales) {
            if (!loc.equalsIgnoreCase("ALL_LOCALES")) continue;
            return true;
        }
        return false;
    }

    private boolean areLocalesSelected(Set<String> locales) {
        for (String loc : locales) {
            if (!this.selectedLocales.contains(loc)) continue;
            return true;
        }
        return false;
    }

    protected Component getComponent(File stageDir, Reference compRef) throws IOException, DataHandlerException, GdrException {
        return ComponentHelper.getInstance().getComponentArchiveFromLabel(stageDir, compRef);
    }

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 4) {
            System.out.println(ComponentArchiveSplitter.getUsage());
            System.exit(-1);
        }
        File stageDir = new File(args[0]);
        File outputDir = new File(args[1]);
        String versionQualifier = args.length > 2 ? args[2] : null;
        boolean createJars = args.length <= 3 || !"false".equalsIgnoreCase(args[3]);
        try {
            ComponentArchiveSplitter.split(stageDir, outputDir, versionQualifier, createJars);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-2);
        }
    }

    static void split(File stageDir, File outputDir, String versionQualifier, boolean createJars) throws IOException, DataHandlerException, GdrException, DependencyManagementException {
        ComponentArchiveSplitter splitter = new ComponentArchiveSplitter(stageDir, outputDir, versionQualifier);
        splitter.setCreateJars(createJars);
        splitter.split();
    }

    public static String getUsage() {
        return "java " + ComponentArchiveSplitter.class.getSimpleName() + " <stage_dir> <output_dir> <version_qualifier> <true/false>";
    }

    public void setLocales(String locs) {
        if (locs == null || locs.isEmpty()) {
            locs = "ALL_LOCALES";
        }
        String[] locsArray = locs.split(",");
        for (int i = 0; i < locsArray.length; ++i) {
            this.selectedLocales.add(locsArray[i].trim());
        }
    }
}

