/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class NginstSanityTest {
    private static final String FS = File.separator;
    private static final String WORK_DIR = "-workDir";
    private static final String HELP = "-help";
    private static final String LOGS_FOLDER_NAME = "NginstSanityTest";
    private String _logsDir;
    private String _viewRoot;
    private String _viewAntLabel;
    private String _nginstAntLabel;
    private static final Logger _log = Logger.getLogger(NginstSanityTest.class.getName());

    private NginstSanityTest(String workDir) {
        this.setLogsDir(workDir);
    }

    private boolean run() throws TestException, IOException, GdrException {
        _log.log(Level.INFO, "Initializing sanity test...");
        File dir = new File(this.getLogsDir());
        if (dir.exists()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                file.delete();
            }
            dir.delete();
        }
        dir.mkdirs();
        _log.log(Level.INFO, "Logs directory '" + dir.getAbsolutePath() + "' was created successfully");
        try {
            FileHandler handler = new FileHandler(this.getLogsDir() + "SanityTest.log", false);
            handler.setFormatter(new SimpleFormatter());
            _log.addHandler(handler);
            _log.setLevel(Level.ALL);
            handler.setLevel(Level.ALL);
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "Unable to create log file " + this.getLogsDir() + "SanityTest.log");
            throw new TestException((Throwable)e);
        }
        this.getViewRootDir();
        String nginstLabel = TopLevelDirectoryService.getLabelFromTopLevelDirectory("nginst");
        _log.log(Level.INFO, "Current view NGINST label is " + nginstLabel + " label.");
        String nginstSeries = TopLevelDirectoryService.getSeriesFromTopLevelDirectory("nginst");
        String nginstLatestLabel = this.getLatestLabel(nginstSeries);
        _log.log(Level.INFO, "NGISNT label will be reseted to " + nginstLatestLabel + ".");
        this.resetDepLabel(nginstLatestLabel);
        this.expand(this.getViewRoot() + "nginst");
        String viewAntSeries = TopLevelDirectoryService.getSeriesFromTopLevelDirectory("ant");
        this.setViewAntLabel(this.getLatestLabel(viewAntSeries));
        _log.log(Level.INFO, "Current view ANT label is " + this.getViewAntLabel());
        String nginstAntSeries = "ANT_1.8.2_GENERIC";
        this.setNginstAntLabel(this.getLatestLabel(nginstAntSeries));
        _log.log(Level.INFO, "NGINST ANT label is " + this.getNginstAntLabel() + ".");
        if (!this.getNginstAntLabel().equals(this.getViewAntLabel())) {
            _log.log(Level.INFO, "Current view ANT label will be reseted to " + this.getNginstAntLabel());
            this.resetDepLabel(this.getNginstAntLabel());
        }
        String antScriptPath = this.getLogsDir() + File.separator + "build_nginst.sh";
        String[] commands = new String[]{"cd " + this.getViewRoot() + "nginst/src", ". ./devenv.sh &>" + this.getLogsDir() + "devenv.log", "export NDE_PRODUCT=nginst", "export NDE_PRODUCT_ROOT=" + this.getViewRoot() + "nginst", "cd " + this.getViewRoot() + "nginst", "ant clean -logfile " + this.getLogsDir() + "nginst_ant_clean.log", "ant all -logfile " + this.getLogsDir() + "nginst_ant_all.log"};
        this.createAndExecuteScript(antScriptPath, commands);
        String stageScriptPath = this.getLogsDir() + File.separator + "make_stage.sh";
        commands = new String[]{"cd " + this.getViewRoot() + "nginst/src", ". ./devenv.sh &>" + this.getLogsDir() + "devenv.log", "export NDE_PRODUCT=nginst", "export NDE_PRODUCT_ROOT=" + this.getViewRoot() + "nginst", "rm " + this.getViewRoot() + "nginst/nginstall/stage -r", "cd " + this.getViewRoot() + "nginst/bin", "perl compStager.pl &>" + this.getLogsDir() + "compStager.log", "perl shiphomeStager.pl &>" + this.getLogsDir() + "shiphomeStager.log"};
        this.createAndExecuteScript(stageScriptPath, commands);
        _log.log(Level.INFO, "Restore ANT version.");
        return this.resetDepLabel(this.getViewAntLabel());
    }

    private boolean getViewRootDir() throws TestException, IOException, GdrException {
        List<String> output = TopLevelDirectoryService.getCommandOutput("/bin/sh", "-c", "echo $ADE_VIEW_ROOT");
        if (output != null && !output.isEmpty()) {
            String result = output.get(0);
            if (result != null && !result.isEmpty()) {
                File viewRoot = new File(result.trim());
                String symlink = ComponentHelper.getInstance().getSymlink(viewRoot);
                _log.log(Level.INFO, "Using ADE_VIEW_ROOT=" + symlink + ".");
                this.setViewRoot(symlink);
                return true;
            }
            _log.log(Level.WARNING, output.toString());
        }
        String message = "Unable to resolve $ADE_VIEW_ROOT symlink";
        _log.log(Level.SEVERE, message);
        throw new TestException(message);
    }

    private boolean createAndExecuteScript(String scriptPath, String ... commands) throws TestException, IOException {
        File script = new File(scriptPath);
        script.delete();
        try (PrintWriter out = null;){
            script.createNewFile();
            out = new PrintWriter(new BufferedWriter(new FileWriter(script.getAbsoluteFile(), true)));
            out.println("#!/usr/bin/env bash");
            for (String command : commands) {
                out.println(command);
            }
        }
        _log.log(Level.INFO, scriptPath + " generated successfully.");
        _log.log(Level.INFO, "Executing " + scriptPath + " .");
        List<String> output = TopLevelDirectoryService.getCommandOutput(0, "/bin/bash", scriptPath);
        return true;
    }

    private boolean expand(String dir) throws IOException, TestException {
        String message = "";
        if (!NginstSanityTest.isNullOrEmpty(dir)) {
            _log.log(Level.INFO, "Expanding directory " + dir);
            List<String> output = TopLevelDirectoryService.getCommandOutput("/bin/sh", "-c", "ade expand -recurse " + dir);
            if (output != null && !output.isEmpty()) {
                String result = output.get(0);
                if (result != null && !result.isEmpty()) {
                    _log.log(Level.FINEST, result);
                    _log.log(Level.INFO, dir + " was successfully expanded.");
                    return true;
                }
                _log.log(Level.SEVERE, output.toString());
                message = "Unexpected return value.";
            }
        } else {
            message = "Dir value can not be null or empty.";
        }
        _log.log(Level.SEVERE, message);
        throw new TestException(message);
    }

    private String getDepProdSeries(String tld, String label) throws TestException, IOException {
        if (!NginstSanityTest.isNullOrEmpty(tld) || !NginstSanityTest.isNullOrEmpty(label)) {
            String[] command = new String[]{"/bin/sh", "-c", "echo `ade showdepprods -inl " + label + " -tld " + tld.toLowerCase() + "`"};
            _log.log(Level.FINEST, "Executing 'ade showdepprods -inl " + label + " -tld " + tld.toLowerCase() + " -short | grep " + tld + " | cut -d':' -f2 | cut -d' ' -f2 | grep -o -e '" + tld + "_[a-zA-Z0-9.]*_[a-zA-Z0-9.]*'");
            return this.getDepProdSeries(command);
        }
        String message = "Can not showdepprods,tld or label values were null or empty.";
        _log.log(Level.SEVERE, message);
        throw new TestException(message);
    }

    private String getDepProdSeries(String ... command) throws TestException, IOException {
        List<String> output = TopLevelDirectoryService.getCommandOutput(command);
        if (output != null && !output.isEmpty()) {
            String result = output.get(0).trim();
            if (result != null && !result.isEmpty() && !result.contains("WARNING")) {
                return result.trim();
            }
            _log.log(Level.SEVERE, "Command: " + command.toString());
            _log.log(Level.SEVERE, result);
        }
        String message = "Unable to find dependent product.";
        _log.log(Level.SEVERE, message);
        throw new TestException(message);
    }

    private boolean resetDepLabel(String label) throws TestException, IOException {
        String message = "";
        if (!NginstSanityTest.isNullOrEmpty(label)) {
            _log.log(Level.INFO, "Reseting deplabel " + label);
            List<String> output = TopLevelDirectoryService.getCommandOutput("/bin/sh", "-c", "ade resetdeplabel " + label);
            if (output != null && !output.isEmpty()) {
                String result = output.get(0);
                if (result != null && !result.isEmpty()) {
                    _log.log(Level.FINEST, result);
                    return true;
                }
                _log.log(Level.SEVERE, result);
                message = "Unexpected return value.";
            }
        } else {
            message = "Label can not be null or empty.";
        }
        _log.log(Level.SEVERE, message);
        throw new TestException(message);
    }

    private String getLatestLabel(String series) throws TestException, IOException {
        String message = "";
        if (series != null) {
            String[] command = new String[]{"/bin/sh", "-c", "ade showlabels -series " + series + " -latest | grep " + series};
            _log.log(Level.INFO, "Getting latest " + series + " label.");
            List<String> output = TopLevelDirectoryService.getCommandOutput(command);
            if (output != null && !output.isEmpty()) {
                String result = output.get(0).trim();
                if (result != null && !result.isEmpty() && !result.contains("WARNING")) {
                    return result;
                }
                _log.log(Level.SEVERE, result);
            }
            message = "Unexpected return value.";
        } else {
            message = "Unable to get latest label of series " + series + ".";
        }
        _log.log(Level.SEVERE, message);
        throw new TestException(message);
    }

    public static void main(String[] args) {
        try {
            SanityTestValidator validator = SanityTestValidator.getInstance();
            validator.process(args);
            validator.validate();
            Map<String, String> arguments = validator.getArguments();
            if (Boolean.valueOf(arguments.get(HELP)).booleanValue()) {
                NginstSanityTest.printUsageInstructions();
                return;
            }
            NginstSanityTest test = new NginstSanityTest(arguments.get(WORK_DIR));
            test.run();
        }
        catch (Exception e) {
            System.out.println("NGINST Sanity test failed with the following error:");
            e.printStackTrace();
        }
    }

    private static void printUsageInstructions() {
        System.out.println("Java -cp <location of SanityTest.class> -workDir <WORK_DIR>");
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.length() < 1;
    }

    public String getLogsDir() {
        return this._logsDir;
    }

    public void setLogsDir(String workDir) {
        this._logsDir = workDir + FS + LOGS_FOLDER_NAME + FS;
    }

    public String getViewRoot() {
        return this._viewRoot;
    }

    public void setViewRoot(String viewRoot) {
        this._viewRoot = viewRoot + FS;
    }

    public String getViewAntLabel() {
        return this._viewAntLabel;
    }

    public void setViewAntLabel(String viewAntLabel) {
        this._viewAntLabel = viewAntLabel;
    }

    public String getNginstAntLabel() {
        return this._nginstAntLabel;
    }

    public void setNginstAntLabel(String nginstAntLabel) {
        this._nginstAntLabel = nginstAntLabel;
    }

    public class TestException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TestException() {
        }

        public TestException(Throwable cause) {
            super(cause);
        }

        public TestException(String message) {
            super(message);
        }

        public TestException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class SanityTestValidator {
        private static SanityTestValidator _instance = new SanityTestValidator();
        private Map<String, String> _arguments;

        private SanityTestValidator() {
        }

        public static SanityTestValidator getInstance() {
            return _instance;
        }

        public void process(String[] args) throws Exception {
            String parameter = null;
            String value = null;
            this._arguments = new HashMap<String, String>();
            for (int i = 0; i < args.length; ++i) {
                parameter = args[i];
                if (i + 1 < args.length) {
                    value = args[i + 1];
                }
                if (parameter.equals(NginstSanityTest.WORK_DIR)) {
                    if (value.isEmpty() || value == null) {
                        throw new Exception("The -workDir hasn't been specified or is empty");
                    }
                    this._arguments.put(NginstSanityTest.WORK_DIR, value);
                    ++i;
                    continue;
                }
                if (parameter.startsWith(NginstSanityTest.HELP)) {
                    this._arguments.put(NginstSanityTest.HELP, "true");
                    continue;
                }
                throw new Exception("Invalid input parameter: " + parameter);
            }
            if (this._arguments.isEmpty()) {
                this._arguments.put(NginstSanityTest.HELP, "true");
            }
        }

        public void validate() throws Exception {
            String logDir = this._arguments.get(NginstSanityTest.WORK_DIR);
            String help = this._arguments.get(NginstSanityTest.HELP);
            if (!(!NginstSanityTest.isNullOrEmpty(help) && (NginstSanityTest.isNullOrEmpty(help) || Boolean.valueOf(help).booleanValue()) || !NginstSanityTest.isNullOrEmpty(logDir) && new File(logDir).isDirectory())) {
                throw new Exception("The -workDir must be a directory.");
            }
        }

        public Map<String, String> getArguments() {
            return this._arguments;
        }
    }
}

