/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.gdr.DistributionLoaderFactory;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.dbd.InstallType;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.ftr.FeatureSetDependencies;
import com.oracle.cie.gdr.dao.ftr.FeatureSetDependency;
import com.oracle.cie.gdr.dao.lbm.ComponentMapping;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dependency.FeatureDependencyManager;
import com.oracle.cie.gdr.helpers.ComponentInfoHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import com.oracle.cie.gdr.services.FileLocatorService;
import com.oracle.cie.gdr.tools.FeatureSetConsumer;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GdrMetaDataValidator {
    private static final Logger _log = Logger.getLogger(GdrMetaDataValidator.class.getName());
    private boolean _debug;
    private File _gdrMetaDataHome;
    private Map<File, String> _failedDistributions = new LinkedHashMap<File, String>();
    private Map<File, String> _failedDistributionInfos = new LinkedHashMap<File, String>();
    private Map<File, String> _failedFeatures = new LinkedHashMap<File, String>();
    private Map<File, String> _failedDistributionCompatibilityFiles = new LinkedHashMap<File, String>();
    private Map<File, String> _failedComponentInfos = new LinkedHashMap<File, String>();
    private Map<File, Collection<String>> _missingDistributionFeatures = new LinkedHashMap<File, Collection<String>>();
    private Map<File, Collection<String>> _missingFeatureDependencies = new LinkedHashMap<File, Collection<String>>();
    private Map<File, Collection<String>> _missingDistributionCompatibilityDependencies = new LinkedHashMap<File, Collection<String>>();
    private Map<File, Collection<String>> _missingComponentMappings = new LinkedHashMap<File, Collection<String>>();
    private Collection<File> _missingDistributionInfos = new ArrayList<File>();
    private Collection<File> _orphanedDistributionInfos = new ArrayList<File>();
    private Collection<String> _missingFeatureResources = new ArrayList<String>();
    private Collection<String> _missingDistributionResources = new ArrayList<String>();
    private Map<File, Collection<String>> _missingFeatureResourceKeys = new LinkedHashMap<File, Collection<String>>();
    private Map<File, Collection<String>> _missingDistributionResourceKeys = new LinkedHashMap<File, Collection<String>>();
    private FeatureSetConsumer _consumer;
    private String _failedLabelMap;

    public GdrMetaDataValidator(File gdrMetaDataHome) {
        this._gdrMetaDataHome = gdrMetaDataHome;
    }

    public File getGdrMetaDataHome() {
        return this._gdrMetaDataHome;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public Map<File, String> getFailedDistributions() {
        return this._failedDistributions;
    }

    public Map<File, String> getFailedDistributionInfos() {
        return this._failedDistributionInfos;
    }

    public Map<File, String> getFailedComponentInfos() {
        return this._failedComponentInfos;
    }

    public Map<File, String> getFailedFeatures() {
        return this._failedFeatures;
    }

    public Map<File, String> getFailedDistributionCompatibilityFiles() {
        return this._failedDistributionCompatibilityFiles;
    }

    public Collection<FeatureSet> getNonConsumableFeatures() {
        return this._consumer.getNonConsumableFeatures();
    }

    public Map<File, Collection<String>> getMissingDistributionFeatures() {
        return this._missingDistributionFeatures;
    }

    public Map<File, Collection<String>> getMissingFeatureDependencies() {
        return this._missingFeatureDependencies;
    }

    public Map<File, Collection<String>> getMissingDistributionCompatibilityDependencies() {
        return this._missingDistributionCompatibilityDependencies;
    }

    public Map<File, Collection<String>> getMissingComponentMappings() {
        return this._missingComponentMappings;
    }

    public String getFailedLabelMap() {
        return this._failedLabelMap;
    }

    public Collection<File> getMissingDistributionInfos() {
        return this._missingDistributionInfos;
    }

    public Collection<File> getOrphanedDistributionInfos() {
        return this._orphanedDistributionInfos;
    }

    public Collection<String> getMissingFeatureResources() {
        return this._missingFeatureResources;
    }

    public Collection<String> getMissingDistributionResources() {
        return this._missingDistributionResources;
    }

    public Map<File, Collection<String>> getMissingFeatureResourceKeys() {
        return this._missingFeatureResourceKeys;
    }

    public Map<File, Collection<String>> getMissingDistributionResourceKeys() {
        return this._missingDistributionResourceKeys;
    }

    public boolean hasFailure() {
        return !this._failedDistributions.isEmpty() || !this._failedDistributionInfos.isEmpty() || !this._failedFeatures.isEmpty() || !this._failedDistributionCompatibilityFiles.isEmpty() || !this._failedComponentInfos.isEmpty() || !this._missingDistributionFeatures.isEmpty() || !this._missingFeatureDependencies.isEmpty() || !this._missingDistributionCompatibilityDependencies.isEmpty() || !this._missingDistributionResources.isEmpty() || !this._missingFeatureResources.isEmpty() || !this._missingFeatureResourceKeys.isEmpty() || !this._missingDistributionResourceKeys.isEmpty() || this._failedLabelMap != null || !this._consumer.getNonConsumableFeatures().isEmpty();
    }

    public boolean hasWarning() {
        return !this._missingDistributionInfos.isEmpty() || !this._missingComponentMappings.isEmpty() || !this._orphanedDistributionInfos.isEmpty();
    }

    public void validate() throws GdrException {
        if (this._gdrMetaDataHome == null) {
            GdrException ex = new GdrException("The GDR meta-data home was not specified.");
            _log.throwing(GdrMetaDataValidator.class.getName(), "getDistribution", ex);
            throw ex;
        }
        if (!this._gdrMetaDataHome.isDirectory()) {
            GdrException ex = new GdrException("The GDR meta-data home did not exist or was not a directory.");
            _log.throwing(GdrMetaDataValidator.class.getName(), "getDistribution", ex);
            throw ex;
        }
        LabelMap labelMap = null;
        try {
            labelMap = LabelMapHelper.getInstance().getLabelMap(this._gdrMetaDataHome);
        }
        catch (Exception e) {
            _log.log(Level.FINEST, "Failed to parse label map.", e);
            if (this._debug) {
                e.printStackTrace();
            }
            this._failedLabelMap = e.getMessage();
        }
        List<File> files = FeatureSetHelper.getInstance().getFeatureSetFiles(this._gdrMetaDataHome);
        LinkedHashMap<File, FeatureSet> featureSets = new LinkedHashMap<File, FeatureSet>();
        for (File file : files) {
            List<ComponentReference> compRefs;
            FeatureSet featureSet;
            try {
                featureSet = FeatureSetHelper.getInstance().getFeatureSet(file);
            }
            catch (Exception e) {
                _log.log(Level.FINEST, "Failed to parse feature set " + file, e);
                if (this._debug) {
                    e.printStackTrace();
                }
                this._failedFeatures.put(file, e.getMessage());
                continue;
            }
            featureSets.put(file, featureSet);
            String featureName = featureSet.getName();
            String featureVersion = featureSet.getVersion();
            File resourceLocation = FeatureSetHelper.getInstance().getResourceBundleFile(featureSet, this._gdrMetaDataHome);
            if (resourceLocation == null || !resourceLocation.exists() || featureSet.getResourceBundleInfo() == null) {
                this._missingFeatureResources.add(FeatureSetHelper.getInstance().getResourceLocation(featureName, featureVersion));
            } else {
                ResourceBundle resourceBundle = featureSet.getResourceBundleInfo().getResourceBundle();
                if (resourceBundle != null) {
                    String descriptionKey;
                    Enumeration<String> keys = resourceBundle.getKeys();
                    Iterator resourceKeys = new ArrayList<String>();
                    while (keys.hasMoreElements()) {
                        resourceKeys.add(keys.nextElement());
                    }
                    ArrayList<String> missingKeys = new ArrayList<String>();
                    String displayNameKey = featureSet.getDisplayNameKey();
                    if (!StringUtil.isNullOrEmpty((String)displayNameKey, (boolean)true) && !resourceKeys.contains(displayNameKey)) {
                        missingKeys.add("<feature-set-def display-name-key=\"" + displayNameKey + "\"");
                    }
                    if (!StringUtil.isNullOrEmpty((String)(descriptionKey = featureSet.getDescriptionKey()), (boolean)true) && !resourceKeys.contains(descriptionKey)) {
                        missingKeys.add("<feature-set-def description-key=\"" + descriptionKey + "\"");
                    }
                    if (!missingKeys.isEmpty()) {
                        this._missingFeatureResourceKeys.put(resourceLocation, missingKeys);
                    }
                } else {
                    this._missingFeatureResources.add(FeatureSetHelper.getInstance().getResourceLocation(featureName, featureVersion));
                }
            }
            if (labelMap == null || (compRefs = featureSet.getComponentReferences()) == null || compRefs.isEmpty()) continue;
            ArrayList<String> missing = new ArrayList<String>();
            for (ComponentReference compRef : compRefs) {
                Collection<ComponentMapping> mappings = LabelMapHelper.getInstance().getMappingsForComponent(labelMap, compRef);
                if (mappings != null && !mappings.isEmpty()) continue;
                missing.add(compRef.toString());
            }
            if (missing.isEmpty()) continue;
            this._missingComponentMappings.put(file, missing);
        }
        this._consumer = new FeatureSetConsumer(this._gdrMetaDataHome, new LinkedHashSet<FeatureSet>(featureSets.values()));
        if (!featureSets.isEmpty()) {
            for (File file : featureSets.keySet()) {
                FeatureSet feature = (FeatureSet)featureSets.get(file);
                ArrayList<String> missing = new ArrayList<String>();
                Set<DependencyRef> featureDependencies = FeatureSetHelper.getInstance().getFeatureDependencies(feature);
                for (DependencyRef dependencyRef : featureDependencies) {
                    boolean found = false;
                    for (FeatureSet featureSet : featureSets.values()) {
                        if (!DistributionHelper.getInstance().isMatchingDependencyReference(featureSet.getName(), featureSet.getVersion(), dependencyRef)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    missing.add(dependencyRef.toString());
                }
                if (missing.isEmpty()) continue;
                this._missingFeatureDependencies.put(file, missing);
            }
        }
        List distInfoFiles = DistributionInfoHelper.getInstance().getDistributionInfoFiles(this._gdrMetaDataHome);
        for (Object file : distInfoFiles) {
            try {
                DistributionInfoHelper.getInstance().getDistributionInfo((File)file);
            }
            catch (Exception e) {
                _log.log(Level.FINEST, "Failed to parse distribution info " + file, e);
                if (this._debug) {
                    e.printStackTrace();
                }
                this._failedDistributionInfos.put((File)file, e.getMessage());
            }
        }
        List list = ComponentInfoHelper.getInstance().getComponentInfoFiles(this._gdrMetaDataHome);
        for (Object file : list) {
            try {
                ComponentInfoHelper.getInstance().getComponentInfo((File)file);
            }
            catch (Exception e) {
                _log.log(Level.FINEST, "Failed to parse component info " + file, e);
                if (this._debug) {
                    e.printStackTrace();
                }
                this._failedComponentInfos.put((File)file, e.getMessage());
            }
        }
        MetaDataHome metaDataHome = new MetaDataHome(this._gdrMetaDataHome, this._gdrMetaDataHome, false);
        files = DistributionHelper.getInstance().getDistributionFiles(metaDataHome);
        for (File file : files) {
            Set<FeatureSetReference> featureRefs;
            Distribution distribution;
            try {
                distribution = DistributionHelper.getInstance().getDistribution(file);
                DistributionLoaderFactory.getDistributionLoader(metaDataHome, distribution);
            }
            catch (Exception e) {
                _log.log(Level.FINEST, "Failed to parse or load distribution " + file, e);
                if (this._debug) {
                    e.printStackTrace();
                }
                this._failedDistributions.put(file, e.getMessage());
                continue;
            }
            String distributionName = distribution.getName();
            String distributionVersion = distribution.getVersion();
            File resourceLocation = DistributionHelper.getInstance().getResourceBundleFile(distribution, this._gdrMetaDataHome);
            if (resourceLocation == null || !resourceLocation.exists() || distribution.getResourceBundleInfo() == null) {
                this._missingDistributionResources.add(DistributionHelper.getInstance().getResourceLocation(distributionName, distributionVersion));
            } else {
                ResourceBundle resourceBundle = distribution.getResourceBundleInfo().getResourceBundle();
                if (resourceBundle != null) {
                    List<InstallType> installTypes;
                    List<FeatureSetGroup> featureSetGroups;
                    String descriptionKey;
                    String externalShortNameKey;
                    Enumeration<String> keys = resourceBundle.getKeys();
                    ArrayList<String> resourceKeys = new ArrayList<String>();
                    while (keys.hasMoreElements()) {
                        resourceKeys.add(keys.nextElement());
                    }
                    ArrayList<String> missingKeys = new ArrayList<String>();
                    String externalNameKey = distribution.getExternalNameKey();
                    if (!StringUtil.isNullOrEmpty((String)externalNameKey, (boolean)true) && !resourceKeys.contains(externalNameKey)) {
                        missingKeys.add("<distribution external-name-key=\"" + externalNameKey + "\"");
                    }
                    if (!StringUtil.isNullOrEmpty((String)(externalShortNameKey = distribution.getExternalShortNameKey()), (boolean)true) && !resourceKeys.contains(externalShortNameKey)) {
                        missingKeys.add("<distribution external-shortname-key\"=" + externalShortNameKey + "\"");
                    }
                    if (!StringUtil.isNullOrEmpty((String)(descriptionKey = distribution.getDescriptionKey()), (boolean)true) && !resourceKeys.contains(descriptionKey)) {
                        missingKeys.add("<distribution description-key=\"" + descriptionKey + "\"");
                    }
                    if ((featureSetGroups = DistributionHelper.getInstance().getFeatureSetGroups(distribution.getFeatureSetGroups())) != null && !featureSetGroups.isEmpty()) {
                        for (FeatureSetGroup featureSetGroup : featureSetGroups) {
                            String displayNameKey = featureSetGroup.getDisplayNameKey();
                            if (!StringUtil.isNullOrEmpty((String)displayNameKey, (boolean)true) && !resourceKeys.contains(displayNameKey)) {
                                missingKeys.add("<feature-set-group display-name-key=\"" + displayNameKey + "\"");
                            }
                            if (StringUtil.isNullOrEmpty((String)(descriptionKey = featureSetGroup.getDescriptionKey()), (boolean)true) || resourceKeys.contains(descriptionKey)) continue;
                            missingKeys.add("feature-set-group description-key=\"" + descriptionKey + "\"");
                        }
                    }
                    if ((installTypes = distribution.getInstallType()) != null && !installTypes.isEmpty()) {
                        for (InstallType installType : installTypes) {
                            String installTypeExternalNameKey = installType.getExternalNameKey();
                            if (!StringUtil.isNullOrEmpty((String)installTypeExternalNameKey, (boolean)true) && !resourceKeys.contains(installTypeExternalNameKey)) {
                                missingKeys.add("<install-type external-name-key=\"" + installTypeExternalNameKey + "\"");
                            }
                            if (StringUtil.isNullOrEmpty((String)(descriptionKey = installType.getDescriptionKey()), (boolean)true) || resourceKeys.contains(descriptionKey)) continue;
                            missingKeys.add("<install-type description-key=\"" + descriptionKey + "\"");
                        }
                    }
                    if (!missingKeys.isEmpty()) {
                        this._missingDistributionResourceKeys.put(resourceLocation, (Collection<String>)missingKeys);
                    }
                } else {
                    this._missingDistributionResources.add(DistributionHelper.getInstance().getResourceLocation(distributionName, distributionVersion));
                }
            }
            try {
                File distInfoFile = DistributionInfoHelper.getInstance().getDistributionInfoFile(this._gdrMetaDataHome, distributionName, distributionVersion);
                distInfoFiles.remove(distInfoFile);
            }
            catch (FileNotFoundException e) {
                this._missingDistributionInfos.add(new File(DistributionInfoHelper.getInstance().getPath(), DistributionInfoHelper.getInstance().getDistributionInfoFileName(distributionName, distributionVersion)));
            }
            if ((featureRefs = DistributionHelper.getInstance().getFeatureSetReferences(distribution)) == null || featureRefs.isEmpty()) continue;
            ArrayList<String> missing = new ArrayList<String>();
            for (FeatureSetReference featureRef : featureRefs) {
                String name = featureRef.getName();
                String version = featureRef.getVersion();
                boolean found = false;
                for (FeatureSet featureSet : featureSets.values()) {
                    if (!name.equals(featureSet.getName()) || !version.equals(featureSet.getVersion())) continue;
                    found = true;
                }
                if (found) continue;
                missing.add(featureRef.toString());
            }
            if (missing.isEmpty()) continue;
            this._missingDistributionFeatures.put(file, missing);
        }
        if (!distInfoFiles.isEmpty()) {
            this._orphanedDistributionInfos.addAll(distInfoFiles);
        }
        FeatureDependencyManager featureDependencyManager = new FeatureDependencyManager();
        files = featureDependencyManager.getDistributionCompatibilityFiles(this._gdrMetaDataHome);
        for (File file : files) {
            FeatureSetDependencies featureSetDependencies;
            try {
                featureSetDependencies = featureDependencyManager.loadDistributionCompatibilityFile(file, true);
            }
            catch (Exception e) {
                _log.log(Level.FINEST, "Failed to parse or load distribution compatibility file " + file, e);
                if (this._debug) {
                    e.printStackTrace();
                }
                this._failedDistributionCompatibilityFiles.put(file, e.getMessage());
                continue;
            }
            FileLocatorService fileLocatorService = DistributionHelper.getInstance().getFileLocatorService(this._gdrMetaDataHome);
            try {
                fileLocatorService.getFile(DistributionHelper.getInstance().getPath(), file.getName());
            }
            catch (FileNotFoundException e) {
                _log.log(Level.FINEST, "Failed to locate distribution corresponding to distribution compatibility file " + file, e);
                if (this._debug) {
                    e.printStackTrace();
                }
                this._failedDistributionCompatibilityFiles.put(file, "Corresponding distribution did not exist for distribution compatibility file " + file);
            }
            ArrayList<String> missingFeatureDependencies = new ArrayList<String>();
            fileLocatorService = FeatureSetHelper.getInstance().getFileLocatorService(this._gdrMetaDataHome);
            for (FeatureSetDependency featureSetDep : featureSetDependencies.getFeatureSetDependencies()) {
                String featureSetFileName = FeatureSetHelper.getInstance().getFeatureSetFileName(featureSetDep.getName(), featureSetDep.getVersion());
                try {
                    fileLocatorService.getFile(FeatureSetHelper.getInstance().getPath(), featureSetFileName);
                }
                catch (FileNotFoundException e) {
                    _log.log(Level.FINEST, "Failed to locate distribution compatibility file feature set dependency " + featureSetFileName, e);
                    if (this._debug) {
                        e.printStackTrace();
                    }
                    missingFeatureDependencies.add(featureSetFileName);
                }
            }
            if (missingFeatureDependencies.isEmpty()) continue;
            this._missingDistributionCompatibilityDependencies.put(file, missingFeatureDependencies);
        }
    }

    public static void main(String[] args) {
        File gdrMetaDataHome;
        if (args.length != 1 && args.length != 2) {
            System.out.println("Usage: GdrMetaDataValidator <gdr-home>");
            System.exit(1);
        }
        String log = System.getProperty("GdrMetaDataValidator.log", "disable");
        String logLevel = System.getProperty("GdrMetaDataValidator.logLevel", "INFO");
        boolean debug = false;
        if (args[0].equals("-debug")) {
            gdrMetaDataHome = new File(args[1]);
            debug = true;
        } else {
            gdrMetaDataHome = new File(args[0]);
        }
        LogFactory.getFactory().setupLogging(log, logLevel, new String[0]);
        try {
            GdrMetaDataValidator validator = new GdrMetaDataValidator(gdrMetaDataHome);
            validator.setDebug(debug);
            validator.validate();
            if (validator.hasFailure() || validator.hasWarning()) {
                GdrMetaDataValidator.printReport(validator);
            }
            if (validator.hasFailure()) {
                System.exit(1);
            }
        }
        catch (GdrException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void printReport(GdrMetaDataValidator validator) {
        GdrMetaDataValidator.printReport(validator, null);
    }

    public static void printReport(GdrMetaDataValidator validator, PrintStream ps) {
        Collection<File> collection;
        Collection<File> collection2;
        Map<File, Collection<String>> map;
        Map<File, Collection<String>> map2;
        Map<File, String> map3;
        Map<File, Collection<String>> map4;
        Map<File, Collection<String>> map5;
        Collection<String> collection3;
        Collection<String> collection4;
        Map<File, String> map6;
        Map<File, String> map7;
        Map<File, Collection<String>> map8;
        Map<File, String> map9;
        Map<File, Collection<String>> map10;
        Collection<FeatureSet> nonConsumableFeatures;
        Map<File, String> failedFeatures;
        String labelMapFailed;
        if (ps == null) {
            ps = System.out;
        }
        if (validator.hasFailure()) {
            ps.println("Validation FAILED for " + validator.getGdrMetaDataHome() + ":\n");
        }
        if ((labelMapFailed = validator.getFailedLabelMap()) != null) {
            ps.println("Failed to parse label-map.xml:\n" + labelMapFailed + "\n");
        }
        if (!(failedFeatures = validator.getFailedFeatures()).isEmpty()) {
            for (File file : failedFeatures.keySet()) {
                ps.println("Failed to parse feature set " + file + ":\n" + failedFeatures.get(file) + "\n");
            }
        }
        if (!(nonConsumableFeatures = validator.getNonConsumableFeatures()).isEmpty()) {
            for (FeatureSet featureSet : nonConsumableFeatures) {
                ps.println("Non consumable feature set:\n" + featureSet + "\n");
            }
        }
        if (!(map10 = validator.getMissingFeatureDependencies()).isEmpty()) {
            for (File file : map10.keySet()) {
                ps.println("Unable to locate feature dependency defined in feature set " + file + ":\n" + map10.get(file) + "\n");
            }
        }
        if (!(map9 = validator.getFailedDistributions()).isEmpty()) {
            for (File file : map9.keySet()) {
                ps.println("Failed to parse or load distribution " + file + ":\n" + map9.get(file) + "\n");
            }
        }
        if (!(map8 = validator.getMissingDistributionFeatures()).isEmpty()) {
            for (File file : map8.keySet()) {
                ps.println("Feature set(s) did not exist for feature set referenced in distribution " + file + ":\n" + map8.get(file) + "\n");
            }
        }
        if (!(map7 = validator.getFailedDistributionInfos()).isEmpty()) {
            for (File file : map7.keySet()) {
                ps.println("Failed to parse distribution info " + file + ":\n" + map7.get(file) + "\n");
            }
        }
        if (!(map6 = validator.getFailedComponentInfos()).isEmpty()) {
            for (File file : map6.keySet()) {
                ps.println("Failed to parse component info " + file + ":\n" + map6.get(file) + "\n");
            }
        }
        if (!(collection4 = validator.getMissingDistributionResources()).isEmpty()) {
            for (String string : collection4) {
                ps.println("The following distribution resources jar did not exist or was empty " + string + "\n");
            }
        }
        if (!(collection3 = validator.getMissingFeatureResources()).isEmpty()) {
            for (String string : collection3) {
                ps.println("The following feature set resources jar did not exist or was empty " + string + "\n");
            }
        }
        if (!(map5 = validator.getMissingFeatureResourceKeys()).isEmpty()) {
            for (File file : map5.keySet()) {
                ps.println("Unable to locate feature set resource keys in resource jar " + file + ":\n" + map5.get(file) + "\n");
            }
        }
        if (!(map4 = validator.getMissingDistributionResourceKeys()).isEmpty()) {
            for (File file : map4.keySet()) {
                ps.println("Unable to locate distribution resource keys in resource jar " + file + ":\n" + map4.get(file) + "\n");
            }
        }
        if (!(map3 = validator.getFailedDistributionCompatibilityFiles()).isEmpty()) {
            for (File file : map3.keySet()) {
                ps.println("Failed to parse or load distribution compatibility file " + file + ":\n" + map3.get(file) + "\n");
            }
        }
        if (!(map2 = validator.getMissingDistributionCompatibilityDependencies()).isEmpty()) {
            for (File file : map2.keySet()) {
                ps.println("Feature set(s) did not exist for feature set dependencies in distribution compatibility file " + file + ":\n" + map2.get(file) + "\n");
            }
        }
        if (validator.hasWarning()) {
            ps.println("Validation WARNINGS for " + validator.getGdrMetaDataHome() + ":\n");
        }
        if (!(map = validator.getMissingComponentMappings()).isEmpty()) {
            for (File file : map.keySet()) {
                ps.println("Label mapping(s) missing for components in feature set " + file + ":\n" + map.get(file) + "\n");
            }
        }
        if (!(collection2 = validator.getMissingDistributionInfos()).isEmpty()) {
            for (File s : collection2) {
                ps.println("Unable to locate distribution info file " + s + "\n");
            }
        }
        if (!(collection = validator.getOrphanedDistributionInfos()).isEmpty()) {
            for (File f : collection) {
                ps.println("The following distribution info file did not have a corresponding distribution " + f + "\n");
            }
        }
    }
}

