/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.session;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionLoaderFactory;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.dbd.InstallType;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.external.InstallTypeSelector;
import com.oracle.cie.gdr.external.Session;
import com.oracle.cie.gdr.external.impl.InstallTypeImpl;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.session.BaseSession;
import com.oracle.cie.gdr.session.DistributionSession;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.ini.DefaultOraparamIni;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DistributionSessionImpl
extends BaseSession
implements Session,
DistributionSession {
    private static final Logger _log = Logger.getLogger(DistributionSessionImpl.class.getName());
    protected DistributionLoader _distributionLoader;
    protected FeatureSelectionTarget _featureSelectionTarget;
    protected Mode _mode;
    private InstallType _defaultInstallType;
    private Set<InstallType> _installTypes;
    private InstallType _selectedInstallType = null;

    public DistributionSessionImpl(Home home, MetaDataHome metaDataHome, Reference distributionReference, Mode mode) throws GdrException, IOException, DataHandlerException {
        super(metaDataHome, home, null, null);
        this.init(distributionReference, null, mode);
    }

    public DistributionSessionImpl(Home home, MetaDataHome metaDataHome, Distribution distribution, Mode mode) throws GdrException, IOException, DataHandlerException {
        super(metaDataHome, home, null, null);
        this.init(null, distribution, mode);
    }

    @Override
    public void setHome(Home home) throws GdrException {
        super.setHome(home);
        this.setInstallationStatus();
        this.buildFeatureSelectionTarget();
        this.validateInstallTypes();
        this._selectedInstallType = null;
    }

    @Override
    public DistributionLoader getDistributionLoader() {
        return this._distributionLoader;
    }

    @Override
    public FeatureSelectionTarget getFeatureSelectionTarget() {
        return this._featureSelectionTarget;
    }

    public boolean isInstallTypeSet() {
        return this._selectedInstallType != null;
    }

    public InstallType getSelectedInstallType() {
        return this._selectedInstallType;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        LinkedHashSet<FeatureSet> selectedFeatures;
        FeatureSelectionTarget featureSelectionTarget = this.getFeatureSelectionTarget();
        if (this._mode.isDeInstallMode()) {
            selectedFeatures = new LinkedHashSet(featureSelectionTarget.getOrderedUnSelection());
        } else {
            selectedFeatures = new LinkedHashSet<FeatureSet>();
            LinkedHashSet targetSelectedFeatures = new LinkedHashSet(featureSelectionTarget.getOrderedSelection());
            List orderedFeatures = featureSelectionTarget.getOrderedItems();
            ArrayList<FeatureSet> distributionFeatures = new ArrayList<FeatureSet>(this.getDistributionLoader().getFeatureSets());
            for (FeatureSet orderedFeature : orderedFeatures) {
                int index = distributionFeatures.indexOf(orderedFeature);
                if (index <= -1 || !targetSelectedFeatures.contains(orderedFeature)) continue;
                selectedFeatures.add(distributionFeatures.get(index));
            }
        }
        this.removeDummyFeatures(selectedFeatures);
        return selectedFeatures;
    }

    @Override
    public void setSelectedFeatures(Set<Reference> featureRefs) throws GdrException, DependencyException {
        if (featureRefs == null || featureRefs.isEmpty()) {
            GdrException ex = new GdrException("The feature references provided were null or empty.");
            _log.throwing(DistributionSessionImpl.class.getName(), "setSelectedFeatures", ex);
            throw ex;
        }
        InstallType selectedInstallType = this.getSelectedInstallType();
        if (selectedInstallType == null || !selectedInstallType.isCustom()) {
            throw new GdrException("Feature sets cannot be selected if a custom install type has not been set.");
        }
        FeatureSelectionTarget featureSelectionTarget = this.getFeatureSelectionTarget();
        List allOrderedFeatures = featureSelectionTarget.getOrderedItems();
        ArrayList<FeatureSet> distributionFeatures = new ArrayList<FeatureSet>(this.getDistributionLoader().getFeatureSets());
        LinkedHashSet<FeatureSet> orderedDistributionFeatureSets = new LinkedHashSet<FeatureSet>();
        LinkedHashSet<FeatureSet> visibleFeatures = new LinkedHashSet<FeatureSet>();
        for (FeatureSet orderedFeature : allOrderedFeatures) {
            int index = distributionFeatures.indexOf(orderedFeature);
            if (index <= -1) continue;
            FeatureSet featureSet = distributionFeatures.get(index);
            if (featureSet.isVisible()) {
                visibleFeatures.add(featureSet);
            }
            if (featureSet.isExternal()) continue;
            orderedDistributionFeatureSets.add(featureSet);
        }
        LinkedHashSet<FeatureSet> orderedFeatureSetSelections = new LinkedHashSet<FeatureSet>();
        LinkedHashSet<Reference> featureRefsCopy = new LinkedHashSet<Reference>(featureRefs);
        block1: for (FeatureSet featureSet : orderedDistributionFeatureSets) {
            String name = featureSet.getName();
            String version = featureSet.getVersion();
            Iterator it = featureRefsCopy.iterator();
            while (it.hasNext()) {
                Reference featureRef = (Reference)((Object)it.next());
                if (!featureRef.getName().equals(name) || !featureRef.getVersion().equals(version)) continue;
                if (featureSet.isVisible()) {
                    orderedFeatureSetSelections.add(featureSet);
                    it.remove();
                    continue block1;
                }
                _log.warning("The feature set specified was not visible and hence was excluded from explicit selection " + (Object)((Object)featureRef));
                it.remove();
            }
        }
        if (!featureRefsCopy.isEmpty()) {
            throw new GdrException("Unable to locate feature set(s) for selection " + featureRefsCopy);
        }
        for (FeatureSet featureSet : visibleFeatures) {
            boolean isSelected = featureSelectionTarget.isSelected(featureSet);
            boolean isInstalled = featureSelectionTarget.isInstalled(featureSet);
            if (this._mode.isDeInstallMode()) {
                if (isSelected || !isInstalled) continue;
                featureSelectionTarget.selectWithPrerequisites(featureSet);
                continue;
            }
            if (!isSelected || isInstalled) continue;
            featureSelectionTarget.unselectWithDependents(featureSet);
        }
        for (FeatureSet featureSet : orderedFeatureSetSelections) {
            _log.fine("Selecting feature set " + featureSet);
            boolean isSelected = featureSelectionTarget.isSelected(featureSet);
            boolean isInstalled = featureSelectionTarget.isInstalled(featureSet);
            if (this._mode.isDeInstallMode()) {
                if (!isSelected || !isInstalled) continue;
                featureSelectionTarget.unselectWithDependents(featureSet);
                continue;
            }
            if (isSelected || isInstalled) continue;
            featureSelectionTarget.selectWithPrerequisites(featureSet);
        }
        for (FeatureSet featureSet : orderedFeatureSetSelections) {
            if (featureSelectionTarget.isSelected(featureSet) || featureSelectionTarget.isInstalled(featureSet)) continue;
            throw new GdrException("The feature set specified for selection was not selected " + featureSet);
        }
    }

    public void validateInstallTypes() throws GdrException {
        if (this._mode.isInstallMode() && this._installTypes != null && !this._installTypes.isEmpty()) {
            String selectorClass = DefaultOraparamIni.getOraparamProfileString((String)"CUSTOM_INSTALL_TYPE_SELECTOR", null);
            if (!StringUtil.isNullOrEmpty((String)selectorClass) && this.getHomeDir() != null) {
                try {
                    Class<?> c = Class.forName(selectorClass);
                    InstallTypeSelector selector = (InstallTypeSelector)c.newInstance();
                    com.oracle.cie.gdr.external.InstallType externalInstallType = selector.getCustomInstallType(this.getExternalInstallTypes(this._installTypes), this.getHomeDir());
                    Set<com.oracle.cie.gdr.external.InstallType> compatibleInstallTypes = selector.getCompatibleInstallTypes(this.getExternalInstallTypes(this._installTypes), this.getHomeDir());
                    if (compatibleInstallTypes != null && !compatibleInstallTypes.isEmpty()) {
                        if (externalInstallType == null) {
                            throw new GdrException("A default InstallType must be provided by selector class " + selectorClass + " if there are compatible InstallTypes");
                        }
                        if (!compatibleInstallTypes.contains(externalInstallType)) {
                            throw new GdrException("The default InstallType " + externalInstallType + " is not included in the compatible InstallTypes selected by class " + selectorClass);
                        }
                    } else if (externalInstallType != null) {
                        throw new GdrException("There are no compatible Install Types for the default InstallType " + externalInstallType + selectorClass);
                    }
                    if (externalInstallType != null) {
                        this._defaultInstallType = ((InstallTypeImpl)externalInstallType).getInstallType();
                    }
                    Set<InstallType> internalTypes = this.getInternalInstallTypes(compatibleInstallTypes);
                    for (InstallType installType : this._installTypes) {
                        if (!internalTypes.contains((Object)installType)) {
                            installType.setIncompatible("Install type not compatible with this Oracle Home");
                            continue;
                        }
                        installType.setIncompatible(null);
                    }
                }
                catch (ClassNotFoundException e) {
                    _log.warning("A problem occured when loading the custom install type selector.");
                }
                catch (InstantiationException e) {
                    _log.warning("A problem occured when loading the custom install type selector.");
                }
                catch (IllegalAccessException e) {
                    _log.warning("A problem occured when loading the custom install type selector.");
                }
            }
            if (this._defaultInstallType == null || StringUtil.isNullOrEmpty((String)selectorClass)) {
                for (Object installType : this._installTypes) {
                    if (!installType.isDefault()) continue;
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.log(Level.FINEST, "The default install-type defined for distribution " + this.getDistributionLoader() + " is " + (Object)installType);
                    }
                    this._defaultInstallType = installType;
                    break;
                }
                boolean needNewDefault = false;
                for (InstallType installType : this._installTypes) {
                    try {
                        this.getFeatureSelectionTarget().setInstallType(installType);
                        if (_log.isLoggable(Level.FINEST)) {
                            _log.log(Level.FINEST, "The install-type " + (Object)((Object)installType) + " in distribution " + this.getDistributionLoader() + " as compatible with the home " + this.getHome());
                        }
                        installType.setIncompatible(null);
                        if (!needNewDefault) continue;
                        this._defaultInstallType = installType;
                        needNewDefault = false;
                        if (!_log.isLoggable(Level.FINE)) continue;
                        _log.log(Level.FINE, "Changed default install-type to " + (Object)((Object)installType) + " for distribution " + this.getDistributionLoader());
                    }
                    catch (DependencyException e) {
                        if (_log.isLoggable(Level.FINE)) {
                            _log.log(Level.FINE, "Setting install-type " + (Object)((Object)installType) + " in distribution " + this.getDistributionLoader() + " as incompatible due to " + e.getMessage());
                        }
                        installType.setIncompatible(e.getMessage());
                        if (!installType.isDefault()) continue;
                        needNewDefault = true;
                    }
                }
            }
            this.getFeatureSelectionTarget().unselectAll();
        }
        if (this._installTypes != null && !this._installTypes.isEmpty()) {
            Set<FeatureSet> features = this.getDistributionLoader().getFeatureSets();
            for (Object installType : this._installTypes) {
                installType.setInstalled(this.isInstallTypeInstalled((InstallType)((Object)installType), features));
                installType.setFullyInstalled(this.isInstallTypeFullyInstalled((InstallType)((Object)installType), features));
            }
        }
    }

    private Set<com.oracle.cie.gdr.external.InstallType> getExternalInstallTypes(Set<InstallType> installTypes) {
        HashSet<com.oracle.cie.gdr.external.InstallType> externalTypes = new HashSet<com.oracle.cie.gdr.external.InstallType>();
        for (InstallType installType : installTypes) {
            externalTypes.add(new InstallTypeImpl(installType));
        }
        return externalTypes;
    }

    private Set<InstallType> getInternalInstallTypes(Set<com.oracle.cie.gdr.external.InstallType> installTypes) {
        HashSet<InstallType> internalTypes = new HashSet<InstallType>();
        for (com.oracle.cie.gdr.external.InstallType installType : installTypes) {
            internalTypes.add(((InstallTypeImpl)installType).getInstallType());
        }
        return internalTypes;
    }

    private boolean isInstallTypeFullyInstalled(InstallType installType, Set<FeatureSet> features) {
        Set<FeatureSetReference> refs;
        Set<FeatureSetReference> set = refs = installType != null ? installType.getFullFeatures() : null;
        if (refs != null && !refs.isEmpty() && features != null) {
            for (FeatureSet feature : features) {
                FeatureSetReference installTypeRef = null;
                for (FeatureSetReference ref : refs) {
                    if (!feature.matchesReference(ref)) continue;
                    installTypeRef = ref;
                    break;
                }
                if (installTypeRef == null || feature.isFullyInstalled()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isInstallTypeInstalled(InstallType installType, Set<FeatureSet> features) {
        Set<FeatureSetReference> refs;
        Set<FeatureSetReference> set = refs = installType != null ? installType.getFullFeatures() : null;
        if (refs != null && !refs.isEmpty() && features != null) {
            for (FeatureSet feature : features) {
                FeatureSetReference installTypeRef = null;
                for (FeatureSetReference ref : refs) {
                    if (!feature.matchesReference(ref)) continue;
                    installTypeRef = ref;
                    break;
                }
                if ((installTypeRef == null || !installType.isCustom() && !installTypeRef.isSelected()) && (installTypeRef != null || !feature.isSelected() && !feature.isRequired()) || feature.getStatus().isInstalled()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public InstallType getDefaultInstallType() {
        return this._defaultInstallType;
    }

    public Set<InstallType> getInstallTypes() {
        return this._installTypes;
    }

    public void initDefaultInstallType() throws DependencyException, GdrException {
        if (!this.isInstallTypeSet()) {
            this.setInstallType(this.getDefaultInstallType());
        }
    }

    public void setInstallType(InstallType installType) throws GdrException, DependencyException {
        if (installType == null) {
            GdrException ex = new GdrException("The install-type was null. Provide a valid one.");
            _log.throwing(DistributionSessionImpl.class.getName(), "setInstallType", ex);
            throw ex;
        }
        if (this._mode.isInstallMode()) {
            if (_log.isLoggable(Level.FINE)) {
                _log.fine("Setting install-type for " + this.getDistributionLoader() + " to " + (Object)((Object)installType));
            }
            if (installType != null && !this._installTypes.contains((Object)installType)) {
                GdrException ex = new GdrException("The specified install-type " + (Object)((Object)installType) + " did not exist in the distribution " + this.getDistributionLoader());
                _log.throwing(DistributionSessionImpl.class.getName(), "setInstallType", ex);
                throw ex;
            }
            try {
                this.getFeatureSelectionTarget().setInstallType(installType);
            }
            catch (DependencyException e) {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "Failed to set install-type for " + this.getDistributionLoader() + " to " + (Object)((Object)installType), e);
                }
                throw e;
            }
            this._selectedInstallType = installType;
        } else if (_log.isLoggable(Level.FINEST)) {
            _log.finest("The install-type for " + this.getDistributionLoader() + " not set to " + (Object)((Object)installType) + " because we are not in install mode.");
        }
    }

    private void removeDummyFeatures(Collection<FeatureSet> features) {
        if (features != null && !features.isEmpty()) {
            Iterator<FeatureSet> it = features.iterator();
            while (it.hasNext()) {
                FeatureSet feature = it.next();
                if (!feature.isDummy()) continue;
                it.remove();
            }
        }
    }

    protected void init(Reference distributionReference, Distribution distribution, Mode mode) throws IOException, DataHandlerException, GdrException {
        if (mode == null) {
            GdrException ex = new GdrException("The specified mode was null.");
            _log.throwing(DistributionSessionImpl.class.getName(), "init", ex);
            throw ex;
        }
        this._mode = mode;
        if (distributionReference == null && distribution == null) {
            GdrException ex = new GdrException("The distribution provided was null");
            _log.throwing(DistributionSessionImpl.class.getName(), "init", ex);
            throw ex;
        }
        this._distributionLoader = distributionReference != null ? DistributionLoaderFactory.getDistributionLoader(this.getMetaDataHome(), distributionReference.getName(), distributionReference.getVersion()) : DistributionLoaderFactory.getDistributionLoader(this.getMetaDataHome(), distribution);
        if (this._distributionLoader == null) {
            GdrException ex = new GdrException("The distribution loader was not loaded properly.");
            _log.throwing(DistributionSessionImpl.class.getName(), "init", ex);
            throw ex;
        }
        this.setInstallationStatus();
        this.loadInstallTypes();
        this.buildFeatureSelectionTarget();
        this.validateInstallTypes();
    }

    protected void loadInstallTypes() {
        if (this._installTypes == null) {
            this._installTypes = this.getDistributionLoader().getInstallTypes();
        }
    }

    protected void buildFeatureSelectionTarget() throws GdrException {
        Set<FeatureSet> features = this.getDistributionLoader().getFeatureSets();
        Set<FeatureSet> installedFeatures = null;
        if (this._mode.isDeInstallMode()) {
            Iterator<FeatureSet> it = features.iterator();
            while (it.hasNext()) {
                FeatureSet feature = it.next();
                if (feature.getStatus().isInstalled()) continue;
                it.remove();
            }
        } else {
            Home home = this.getHome();
            installedFeatures = home != null ? home.getInstalledFeatures() : null;
            Set<FeatureSet> dummyFeatures = this.getDistributionLoader().getDistributionTarget().getDummyExternalFeatureSets();
            if (dummyFeatures != null) {
                if (installedFeatures != null && !installedFeatures.isEmpty()) {
                    dummyFeatures.removeAll(installedFeatures);
                }
                features.addAll(dummyFeatures);
            }
            for (FeatureSet feature : FeatureSetHelper.getInstance().getUpgradeInstalledFesturesToRemove(features, installedFeatures)) {
                _log.info("Skipping installation of " + feature.getDisplayName() + " featureset");
                features.remove(feature);
            }
        }
        String skipNginst = DefaultOraparamIni.getOraparamProfileString((String)"SKIP_NGINST_UPGRADE", null);
        _log.fine("Contents of SKIP_NGINST_UPGRADE: " + skipNginst);
        if (!StringUtil.isNullOrEmpty((String)skipNginst) && Boolean.parseBoolean(skipNginst) && this.getHomeDir() != null) {
            _log.fine("Searching for nginst core featureset to remove.");
            for (FeatureSet feature : features) {
                if (!feature.getName().equals("nginst_core")) continue;
                _log.info("Skipping installation of nginst_core featureset since SKIP_NGINST_UPGRADE is set to true");
                features.remove(feature);
                break;
            }
        }
        if (installedFeatures != null && !installedFeatures.isEmpty()) {
            for (FeatureSet feature : features) {
                if (!installedFeatures.contains(feature)) continue;
                installedFeatures.remove(feature);
            }
        }
        this._featureSelectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(features, installedFeatures, this._mode);
    }

    protected void setInstallationStatus() throws GdrException {
        Set<FeatureSet> featureSets = this.getDistributionLoader().getFeatureSets();
        if (featureSets != null) {
            for (FeatureSet featureSet : featureSets) {
                if (!featureSet.isUpgradesInHome()) continue;
                featureSet.setUpgradesInHome(null);
            }
        }
        RegistryHelper.getInstance().setInstallationStatus(this.getHome(), this.getDistributionLoader(), !this._mode.isInstallMode());
    }
}

