/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.gdr.services.LocaleService;
import com.oracle.cie.gdr.services.PlatformService;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.services.RuleEvaluationService;
import com.oracle.cie.gdr.services.VariableResolverService;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.Map;
import java.util.Set;

public class ServiceHolder {
    private PlatformService _platformService;
    private LocaleService _localeService;
    private RuleEvaluationService _ruleEvaluationService;
    private String _namespace;

    public ServiceHolder() {
    }

    public ServiceHolder(Set<Integer> platforms, Set<Integer> locales, Map<String, String> variableMap) {
        this.setPlatformService(PlatformService.getPlatformService(platforms));
        this.setLocaleService(LocaleService.getLocaleService(locales));
        VariableResolverService.getVariableResolverService(variableMap);
        this._ruleEvaluationService = RuleEvaluationService.getRuleEvaluationService();
    }

    public ServiceHolder(ServiceHolder parent, String namespace) {
        this._namespace = namespace;
        this._platformService = parent.getPlatformService();
        this._localeService = parent.getLocaleService();
        this._ruleEvaluationService = RuleEvaluationService.getRuleEvaluationService(namespace);
    }

    public String getNamespace() {
        return this._namespace;
    }

    public PlatformService getPlatformService() {
        if (this._platformService == null) {
            this._platformService = PlatformService.getPlatformService();
        }
        return this._platformService;
    }

    public void setPlatformService(PlatformService platformService) {
        this._platformService = platformService;
    }

    public LocaleService getLocaleService() {
        if (this._localeService == null) {
            this._localeService = LocaleService.getLocaleService();
        }
        return this._localeService;
    }

    public void setLocaleService(LocaleService localeService) {
        this._localeService = localeService;
    }

    public RuleEvaluationService getRuleEvaluationService() {
        return this._ruleEvaluationService;
    }

    public VariableResolverService getVariableResolverService() {
        return VariableResolverService.getVariableResolverService();
    }

    public RepositoryService getRepositoryService() throws GdrException {
        return new RepositoryService(this.getVariableResolverService());
    }
}

