/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.platform.PlatformInfoHolder;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;

public class PlatformService {
    private final Logger _log = Logger.getLogger(PlatformService.class.getName());
    private Set<PlatformInfoHolder> _platformInfoHolders = new LinkedHashSet<PlatformInfoHolder>();
    private boolean _generic;
    private boolean _disableOsFamily = Boolean.getBoolean("PlatformService.disable.osfamily");

    public static PlatformService getPlatformService() {
        return PlatformService.getPlatformService(null);
    }

    public static PlatformService getPlatformService(Collection<Integer> platforms) {
        return new PlatformService(platforms);
    }

    private PlatformService(Collection<Integer> platforms) {
        this.setPlatforms(platforms);
    }

    public boolean isGeneric() {
        return this._generic;
    }

    public void setPlatforms(Collection<Integer> platforms) {
        this._platformInfoHolders.clear();
        this._generic = false;
        if (platforms != null) {
            this.addPlatforms(platforms);
        } else {
            this.addPlatform(2000);
        }
    }

    public Set<Integer> getPlatforms() {
        LinkedHashSet<Integer> platforms = new LinkedHashSet<Integer>();
        for (PlatformInfoHolder holder : this._platformInfoHolders) {
            platforms.add(holder.getId());
        }
        return platforms;
    }

    public void addPlatform(int platform) {
        PlatformInfoHolder holder = PlatformInfoHelper.getInstance().getPlatformInfoHolder(platform);
        if (holder != null) {
            this.addPlatform(holder);
        } else {
            this._log.warning("Unable to locate platform with id " + platform);
        }
    }

    public void addPlatform(PlatformInfoHolder infoHolder) {
        if (infoHolder != null) {
            this._platformInfoHolders.add(infoHolder);
            if (2000 == infoHolder.getId()) {
                this._generic = true;
            }
        }
    }

    public void addPlatforms(Collection<Integer> platforms) {
        if (platforms != null && !platforms.isEmpty()) {
            for (int id : platforms) {
                this.addPlatform(id);
            }
        }
    }

    public boolean containsName(String platform) {
        if (this._generic) {
            return true;
        }
        if (!StringUtil.isNullOrEmpty((String)platform)) {
            for (PlatformInfoHolder holder : this._platformInfoHolders) {
                if (!holder.isMatchingNameOrAlias(platform)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAllNames(Set<String> platforms) {
        if (this._generic) {
            return true;
        }
        if (platforms != null && !platforms.isEmpty()) {
            for (String platform : platforms) {
                if (this.containsName(platform)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasOsFamily(String osFamily) {
        if (this._generic || StringUtil.isNullOrEmpty((String)osFamily) || this._disableOsFamily) {
            return true;
        }
        for (PlatformInfoHolder holder : this._platformInfoHolders) {
            int platform = holder.getId();
            if (!OsFamily.valueOf(osFamily).equals((Object)PlatformService.getOsFamily(platform))) continue;
            return true;
        }
        return false;
    }

    public static OsFamily getOsFamily(String platform) {
        return PlatformService.getOsFamily(PlatformInfoHelper.getInstance().getPlatformIdByName(platform));
    }

    public static OsFamily getOsFamily(int platform) {
        return PlatformInfoHelper.getInstance().isInWindowsGroup(platform) ? OsFamily.windows : OsFamily.unix;
    }

    public static enum OsFamily {
        windows,
        unix;

    }
}

