/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.common.JarClassLoader;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class CompatibilityService {
    private static final Logger _log = Logger.getLogger(CompatibilityService.class.getName());
    private static CompatibilityService _instance = new CompatibilityService();
    private static final String OUI_DIR = "oui";
    private static final String MODULES_DIR = "modules";
    private static final String NEXTGEN_JAR_NAME = "com.oracle.cie.gdr_1.0.0.0.jar";
    private static final String COMDEV_JAR_NAME = "com.oracle.cie.comdev_7.0.0.0.jar";
    private static final String VERSION_CLASS_NAME = "com.oracle.cie.gdr.Version";

    public static CompatibilityService getInstance() {
        return _instance;
    }

    private CompatibilityService() {
    }

    public String getNextGenVersion(File oracleHome) throws Exception {
        JarClassLoader jarClassLoader1 = new JarClassLoader(oracleHome.getAbsolutePath() + File.separator + OUI_DIR + File.separator + MODULES_DIR + File.separator + "OraInstaller.jar", false, true);
        ClassLoader classLoader1 = jarClassLoader1.load();
        String version = null;
        try {
            version = (String)this.process(VERSION_CLASS_NAME, null, "getVersion", null, null, classLoader1);
            return version;
        }
        catch (Exception anyException) {
            _log.warning("A nextgen version could not be obtained from the Oracle Home: " + oracleHome.getAbsolutePath());
            throw anyException;
        }
    }

    private Object process(String className, Object object, String methodName, Class[] argTypes, Object[] args, ClassLoader classloader) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (classloader == null) {
            classloader = CompatibilityService.class.getClassLoader();
        }
        Class<?> classZ = object != null ? object.getClass() : Class.forName(className, true, classloader);
        Method m = classZ.getDeclaredMethod(methodName, argTypes);
        m.setAccessible(true);
        return m.invoke(object, args);
    }

    private String getHighestVersion(String version1, String version2) {
        block8: {
            int i;
            String[] versionParts2;
            String[] versionParts1;
            block7: {
                versionParts1 = version1.split("\\.");
                versionParts2 = version2.split("\\.");
                int maxLength = 0;
                if (versionParts2.length > versionParts1.length) {
                    maxLength = versionParts1.length;
                } else if (versionParts1.length >= versionParts2.length) {
                    maxLength = versionParts2.length;
                }
                for (i = 0; i < maxLength; ++i) {
                    if (Integer.parseInt(versionParts1[i]) > Integer.parseInt(versionParts2[i])) {
                        return version1;
                    }
                    if (Integer.parseInt(versionParts2[i]) <= Integer.parseInt(versionParts1[i])) continue;
                    return version2;
                }
                if (versionParts2.length <= versionParts1.length) break block7;
                for (i = maxLength; i < versionParts2.length; ++i) {
                    if (Integer.parseInt(versionParts2[i]) <= 0) continue;
                    return version2;
                }
                break block8;
            }
            if (versionParts1.length < versionParts2.length) break block8;
            for (i = maxLength; i < versionParts1.length; ++i) {
                if (Integer.parseInt(versionParts1[i]) <= 0) continue;
                return version1;
            }
        }
        return version1;
    }

    public String getLatestVersion(File oracleHome1, File oracleHome2) throws Exception {
        String version1 = null;
        String version2 = null;
        try {
            version1 = this.getNextGenVersion(oracleHome1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            version2 = this.getNextGenVersion(oracleHome2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (version1 == null && version2 != null) {
            _log.warning("Unable to obtain version for oracle home " + oracleHome1.getAbsolutePath() + " will use version of oracle home " + oracleHome2.getAbsolutePath());
            return version2;
        }
        if (version2 == null && version1 != null) {
            _log.warning("Unable to obtain version for oracle home " + oracleHome2.getAbsolutePath() + " will use version of oracle home " + oracleHome1.getAbsolutePath());
            return version1;
        }
        if (version1 == null && version2 == null) {
            throw new Exception("Unable to obtain versions for oracle home: " + oracleHome1.getAbsolutePath() + "  and oracle home: " + oracleHome2.getAbsolutePath());
        }
        return this.getHighestVersion(version1, version2);
    }

    public ClassLoader getIsolatedClassLoader(File oracleHome) {
        JarClassLoader jarClassLoader1 = new JarClassLoader(oracleHome.getAbsolutePath() + File.separator + OUI_DIR + File.separator + MODULES_DIR + File.separator + "OraInstaller.jar", false, true);
        return jarClassLoader1.load();
    }

    public Object getIsolatedInstance(File oracleHome, String className) {
        ClassLoader classLoader = this.getIsolatedClassLoader(oracleHome);
        Class<?> inventoryCompareClazz = null;
        try {
            inventoryCompareClazz = Class.forName(className, true, classLoader);
            return inventoryCompareClazz.newInstance();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }
}

