/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.repository;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpi.ComponentInfo;
import com.oracle.cie.gdr.dao.cpi.FileMapTarget;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.Components;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.pld.ProductLayers;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.ComponentInfoHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.helpers.ProductLayersDefinitionHelper;
import com.oracle.cie.gdr.locale.LocaleInfoHolder;
import com.oracle.cie.gdr.platform.PlatformInfoHolder;
import com.oracle.cie.gdr.repository.RepositoryFeatureLoader;
import com.oracle.cie.gdr.utils.ComponentArchiveUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepositoryProcessor {
    private static final Logger _log = Logger.getLogger(RepositoryProcessor.class.getName());
    private Set<Artifact> _consumedArtifacts;
    private RestHandler _restHandler;
    private RepositoryVersionResolver _versionResolver;
    private Collection<Reference> _filteredComponents;
    private Collection<Reference> _skippedComponents;
    private Collection<Reference> _emptyComponents;
    private File _gdrMetaDataDir;
    private List<Repository> _remoteRepositories;
    private boolean _gendeps = false;
    private boolean _copyToRepoBaseDir = true;
    private Collection<PlatformInfoHolder> _targetPlatforms;
    private Collection<LocaleInfoHolder> _targetLocales;

    public RepositoryProcessor(RestHandler restHandler, RepositoryVersionResolver versionResolver, File gdrMetaDataDir, List<Repository> remoteRepositories, boolean gendeps) {
        this._restHandler = restHandler;
        this._versionResolver = versionResolver;
        this._gdrMetaDataDir = gdrMetaDataDir;
        this._remoteRepositories = remoteRepositories;
        this._gendeps = gendeps;
        this.resetConsumedArtifacts();
    }

    public boolean isCopyToRepoBaseDir() {
        return this._copyToRepoBaseDir;
    }

    public void setCopyToRepoBaseDir(boolean copyToRepoBaseDir) {
        this._copyToRepoBaseDir = copyToRepoBaseDir;
    }

    public void setVersionResolver(RepositoryVersionResolver versionResolver) {
        this._versionResolver = versionResolver;
    }

    public Collection<PlatformInfoHolder> getTargetPlatforms() {
        return this._targetPlatforms;
    }

    public void setTargetPlatforms(Collection<PlatformInfoHolder> targetPlatforms) {
        this._targetPlatforms = targetPlatforms;
    }

    public Collection<LocaleInfoHolder> getTargetLocales() {
        return this._targetLocales;
    }

    public void setTargetLocales(Collection<LocaleInfoHolder> targetLocales) {
        this._targetLocales = targetLocales;
    }

    public Set<Artifact> getConsumedArtifacts() {
        return this._consumedArtifacts;
    }

    public void resetConsumedArtifacts() {
        this._consumedArtifacts = new LinkedHashSet<Artifact>();
        this._skippedComponents = null;
        this._emptyComponents = null;
    }

    public void setFilteredComponents(Collection<Reference> filteredComponents) {
        this._filteredComponents = filteredComponents;
    }

    public Collection<Reference> getSkippedComponents() {
        return this._skippedComponents;
    }

    public Collection<Reference> getEmptyComponents() {
        return this._emptyComponents;
    }

    public ProductLayers getProductLayersDefinition(String productLayersDefinitionName, String productLayersDefinitionVersion) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        ProductLayers pld;
        if (StringUtil.isNullOrEmpty((String)productLayersDefinitionName, (boolean)true)) {
            throw new GdrException("The product layers definition name specified was null or empty");
        }
        if (StringUtil.isNullOrEmpty((String)productLayersDefinitionVersion, (boolean)true)) {
            throw new GdrException("The product layers definition version specified was null or empty");
        }
        Version pldVersion = this._versionResolver.getProductLayersDefinitionVersion(productLayersDefinitionName = productLayersDefinitionName.trim(), productLayersDefinitionVersion = productLayersDefinitionVersion.trim());
        if (pldVersion == null) {
            throw new GdrException("Could not resolve product layers definition version for " + productLayersDefinitionName + " : " + productLayersDefinitionVersion);
        }
        Artifact productLayersDefinitionArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.shiphome.layer", productLayersDefinitionName, pldVersion, "json");
        File productLayersDefinitionFile = this._restHandler.retrieveArtifact(productLayersDefinitionArtifact, this._remoteRepositories, true);
        this._consumedArtifacts.add(productLayersDefinitionArtifact);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Working with product layer definition" + productLayersDefinitionArtifact);
        }
        try {
            pld = (ProductLayers)ProductLayersDefinitionHelper.getInstance().getRootWrapperFromJson(productLayersDefinitionFile);
        }
        catch (Exception e) {
            throw new GdrException((Throwable)e);
        }
        return pld;
    }

    public Distribution getDistribution(String distributionName, String distributionVersion) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        return this.getDistribution(distributionName, distributionVersion, this.isCopyToRepoBaseDir());
    }

    public Distribution getDistribution(String distributionName, String distributionVersion, boolean copyToRepoBaseDir) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        return this.getDistribution(distributionName, distributionVersion, true, copyToRepoBaseDir);
    }

    public Distribution getDistribution(String distributionName, String distributionVersion, boolean loadDistributionDependencies, boolean copyToRepoBaseDir) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        Distribution distribution;
        if (StringUtil.isNullOrEmpty((String)distributionName, (boolean)true)) {
            throw new GdrException("The distribution name specified was null or empty");
        }
        if (StringUtil.isNullOrEmpty((String)distributionVersion, (boolean)true)) {
            throw new GdrException("The distribution version specified was null or empty");
        }
        Version distVersion = this._versionResolver.getDistributionVersion(distributionName = distributionName.trim(), distributionVersion = distributionVersion.trim());
        if (distVersion == null) {
            throw new GdrException("Could not resolve distribution version for " + distributionName + " : " + distributionVersion);
        }
        Artifact distributionArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution", distributionName, distVersion, "xml");
        File distributionFile = this._restHandler.retrieveArtifact(distributionArtifact, this._remoteRepositories, true);
        this._consumedArtifacts.add(distributionArtifact);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Working with distribution " + distributionArtifact);
        }
        Version distDepsVersion = null;
        if (loadDistributionDependencies) {
            try {
                distDepsVersion = this._versionResolver.getDistributionDependencyVersion(distributionName, distVersion.getVersion());
            }
            catch (RepositoryCommonException e) {
                _log.finest(e.getMessage());
            }
            if (distDepsVersion != null) {
                Artifact distributionDepsArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution.dependencies", distributionName, distDepsVersion, "xml");
                File distDepsFile = this._restHandler.retrieveArtifact(distributionDepsArtifact, this._remoteRepositories, true);
                Module distDepsModule = DependencyManagementFactory.getInstance().getDependencyFileHandler().readDependenciesFile(distDepsFile);
                this._versionResolver.addDependencyModule(distDepsModule);
                this._consumedArtifacts.add(distributionDepsArtifact);
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Working with distribution dependencies " + distributionDepsArtifact);
                }
            } else if (_log.isLoggable(Level.FINER)) {
                _log.finer("No distribution dependencies file found for " + distributionArtifact);
            }
            if (distDepsVersion == null && this._gendeps) {
                try {
                    Version latestDistDepVersion = this._versionResolver.getDistributionDependencyVersion(distributionName, distVersion.getVersion(), true, false);
                    Artifact latestDistDepsArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution.dependencies", distributionName, latestDistDepVersion, "xml");
                    this._restHandler.retrieveArtifact(latestDistDepsArtifact, this._remoteRepositories, true);
                    if (_log.isLoggable(Level.FINER)) {
                        _log.finer("Adding latest distribution dependency file to consumed artifacts for gendeps processing : " + latestDistDepsArtifact);
                    }
                    this._consumedArtifacts.add(latestDistDepsArtifact);
                }
                catch (RepositoryCommonException e) {
                    _log.finest(e.getMessage());
                }
            }
        }
        File distributionResourcesFile = null;
        Version distInfoVersion = this._versionResolver.getDistributionInfoVersion(distributionName, distVersion.getBaseVersion());
        if (distInfoVersion == null) {
            throw new GdrException("Could not resolve distribution info version for " + distributionName + " : " + distributionVersion);
        }
        Artifact distributionInfoArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution.info", distributionName, distInfoVersion, "xml");
        _log.finest("Using distribution-info artifact " + distributionInfoArtifact);
        File distInfoFile = this._restHandler.retrieveArtifact(distributionInfoArtifact, this._remoteRepositories, true);
        this._consumedArtifacts.add(distributionInfoArtifact);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Working with distribution info " + distributionInfoArtifact);
        }
        Version distResourceVersion = null;
        try {
            distResourceVersion = this._versionResolver.getDistributionResourcesVersion(distributionName, distVersion.getBaseVersion());
        }
        catch (RepositoryCommonException e) {
            _log.log(Level.FINEST, e.getMessage(), e);
        }
        if (distResourceVersion == null) {
            _log.warning("Could not resolve distribution resources version for " + distributionName + " : " + distributionVersion);
        } else {
            Artifact distributionResourcesArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution.resources", distributionName, distResourceVersion, "jar");
            _log.finest("Using distribution resources artifact " + distributionResourcesArtifact);
            distributionResourcesFile = this._restHandler.retrieveArtifact(distributionResourcesArtifact, this._remoteRepositories, true);
            this._consumedArtifacts.add(distributionResourcesArtifact);
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Working with distribution resources " + distributionResourcesArtifact);
            }
        }
        if (copyToRepoBaseDir) {
            this.createGdrMetaDataDir();
            File distributionFileDest = new File(this._gdrMetaDataDir, "distributions" + File.separator + DistributionHelper.getInstance().getDistributionFileName(distributionName, distVersion.getBaseVersion()));
            FileCopy.copy((File)distributionFile, (File)distributionFileDest, (boolean)true);
            if (distributionResourcesFile != null) {
                File distributionResourcesFileDest = new File(this._gdrMetaDataDir, "distributions" + File.separator + DistributionHelper.getInstance().getResourceLocation(distributionName, distVersion.getBaseVersion()));
                FileCopy.copy((File)distributionResourcesFile, (File)distributionResourcesFileDest, (boolean)true);
            }
            if (distInfoFile != null) {
                File distInfoFileDest = new File(this._gdrMetaDataDir, DistributionInfoHelper.DISTRIBUTION_INFO_DIR + File.separator + DistributionInfoHelper.getInstance().getDistributionInfoFileName(distributionName, distVersion.getBaseVersion()));
                FileCopy.copy((File)distInfoFile, (File)distInfoFileDest, (boolean)true);
            }
            try {
                distribution = DistributionHelper.getInstance().getDistribution(distributionFileDest);
            }
            catch (Exception e) {
                throw new GdrException((Throwable)e);
            }
        }
        try {
            distribution = DistributionHelper.getInstance().getDistribution(distributionFile, false);
            if (distributionResourcesFile != null) {
                distribution.setResourceBundleInfo(new ResourceBundleInfo(distributionResourcesFile, distribution.getName(), distribution.getVersion(), (GdrHelper)DistributionHelper.getInstance()));
            }
        }
        catch (Exception e) {
            throw new GdrException((Throwable)e);
        }
        return distribution;
    }

    public void addExtraConsumedArtifact(Artifact artifact) {
        this._consumedArtifacts.add(artifact);
    }

    public Set<Artifact> getComponentArtifactsFromDistribution(String distributionName, String distributionVersion) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        Distribution distribution = this.getDistribution(distributionName, distributionVersion);
        return this.getComponentArtifactsFromFeatures(DistributionHelper.getInstance().getFeatureSetReferences(distribution));
    }

    public Set<FeatureSet> getFeatures(Distribution distribution) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        return this.getFeatures(distribution, true, this.isCopyToRepoBaseDir(), false, true);
    }

    public Set<FeatureSet> getFeatures(Distribution distribution, boolean loadFeatureDependencies, boolean copyToRepoBaseDir, boolean includeExternalDummyFeatures, boolean retrieveDependencyFiles) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        if (distribution == null) {
            throw new GdrException("The distribution specified was null.");
        }
        return this.getFeatures(DistributionHelper.getInstance().getFeatureSetReferences(distribution), loadFeatureDependencies, copyToRepoBaseDir, includeExternalDummyFeatures, retrieveDependencyFiles);
    }

    public Set<FeatureSet> getFeatures(Set<FeatureSetReference> featureRefs) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        return this.getFeatures(featureRefs, true);
    }

    public Set<FeatureSet> getFeatures(Set<FeatureSetReference> featureRefs, boolean loadFeatureDependencies) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        return this.getFeatures(featureRefs, loadFeatureDependencies, this.isCopyToRepoBaseDir());
    }

    public Set<FeatureSet> getFeatures(Set<FeatureSetReference> featureRefs, boolean loadFeatureDependencies, boolean copyToRepoBaseDir) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        return this.getFeatures(featureRefs, loadFeatureDependencies, copyToRepoBaseDir, false);
    }

    public Set<FeatureSet> getFeatures(Set<FeatureSetReference> featureRefs, boolean loadFeatureDependencies, boolean copyToRepoBaseDir, boolean includeExternalDummyFeatures) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        return this.getFeatures(featureRefs, loadFeatureDependencies, copyToRepoBaseDir, includeExternalDummyFeatures, true);
    }

    public Set<FeatureSet> getFeatures(Set<FeatureSetReference> featureRefs, boolean loadFeatureDependencies, boolean copyToRepoBaseDir, boolean includeExternalDummyFeatures, boolean retrieveDependencyFiles) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        LinkedHashSet<FeatureSet> featureSets = new LinkedHashSet<FeatureSet>();
        if (featureRefs != null && !featureRefs.isEmpty()) {
            try {
                Set<FeatureSetReference> externalFeatures;
                if (copyToRepoBaseDir) {
                    this.createGdrMetaDataDir();
                }
                RepositoryFeatureLoader featureLoader = new RepositoryFeatureLoader(copyToRepoBaseDir ? this._gdrMetaDataDir : null, featureRefs, loadFeatureDependencies, this._restHandler, this._versionResolver, this._remoteRepositories, this._gendeps, copyToRepoBaseDir, retrieveDependencyFiles);
                this._consumedArtifacts.addAll(featureLoader.getArtifacts());
                featureSets.addAll(featureLoader.getFeatureSets());
                if (includeExternalDummyFeatures && (externalFeatures = featureLoader.getExternalFeatures()) != null && !externalFeatures.isEmpty()) {
                    for (FeatureSetReference externalFeature : externalFeatures) {
                        FeatureSet fs = new FeatureSet(externalFeature.getName(), externalFeature.getVersion());
                        fs.setDummy(true);
                        featureSets.add(fs);
                    }
                }
                if (this._gendeps && (externalFeatures = featureLoader.getExternalFeatures()) != null && !externalFeatures.isEmpty()) {
                    for (FeatureSetReference externalFeature : externalFeatures) {
                        String featureName = externalFeature.getName();
                        Version version = this._versionResolver.getFeatureSetVersion(featureName, externalFeature.getVersion());
                        Artifact externalFeatureArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.featureset", featureName, version, "xml");
                        this._consumedArtifacts.add(externalFeatureArtifact);
                        try {
                            Version latestDepVersion = this._versionResolver.getFeatureSetDependencyVersion(featureName, version.getVersion(), true, false);
                            Artifact latestFeatureSetDepsArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.featureset.dependencies", featureName, latestDepVersion, "xml");
                            this._restHandler.retrieveArtifact(latestFeatureSetDepsArtifact, this._remoteRepositories, true);
                            if (_log.isLoggable(Level.FINER)) {
                                _log.finer("Adding latest external feature set dependency file to consumed artifacts for gendeps processing : " + latestFeatureSetDepsArtifact);
                            }
                            this._consumedArtifacts.add(latestFeatureSetDepsArtifact);
                        }
                        catch (RepositoryCommonException e) {
                            _log.finest(e.getMessage());
                        }
                    }
                }
            }
            catch (GdrException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GdrException((Throwable)e);
            }
        }
        return featureSets;
    }

    public Artifact getFeatureArchive(String featureArchiveName, String featureArchiveVersion) throws GdrException, RestException, IOException, RepositoryCommonException {
        if (StringUtil.isNullOrEmpty((String)featureArchiveName, (boolean)true)) {
            throw new GdrException("The feature archive name specified was null or empty");
        }
        if (StringUtil.isNullOrEmpty((String)featureArchiveVersion, (boolean)true)) {
            throw new GdrException("The feature archive version specified was null or empty");
        }
        Version version = this._versionResolver.getFeatureArchiveVersion(featureArchiveName = featureArchiveName.trim(), featureArchiveVersion = featureArchiveVersion.trim());
        if (version == null) {
            throw new GdrException("Could not resolve feature archive version for " + featureArchiveName + " : " + featureArchiveVersion);
        }
        Artifact featureArchiveArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.farb", featureArchiveName, version, "farb");
        this._restHandler.retrieveArtifact(featureArchiveArtifact, this._remoteRepositories, true);
        this._consumedArtifacts.add(featureArchiveArtifact);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Working with feature archive " + featureArchiveArtifact);
        }
        return featureArchiveArtifact;
    }

    public Set<Artifact> getComponentArtifactsFromFeatures(Set<FeatureSetReference> featureRefs) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        try {
            Set<FeatureSet> featureSets = this.getFeatures(featureRefs);
            if (featureSets != null && !featureSets.isEmpty()) {
                for (FeatureSet featureSet : featureSets) {
                    artifacts.addAll(this.getComponentArtifactsFromFeature(featureSet));
                }
            }
        }
        catch (GdrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GdrException((Throwable)e);
        }
        return artifacts;
    }

    public Set<Artifact> getComponentArtifactsFromFeature(FeatureSet featureSet) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        return this.getComponentArtifactsFromFeature(featureSet, false);
    }

    public Set<Artifact> getComponentArtifactsFromFeature(FeatureSet featureSet, boolean includeComponentInfo) throws GdrException, RestException, IOException, DependencyManagementException, RepositoryCommonException {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        try {
            _log.info("Processing components for feature set " + featureSet.toString(false));
            if (!featureSet.isGeneric() && (this._targetPlatforms == null || this._targetPlatforms.isEmpty())) {
                _log.info("Skipping feature set's components because it is flagged as not generic and we are processing for generic consumption " + featureSet.toString(false));
                return new LinkedHashSet<Artifact>();
            }
            List<Components> components = featureSet.getComponents();
            if (components != null && !components.isEmpty()) {
                for (Components comps : components) {
                    boolean choice = "choice".equals(comps.getConstraint());
                    List<ComponentReference> componentRefs = comps.getComponentReferences();
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Processing components " + componentRefs + " for feature set " + featureSet.toString(false) + " with choice=" + choice);
                    }
                    artifacts.addAll(this.getComponentArtifacts(componentRefs, choice, includeComponentInfo));
                }
            }
        }
        catch (GdrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GdrException((Throwable)e);
        }
        return artifacts;
    }

    public Set<Artifact> getComponentArtifacts(List<ComponentReference> componentRefs) throws RestException, IOException, DependencyManagementException, GdrException, RepositoryCommonException {
        return this.getComponentArtifacts(componentRefs, false);
    }

    public Set<Artifact> getComponentArtifacts(List<ComponentReference> componentRefs, boolean choice) throws RestException, IOException, DependencyManagementException, GdrException, RepositoryCommonException {
        return this.getComponentArtifacts(componentRefs, choice, false);
    }

    public Set<Artifact> getComponentArtifacts(List<ComponentReference> componentRefs, boolean choice, boolean includeComponentInfo) throws RestException, IOException, DependencyManagementException, GdrException, RepositoryCommonException {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        LinkedHashSet<Artifact> componentInfoArtifacts = new LinkedHashSet<Artifact>();
        if (componentRefs != null && !componentRefs.isEmpty()) {
            int filtered = 0;
            boolean targetMatch = false;
            for (ComponentReference componentRef : componentRefs) {
                List targets;
                boolean generic;
                _log.finer("Processing component reference " + (Object)((Object)componentRef));
                if (this.isFilteredComponent(componentRef)) {
                    _log.finer("Encountered filtered component " + (Object)((Object)componentRef) + ", skipping...");
                    this.addSkippedComponent(componentRef);
                    ++filtered;
                    continue;
                }
                LinkedHashSet<Artifact> componentArtifacts = new LinkedHashSet<Artifact>();
                ComponentInfo componentInfo = null;
                Version compInfoVersion = null;
                try {
                    _log.finest("Attempting to resolve component info version for " + (Object)((Object)componentRef));
                    compInfoVersion = this._versionResolver.getComponentInfoVersion(componentRef.getName(), DependencyManagementFactory.getInstance().getVersion(componentRef.getVersion()).getBaseVersion());
                    _log.finest("Resolved component info version " + compInfoVersion + " for " + (Object)((Object)componentRef));
                }
                catch (RepositoryCommonException e) {
                    _log.finest("Unable to resolve component-info version for " + (Object)((Object)componentRef) + ", assuming base generic carb only...");
                }
                if (compInfoVersion != null) {
                    Artifact carbInfoArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.carb.info", componentRef.getName(), compInfoVersion, "xml");
                    File componentInfoFile = this._restHandler.retrieveArtifact(carbInfoArtifact, this._remoteRepositories, true);
                    componentInfo = ComponentInfoHelper.getInstance().getComponentInfo(componentInfoFile, false);
                    componentInfoArtifacts.add(carbInfoArtifact);
                }
                String carbGroupId = componentRef.isPatch() ? "com.oracle.cie.gdr.patch.carb." + componentRef.getPatch() : "com.oracle.cie.gdr.carb";
                boolean bl = generic = componentInfo == null || componentInfo.isGeneric();
                if (generic) {
                    targetMatch = true;
                    _log.finest("Attempting to locate base/generic component artifact for " + (Object)((Object)componentRef));
                    Artifact carbArtifact = this.getComponentArtifact(componentRef, carbGroupId, choice);
                    if (carbArtifact != null) {
                        if (_log.isLoggable(Level.FINER)) {
                            _log.finer("Working with carb " + carbArtifact);
                        }
                        componentArtifacts.add(carbArtifact);
                    } else {
                        _log.finest("Skipped base/generic component " + (Object)((Object)componentRef) + " due it being choice or optional.");
                        continue;
                    }
                }
                if (componentInfo != null && (targets = componentInfo.getFileMapTargets()) != null && !targets.isEmpty()) {
                    boolean skipped = !generic;
                    boolean foundMatch = false;
                    for (FileMapTarget target : targets) {
                        Set platforms = target.getPlatforms();
                        Set locales = target.getLocales();
                        if (platforms.isEmpty() && locales.isEmpty() || !this.matchesTarget(platforms, locales)) continue;
                        targetMatch = true;
                        _log.finest("Processing matching target for component " + (Object)((Object)componentRef) + " platforms " + platforms + " locales " + locales);
                        String targetString = ComponentArchiveUtils.getTargetIdentifier(platforms, locales);
                        if (StringUtil.isNullOrEmpty((String)targetString, (boolean)true)) {
                            throw new GdrException("Encountered unexpected empty target identifier for component " + (Object)((Object)componentRef) + " and component info target " + target);
                        }
                        _log.finest("Using target identifier " + targetString + " for component " + (Object)((Object)componentRef) + " platforms " + platforms + " locales " + locales);
                        Artifact targetCarbArtifact = this.getComponentArtifact(componentRef, carbGroupId + "." + targetString, choice);
                        if (targetCarbArtifact != null) {
                            if (_log.isLoggable(Level.FINER)) {
                                _log.finer("Working with targeted carb " + targetCarbArtifact);
                            }
                            componentArtifacts.add(targetCarbArtifact);
                            skipped = false;
                            foundMatch = true;
                            continue;
                        }
                        if (!generic && !foundMatch) {
                            _log.finest("Skipped non-generic component " + (Object)((Object)componentRef) + " due it being choice or optional.");
                            skipped = true;
                            break;
                        }
                        throw new GdrException("Failed to locate targeted component " + (Object)((Object)componentRef) + " at group id " + carbGroupId + "." + targetString);
                    }
                    if (skipped) {
                        if (generic) continue;
                        if (!choice) {
                            this.addEmptyComponent(componentRef);
                            continue;
                        }
                        this.addSkippedComponent(componentRef);
                        continue;
                    }
                }
                artifacts.addAll(componentArtifacts);
                if (!choice) continue;
                _log.info("Using artifact(s) " + componentArtifacts + " for \"choice\" constraint.");
                break;
            }
            if (choice && artifacts.isEmpty() && componentRefs.size() != filtered) {
                if (targetMatch) {
                    _log.severe("Encountered unresolvable choice constraint for components " + componentRefs);
                    throw new GdrException("Unable to locate the following components " + componentRefs);
                }
                _log.finest("Adding empty component \"" + (Object)((Object)componentRefs.get(0)) + "\" for unresolved choice constraint since none of the components matched the target platform.");
                this.addEmptyComponent(componentRefs.get(0));
            }
        }
        this._consumedArtifacts.addAll(artifacts);
        this._consumedArtifacts.addAll(componentInfoArtifacts);
        if (includeComponentInfo) {
            artifacts.addAll(componentInfoArtifacts);
        }
        return artifacts;
    }

    protected Artifact getComponentArtifact(ComponentReference componentRef, String groupId, boolean choice) throws RestException, IOException, DependencyManagementException, GdrException, RepositoryCommonException {
        Version carbVersion;
        try {
            _log.info("Resolving version of component " + (Object)((Object)componentRef) + " under group id " + groupId);
            carbVersion = this._versionResolver.getComponentArchiveVersion(groupId, componentRef.getName(), componentRef.getVersion());
        }
        catch (RepositoryCommonException e) {
            if (choice) {
                _log.finer("Could not locate \"choice\" constraint component " + (Object)((Object)componentRef) + " under group id " + groupId + ", skipping...");
                this.addSkippedComponent(componentRef);
                return null;
            }
            if (componentRef.isOptional()) {
                _log.info("Could not determine version of \"optional\" component " + (Object)((Object)componentRef) + " under group id " + groupId + ", skipping...");
                this.addSkippedComponent(componentRef);
                return null;
            }
            _log.severe("Unable to resolve version of component " + (Object)((Object)componentRef) + " under group id " + groupId);
            throw e;
        }
        _log.finer("Resolved carb version " + carbVersion + " for " + (Object)((Object)componentRef) + " under group id " + groupId);
        return DependencyManagementFactory.getInstance().getArtifact(groupId, componentRef.getName(), carbVersion, "carb");
    }

    private boolean matchesTarget(Set<String> platforms, Set<String> locales) throws GdrException {
        return ComponentArchiveUtils.matchesTarget(platforms, locales, this.getTargetPlatforms(), this.getTargetLocales());
    }

    public Set<Component> getComponents(Set<Artifact> componentArtifacts) throws RestException, IOException, DataHandlerException {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        if (componentArtifacts != null && !componentArtifacts.isEmpty()) {
            for (Artifact a : componentArtifacts) {
                String entryPath = ComponentHelper.getInstance().getComponentArchiveCarbPath(a.getName(), a.getBaseVersion()) + "/" + "compDef.xml";
                _log.info("Retrieving component definition from artifact : " + a);
                byte[] compDefBytes = this._restHandler.getArchiveEntryContents(a, entryPath, this._remoteRepositories);
                components.add((Component)ComponentHelper.getInstance().getRootWrapper(new String(compDefBytes)));
            }
        }
        return components;
    }

    public boolean isFilteredComponent(Reference componentReference) {
        if (this._filteredComponents != null && !this._filteredComponents.isEmpty() && componentReference != null) {
            String name = componentReference.getName();
            String version = componentReference.getVersion();
            if (!StringUtil.isNullOrEmpty((String)name, (boolean)true) && !StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                String baseVersion = DependencyManagementFactory.getInstance().getVersion(version).getBaseVersion();
                for (Reference filteredReference : this._filteredComponents) {
                    if (!name.equals(filteredReference.getName()) || !baseVersion.equals(filteredReference.getVersion())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void addSkippedComponent(Reference componentRef) {
        if (this._skippedComponents == null) {
            this._skippedComponents = new LinkedHashSet<Reference>();
        }
        this._skippedComponents.add(componentRef);
    }

    protected void addEmptyComponent(Reference componentRef) {
        if (this._emptyComponents == null) {
            this._emptyComponents = new LinkedHashSet<Reference>();
        }
        this._emptyComponents.add(componentRef);
    }

    public void retrieveComponents(Set<Artifact> components, int maxConcurrent) throws RestException, IOException {
        if (components != null && !components.isEmpty()) {
            if (maxConcurrent > 1) {
                _log.info("Retrieving up to " + maxConcurrent + " component archives concurrently : " + components);
                this._restHandler.retrieveArtifacts(components, this._remoteRepositories, true, maxConcurrent);
            } else {
                for (Artifact a : components) {
                    _log.info("Retrieving component archive : " + a);
                    this._restHandler.retrieveArtifact(a, this._remoteRepositories, true);
                }
            }
        }
    }

    public void extractComponentArchives(Set<Artifact> components, File outputDir) throws RestException, IOException {
        if (components != null && !components.isEmpty()) {
            ComponentArchiveUtils.extractCarbs(components, outputDir, this._remoteRepositories);
        }
    }

    public void createEmptyComponents(Collection<Reference> emptyComponents, File outputDir) throws DataHandlerException {
        if (emptyComponents != null && !emptyComponents.isEmpty()) {
            ComponentArchiveUtils.createEmptyComponents(emptyComponents, outputDir);
        }
    }

    private void createGdrMetaDataDir() throws IOException, GdrException {
        if (this._gdrMetaDataDir == null) {
            throw new GdrException("The GDR meta-data directory was null.");
        }
        if (this._gdrMetaDataDir.exists() && !this._gdrMetaDataDir.isDirectory()) {
            throw new IOException("The GDR meta-data directory exists, but is not a directory : " + this._gdrMetaDataDir);
        }
        if (!this._gdrMetaDataDir.exists() && !this._gdrMetaDataDir.mkdirs()) {
            throw new IOException("Failed to create directory : " + this._gdrMetaDataDir);
        }
    }
}

