/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch.cin;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cin.Home;
import com.oracle.cie.gdr.helpers.CentralInventoryHelper;
import com.oracle.cie.gdr.patch.cin.AttachUpdater;
import com.oracle.cie.gdr.patch.cin.DetachUpdater;
import com.oracle.cie.gdr.patch.cin.HomeImpl;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.glcm.common.inventory.api.CentralInventory;
import oracle.glcm.common.inventory.api.InventoryException;

public class CentralInventoryImpl
implements CentralInventory {
    private static final Logger _log = Logger.getLogger(CentralInventoryImpl.class.getName());
    private String inventoryPointerFile;
    private Properties invPtrProperties = new Properties();
    private CentralInventoryHelper ciHelper = CentralInventoryHelper.getInstance();

    public CentralInventoryImpl(String inventoryPtrFile) throws InventoryException {
        this.setInventoryPointerFile(inventoryPtrFile);
    }

    public CentralInventoryImpl(String centralInventoryLocation, String groupId) throws InventoryException {
        if (StringUtil.isNullOrEmpty((String)centralInventoryLocation, (boolean)true)) {
            throw new InventoryException("The Central Inventory location provided is null or empty.");
        }
        this.invPtrProperties.setProperty("inventory_loc", centralInventoryLocation);
        this.invPtrProperties.setProperty("inst_group", groupId == null ? "" : groupId);
    }

    protected void setInventoryPointerFile(String inventoryPointerFile) throws InventoryException {
        if (StringUtil.isNullOrEmpty((String)inventoryPointerFile, (boolean)true)) {
            throw new InventoryException("The Inventory pointer file provided is null or empty.");
        }
        this.inventoryPointerFile = inventoryPointerFile;
    }

    public String getCentralInventoryLocation() throws GdrException, InventoryException {
        if (StringUtil.isNullOrEmpty((String)this.invPtrProperties.getProperty("inventory_loc"), (boolean)true)) {
            this.invPtrProperties = this.ciHelper.getInventoryPointerProperties(this.inventoryPointerFile);
            if (StringUtil.isNullOrEmpty((String)this.invPtrProperties.getProperty("inventory_loc"), (boolean)true)) {
                throw new InventoryException("Central Inventory location PROPERTY is null or empty");
            }
        }
        return this.invPtrProperties.getProperty("inventory_loc");
    }

    public String getCentralInventoryGroup() {
        return this.invPtrProperties.getProperty("inst_group");
    }

    public oracle.glcm.common.inventory.api.Home getHome(String homeLocation) throws InventoryException {
        _log.info("getHome(" + homeLocation + ")");
        try {
            Home homeDao = this.ciHelper.getHome(this.getCentralInventoryLocation(), homeLocation);
            return this.generateHome(homeDao);
        }
        catch (GdrException e) {
            _log.warning(e.getMessage());
            throw new InventoryException("Failed trying to getHome using as homeLocation[" + homeLocation + "]", (Throwable)e);
        }
    }

    public List<oracle.glcm.common.inventory.api.Home> getHomes() throws InventoryException {
        _log.info("getHomes");
        LinkedList<oracle.glcm.common.inventory.api.Home> homes = new LinkedList<oracle.glcm.common.inventory.api.Home>();
        try {
            List<Home> homeDaoList = this.ciHelper.getHomes(this.getCentralInventoryLocation());
            if (homeDaoList == null || homeDaoList.isEmpty()) {
                return homes;
            }
            for (Home homeDao : homeDaoList) {
                if (homeDao == null || homeDao.isRemoved()) continue;
                homes.add(this.generateHome(homeDao));
            }
            return homes;
        }
        catch (GdrException e) {
            _log.warning(e.getMessage());
            throw new InventoryException("Failed getting Home List from Central Inventory.", (Throwable)e);
        }
    }

    public void attachHome(String homeLocation, String homeName, String[] params) throws InventoryException {
        _log.info("attachHome(" + homeLocation + "," + homeName + ")");
        try {
            this.ciHelper.updateCentralInventory(this.getCentralInventoryLocation(), new AttachUpdater(homeLocation, homeName, params, this.getCentralInventoryLocation(), this.getCentralInventoryGroup()));
        }
        catch (GdrException e) {
            _log.warning(e.getMessage());
            throw new InventoryException("Failed attaching home to Central Inventory. homeLocation[" + homeLocation + "] homeName[" + homeName + "]", (Throwable)e);
        }
    }

    public void detachHome(String homeLocation, String[] params) throws InventoryException {
        _log.info("detachHome with homeLocation(" + homeLocation + ")");
        try {
            this.ciHelper.updateCentralInventory(this.getCentralInventoryLocation(), new DetachUpdater(homeLocation, params));
        }
        catch (GdrException e) {
            _log.warning(e.getMessage());
            throw new InventoryException("Failed detaching home from Central Inventory. homeLocation[" + homeLocation + "]", (Throwable)e);
        }
    }

    protected oracle.glcm.common.inventory.api.Home generateHome(Home homeDao) {
        if (homeDao == null) {
            return null;
        }
        HomeImpl.HomeImplBuilder builder = HomeImpl.getHomeImplBuilder(homeDao.getName(), homeDao.getLoc());
        builder.index(Integer.parseInt(homeDao.getIdx()));
        return builder.build();
    }
}

