/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch.cin;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cin.CentralInventory;
import com.oracle.cie.gdr.dao.cin.Home;
import com.oracle.cie.gdr.helpers.CentralInventoryHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.patch.cin.CentralInventoryUpdater;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.inventory.InventoryUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class AttachUpdater
implements CentralInventoryUpdater {
    private static final Logger _log = Logger.getLogger(AttachUpdater.class.getName());
    public static final String FORCE = "oracle.installer.force";
    private static final String[] EMPTY_ARRAY = new String[0];
    private String homeLocation;
    private String homeName;
    private String centralInventoryLocation;
    private String centralInventoryGroup;
    private String[] params = EMPTY_ARRAY;

    public AttachUpdater(String homeLocation, String homeName, String[] params, String centralInventoryLocation, String groupId) throws GdrException {
        if (StringUtil.isNullOrEmpty((String)homeLocation, (boolean)true)) {
            throw new GdrException("The homeLocation is null or empty.");
        }
        if (StringUtil.isNullOrEmpty((String)homeName, (boolean)true)) {
            throw new GdrException("The homeName is null or empty.");
        }
        this.homeLocation = homeLocation.trim();
        this.homeName = homeName.trim();
        this.centralInventoryLocation = centralInventoryLocation;
        this.centralInventoryGroup = groupId;
        this.setParams(params);
    }

    @Override
    public void update(CentralInventory centralInventory) throws GdrException {
        _log.info("Updating central inventory - Attach. homeLocation[" + this.homeLocation + "] homeName[" + this.homeName + "] params[" + CentralInventoryHelper.dumpParams(this.params) + "]");
        if (this.isForce()) {
            this.attachHomeForced(centralInventory);
        } else {
            this.attachHome(centralInventory);
        }
        this.updateHomeCentralInventoryPointerFile(this.centralInventoryLocation, this.centralInventoryGroup);
    }

    private void updateHomeCentralInventoryPointerFile(String centralInventoryLocation, String centralInventoryGroup) throws GdrException {
        Path centralInventoryPath = NioHelper.getInstance().getPath(centralInventoryLocation, new String[0]);
        boolean isUnix = !ComdevHelper.isWindows();
        File invPtrFile = InventoryUtils.getInvPtrFileForOracleHome((String)this.homeLocation, (boolean)isUnix);
        Path invPtrPath = invPtrFile.toPath();
        try {
            CentralInventoryHelper.getInstance().createOraInvPtr(centralInventoryPath, invPtrPath, centralInventoryGroup);
        }
        catch (IOException e) {
            String message = "Failure creating/updating Central inventory pointer file after Attach operation. invPtrPath[" + invPtrPath + "] inventory_loc[" + centralInventoryPath + "]  group_id" + centralInventoryGroup + "] ex message[" + e.getMessage() + "]";
            _log.warning(message);
            throw new GdrException(message, (Throwable)e);
        }
    }

    private void attachHome(CentralInventory centralInventory) throws GdrException {
        centralInventory.addHome(new Home(this.homeName, this.homeLocation, "O"));
    }

    private void attachHomeForced(CentralInventory centralInventory) throws GdrException {
        _log.info("Attaching Home Force=true procedure");
        List<Home> homes = centralInventory.getHomes();
        Home duplicatedHome = null;
        _log.info("Searching for duplicated homeLocation");
        Path homeLocationPath = NioHelper.getInstance().getPath(this.homeLocation, new String[0]);
        for (Home home : homes) {
            Path indexHomeLocationPath;
            if (home == null || home.isRemoved() || !homeLocationPath.equals(indexHomeLocationPath = NioHelper.getInstance().getPath(home.getLoc(), new String[0]))) continue;
            duplicatedHome = home;
            break;
        }
        _log.info("Duplicated home by homeLocation [null|duplicatedHome][" + duplicatedHome + "]");
        if (duplicatedHome != null) {
            _log.info("Removing duplicatedHome because homeLocation");
            centralInventory.removeHome(duplicatedHome);
            _log.info("Attaching home keeping homeLocation and updating homeName. ");
            centralInventory.addHome(new Home(this.homeName, this.homeLocation, "O"));
            return;
        }
        _log.info("Searching for duplicated homeName");
        for (Home home : homes) {
            if (home == null || home.isRemoved() || !this.homeName.equals(home.getName())) continue;
            duplicatedHome = home;
            break;
        }
        _log.info("Duplicated home by homeName [null|duplicatedHome][" + (Object)((Object)duplicatedHome) + "]");
        if (duplicatedHome != null) {
            _log.info("Removing duplicatedHome because homeName");
            centralInventory.removeHome(duplicatedHome);
            _log.info("Attaching home keeping homeName and updating homeLocation. ");
            centralInventory.addHome(new Home(this.homeName, this.homeLocation, "O"));
            return;
        }
        _log.info("Duplicated home not found. Continue normal attaching home.");
        this.attachHome(centralInventory);
    }

    private boolean isForce() {
        return Arrays.asList(this.params).contains(FORCE);
    }

    private void setParams(String[] params) {
        this.params = params == null ? EMPTY_ARRAY : params;
    }
}

