/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.rgy.BaseInfoReference;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.patch.InternalPatchHandler;
import com.oracle.cie.gdr.patch.SharedPatchMetaDataHandler;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.glcm.opatch.common.api.Patch;

public abstract class PatchMetaDataHandler<T extends BaseInfoReference>
extends SharedPatchMetaDataHandler<T> {
    public PatchMetaDataHandler(InternalPatchHandler patchHandler, Patch patch) {
        super(patchHandler, patch);
    }

    protected abstract Path getPatchUpgradesDirectory() throws GdrException;

    protected abstract Path getPatchInstallDirectory() throws GdrException;

    protected abstract Path getPatchDeinstallDirectory() throws GdrException;

    protected abstract Set<Reference> getPatchMetaDataRefs(List<Path> var1) throws DataHandlerException, GdrException, IOException;

    protected abstract List<T> getAllRegistryInfos() throws GdrException;

    protected abstract List<T> getRegistryInfosForPatch(String var1) throws GdrException;

    protected abstract Path getMetaDataSource(Reference var1) throws GdrException;

    protected abstract Path getMetaDataDest(Reference var1) throws GdrException;

    protected abstract Map<Path, Path> getAdditionalMetaDataMappings(Reference var1) throws GdrException;

    @Override
    public void applyUpgradePatches() throws GdrException, IOException, DataHandlerException {
        List<Path> patchMetaDataFiles;
        Path patchInstallDir;
        List<Path> patchMetaDataFiles2;
        Path patchDeinstallDir;
        List<Path> patchMetaDataFiles3;
        Set<Reference> patchMetaDataRefs;
        Path patchUpgradesDir = this.getPatchUpgradesDirectory();
        if (Files.isDirectory(patchUpgradesDir, new LinkOption[0]) && !(patchMetaDataRefs = this.getPatchMetaDataRefs(patchMetaDataFiles3 = this.getPatchMetaDataFiles(patchUpgradesDir))).isEmpty()) {
            List<T> allRegistryInfos = this.getAllRegistryInfos();
            for (Reference patchMetaDataRef : patchMetaDataRefs) {
                String patchMetaDataVersion = patchMetaDataRef.getVersion();
                List<T> matchingInstalledInfos = this.getMatchingInstalledRegistryInfos(allRegistryInfos, patchMetaDataRef.getName(), ".*");
                List<T> matchingNotInstalledInfos = this.getMatchingRegistryInfos(allRegistryInfos, patchMetaDataRef.getName(), ".*", Status.notinstalled);
                if (!matchingInstalledInfos.isEmpty()) {
                    this.applyPatchRegistryInfo(matchingInstalledInfos, patchMetaDataVersion);
                }
                if (matchingInstalledInfos.isEmpty() && matchingNotInstalledInfos.isEmpty()) continue;
                this.savePatchMetaData(patchMetaDataRef);
            }
        }
        if ((patchDeinstallDir = this.getPatchDeinstallDirectory()) != null && Files.isDirectory(patchDeinstallDir, new LinkOption[0]) && !(patchMetaDataFiles2 = this.getPatchMetaDataFiles(patchDeinstallDir)).isEmpty()) {
            this.performMetadataDeinstallation(patchMetaDataFiles2);
        }
        if ((patchInstallDir = this.getPatchInstallDirectory()) != null && Files.isDirectory(patchInstallDir, new LinkOption[0]) && !(patchMetaDataFiles = this.getPatchMetaDataFiles(patchInstallDir)).isEmpty()) {
            this.performMetadataInstallation(patchMetaDataFiles);
        }
    }

    protected void savePatchMetaData(Reference patchMetaDataRef) throws GdrException, IOException {
        Map<Path, Path> additionalMetaDataMappings;
        Path metaDataDest = this.getMetaDataDest(patchMetaDataRef);
        if (!Files.exists(metaDataDest, new LinkOption[0])) {
            NioCopy.copyFile((Path)this.getMetaDataSource(patchMetaDataRef), (Path)metaDataDest);
            this.getPatchHandler().addCreatedFile(metaDataDest);
        }
        if ((additionalMetaDataMappings = this.getAdditionalMetaDataMappings(patchMetaDataRef)) != null && !additionalMetaDataMappings.isEmpty()) {
            for (Map.Entry<Path, Path> entry : additionalMetaDataMappings.entrySet()) {
                Path dest;
                Path source = entry.getKey();
                if (source == null || !Files.exists(source, new LinkOption[0]) || Files.exists(dest = entry.getValue(), new LinkOption[0])) continue;
                NioCopy.copyFile((Path)source, (Path)dest);
                this.getPatchHandler().addCreatedFile(dest);
            }
        }
    }

    protected abstract void performMetadataInstallation(List<Path> var1) throws GdrException, IOException, DataHandlerException;

    protected abstract void performMetadataDeinstallation(List<Path> var1) throws GdrException, IOException, DataHandlerException;

    @Override
    public void rollbackUpgradePatches() throws GdrException, IOException, DataHandlerException {
        List<T> registryInfosForPatch = this.getRegistryInfosForPatch(this.getPatch().getPatchUpi());
        List<SharedPatchMetaDataHandler.RolledBackRegistryInfo> rolledBack = this.rollbackPatchRegistryInfo(registryInfosForPatch);
        for (SharedPatchMetaDataHandler.RolledBackRegistryInfo info : rolledBack) {
            this.removePatchMetaData(info.getRegistryInfo(), info.getPreviousPatchVersion());
        }
    }

    protected void removePatchMetaData(T registryInfo, String patchedVersion) throws GdrException, IOException {
        QuickReference reference = new QuickReference(((Reference)((Object)registryInfo)).getName(), patchedVersion);
        Path metaDataDest = this.getMetaDataDest(reference);
        Files.deleteIfExists(metaDataDest);
        Map<Path, Path> additionalMetaDataMappings = this.getAdditionalMetaDataMappings(reference);
        if (additionalMetaDataMappings != null && !additionalMetaDataMappings.isEmpty()) {
            for (Path dest : additionalMetaDataMappings.values()) {
                Files.deleteIfExists(dest);
            }
        }
    }

    protected List<Path> getPatchMetaDataFiles(Path sourceDir) throws IOException {
        ArrayList<Path> patchMetaDataFiles = new ArrayList<Path>();
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path pathname) {
                return pathname.toString().endsWith(".xml");
            }
        };
        try (DirectoryStream<Path> patchUpgradeFiles = Files.newDirectoryStream(sourceDir, (DirectoryStream.Filter<? super Path>)filter);){
            for (Path path : patchUpgradeFiles) {
                patchMetaDataFiles.add(path);
            }
        }
        return patchMetaDataFiles;
    }
}

