/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.patch.InternalPatchHandler;
import com.oracle.cie.gdr.patch.PatchHandler;
import com.oracle.cie.gdr.patch.PatchHandlerImpl;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.nio.file.Path;

public class PatchHandlerFactory {
    public static PatchHandler getPatchHandler(File home) throws GdrException {
        return PatchHandlerFactory.getPatchHandler(NioHelper.getInstance().getPath(home));
    }

    public static PatchHandler getPatchHandler(Path home) throws GdrException {
        try {
            return new PatchHandlerImpl(home);
        }
        catch (GdrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GdrException("Failed to create patch handler for home " + home, (Throwable)e);
        }
    }

    public static PatchHandler getPatchHandler(Home home) throws GdrException {
        try {
            return new PatchHandlerImpl(home);
        }
        catch (GdrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GdrException("Failed to create patch handler for home " + home, (Throwable)e);
        }
    }

    static InternalPatchHandler getInternalPatchHandler(Home home) throws GdrException {
        try {
            return new PatchHandlerImpl(home);
        }
        catch (GdrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GdrException("Failed to create patch handler for home " + home, (Throwable)e);
        }
    }
}

