/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.xmldiff.XmlDiffApplicator;
import com.oracle.cie.common.xmldiff.XmlDiffAspect;
import com.oracle.cie.common.xmldiff.XmlDiffException;
import com.oracle.cie.common.xmldiff.XmlDiffTree;
import com.oracle.cie.common.xmldiff.XmlDiffTreeFilter;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.rgy.BaseInfoReference;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionAction;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.helpers.DeInstallInfoHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.installation.ReferenceCounter;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.patch.InternalPatchHandler;
import com.oracle.cie.gdr.patch.PatchHandlerImpl;
import com.oracle.cie.gdr.patch.PatchMetaDataHandler;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.services.PatchTrackerService;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.version.VersionHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.Patch;

public class FeatureSetMetaDataPatchHandler
extends PatchMetaDataHandler<FeatureInfo> {
    private static final Logger _log = Logger.getLogger(FeatureSetMetaDataPatchHandler.class.getName());
    private FeatureSetHelper _featureSetHelper;
    private Map<Reference, FeatureSet> _featureSetMap = new HashMap<Reference, FeatureSet>();
    private Map<Path, Reference> _featureSetRefMap = new HashMap<Path, Reference>();
    private Map<Distribution, Set<FeatureSet>> _distributionMap = new HashMap<Distribution, Set<FeatureSet>>();

    public FeatureSetMetaDataPatchHandler(InternalPatchHandler patchHandler, Patch patch) {
        super(patchHandler, patch);
        this._featureSetHelper = FeatureSetHelper.getInstance(patchHandler.getHome().getClassLoader());
    }

    @Override
    protected Path getPatchUpgradesDirectory() throws GdrException {
        return this.getPatchHandler().getHome().getMetaDataHome().getGdrMetaDataHomePath().resolve(this._featureSetHelper.getPath()).resolve("upgrades").resolve(this.getPatch().getPatchUpi());
    }

    @Override
    protected Path getPatchInstallDirectory() throws GdrException {
        return this.getPatchHandler().getHome().getMetaDataHome().getGdrMetaDataHomePath().resolve(this._featureSetHelper.getPath()).resolve("install").resolve(this.getPatch().getPatchUpi());
    }

    @Override
    protected Path getPatchDeinstallDirectory() throws GdrException {
        return this.getPatchHandler().getHome().getMetaDataHome().getGdrMetaDataHomePath().resolve(this._featureSetHelper.getPath()).resolve("deinstall").resolve(this.getPatch().getPatchUpi());
    }

    @Override
    protected Set<Reference> getPatchMetaDataRefs(List<Path> patchMetaDataFiles) throws DataHandlerException, GdrException, IOException {
        HashSet<Reference> patchMetaDataRefs = new HashSet<Reference>();
        for (Path patchFeatureSetFile : patchMetaDataFiles) {
            if (!this._featureSetRefMap.containsKey(patchFeatureSetFile)) {
                this.loadFeatureSetToMap(patchFeatureSetFile);
            }
            patchMetaDataRefs.add(this._featureSetRefMap.get(patchFeatureSetFile));
        }
        return patchMetaDataRefs;
    }

    protected FeatureSet getPatchMetaDataFeatureSet(Path patchMetaDataFile) throws IOException, DataHandlerException, GdrException {
        ArrayList<Path> patchMetaDataFiles = new ArrayList<Path>();
        patchMetaDataFiles.add(patchMetaDataFile);
        return this.getPatchMetaDataFeatureSets(patchMetaDataFiles).iterator().next();
    }

    protected Set<FeatureSet> getPatchMetaDataFeatureSets(List<Path> patchMetaDataFiles) throws IOException, DataHandlerException, GdrException {
        HashSet<FeatureSet> patchMetaDataFeatureSets = new HashSet<FeatureSet>();
        for (Path patchFeatureSetFile : patchMetaDataFiles) {
            if (!this._featureSetRefMap.containsKey(patchFeatureSetFile)) {
                this.loadFeatureSetToMap(patchFeatureSetFile);
            }
            patchMetaDataFeatureSets.add(this._featureSetMap.get((Object)this._featureSetRefMap.get(patchFeatureSetFile)));
        }
        return patchMetaDataFeatureSets;
    }

    private void loadFeatureSetToMap(Path patchFeatureSetFile) throws IOException, DataHandlerException, GdrException {
        _log.info("Loading patch feature set meta-data file from " + patchFeatureSetFile);
        FeatureSet featureSet = this._featureSetHelper.getFeatureSet(patchFeatureSetFile);
        QuickReference featureRef = new QuickReference(featureSet.getName(), featureSet.getVersion());
        this._featureSetRefMap.put(patchFeatureSetFile, featureRef);
        if (!this._featureSetMap.containsKey((Object)featureRef)) {
            this._featureSetMap.put(featureRef, featureSet);
        }
    }

    protected Collection<FeatureSet> getLoadedFeatureSets() {
        return this._featureSetMap.values();
    }

    protected Map<Distribution, Set<FeatureSet>> getDistributionMap() {
        return this._distributionMap;
    }

    @Override
    protected List<FeatureInfo> getAllRegistryInfos() throws GdrException {
        return this.getRegistryHelper().getAllFeatureInfos(this.getPatchHandler().getLockedRegistry());
    }

    @Override
    protected List<FeatureInfo> getRegistryInfosForPatch(String patchId) throws GdrException {
        return this.getRegistryHelper().getFeatureInfosForPatch(this.getPatchHandler().getLockedRegistry(), patchId, true);
    }

    @Override
    protected Path getMetaDataSource(Reference patchMetaDataRef) throws GdrException {
        return this._featureSetMap.get((Object)patchMetaDataRef).getFeatureSetFileLocationPath();
    }

    @Override
    protected Path getMetaDataDest(Reference patchMetaDataRef) throws GdrException {
        return this.getPatchHandler().getHome().getMetaDataHome().getGdrMetaDataHomePath().resolve(this._featureSetHelper.getPath()).resolve(this._featureSetHelper.getFeatureSetFileName(patchMetaDataRef.getName(), patchMetaDataRef.getVersion()));
    }

    @Override
    protected Map<Path, Path> getAdditionalMetaDataMappings(Reference patchMetaDataRef) throws GdrException {
        LinkedHashMap<Path, Path> additionalMetaData = new LinkedHashMap<Path, Path>();
        Path destParentDir = this.getPatchHandler().getHome().getMetaDataHome().getGdrMetaDataHomePath();
        Path sourceParentDir = !this._featureSetMap.containsKey((Object)patchMetaDataRef) ? destParentDir : this._featureSetMap.get((Object)patchMetaDataRef).getFeatureSetFileLocationPath().getParent();
        Path resourceSource = sourceParentDir.resolve(this._featureSetHelper.getResourceLocation(patchMetaDataRef.getName(), patchMetaDataRef.getVersion()));
        Path resourceDest = destParentDir.resolve(this._featureSetHelper.getPath()).resolve(this._featureSetHelper.getResourceLocation(patchMetaDataRef.getName(), patchMetaDataRef.getVersion()));
        additionalMetaData.put(resourceSource, resourceDest);
        return additionalMetaData;
    }

    public static Map<String, Set<FeatureSet>> processFeatureSetUpdatePatches(InternalPatchHandler patchHandler) throws GdrException, IOException, DataHandlerException {
        FeatureSetHelper featureSetHelper = FeatureSetHelper.getInstance(patchHandler.getHome().getClassLoader());
        LinkedHashMap<String, Set<FeatureSet>> affectedFeatureSets = new LinkedHashMap<String, Set<FeatureSet>>();
        MetaDataHome metaDataHome = patchHandler.getHome().getMetaDataHome();
        Path patchesDir = metaDataHome.getGdrMetaDataHomePath().resolve(featureSetHelper.getPath()).resolve("patches");
        if (Files.isDirectory(patchesDir, new LinkOption[0])) {
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path pathname) {
                    return Files.isDirectory(pathname, new LinkOption[0]);
                }
            };
            try (DirectoryStream<Path> featureSetPatchDirs = Files.newDirectoryStream(patchesDir, (DirectoryStream.Filter<? super Path>)filter);){
                for (Path featureSetPatchDir : featureSetPatchDirs) {
                    Object patchIdDir;
                    PatchTrackerService tracker = PatchTrackerService.getPatchApplicationTrackerService(featureSetPatchDir);
                    if (!tracker.statusChanged()) continue;
                    String featureSetDirName = featureSetPatchDir.getFileName().toString();
                    int index = featureSetDirName.lastIndexOf("_");
                    String featureName = featureSetDirName.substring(0, index);
                    String featureVersion = featureSetDirName.substring(index + 1);
                    Path mergedFeatureSet = featureSetPatchDir.resolve(featureSetHelper.getFeatureSetFileName(featureName, featureVersion));
                    Path mergedFeatureSetResources = featureSetPatchDir.resolve(featureSetHelper.getResourceLocation(featureName, featureVersion));
                    Path featureFile = featureSetHelper.getFileLocatorService(metaDataHome.getGdrMetaDataHomePath()).getPath(featureSetHelper.getPath(), featureSetHelper.getFeatureSetFileName(featureName, featureVersion));
                    FeatureSet originalFeatureSet = featureSetHelper.getFeatureSet(featureFile);
                    for (Map.Entry<String, PatchTrackerService.PatchStatus> entry : tracker.getPatchStatuses().entrySet()) {
                        if (entry.getValue().isApplied()) continue;
                        String patchId = entry.getKey();
                        LinkedHashSet<FeatureSet> affected = (LinkedHashSet<FeatureSet>)affectedFeatureSets.get(patchId);
                        if (affected == null) {
                            affected = new LinkedHashSet<FeatureSet>();
                            affectedFeatureSets.put(entry.getKey(), (Set<FeatureSet>)affected);
                        }
                        affected.add(originalFeatureSet);
                    }
                    tracker.resetStatuses();
                    if (Files.exists(mergedFeatureSet, new LinkOption[0])) {
                        Files.delete(mergedFeatureSet);
                        if (Files.exists(mergedFeatureSet, new LinkOption[0])) {
                            throw new IOException("Unable to delete patched feature set cache xml file " + mergedFeatureSet);
                        }
                    }
                    if (Files.exists(mergedFeatureSetResources, new LinkOption[0])) {
                        Files.delete(mergedFeatureSetResources);
                        if (Files.exists(mergedFeatureSetResources, new LinkOption[0])) {
                            throw new IOException("Unable to delete patched feature set cache resource file " + mergedFeatureSetResources);
                        }
                    }
                    ArrayList<Path> xmlDiffs = new ArrayList<Path>();
                    ArrayList<Path> resourcePatchJars = new ArrayList<Path>();
                    Set<String> patchIds = tracker.getPatchIds();
                    for (String patchId : patchIds) {
                        if (tracker.isPatchRemoved(patchId) || !Files.exists((Path)(patchIdDir = tracker.getPatchIdDirPath(patchId)), new LinkOption[0])) continue;
                        try (DirectoryStream<Path> xmlDiffFiles = Files.newDirectoryStream((Path)patchIdDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                            @Override
                            public boolean accept(Path entry) throws IOException {
                                return Files.isRegularFile(entry, new LinkOption[0]) && entry.getFileName().toString().endsWith(".xdiff");
                            }
                        });){
                            for (Path xmlDiffFile : xmlDiffFiles) {
                                xmlDiffs.add(xmlDiffFile);
                            }
                        }
                        Path resourceJar = patchIdDir.resolve(featureSetHelper.getResourceLocation(featureName, featureVersion));
                        if (!Files.exists(resourceJar, new LinkOption[0])) continue;
                        resourcePatchJars.add(resourceJar);
                    }
                    if (!xmlDiffs.isEmpty()) {
                        XmlDiffTree[] xmlDiffTrees = new XmlDiffTree[xmlDiffs.size()];
                        int x = 0;
                        patchIdDir = xmlDiffs.iterator();
                        while (patchIdDir.hasNext()) {
                            Path xmlDiffFile = (Path)patchIdDir.next();
                            InputStream is = Files.newInputStream(xmlDiffFile, new OpenOption[0]);
                            try {
                                xmlDiffTrees[x] = XmlDiffTree.load((InputStream)is, (ClassLoader)patchHandler.getHome().getClassLoader());
                                ++x;
                            }
                            finally {
                                if (is == null) continue;
                                is.close();
                            }
                        }
                        try {
                            XmlDiffTree mergedDiffTree;
                            XmlDiffTree xmlDiffTree = mergedDiffTree = xmlDiffTrees.length == 1 ? xmlDiffTrees[0] : XmlDiffTree.merge((XmlDiffTree[])xmlDiffTrees);
                            if (_log.isLoggable(Level.FINEST)) {
                                _log.finest("Applying merged diff tree to " + originalFeatureSet.toString(false) + " feature : " + mergedDiffTree);
                            }
                            XmlDiffApplicator xmlDiff = new XmlDiffApplicator((XmlDiffAspect)originalFeatureSet.getDataHandler(), mergedDiffTree, (XmlDiffTreeFilter)null);
                            xmlDiff.setTolerateMissingElements(true);
                            xmlDiff.apply();
                        }
                        catch (XmlDiffException e) {
                            throw new GdrException("Failed to apply xml diff to feature set " + featureFile, (Throwable)e);
                        }
                        featureSetHelper.save((IDataHandlerWrapper)originalFeatureSet, mergedFeatureSet);
                    }
                    if (!resourcePatchJars.isEmpty()) {
                        ArrayList<Path> resourceJars = new ArrayList<Path>();
                        Path origResourceJar = featureSetHelper.getResourceBundleFilePath(featureName, featureVersion, metaDataHome.getGdrMetaDataHomePath());
                        if (origResourceJar != null && Files.exists(origResourceJar, new LinkOption[0])) {
                            resourceJars.add(origResourceJar);
                        }
                        resourceJars.addAll(resourcePatchJars);
                        if (resourceJars.size() == 1) {
                            NioCopy.copyFile((Path)((Path)resourceJars.get(0)), (Path)mergedFeatureSetResources);
                        } else {
                            Path destResourcesJar = (Path)resourceJars.remove(0);
                            for (Path resourceJar : resourceJars) {
                                JarHelper destJar = new JarHelper(destResourcesJar.toFile(), 3);
                                JarHelper mergedJar = new JarHelper(resourceJar.toFile());
                                destJar.merge(mergedJar, mergedFeatureSetResources.toFile(), (JarHelper.MergeConflictResolver)new JarHelper.DefaultMergeConflictResolver(){

                                    public InputStream resolve(JarFile destJar, JarFile mergeJar, String jarEntry) throws IOException {
                                        if (jarEntry.endsWith(".properties")) {
                                            Properties destProperties = new Properties();
                                            destProperties.load(destJar.getInputStream(new JarEntry(jarEntry)));
                                            Properties mergeProperties = new Properties();
                                            mergeProperties.load(mergeJar.getInputStream(new JarEntry(jarEntry)));
                                            for (String name : destProperties.stringPropertyNames()) {
                                                if (mergeProperties.containsKey(name)) continue;
                                                mergeProperties.setProperty(name, destProperties.getProperty(name));
                                            }
                                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                            mergeProperties.store(baos, null);
                                            return new ByteArrayInputStream(baos.toByteArray());
                                        }
                                        return super.resolve(destJar, mergeJar, jarEntry);
                                    }
                                });
                                destJar.close();
                                mergedJar.close();
                                destResourcesJar = mergedFeatureSetResources;
                            }
                        }
                    }
                    tracker.patchesApplied();
                }
            }
        }
        return affectedFeatureSets;
    }

    public static Map<String, Set<FeatureSet>> removeFeatureSetUpdatePatch(InternalPatchHandler patchHandler, String patchId) throws GdrException, IOException, DataHandlerException {
        HashSet<String> patchIds = new HashSet<String>(Arrays.asList(patchId));
        return FeatureSetMetaDataPatchHandler.removeFeatureSetUpdatePatch(patchHandler, patchIds);
    }

    public static Map<String, Set<FeatureSet>> removeFeatureSetUpdatePatch(InternalPatchHandler patchHandler, Set<String> patchIds) throws GdrException, IOException, DataHandlerException {
        if (patchIds == null || patchIds.isEmpty()) {
            GdrException ex = new GdrException("The patch ids specified were null or empty.");
            _log.throwing(PatchHandlerImpl.class.getName(), "removeFeatureSetUpdatePatch", ex);
            throw ex;
        }
        boolean patchRemoved = false;
        Path patchesDir = patchHandler.getHome().getMetaDataHome().getGdrMetaDataHomePath().resolve(FeatureSetHelper.getInstance(patchHandler.getHome().getClassLoader()).getPath()).resolve("patches");
        if (Files.isDirectory(patchesDir, new LinkOption[0])) {
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path pathname) {
                    return Files.isDirectory(pathname, new LinkOption[0]);
                }
            };
            try (DirectoryStream<Path> featureSetPatchDirs = Files.newDirectoryStream(patchesDir, (DirectoryStream.Filter<? super Path>)filter);){
                for (Path featureSetPatchDir : featureSetPatchDirs) {
                    for (String patchId : patchIds) {
                        if (StringUtil.isNullOrEmpty((String)patchId, (boolean)true)) {
                            GdrException ex = new GdrException("One of the patch ids specified was null or empty.");
                            _log.throwing(PatchHandlerImpl.class.getName(), "removeFeatureSetUpdatePatch", ex);
                            throw ex;
                        }
                        Path patchDir = featureSetPatchDir.resolve(patchId);
                        if (!Files.exists(patchDir, new LinkOption[0])) continue;
                        NioDelete.delete((Path)patchDir);
                        patchRemoved = true;
                    }
                }
            }
        }
        if (patchRemoved) {
            return FeatureSetMetaDataPatchHandler.processFeatureSetUpdatePatches(patchHandler);
        }
        return null;
    }

    public static void applyUpdatePatchRegistryEntries(InternalPatchHandler patchHandler, Patch patch, Set<FeatureSet> affectedFeatures) throws GdrException {
        if (affectedFeatures != null && !affectedFeatures.isEmpty()) {
            RegistryHelper registryHelper = RegistryHelper.getInstance(patchHandler.getHome().getClassLoader());
            ArrayList<FeatureInfo> allFeatureInfos = new ArrayList<FeatureInfo>(registryHelper.getAllFeatureInfos(patchHandler.getLockedRegistry()));
            for (FeatureSet featureSet : affectedFeatures) {
                List<FeatureInfo> featureInfos = registryHelper.getFeatureInfos(allFeatureInfos, featureSet.getName(), featureSet.getVersion(), false);
                for (FeatureInfo featureInfo : featureInfos) {
                    SessionInfo sessionInfo = patchHandler.getRegistrySession(SessionAction.patch).copy();
                    sessionInfo.addPatchId(patch.getPatchUpi());
                    sessionInfo.setVersion(featureSet.getVersion());
                    featureInfo.addSession(sessionInfo, false);
                }
            }
        }
    }

    public static void rollbackUpdatePatchRegistryEntries(InternalPatchHandler patchHandler, Patch patch) throws GdrException {
        RegistryHelper registryHelper = RegistryHelper.getInstance(patchHandler.getHome().getClassLoader());
        ArrayList<FeatureInfo> patchFeatureInfos = new ArrayList<FeatureInfo>(registryHelper.getFeatureInfosForPatch(patchHandler.getLockedRegistry(), patch.getPatchUpi()));
        for (FeatureInfo featureInfo : patchFeatureInfos) {
            List<SessionInfo> sessionInfos = featureInfo.getSessions();
            int originalSize = sessionInfos.size();
            Iterator<SessionInfo> it = sessionInfos.iterator();
            while (it.hasNext()) {
                SessionInfo sessionInfo = it.next();
                if (sessionInfo.getAction() != SessionAction.patch || !sessionInfo.getPatchIdsSet().contains(patch.getPatchUpi())) continue;
                it.remove();
            }
            if (originalSize == sessionInfos.size()) continue;
            featureInfo.setSessions(sessionInfos);
        }
    }

    @Override
    protected void performMetadataInstallation(List<Path> patchMetaDataFiles) throws DataHandlerException, GdrException, IOException {
        Set<Reference> patchMetaDataRefs = this.getPatchMetaDataRefs(patchMetaDataFiles);
        if (!patchMetaDataRefs.isEmpty()) {
            for (Reference patchMetaDataRef : patchMetaDataRefs) {
                String patchMetaDataVersion = patchMetaDataRef.getVersion();
                FeatureSet feature = this._featureSetMap.get((Object)patchMetaDataRef);
                ReferenceCounter refCounter = ReferenceCounter.getReferenceCounter(this.getPatchHandler().getHome().getHomePath(), ReferenceCounter.RefType.featuresets, feature.getName(), feature.getVersion());
                int count = refCounter.getRefCount();
                Registry registry = this.getPatchHandler().getLockedRegistry();
                List<DistributionInfo> distributionsToRegister = this.getDistributionsToUpdateOnInstall(feature, registry);
                for (DistributionInfo dinfo : distributionsToRegister) {
                    if (dinfo == null) continue;
                    SessionInfo sessionInfo = this.getPatchHandler().getRegistrySession().copy();
                    sessionInfo.setAction(SessionAction.install);
                    sessionInfo.addPatchId(this.getPatch().getPatchUpi());
                    BaseInfoReference featureInfo = null;
                    for (FeatureInfo finfo : dinfo.getFeatures()) {
                        if (!patchMetaDataRef.getName().equalsIgnoreCase(finfo.getName()) || !patchMetaDataVersion.equals(finfo.getVersion())) continue;
                        featureInfo = finfo;
                        break;
                    }
                    if (featureInfo == null) {
                        sessionInfo.setOriginatingPatchId(this.getPatch().getPatchUpi());
                        featureInfo = new FeatureInfo(this.getPatchHandler().getHome().getClassLoader(), feature.getName(), feature.getVersion());
                        dinfo.addFeature((FeatureInfo)featureInfo);
                        if (feature.isSingleton()) {
                            ((FeatureInfo)featureInfo).setSingleton(true);
                        }
                        featureInfo.setStatus(Status.installed);
                        featureInfo.addSession(sessionInfo);
                        ++count;
                        this.savePatchMetaData(patchMetaDataRef);
                        continue;
                    }
                    if (featureInfo.getStatus().isNotInstalled()) {
                        featureInfo.setStatus(Status.installed);
                        featureInfo.addSession(sessionInfo, false);
                        ++count;
                        this.savePatchMetaData(patchMetaDataRef);
                        continue;
                    }
                    featureInfo.addSession(sessionInfo, false);
                }
                if (refCounter.getRefCount() != count) {
                    refCounter.setRefCount(count);
                }
                ReferenceCounter.releaseReferenceCounter(refCounter);
            }
        }
    }

    @Override
    protected void performMetadataDeinstallation(List<Path> patchMetaDataFiles) throws DataHandlerException, GdrException, IOException {
        DeInstallInfoHelper deinstallInfoHelper = DeInstallInfoHelper.getInstance();
        Set<Reference> patchMetaDataRefs = this.getPatchMetaDataRefs(patchMetaDataFiles);
        if (!patchMetaDataRefs.isEmpty()) {
            for (Reference patchMetaDataRef : patchMetaDataRefs) {
                DeInstallInfo deInstallInfo;
                try {
                    deInstallInfo = deinstallInfoHelper.getDeInstallInfoFromHome(this.getPatchHandler().getHome().getHomePath());
                }
                catch (DataHandlerException e) {
                    throw new GdrException("Problem processing deinstallInfo", (Throwable)e);
                }
                FeatureSet feature = this._featureSetMap.get((Object)patchMetaDataRef);
                ReferenceCounter refCounter = ReferenceCounter.getReferenceCounter(this.getPatchHandler().getHome().getHomePath(), ReferenceCounter.RefType.featuresets, feature.getName(), feature.getVersion());
                int count = refCounter.getRefCount();
                Registry registry = this.getPatchHandler().getLockedRegistry();
                List<FeatureInfo> featuresToRegister = this.getFeatureInfosToDeinstall(feature, registry);
                if (featuresToRegister.isEmpty()) {
                    List<FeatureInfo> allRegistryInfos = this.getAllRegistryInfos();
                    String patchMetaDataVersion = patchMetaDataRef.getVersion();
                    featuresToRegister = this.getMatchingInstalledRegistryInfos(allRegistryInfos, patchMetaDataRef.getName(), patchMetaDataVersion);
                }
                for (FeatureInfo finfo : featuresToRegister) {
                    SessionInfo sessionInfo = this.getPatchHandler().getRegistrySession().copy();
                    sessionInfo.setAction(SessionAction.deinstall);
                    sessionInfo.addPatchId(this.getPatch().getPatchUpi());
                    if (!finfo.getStatus().isNotInstalled()) {
                        deinstallInfoHelper.removeFeatureSetFiles(deInstallInfo, this.getPatchHandler().getHome(), feature);
                        deinstallInfoHelper.saveDeInstallInfoToHome(deInstallInfo, this.getPatchHandler().getHome().getHomePath());
                        sessionInfo.setOriginatingPatchId(this.getPatch().getPatchUpi());
                        --count;
                    }
                    finfo.setStatus(Status.notinstalled);
                    finfo.addSession(sessionInfo);
                }
                if (refCounter.getRefCount() != count) {
                    refCounter.setRefCount(count);
                }
                ReferenceCounter.releaseReferenceCounter(refCounter);
            }
        }
    }

    @Override
    protected void performDeinstallationRollback(FeatureInfo registryInfo) throws GdrException {
        ReferenceCounter refCounter = ReferenceCounter.getReferenceCounter(this.getPatchHandler().getHome().getHomePath(), ReferenceCounter.RefType.featuresets, registryInfo.getName(), registryInfo.getVersion());
        refCounter.increment();
        ReferenceCounter.releaseReferenceCounter(refCounter);
    }

    @Override
    protected void performInstallationRollback(FeatureInfo registryInfo) throws GdrException {
        DeInstallInfoHelper deinstallInfoHelper = DeInstallInfoHelper.getInstance();
        try {
            DeInstallInfo deInstallInfo = deinstallInfoHelper.getDeInstallInfoFromHome(this.getPatchHandler().getHome().getHomePath());
            deinstallInfoHelper.removeFeatureSetFiles(deInstallInfo, this.getPatchHandler().getHome(), FeatureSetHelper.getInstance().getFeatureSet(this.getPatchHandler().getHome().getMetaDataHome(), registryInfo.getName(), registryInfo.getVersion()));
            deinstallInfoHelper.saveDeInstallInfoToHome(deInstallInfo, this.getPatchHandler().getHome().getHomePath());
        }
        catch (DataHandlerException | IOException e) {
            throw new GdrException("Problem processing deinstallInfo", e);
        }
        ReferenceCounter refCounter = ReferenceCounter.getReferenceCounter(this.getPatchHandler().getHome().getHomePath(), ReferenceCounter.RefType.featuresets, registryInfo.getName(), registryInfo.getVersion());
        refCounter.decrement();
        ReferenceCounter.releaseReferenceCounter(refCounter);
    }

    @Override
    protected void analyzeUpgradePatches() throws GdrException, IOException, DataHandlerException {
        for (Map.Entry<Reference, FeatureSet> featureEntry : this._featureSetMap.entrySet()) {
            boolean found = false;
            for (Distribution distribution : ((PatchHandlerImpl)this.getPatchHandler()).getDistributionMetaDataPatchHandler().getPatchedDistributions()) {
                for (FeatureSetGroup featureGroup : distribution.getFeatureSetGroups()) {
                    if (!featureGroup.getFeatures().contains((Object)featureEntry.getKey())) continue;
                    this.addFeatureSetToDistMap(distribution, featureEntry.getValue());
                    found = true;
                }
            }
            if (found) continue;
            for (DistributionTarget distributionTarget : this.getPatchHandler().getHome().getInstalledDistributions()) {
                for (FeatureSet feature : distributionTarget.getFeatureSets()) {
                    if (!featureEntry.getValue().getName().equals(feature.getName()) || VersionHelper.compare((String)featureEntry.getValue().getVersion(), (String)feature.getVersion(), (int)4) != 0) continue;
                    Distribution dist = distributionTarget.getDistribution();
                    for (Distribution upgradeDist : ((PatchHandlerImpl)this.getPatchHandler()).getDistributionMetaDataPatchHandler().getPatchedDistributions()) {
                        if (!dist.getName().equals(dist.getName())) continue;
                        dist = upgradeDist;
                    }
                    this.addFeatureSetToDistMap(dist, featureEntry.getValue());
                }
            }
        }
        for (Map.Entry<Reference, FeatureSet> featureEntry : this._featureSetMap.entrySet()) {
            int foundDistributions = 0;
            do {
                foundDistributions = 0;
                for (Map.Entry entry : this._featureSetMap.entrySet()) {
                    if (featureEntry.getKey().equals(entry.getKey())) continue;
                    for (DependencyRef depRef : FeatureSetHelper.getInstance().getFeatureDependencies((FeatureSet)entry.getValue())) {
                        if (!depRef.getName().equals(featureEntry.getKey().getName())) continue;
                        for (Map.Entry<Distribution, Set<FeatureSet>> entrySet : this._distributionMap.entrySet()) {
                            if (!entrySet.getValue().contains(entry.getValue()) || !this.addFeatureSetToDistMap(entrySet.getKey(), featureEntry.getValue())) continue;
                            ++foundDistributions;
                        }
                    }
                }
            } while (foundDistributions != 0);
        }
    }

    private boolean addFeatureSetToDistMap(Distribution dist, FeatureSet feature) {
        if (this._distributionMap.containsKey(dist)) {
            if (this._distributionMap.get(dist).contains(feature)) {
                return false;
            }
            this._distributionMap.get(dist).add(feature);
            return true;
        }
        HashSet<FeatureSet> features = new HashSet<FeatureSet>();
        features.add(feature);
        this._distributionMap.put(dist, features);
        return true;
    }

    private List<DistributionInfo> getDistributionsToUpdateOnInstall(FeatureSet feature, Registry registry) {
        ArrayList<DistributionInfo> distributions = new ArrayList<DistributionInfo>();
        for (Distribution dist : this._distributionMap.keySet()) {
            if (!this._distributionMap.get(dist).contains(feature)) continue;
            distributions.add(this.getPatchHandler().getHome().getRegistryHelper().getDistributionInfo(registry, dist.getName(), dist.getVersion()));
        }
        return distributions;
    }

    private List<FeatureInfo> getFeatureInfosToDeinstall(FeatureSet feature, Registry registry) {
        ArrayList<FeatureInfo> featureInfos = new ArrayList<FeatureInfo>();
        FeatureSetReference reference = new FeatureSetReference(feature.getName(), feature.getVersion());
        block0: for (Distribution dist : this._distributionMap.keySet()) {
            if (!this._distributionMap.get(dist).contains(feature)) continue;
            DistributionInfo distributionInfo = this.getPatchHandler().getHome().getRegistryHelper().getDistributionInfo(registry, dist.getName(), dist.getVersion());
            for (FeatureInfo finfo : distributionInfo.getFeatures()) {
                if (!reference.getName().equalsIgnoreCase(finfo.getName()) || !reference.getVersion().equals(finfo.getVersion())) continue;
                featureInfos.add(finfo);
                continue block0;
            }
        }
        return featureInfos;
    }
}

