/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.patch.InternalPatchHandler;
import com.oracle.cie.gdr.patch.PatchMetaDataHandler;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.Patch;

public class DistributionMetaDataPatchHandler
extends PatchMetaDataHandler<DistributionInfo> {
    private static final Logger _log = Logger.getLogger(DistributionMetaDataPatchHandler.class.getName());
    private DistributionHelper _distributionHelper;
    private Map<Reference, Distribution> _distributionMap = new HashMap<Reference, Distribution>();
    private Map<Path, Reference> _distributionRefMap = new HashMap<Path, Reference>();

    public DistributionMetaDataPatchHandler(InternalPatchHandler patchHandler, Patch patch) {
        super(patchHandler, patch);
        this._distributionHelper = DistributionHelper.getInstance(patchHandler.getHome().getClassLoader());
    }

    @Override
    protected Path getPatchUpgradesDirectory() throws GdrException {
        return this.getPatchHandler().getHome().getMetaDataHome().getGdrMetaDataHomePath().resolve(this._distributionHelper.getPath()).resolve("upgrades").resolve(this.getPatch().getPatchUpi());
    }

    @Override
    protected Path getPatchInstallDirectory() throws GdrException {
        return null;
    }

    @Override
    protected Path getPatchDeinstallDirectory() throws GdrException {
        return null;
    }

    @Override
    protected Set<Reference> getPatchMetaDataRefs(List<Path> patchMetaDataFiles) throws DataHandlerException, GdrException, IOException {
        HashSet<Reference> patchMetaDataRefs = new HashSet<Reference>();
        for (Path patchDistributionFilePath : patchMetaDataFiles) {
            if (!this._distributionRefMap.containsKey(patchDistributionFilePath)) {
                _log.info("Loading patch distribution meta-data file from " + patchDistributionFilePath);
                Distribution distribution = this._distributionHelper.getDistribution(patchDistributionFilePath);
                QuickReference distributionRef = new QuickReference(distribution.getName(), distribution.getVersion());
                this._distributionRefMap.put(patchDistributionFilePath, distributionRef);
                if (!this._distributionMap.containsKey((Object)distributionRef)) {
                    this._distributionMap.put(distributionRef, distribution);
                }
            }
            patchMetaDataRefs.add(this._distributionRefMap.get(patchDistributionFilePath));
        }
        return patchMetaDataRefs;
    }

    protected Distribution getPatchMetaDataDistribution(Path patchMetaDataFile) throws IOException, DataHandlerException, GdrException {
        ArrayList<Path> patchMetaDataFiles = new ArrayList<Path>();
        patchMetaDataFiles.add(patchMetaDataFile);
        return this.getPatchMetaDataDistributions(patchMetaDataFiles).iterator().next();
    }

    protected Set<Distribution> getPatchMetaDataDistributions(List<Path> patchMetaDataFiles) throws IOException, DataHandlerException, GdrException {
        HashSet<Distribution> patchMetaDataDistributions = new HashSet<Distribution>();
        for (Path patchDistributionFile : patchMetaDataFiles) {
            if (!this._distributionRefMap.containsKey(patchDistributionFile)) {
                _log.info("Loading patch distribution meta-data file from " + patchDistributionFile);
                Distribution distribution = this._distributionHelper.getDistribution(patchDistributionFile);
                QuickReference distributionRef = new QuickReference(distribution.getName(), distribution.getVersion());
                this._distributionRefMap.put(patchDistributionFile, distributionRef);
                if (!this._distributionMap.containsKey((Object)distributionRef)) {
                    this._distributionMap.put(distributionRef, distribution);
                }
            }
            patchMetaDataDistributions.add(this._distributionMap.get((Object)this._distributionRefMap.get(patchDistributionFile)));
        }
        return patchMetaDataDistributions;
    }

    protected Collection<Distribution> getPatchedDistributions() {
        return this._distributionMap.values();
    }

    @Override
    protected List<DistributionInfo> getAllRegistryInfos() throws GdrException {
        return this.getPatchHandler().getLockedRegistry().getDistributions();
    }

    @Override
    protected List<DistributionInfo> getRegistryInfosForPatch(String patchId) throws GdrException {
        return this.getRegistryHelper().getDistributionInfosForPatch(this.getPatchHandler().getLockedRegistry(), patchId);
    }

    @Override
    protected Path getMetaDataSource(Reference patchMetaDataRef) throws GdrException {
        return this._distributionMap.get((Object)patchMetaDataRef).getDistributionFileLocationPath();
    }

    @Override
    protected Path getMetaDataDest(Reference patchMetaDataRef) throws GdrException {
        return this.getPatchHandler().getHome().getMetaDataHome().getGdrMetaDataHomePath().resolve(this._distributionHelper.getPath()).resolve(this._distributionHelper.getDistributionFileName(patchMetaDataRef.getName(), patchMetaDataRef.getVersion()));
    }

    @Override
    protected Map<Path, Path> getAdditionalMetaDataMappings(Reference patchMetaDataRef) throws GdrException {
        LinkedHashMap<Path, Path> additionalMetaData = new LinkedHashMap<Path, Path>();
        Path destParentDir = this.getPatchHandler().getHome().getMetaDataHome().getGdrMetaDataHomePath();
        Path sourceParentDir = !this._distributionMap.containsKey((Object)patchMetaDataRef) ? destParentDir : this._distributionMap.get((Object)patchMetaDataRef).getDistributionFileLocationPath().getParent();
        Path resourceSource = sourceParentDir.resolve(this._distributionHelper.getResourceLocation(patchMetaDataRef.getName(), patchMetaDataRef.getVersion()));
        Path resourceDest = destParentDir.resolve(this._distributionHelper.getPath()).resolve(this._distributionHelper.getResourceLocation(patchMetaDataRef.getName(), patchMetaDataRef.getVersion()));
        additionalMetaData.put(resourceSource, resourceDest);
        Path infoSource = sourceParentDir.resolve("info").resolve(DistributionInfoHelper.getInstance().getDistributionInfoFileName(patchMetaDataRef.getName(), patchMetaDataRef.getVersion()));
        Path infoDest = destParentDir.resolve(DistributionInfoHelper.getInstance().getPath()).resolve(DistributionInfoHelper.getInstance().getDistributionInfoFileName(patchMetaDataRef.getName(), patchMetaDataRef.getVersion()));
        additionalMetaData.put(infoSource, infoDest);
        return additionalMetaData;
    }

    @Override
    protected void performMetadataInstallation(List<Path> patchMetaDataFiles) throws GdrException, IOException, DataHandlerException {
    }

    @Override
    protected void performMetadataDeinstallation(List<Path> patchMetaDataFiles) {
    }

    @Override
    protected void analyzeUpgradePatches() throws GdrException, IOException, DataHandlerException {
    }

    @Override
    protected void performInstallationRollback(DistributionInfo registryInfo) {
    }

    @Override
    protected void performDeinstallationRollback(DistributionInfo registryInfo) throws GdrException {
    }
}

