/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration.impl;

import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.deinstallation.DeInstaller;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.orchestration.InstallActionTarget;
import com.oracle.cie.gdr.orchestration.lifecycle.InstallPhase;
import com.oracle.cie.gdr.services.ServiceHolder;
import java.nio.file.Path;

public class InstallActionTargetImpl
implements InstallActionTarget {
    private Mode _mode;
    private Installer _installer;
    private DeInstaller _deInstaller;
    private Path _homePath;
    private InstallPhase _currentInstallPhase;

    public InstallActionTargetImpl(Installer installer) {
        if (installer == null) {
            throw new NullPointerException("The installer provided was null.");
        }
        this._installer = installer;
        this._mode = Mode.INSTALL;
        this._homePath = this._installer.getHome().getHomePath();
    }

    public InstallActionTargetImpl(DeInstaller deInstaller) {
        if (deInstaller == null) {
            throw new NullPointerException("The de-installer provided was null.");
        }
        this._deInstaller = deInstaller;
        this._mode = Mode.DEINSTALL;
        this._homePath = NioHelper.getInstance().getPath(this._deInstaller.getHomeDir());
    }

    @Override
    public Mode getMode() {
        return this._mode;
    }

    @Override
    public Installer getInstaller() {
        return this._installer;
    }

    @Override
    public DeInstaller getDeInstaller() {
        return this._deInstaller;
    }

    @Override
    public Path getHomePath() {
        return this._homePath;
    }

    @Override
    public InstallPhase getCurrentInstallPhase() {
        return this._currentInstallPhase;
    }

    public void setCurrentInstallPhase(InstallPhase currentInstallPhase) {
        this._currentInstallPhase = currentInstallPhase;
    }

    @Override
    public ServiceHolder getServiceHolder() {
        if (this.getMode().isInstallMode()) {
            return this.getInstaller().getInstallationSession().getServiceHolder();
        }
        if (this.getMode().isDeInstallMode()) {
            return this.getDeInstaller().getDeInstallationSession().getServiceHolder();
        }
        return null;
    }
}

