/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration.impl;

import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.orchestration.InstallActionExecutor;
import com.oracle.cie.gdr.orchestration.InstallActionManager;
import com.oracle.cie.gdr.orchestration.InstallActionTarget;
import com.oracle.cie.gdr.orchestration.action.InstallAction;
import com.oracle.cie.gdr.orchestration.action.impl.CentralInventoryInstallAction;
import com.oracle.cie.gdr.orchestration.action.impl.CompleteInstallAction;
import com.oracle.cie.gdr.orchestration.action.impl.ComponentDeInstallAction;
import com.oracle.cie.gdr.orchestration.action.impl.ComponentInstallAction;
import com.oracle.cie.gdr.orchestration.action.impl.GlobalEnvPropertiesAction;
import com.oracle.cie.gdr.orchestration.action.impl.LibraryGenerationInstallAction;
import com.oracle.cie.gdr.orchestration.action.impl.StartInstallAction;
import com.oracle.cie.gdr.orchestration.action.impl.StringSubsInstallAction;
import com.oracle.cie.gdr.orchestration.impl.InstallActionExecutorImpl;
import com.oracle.cie.gdr.orchestration.lifecycle.InstallPhase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InstallActionManagerImpl
implements InstallActionManager {
    private InstallActionTarget _installActionTarget;

    public InstallActionManagerImpl(InstallActionTarget installActionTarget) {
        this._installActionTarget = installActionTarget;
    }

    @Override
    public InstallActionTarget getInstallActionTarget() {
        return this._installActionTarget;
    }

    @Override
    public Map<InstallPhase, List<InstallAction>> getInstallActions() {
        HashMap<InstallPhase, List<InstallAction>> actions = new HashMap<InstallPhase, List<InstallAction>>();
        List<InstallAction> allActions = this.getAllInstallActions();
        if (allActions != null) {
            for (InstallAction installAction : allActions) {
                Set<InstallPhase> phases;
                Set<Mode> installActionModes = installAction.getInstallActionModes();
                if (installActionModes == null || !installActionModes.contains((Object)this.getInstallActionTarget().getMode()) || (phases = installAction.getInstallPhases(this.getInstallActionTarget().getMode())) == null) continue;
                for (InstallPhase phase : phases) {
                    ArrayList<InstallAction> installActions = (ArrayList<InstallAction>)actions.get((Object)phase);
                    if (installActions == null) {
                        installActions = new ArrayList<InstallAction>();
                        actions.put(phase, installActions);
                    }
                    installActions.add(installAction);
                }
            }
        }
        return actions;
    }

    public List<InstallAction> getAllInstallActions() {
        ArrayList<InstallAction> actions = new ArrayList<InstallAction>();
        actions.add(new StartInstallAction(this.getInstallActionTarget()));
        actions.add(new ComponentInstallAction(this.getInstallActionTarget()));
        actions.add(new ComponentDeInstallAction(this.getInstallActionTarget()));
        actions.add(new LibraryGenerationInstallAction(this.getInstallActionTarget()));
        actions.add(new StringSubsInstallAction(this.getInstallActionTarget()));
        actions.add(new GlobalEnvPropertiesAction(this.getInstallActionTarget()));
        actions.add(new CompleteInstallAction(this.getInstallActionTarget()));
        actions.add(new CentralInventoryInstallAction(this.getInstallActionTarget()));
        return actions;
    }

    @Override
    public InstallActionExecutor getInstallActionExecutor() {
        return new InstallActionExecutorImpl(this);
    }
}

