/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration.action.impl;

import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.orchestration.InstallActionFactory;
import com.oracle.cie.gdr.orchestration.InstallActionResult;
import com.oracle.cie.gdr.orchestration.InstallActionTarget;
import com.oracle.cie.gdr.orchestration.action.impl.CommonInstallAction;
import com.oracle.cie.gdr.orchestration.lifecycle.InstallPhase;
import com.oracle.cie.gdr.services.ProductFamilyService;
import com.oracle.cie.gdr.services.VariableResolverService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class StringSubsInstallAction
extends CommonInstallAction {
    private static final Logger _log = Logger.getLogger(StringSubsInstallAction.class.getName());
    public static final String TEMPLATES_DIR = "Templates";

    public StringSubsInstallAction(InstallActionTarget target) {
        super(target);
    }

    @Override
    public String getName() {
        return "string-substitution";
    }

    @Override
    public String getDisplayName() {
        return "String Substitution";
    }

    @Override
    public Set<Mode> getInstallActionModes() {
        return this.getModeSet(Mode.INSTALL);
    }

    @Override
    public Set<InstallPhase> getInstallPhases(Mode mode) {
        return this.getInstallPhaseSet(InstallPhase.POST_PROCESS);
    }

    @Override
    public InstallActionResult execute() {
        Installer installer = this.getTarget().getInstaller();
        Set<Component> components = installer.getPostProcessComponents();
        String oracleHomeStr = installer.getHome().getHomePath().toString();
        Path templatesDir = installer.getHome().getInventoryDirectoryPath().resolve(TEMPLATES_DIR);
        try {
            if (components != null) {
                Map<String, String> productFamiliesMap = ProductFamilyService.getInstance().getFederatedOracleHomeProductFamiliesMap(installer);
                for (Component component : components) {
                    if (!component.hasStringsubs()) continue;
                    IObjectStore componentObjectStore = VariableResolverService.getVariableResolverService().getObjectStore(component.getNamespace());
                    componentObjectStore.storeAll(productFamiliesMap);
                    Map<String, String> backupFiles = ComponentHelper.getInstance().stringsub(component, VariableResolverService.getVariableResolverService(), templatesDir, oracleHomeStr);
                    StringSubsInstallAction.fixBackupPermissions(backupFiles);
                }
            }
        }
        catch (Exception e) {
            return InstallActionFactory.getFailureResult(this, "String subs failed", e);
        }
        return InstallActionFactory.getSuccessResult(this);
    }

    public static void fixBackupPermissions(Map<String, String> backupFiles) throws IOException {
        boolean windows = PlatformInfoHelper.getInstance().isInWindowsGroup(PlatformInfoHelper.getInstance().getCurrentPlatformId());
        if (!windows && backupFiles != null && backupFiles.size() > 0) {
            for (Map.Entry<String, String> entry : backupFiles.entrySet()) {
                Set<PosixFilePermission> originalPerms = Files.getPosixFilePermissions(NioHelper.getInstance().getPath(entry.getKey(), new String[0]), new LinkOption[0]);
                Path backedupFile = NioHelper.getInstance().getPath(entry.getValue(), new String[0]);
                _log.finest("Setting permissions of backed up file \"" + backedupFile + "\" to " + PosixFilePermissions.toString(originalPerms));
                Files.setPosixFilePermissions(backedupFile, originalPerms);
            }
        } else {
            _log.finest("Backup files map is null or empty");
        }
    }
}

