/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.merger;

import com.oracle.cie.common.util.ManifestBuilder;
import com.oracle.cie.gdr.merger.AttributeDescriptor;
import com.oracle.cie.gdr.merger.AttributeDescriptorCollection;
import com.oracle.cie.gdr.merger.IManifestConflictResolver;
import com.oracle.cie.gdr.merger.LibraryJarHelper;
import com.oracle.cie.gdr.merger.MergeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestMerger {
    public static Manifest mergeManifests(List<LibraryJarHelper> jarList, IManifestConflictResolver resolver, Attributes additionalAttrs) throws MergeException, IOException {
        AttributeDescriptorCollection attrCollection = new AttributeDescriptorCollection();
        for (LibraryJarHelper jar : jarList) {
            Manifest myManifest = null;
            try {
                myManifest = jar.getJar().getManifest();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (myManifest == null) continue;
            Attributes attrs = myManifest.getMainAttributes();
            List<Attributes.Name> names = Arrays.asList(attrs.keySet().toArray(new Attributes.Name[0]));
            for (Attributes.Name name : names) {
                AttributeDescriptor attr = new AttributeDescriptor(jar, name, attrs.getValue(name));
                attrCollection.add(attr);
            }
        }
        List<Attributes.Name> additionalNames = Arrays.asList(additionalAttrs.keySet().toArray(new Attributes.Name[0]));
        for (Attributes.Name name : additionalNames) {
            AttributeDescriptor attr = new AttributeDescriptor(null, name, additionalAttrs.getValue(name));
            attrCollection.add(attr);
        }
        ManifestMerger.resolveConflicts(attrCollection, resolver, jarList);
        return ManifestMerger.generateManifest(attrCollection);
    }

    private static void resolveConflicts(AttributeDescriptorCollection attrCollection, IManifestConflictResolver resolver, List<LibraryJarHelper> jars) throws MergeException {
        ArrayList<AttributeDescriptor> resolvedAttrs = new ArrayList<AttributeDescriptor>();
        for (List<AttributeDescriptor> attrList : attrCollection.getConflicts()) {
            boolean equal = true;
            for (int i = 0; i < attrList.size() - 1; ++i) {
                if (attrList.get(i).getValue().equals(attrList.get(i + 1).getValue())) continue;
                equal = false;
                break;
            }
            if (!equal) {
                String newValue = resolver.resolve(attrList, jars);
                AttributeDescriptor newAttr = new AttributeDescriptor(attrList.get(0).getJar(), attrList.get(0).getName(), newValue);
                resolvedAttrs.add(newAttr);
                continue;
            }
            resolvedAttrs.add(attrList.get(0));
        }
        attrCollection.removeAllConflicts();
        attrCollection.add(resolvedAttrs);
    }

    private static Manifest generateManifest(AttributeDescriptorCollection attrCollection) throws IOException {
        HashMap<Attributes.Name, String> attrMap = new HashMap<Attributes.Name, String>();
        for (AttributeDescriptor attr : attrCollection.getAttributes()) {
            if (attr.getValue() == null || attr.getValue().equals("")) continue;
            attrMap.put(attr.getName(), attr.getValue());
        }
        return ManifestBuilder.getManifest(attrMap);
    }
}

