/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.merger;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.FileResolver;
import com.oracle.cie.gdr.dao.cmn.ManifestResolver;
import com.oracle.cie.gdr.dao.cmn.MergeSelection;
import com.oracle.cie.gdr.dao.cmn.MergedJarClasspath;
import com.oracle.cie.gdr.dao.cpd.IncludeExclude;
import com.oracle.cie.gdr.dao.cpd.Selection;
import com.oracle.cie.gdr.libraries.DefaultLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryAccessException;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.merger.EntryDescriptor;
import com.oracle.cie.gdr.merger.EntryDescriptorCollection;
import com.oracle.cie.gdr.merger.ErrorFileResolver;
import com.oracle.cie.gdr.merger.ErrorManifestResolver;
import com.oracle.cie.gdr.merger.IFileConflictResolver;
import com.oracle.cie.gdr.merger.IManifestConflictResolver;
import com.oracle.cie.gdr.merger.LibraryJarHelper;
import com.oracle.cie.gdr.merger.ManifestMerger;
import com.oracle.cie.gdr.merger.MergeException;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.StagingFileFilter;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipException;

public class LibraryJarMerger {
    private static final String MANIFEST_SEPARATOR = "/";
    private static final String BACK_STRING = "../";
    private static final Logger _log = Logger.getLogger(LibraryJarMerger.class.getName());
    private Set<LibraryEntryLocation> entryLocations;
    private Mode mode;
    private String destDir;
    private String productHome;
    private String location;
    private String jarName;
    private List<FileResolver> fileResolvers;
    private IManifestConflictResolver manifestResolver;
    private MergedJarClasspath classpathJarRules;
    private Attributes additionalAttributes;
    private Path homePath;
    private static Map<String, IFileConflictResolver> resolversMap = new HashMap<String, IFileConflictResolver>();

    public LibraryJarMerger(Set<LibraryEntryLocation> entryLocations, Mode mode, Path homePath, String destDir, String productHome, String jarLocation, String jarName, List<FileResolver> fileResolvers, ManifestResolver manifestResolver, MergedJarClasspath classpathJarRules) throws MergeException {
        this.entryLocations = entryLocations;
        this.mode = mode;
        this.homePath = homePath;
        this.destDir = destDir;
        this.productHome = productHome;
        this.location = jarLocation;
        this.jarName = jarName;
        this.classpathJarRules = classpathJarRules;
        this.fileResolvers = fileResolvers == null ? new ArrayList<FileResolver>() : fileResolvers;
        if (manifestResolver == null) {
            this.manifestResolver = new ErrorManifestResolver();
        } else {
            try {
                this.manifestResolver = this.findManifestResolver(manifestResolver.getType());
            }
            catch (Exception e) {
                throw new MergeException(e);
            }
        }
        this.additionalAttributes = new Attributes();
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public String getJarName() {
        return this.jarName;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public List<FileResolver> getFileResolvers() {
        return this.fileResolvers;
    }

    public void setFileResolvers(List<FileResolver> fileResolvers) {
        this.fileResolvers = fileResolvers;
    }

    public IManifestConflictResolver getManifestResolver() {
        return this.manifestResolver;
    }

    public void setManifestResolver(IManifestConflictResolver manifestResolver) {
        this.manifestResolver = manifestResolver;
    }

    private void generateJar(Collection<EntryDescriptor> entryList, Map<Path, Boolean> entryFiles, String destDirPath, String sourceDirPath, Manifest myManifest) throws MergeException, LibraryAccessException {
        Path sourceDir = NioHelper.getInstance().getPath(sourceDirPath, new String[0]);
        Path jarFile = NioHelper.getInstance().getPath(destDirPath, new String[0]).resolve(this.jarName);
        try (JarHelper mergedJar = null;){
            mergedJar = new JarHelper(jarFile.toFile(), 1, myManifest, Long.valueOf(UtilityOps.getStoredSessionTimeStamp()));
            mergedJar.setPreserve(true);
            mergedJar.setLevel(1);
            for (EntryDescriptor entryDescriptor : entryList) {
                mergedJar.append(entryDescriptor.getEntry(), entryDescriptor.getLibraryJar().getJar().getJar().getInputStream(entryDescriptor.getEntry()));
            }
            for (Map.Entry entry : entryFiles.entrySet()) {
                try {
                    if (((Path)entry.getKey()).toString().endsWith(".jar")) {
                        JarFile jarFileEntry = new JarFile(((Path)entry.getKey()).toFile());
                        jarFileEntry.close();
                    }
                    mergedJar.append(((Path)entry.getKey()).toFile(), ((Boolean)entry.getValue()).booleanValue());
                }
                catch (ZipException e) {
                    mergedJar.close();
                    Files.delete(jarFile);
                    throw new LibraryAccessException("Library " + ((Path)entry.getKey()).toAbsolutePath() + " not available for inclusion");
                }
                catch (FileNotFoundException e) {
                    mergedJar.close();
                    Files.delete(jarFile);
                    throw new LibraryAccessException("Library " + ((Path)entry.getKey()).toAbsolutePath() + " not available for inclusion");
                }
            }
            try (DirectoryStream<Path> files = Files.newDirectoryStream(sourceDir);){
                if (files.iterator().hasNext()) {
                    mergedJar.append(sourceDir.toFile(), false);
                }
            }
            catch (Exception e) {
                _log.warning("Unable to get files under location " + sourceDir);
            }
        }
    }

    public void mergeJars() throws LibraryHandlerException {
        ArrayList<LibraryJarHelper> jars = new ArrayList<LibraryJarHelper>();
        String tempDir = "";
        Path tempDirPath = null;
        try {
            tempDirPath = Files.createTempFile(NioHelper.getInstance().getPath(this.destDir, new String[0]), "temp", "", new FileAttribute[0]);
            tempDir = tempDirPath.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e1) {
            throw new LibraryHandlerException("Failed to create temporary file on " + this.destDir);
        }
        NioDelete.delete((Path)tempDirPath);
        try {
            Files.createDirectories(tempDirPath, new FileAttribute[0]);
        }
        catch (IOException e1) {
            throw new LibraryHandlerException("Failed to create temporary directory for Jar Merging: " + tempDirPath, e1);
        }
        if (!Files.exists(tempDirPath, new LinkOption[0])) {
            throw new LibraryHandlerException("Failed to create temporary directory for Jar Merging: " + tempDirPath);
        }
        _log.fine("Comparing JARs");
        try {
            EntryDescriptorCollection entryCollection = new EntryDescriptorCollection();
            HashMap<Path, Boolean> entryFiles = new HashMap<Path, Boolean>();
            for (LibraryEntryLocation entryLocation : this.entryLocations) {
                String classpathValue;
                LibraryJarHelper jar;
                Path sourceJar = DefaultLibraryHandler.getEntryLocationFile(entryLocation, Home.getHome(this.homePath), this.mode);
                if (Files.notExists(sourceJar, new LinkOption[0])) {
                    throw new LibraryAccessException("Source jar " + sourceJar.toString() + " doesn't exist");
                }
                if (entryLocation.getEntry().getExplode().booleanValue() && Files.isRegularFile(sourceJar, new LinkOption[0]) && sourceJar.toString().endsWith(".jar")) {
                    jar = new LibraryJarHelper(new JarHelper(sourceJar.toFile()), entryLocation.getProductHome(), this.productHome, this.location, entryLocation.getPath());
                    if (this.excludeJar(jar)) {
                        _log.finer("Adding Jar to Class-Path: " + jar.getJar().getJar().getName());
                        classpathValue = this.additionalAttributes.getValue(Attributes.Name.CLASS_PATH.toString());
                        if (classpathValue == null) {
                            this.additionalAttributes.putValue(Attributes.Name.CLASS_PATH.toString(), this.calculateClasspath(this.productHome, entryLocation.getProductHome(), this.location, entryLocation.getPath()));
                        } else {
                            this.additionalAttributes.putValue(Attributes.Name.CLASS_PATH.toString(), classpathValue + " " + this.calculateClasspath(this.productHome, entryLocation.getProductHome(), this.location, entryLocation.getPath()));
                        }
                        jar.getJar().close();
                        continue;
                    }
                    _log.finer("Merging Jar: " + jar.getJar().getJar().getName());
                    jars.add(jar);
                    Version gdrVersion = entryLocation.getLibraryTarget().getComponent().getGdrVersion();
                    if (gdrVersion != null && gdrVersion.compareTo(new Version("1.1.0.0")) >= 0) {
                        List<Selection> includes = entryLocation.getIncludes();
                        if (includes != null && !includes.isEmpty()) {
                            for (Selection include : includes) {
                                try {
                                    JarEntry entry = jar.getJar().getJarEntry(include.getName());
                                    entryCollection.add(new EntryDescriptor(jar, entry));
                                }
                                catch (NullPointerException npe) {
                                    _log.warning("Entry not found: " + include.getName() + " in jar: " + jar.getJar().getJar().getName());
                                }
                            }
                            continue;
                        }
                        FileFilter filter = new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                return !file.isDirectory() && !file.getPath().equals("META-INF/MANIFEST.MF");
                            }
                        };
                        ArrayList<JarEntry> jarEntries = Collections.list(jar.getJar().getJar().entries());
                        for (final JarEntry entry : jarEntries) {
                            File jarFileEntry = new File(entry.getName()){

                                @Override
                                public boolean isDirectory() {
                                    return entry.isDirectory();
                                }

                                @Override
                                public boolean isFile() {
                                    return !this.isDirectory();
                                }

                                @Override
                                public String getPath() {
                                    return entry.getName();
                                }
                            };
                            if (!filter.accept(jarFileEntry)) continue;
                            entryCollection.add(new EntryDescriptor(jar, entry));
                        }
                        continue;
                    }
                    ArrayList<IncludeExclude> excludeManifest = new ArrayList<IncludeExclude>();
                    IncludeExclude manifestRule = new IncludeExclude();
                    manifestRule.setRegex("^MANIFEST.MF$");
                    manifestRule.setMatchDirs(true);
                    excludeManifest.add(0, manifestRule);
                    IncludeExclude manifestRule2 = new IncludeExclude();
                    manifestRule2.setRegex("^META-INF$");
                    manifestRule2.setMatchDirs(true);
                    excludeManifest.add(1, manifestRule2);
                    StagingFileFilter newFilter = new StagingFileFilter(null, new ArrayList<IncludeExclude>(), excludeManifest);
                    ArrayList<JarEntry> jarEntries = Collections.list(jar.getJar().getJar().entries());
                    for (JarEntry entry : jarEntries) {
                        Path tempFile = NioHelper.getInstance().getPath(entry.getName(), new String[0]);
                        if (!newFilter.accept(tempFile) || entry.isDirectory() || !StagingFileFilter.accept(tempFile, entryLocation.getIncludes(), entryLocation.getExcludes())) continue;
                        EntryDescriptor tempEntry = new EntryDescriptor(jar, entry);
                        entryCollection.add(tempEntry);
                    }
                    continue;
                }
                if (Files.isRegularFile(sourceJar, new LinkOption[0]) && sourceJar.toString().endsWith(".jar")) {
                    try {
                        jar = new LibraryJarHelper(new JarHelper(sourceJar.toFile()), entryLocation.getProductHome(), this.productHome, this.location, entryLocation.getPath());
                    }
                    catch (IOException e) {
                        throw new LibraryAccessException(e);
                    }
                    if (this.excludeJar(jar)) {
                        _log.finer("Adding Jar to Class-Path: " + jar.getJar().getJar().getName());
                        classpathValue = this.additionalAttributes.getValue(Attributes.Name.CLASS_PATH.toString());
                        if (classpathValue == null) {
                            this.additionalAttributes.putValue(Attributes.Name.CLASS_PATH.toString(), this.calculateClasspath(this.productHome, entryLocation.getProductHome(), this.location, entryLocation.getPath()));
                        } else {
                            this.additionalAttributes.putValue(Attributes.Name.CLASS_PATH.toString(), classpathValue + " " + this.calculateClasspath(this.productHome, entryLocation.getProductHome(), this.location, entryLocation.getPath()));
                        }
                    } else {
                        entryFiles.put(sourceJar, entryLocation.getEntry().getIncludeParent());
                    }
                    jar.getJar().close();
                    continue;
                }
                entryFiles.put(sourceJar, entryLocation.getEntry().getIncludeParent());
            }
            _log.fine("Resolving JAR conflicts");
            this.resolveConflicts(entryCollection, tempDir, this.destDir);
            Manifest myManifest = ManifestMerger.mergeManifests(jars, this.manifestResolver, this.additionalAttributes);
            _log.fine("Generating merged JAR");
            this.generateJar(entryCollection.getEntries(), entryFiles, this.destDir, tempDir, myManifest);
        }
        catch (LibraryAccessException e) {
            throw e;
        }
        catch (ZipException e) {
            throw new LibraryAccessException(e);
        }
        catch (DataHandlerException e) {
            throw new LibraryHandlerException(e);
        }
        catch (GdrException e) {
            throw new LibraryHandlerException(e);
        }
        catch (IOException e) {
            throw new LibraryHandlerException(e);
        }
        catch (MergeException e) {
            _log.warning("JAR not created due to conflicting entries");
            throw new LibraryHandlerException(e);
        }
        finally {
            if (Files.exists(tempDirPath, new LinkOption[0])) {
                _log.fine("Removing temporary directory");
                NioDelete.delete((Path)tempDirPath);
            }
            for (LibraryJarHelper jar : jars) {
                jar.getJar().close();
            }
        }
    }

    private boolean excludeJar(LibraryJarHelper jarHelper) {
        if (this.classpathJarRules != null) {
            boolean exclude = false;
            ArrayList jarEntries = new ArrayList(jarHelper.getJar().getEntries());
            for (MergeSelection rule : this.classpathJarRules.getIncludes()) {
                if (rule.isMatchEntry()) {
                    for (String entry : jarEntries) {
                        if (!rule.matches(entry)) continue;
                        exclude = true;
                    }
                    continue;
                }
                if (!rule.matches(jarHelper.getModuleLocation())) continue;
                exclude = true;
            }
            for (MergeSelection rule : this.classpathJarRules.getExcludes()) {
                if (rule.isMatchEntry()) {
                    for (String entry : jarEntries) {
                        if (!rule.matches(entry)) continue;
                        return false;
                    }
                    continue;
                }
                if (!rule.matches(jarHelper.getModuleLocation())) continue;
                return false;
            }
            return exclude;
        }
        return false;
    }

    private String calculateClasspath(String mergedProductHome, String entryProductHome, String mergedLocation, String entryLocation) {
        String formatedEntryLocation = FileUtils.formatPath(entryLocation, MANIFEST_SEPARATOR);
        String[] entryLocationTokens = formatedEntryLocation.split(MANIFEST_SEPARATOR);
        StringBuilder path = new StringBuilder();
        String formatedPath = FileUtils.formatPath(mergedLocation, MANIFEST_SEPARATOR);
        String[] mergedLocationTokens = formatedPath.split(MANIFEST_SEPARATOR);
        if (mergedProductHome.equals(entryProductHome)) {
            int i;
            int commonDirs;
            for (commonDirs = 0; commonDirs < mergedLocationTokens.length && commonDirs < entryLocationTokens.length && mergedLocationTokens[commonDirs].equals(entryLocationTokens[commonDirs]); ++commonDirs) {
            }
            int goBack = mergedLocationTokens.length - commonDirs - 1;
            for (i = 0; i < goBack; ++i) {
                path.append(BACK_STRING);
            }
            for (i = commonDirs; i < entryLocationTokens.length; ++i) {
                if (i == entryLocationTokens.length - 1) {
                    path.append(entryLocationTokens[i]);
                    continue;
                }
                path.append(entryLocationTokens[i]).append(MANIFEST_SEPARATOR);
            }
        } else {
            for (int i = 0; i < mergedLocationTokens.length; ++i) {
                path.append(BACK_STRING);
            }
            path.append(entryProductHome).append(MANIFEST_SEPARATOR).append(formatedEntryLocation);
        }
        return path.toString();
    }

    private void resolveConflicts(EntryDescriptorCollection entryCollection, String tempDirPath, String destDirPath) throws MergeException {
        Path conflictsDir;
        try {
            conflictsDir = Files.createTempFile(NioHelper.getInstance().getPath(destDirPath, new String[0]), "resolverTemp", "", new FileAttribute[0]);
        }
        catch (IOException e1) {
            throw new MergeException("Failed to create temporary directory for conflict resolution inside: " + destDirPath);
        }
        try {
            Files.delete(conflictsDir);
            if (Files.exists(conflictsDir, new LinkOption[0])) {
                throw new MergeException("Could not delete temp file: " + conflictsDir.toAbsolutePath());
            }
        }
        catch (IOException e1) {
            throw new MergeException("Could not delete temp file: " + conflictsDir.toAbsolutePath());
        }
        try {
            Files.createDirectories(conflictsDir, new FileAttribute[0]);
            if (!Files.exists(conflictsDir, new LinkOption[0])) {
                throw new MergeException("Failed to create temporary directory for conflict resolution: " + conflictsDir);
            }
        }
        catch (IOException e1) {
            throw new MergeException("Failed to create temporary directory for conflict resolution: " + conflictsDir);
        }
        try {
            while (!entryCollection.getConflicts().isEmpty()) {
                List<EntryDescriptor> conflictList = entryCollection.getConflict();
                Path destFile = NioHelper.getInstance().getPath(tempDirPath, new String[0]).resolve(conflictList.get(0).getEntry().getName());
                IFileConflictResolver resolver = this.findMatchingFileResolver(conflictList.get(0).getEntry());
                resolver.resolve(entryCollection, conflictList, destFile, conflictsDir);
            }
        }
        catch (MergeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MergeException(e);
        }
        finally {
            NioDelete.delete((Path)conflictsDir);
        }
    }

    public IFileConflictResolver findMatchingFileResolver(JarEntry entry) throws MergeException {
        for (FileResolver resolver : this.fileResolvers) {
            if (!resolver.matches(entry.getName())) continue;
            try {
                return this.findFileResolver(resolver.getType());
            }
            catch (Exception e) {
                throw new MergeException(e);
            }
        }
        return new ErrorFileResolver();
    }

    public void addManifestAttributes(Attributes attrs) {
        this.additionalAttributes = attrs;
    }

    private IManifestConflictResolver findManifestResolver(String manifestResolverName) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        return (IManifestConflictResolver)Class.forName(IManifestConflictResolver.class.getPackage().getName() + "." + manifestResolverName + "ManifestResolver").getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private IFileConflictResolver findFileResolver(String fileResolverName) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        IFileConflictResolver resolver = resolversMap.get(fileResolverName);
        if (resolver == null) {
            resolver = (IFileConflictResolver)Class.forName(IFileConflictResolver.class.getPackage().getName() + "." + fileResolverName + "FileResolver").getConstructor(new Class[0]).newInstance(new Object[0]);
            resolversMap.put(fileResolverName, resolver);
        }
        return resolver;
    }

    /*
     * Exception decompiling
     */
    public boolean extractUpdatedEntries(Path tempMergedDir) throws LibraryHandlerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Path createTempDir(Path parentDir) throws LibraryHandlerException {
        Path myTempDir;
        try {
            myTempDir = Files.createTempDirectory(parentDir, "temp", new FileAttribute[0]);
        }
        catch (IOException e1) {
            throw new LibraryHandlerException("Failed to create temporary directory for : " + parentDir + e1.getMessage());
        }
        if (!Files.exists(myTempDir, new LinkOption[0])) {
            throw new LibraryHandlerException("Failed to create temporary directory for : " + parentDir);
        }
        return myTempDir;
    }
}

