/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.merger;

import com.oracle.cie.gdr.merger.AttributeDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;

public class AttributeDescriptorCollection {
    private List<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();
    private List<List<AttributeDescriptor>> conflictingAttributes = new ArrayList<List<AttributeDescriptor>>();

    public boolean contains(Attributes.Name name) {
        for (AttributeDescriptor attr : this.attributes) {
            if (!attr.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsConflict(Attributes.Name name) {
        for (List<AttributeDescriptor> attrList : this.conflictingAttributes) {
            if (!attrList.get(0).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void add(AttributeDescriptor attr) {
        if (this.containsConflict(attr.getName())) {
            List<AttributeDescriptor> conflictList = this.getConflict(attr.getName());
            conflictList.add(attr);
        } else if (this.contains(attr.getName())) {
            AttributeDescriptor temp = this.get(attr.getName());
            this.remove(temp);
            ArrayList<AttributeDescriptor> newConflict = new ArrayList<AttributeDescriptor>();
            newConflict.add(temp);
            newConflict.add(attr);
            this.conflictingAttributes.add(newConflict);
        } else {
            this.attributes.add(attr);
        }
    }

    public void add(List<AttributeDescriptor> attrList) {
        for (AttributeDescriptor attr : attrList) {
            this.add(attr);
        }
    }

    public AttributeDescriptor get(Attributes.Name name) {
        for (AttributeDescriptor attr : this.attributes) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public List<AttributeDescriptor> getConflict(Attributes.Name name) {
        for (List<AttributeDescriptor> attrList : this.conflictingAttributes) {
            if (!attrList.get(0).getName().equals(name)) continue;
            return attrList;
        }
        return null;
    }

    public void remove(AttributeDescriptor attr) {
        for (AttributeDescriptor temp : this.attributes) {
            if (!temp.getName().equals(attr.getName())) continue;
            this.attributes.remove(temp);
            break;
        }
    }

    public void removeAllConflicts() {
        this.conflictingAttributes.clear();
    }

    public List<AttributeDescriptor> getAttributes() {
        return this.attributes;
    }

    public List<List<AttributeDescriptor>> getConflicts() {
        return this.conflictingAttributes;
    }
}

