/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.maven;

import java.io.File;

public enum PackagingType {
    POM("pom"),
    JAR("jar"),
    MAVENPLUGIN("maven-plugin"),
    EJB("ejb"),
    WAR("war"),
    EAR("ear"),
    RAR("rar"),
    PAR("par"),
    CARB("carb");

    private String _typeName;

    private PackagingType(String typeName) {
        this._typeName = typeName;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public static boolean isPackagingType(File file) {
        return file != null && PackagingType.isPackagingType(file.getName());
    }

    public static boolean isPackagingType(String fileName) {
        if (fileName != null) {
            String ext = PackagingType.getFileExtension(fileName);
            for (PackagingType type : PackagingType.values()) {
                if (!type.getTypeName().equalsIgnoreCase(ext)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getFileExtension(String fileName) {
        int index;
        if (fileName != null && (index = fileName.lastIndexOf(".")) > -1 && index + 1 < fileName.length()) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    public static boolean isPOM(String filename) {
        return PackagingType.getFileExtension(filename).equalsIgnoreCase(POM.name());
    }
}

