/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.external.FederatedRelationship;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DeInstallInfoHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegenInstallerWrapper
implements InstallerWrapper {
    private static final Logger _log = Logger.getLogger(RegenInstallerWrapper.class.getName());
    private Home _home;
    private Map<FeatureSet, Collection<Component>> _metadataCache = new HashMap<FeatureSet, Collection<Component>>();

    public RegenInstallerWrapper(Home home) {
        this._home = home;
    }

    @Override
    public Map<FeatureSet, LibraryTargetHolder> getLibraryTargets() throws GdrException, DataHandlerException, DependencyException, IOException {
        return null;
    }

    @Override
    public synchronized void addExtraFilesToDeInstallInfo(String name, String version, Collection<Path> files, boolean isFeature) throws GdrException, IOException, DataHandlerException {
        DeInstallInfoHelper.getInstance().addExtraFilesToDeInstallInfo(this._home.getHomePath(), name, version, files, isFeature);
    }

    @Override
    public Home getHome() {
        return this._home;
    }

    @Override
    public Set<FeatureSet> getFeatureSets() {
        HashSet<FeatureSet> installedItems = null;
        if (this._home != null) {
            installedItems = new HashSet<FeatureSet>(this._home.getInstalledFeatures());
            if (this._home.isFederatedHome()) {
                try {
                    installedItems.addAll(FeatureSetHelper.getInstance().getClonedExternalFeatures(this._home.getFederatedInstalledFeatures(FederatedRelationship.CHAINED_DEPENDENCY, false)));
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Failed to get installed feature sets.", e);
                }
            }
        }
        return installedItems;
    }

    @Override
    public Set<Component> getComponents(FeatureSet feature) throws GdrException, IOException, DataHandlerException {
        if (this._metadataCache.containsKey(feature)) {
            return new HashSet<Component>(this._metadataCache.get(feature));
        }
        if (this._home != null) {
            List<ComponentReference> compRefs = feature.getComponentReferences();
            HashSet<Component> comps = new HashSet<Component>();
            Set platIds = PlatformInfoHelper.getInstance().getPlatformIds();
            ServiceHolder serviceHolder = new ServiceHolder(platIds, null, null);
            Home featureHome = feature.isExternal() ? this._home.getFeatureSetFederatedHome(feature, FederatedRelationship.CHAINED_DEPENDENCY) : this._home;
            Collection<DistributionTarget> distributionTargets = featureHome.getDistributionTargetsForFeature(feature);
            if (distributionTargets.isEmpty()) {
                GdrException ex = new GdrException("Could not locate distribution which contained feature set " + feature + " in home " + featureHome);
                _log.throwing(FeatureSetHelper.class.getName(), "getComponents", ex);
                throw ex;
            }
            DirectoryMap directoryMap = distributionTargets.iterator().next().getDirectoryMap();
            Set<ComponentReference> installedCompRefs = featureHome.getInstalledComponents();
            for (ComponentReference compRef : compRefs) {
                if (!installedCompRefs.contains((Object)compRef)) continue;
                Component comp = ComponentHelper.getInstance().getComponent(featureHome.getMetaDataHome(), compRef, Mode.DEINSTALL);
                Collection<ComponentTarget> targets = FeatureSetHelper.getInstance().getComponentTargets(Mode.DEINSTALL, comp, directoryMap, serviceHolder);
                comp.setComponentTargets(targets);
                comps.add(comp);
            }
            this._metadataCache.put(feature, comps);
            return comps;
        }
        return null;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return this.getFeatureSets();
    }

    @Override
    public Distribution getDistribution() {
        return null;
    }

    @Override
    public ServiceHolder getServiceHolder() {
        return null;
    }

    public void addMetadataCache(Map<FeatureSet, Collection<Component>> metadataCache) {
        this._metadataCache.putAll(metadataCache);
    }
}

