/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FeatureCompatibility;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dependency.FeatureSelectionConflictException;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.external.FederatedRelationship;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.helpers.HomeHelper;
import com.oracle.cie.gdr.utils.DistributionCompatibilityException;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.InstallationValidationException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallationValidator {
    private static final Logger _log = Logger.getLogger(InstallationValidator.class.getName());
    private DistributionTarget _distributionTarget;
    private DistributionInfo _distributionInfo;
    private Set<FeatureSet> _selectedFeatures;
    private Home _home;
    private ComponentLoader _componentLoader;
    private DirectoryMap _directoryMap;

    public InstallationValidator(DistributionLoader distributionLoader, Set<FeatureSet> selectedFeatures) {
        this(distributionLoader, selectedFeatures, null);
    }

    public InstallationValidator(DistributionLoader distributionLoader, Set<FeatureSet> selectedFeatures, Home home) {
        this(distributionLoader != null ? distributionLoader.getDistributionTarget() : null, selectedFeatures, home);
    }

    public InstallationValidator(DistributionTarget distributionTarget, Set<FeatureSet> selectedFeatures, Home home) {
        this(distributionTarget, selectedFeatures, null, home);
    }

    public InstallationValidator(DistributionTarget distributionTarget, Set<FeatureSet> selectedFeatures, ComponentLoader componentLoader, Home home) {
        this(distributionTarget, null, selectedFeatures, componentLoader, null, home);
    }

    public InstallationValidator(DistributionTarget distributionTarget, DistributionInfo distributionInfo, Set<FeatureSet> selectedFeatures, ComponentLoader componentLoader, DirectoryMap directoryMap, Home home) {
        this._distributionTarget = distributionTarget;
        this._distributionInfo = distributionInfo;
        this._selectedFeatures = selectedFeatures;
        this._componentLoader = componentLoader;
        this._directoryMap = directoryMap;
        this._home = home;
    }

    public DistributionTarget getDistributionTarget() {
        return this._distributionTarget;
    }

    public DistributionInfo getDistributionInfo() {
        return this._distributionInfo;
    }

    public Set<FeatureSet> getSelectedFeatures() {
        return this._selectedFeatures;
    }

    public Home getHome() {
        return this._home;
    }

    public static void validate(DistributionTarget distributionTarget, Set<FeatureSet> selectedFeatures, ComponentLoader componentLoader, Home home) throws DependencyException, DistributionCompatibilityException, InstallationValidationException {
        InstallationValidator.validate(distributionTarget, null, selectedFeatures, componentLoader, null, home);
    }

    public static void validate(DistributionTarget distributionTarget, DistributionInfo distributionInfo, Set<FeatureSet> selectedFeatures, ComponentLoader componentLoader, DirectoryMap directoryMap, Home home) throws DependencyException, DistributionCompatibilityException, InstallationValidationException {
        new InstallationValidator(distributionTarget, distributionInfo, selectedFeatures, componentLoader, directoryMap, home).validate();
    }

    public void validate() throws DependencyException, DistributionCompatibilityException, InstallationValidationException {
        if (this.getDistributionTarget() == null) {
            InstallationValidationException ex = new InstallationValidationException("The distribution target provided was null.");
            _log.throwing(InstallationValidator.class.getName(), "validate", (Throwable)((Object)ex));
            throw ex;
        }
        Set<FeatureSet> selectedFeatures = this.getSelectedFeatures();
        if (selectedFeatures == null || selectedFeatures.isEmpty()) {
            InstallationValidationException ex = new InstallationValidationException("No feature sets were selected for installation.");
            _log.throwing(InstallationValidator.class.getName(), "validate", (Throwable)((Object)ex));
            throw ex;
        }
        this.validateFederatedHomes();
        this.validateDependencies();
        this.validateInstallation();
    }

    public Set<FeatureSet> getInstalledFeatureSets(boolean federated) throws InstallationValidationException {
        HashSet<FeatureSet> installedFeatures = null;
        Collection<DistributionTarget> installedDistributions = this.getInstalledDistributions(federated);
        if (installedDistributions != null) {
            installedFeatures = new HashSet<FeatureSet>();
            for (DistributionTarget distributionTarget : installedDistributions) {
                installedFeatures.addAll(this.getInstalledFeatureSets(distributionTarget, federated));
            }
        }
        return installedFeatures;
    }

    public Set<FeatureSet> getInstalledFeatureSets(DistributionTarget distributionTarget, boolean federated) throws InstallationValidationException {
        Set<FeatureSet> installedFeatures = null;
        if (distributionTarget != null) {
            installedFeatures = distributionTarget.getInstalledFeatureSets();
            Home home = this.getHome();
            if (home != null && home.isFederatedHome() && federated && !home.getChainedFederatedHomes(false).isEmpty()) {
                try {
                    installedFeatures.addAll(HomeHelper.getFederatedFeatureDependencies(home, installedFeatures));
                }
                catch (Exception e) {
                    throw new InstallationValidationException(e);
                }
            }
        }
        return installedFeatures;
    }

    public Collection<DistributionTarget> getInstalledDistributions(boolean federated) throws InstallationValidationException {
        try {
            Home home = this.getHome();
            if (home != null) {
                return federated ? home.getFederatedInstalledDistributions(FederatedRelationship.CHAINED_DEPENDENCY) : home.getInstalledDistributions();
            }
        }
        catch (Exception e) {
            throw new InstallationValidationException(e);
        }
        return null;
    }

    public void validateFederatedHomes() throws InstallationValidationException {
        Path homeParentDir;
        Home home = this.getHome();
        if (home != null && home.isFederatedHome() && (homeParentDir = this.getHomeParentPath(home)) != null) {
            Collection productFamilies = null;
            DistributionInfo distributionInfo = this.getDistributionInfo();
            if (distributionInfo != null) {
                productFamilies = DistributionInfoHelper.getInstance((ClassLoader)home.getClassLoader()).getProductFamilies(distributionInfo);
            }
            for (Home federatedHome : home.getAllFederatedHomes(false)) {
                Path federatedHomeParentDir = this.getHomeParentPath(federatedHome);
                if (federatedHomeParentDir == null || !federatedHomeParentDir.equals(homeParentDir)) {
                    InstallationValidationException ex = new InstallationValidationException("The home \"" + home + "\" does not share the same parent directory as the federated home \"" + federatedHome + "\"");
                    _log.throwing(InstallationValidator.class.getName(), "validateFederatedHomes", (Throwable)((Object)ex));
                    throw ex;
                }
                if (productFamilies == null || productFamilies.isEmpty()) continue;
                Collection<String> federatedFamilies = federatedHome.getProductFamilies();
                for (String productFamily : productFamilies) {
                    if (!federatedFamilies.contains(productFamily)) continue;
                    InstallationValidationException ex = new InstallationValidationException("The federated home \"" + federatedHome + "\" already contains the product family \"" + productFamily + "\" which is also a product family defined in the distribution \"" + this.getDistributionTarget() + "\" currently being installed at " + home);
                    _log.throwing(InstallationValidator.class.getName(), "validateFederatedHomes", (Throwable)((Object)ex));
                    throw ex;
                }
            }
        }
    }

    private Path getHomeParentPath(Home home) throws InstallationValidationException {
        try {
            return home.getHomeParent();
        }
        catch (IOException e) {
            InstallationValidationException ex = new InstallationValidationException("Failed to resolve parent directory for home: " + home, e);
            _log.throwing(InstallationValidator.class.getName(), "getHomeParent", (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void validateDependencies() throws DependencyException, InstallationValidationException {
        this.validateDependencies(this.getInstalledFeatureSets(true));
    }

    public void validatePackagingDependencies() throws DependencyException, InstallationValidationException {
        this.validateDependencies(null);
    }

    private void validateDependencies(Set<FeatureSet> installedFeatures) throws DependencyException, InstallationValidationException {
        FeatureSelectionTarget selectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(this.getSelectedFeatures(), installedFeatures);
        List ordered = selectionTarget.getOrderedItems();
        for (FeatureSet feature : ordered) {
            if (selectionTarget.isInstalled(feature) || selectionTarget.isSelected(feature)) continue;
            try {
                selectionTarget.selectWithPrerequisites(feature, true);
            }
            catch (FeatureSelectionConflictException fsce) {
                if (installedFeatures == null) {
                    selectionTarget.unselectAll();
                    selectionTarget.selectWithPrerequisites(feature, true);
                    continue;
                }
                throw fsce;
            }
        }
    }

    public void validatePackage() throws DistributionCompatibilityException {
        DistributionTarget distTarget = this.getDistributionTarget();
        HashMap<DistributionTarget, Collection<FeatureCompatibility>> incompatible = new HashMap<DistributionTarget, Collection<FeatureCompatibility>>();
        Collection<FeatureCompatibility> features = this.getIncompatibleFeatures(distTarget.getFeatureSets(), distTarget.getFeatureSets(), Mode.PACKAGE_SHIPHOME);
        if (features != null && !features.isEmpty()) {
            incompatible.put(distTarget, features);
        }
        if (!incompatible.isEmpty()) {
            DistributionCompatibilityException ex = new DistributionCompatibilityException(distTarget, incompatible);
            _log.throwing(InstallationValidator.class.getName(), "validatePackage", (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void validateInstallation() throws DistributionCompatibilityException, InstallationValidationException {
        this.validateFeatureCompatibility();
        try {
            this.validateComponents();
        }
        catch (InstallationValidationException e) {
            throw e;
        }
        catch (GdrException e) {
            throw new InstallationValidationException("Failed while attempting to validate components.", e);
        }
        this.validateSomethingToInstall();
    }

    public void validateFeatureCompatibility() throws DistributionCompatibilityException, InstallationValidationException {
        Collection<DistributionTarget> installedDists = this.getInstalledDistributions(false);
        if (installedDists != null && !installedDists.isEmpty()) {
            HashMap<DistributionTarget, Collection<FeatureCompatibility>> incompatible = new HashMap<DistributionTarget, Collection<FeatureCompatibility>>();
            for (DistributionTarget installedDist : installedDists) {
                Collection<FeatureCompatibility> features = this.getIncompatibleFeatures(this.getSelectedFeatures(), this.getInstalledFeatureSets(installedDist, false), Mode.INSTALL);
                if (features == null || features.isEmpty()) continue;
                incompatible.put(installedDist, features);
            }
            if (!incompatible.isEmpty()) {
                DistributionCompatibilityException ex = new DistributionCompatibilityException(this.getDistributionTarget(), incompatible);
                _log.fine(ex.getLogMessage());
                if (Boolean.getBoolean("InstallationValidator.ignore.incompatible.features")) {
                    _log.log(Level.WARNING, "Ignored incompatible features due to system property override.", (Throwable)((Object)ex));
                } else {
                    _log.throwing(InstallationValidator.class.getName(), "validateFeatureCompatibility", (Throwable)((Object)ex));
                    throw ex;
                }
            }
        }
    }

    public void validateSomethingToInstall() throws InstallationValidationException {
        Set<FeatureSet> selectedFeatures = this.getSelectedFeatures();
        if (selectedFeatures == null) {
            InstallationValidationException ex = new InstallationValidationException("The selected features provided was null.");
            _log.throwing(InstallationValidator.class.getName(), "validateSomethingToInstall", (Throwable)((Object)ex));
            throw ex;
        }
        boolean featureNotInstalled = false;
        for (FeatureSet feature : selectedFeatures) {
            if (feature.isFullyInstalled()) continue;
            featureNotInstalled = true;
            break;
        }
        if (!featureNotInstalled) {
            InstallationValidationException ex = new InstallationValidationException("All of feature sets selected for installation and their components have already been installed for the distribution " + this.getDistributionTarget().getDistribution() + " in the home directory " + this.getHome());
            _log.throwing(InstallationValidator.class.getName(), "validateSomethingToInstall", (Throwable)((Object)ex));
            throw ex;
        }
    }

    private Collection<FeatureCompatibility> getIncompatibleFeatures(Set<FeatureSet> selectedFeatures, Set<FeatureSet> targetFeatures, Mode mode) {
        ArrayList<FeatureCompatibility> incompatible = new ArrayList<FeatureCompatibility>();
        for (FeatureSet feature : selectedFeatures) {
            for (FeatureSet targetFeature : targetFeatures) {
                FeatureCompatibility fc;
                if (feature.equals(targetFeature) || (fc = new FeatureCompatibility(feature, targetFeature, mode)).isCompatible()) continue;
                incompatible.add(fc);
            }
        }
        return incompatible;
    }

    public void validateComponents() throws GdrException {
        if (this._componentLoader == null) {
            return;
        }
        Collection<DistributionTarget> installedDistTargets = this.getInstalledDistributions(false);
        if (installedDistTargets == null || installedDistTargets.isEmpty()) {
            return;
        }
        Set<Component> selectedComponents = this.getSelectedComponents();
        DirectoryMap dirMap = this._directoryMap != null ? this._directoryMap : this.getDistributionTarget().getDirectoryMap();
        for (Component component : selectedComponents) {
            List<FileMap> fileMaps = component.getFileMaps();
            if (fileMaps == null || fileMaps.isEmpty()) continue;
            boolean replicable = component.isReplicable();
            for (FileMap fileMap : fileMaps) {
                InstallationValidationException ex;
                String symbol = fileMap.getSymbol();
                Collection<String> compRootDirs = DistributionHelper.getInstance().getRootDirsForSymbol(dirMap, symbol);
                if (compRootDirs == null || compRootDirs.isEmpty()) {
                    ex = new InstallationValidationException("Unable to locate directory mapping for component. component: [" + component + " symbol: [" + symbol + "] distribution: [" + this.getDistributionTarget() + "]");
                    _log.throwing(InstallationValidator.class.getName(), "validateComponents", (Throwable)((Object)ex));
                    throw ex;
                }
                if (compRootDirs.size() > 1 && !replicable) {
                    ex = new InstallationValidationException("Component which is not replicable has symbol mapped to multiple directories. component: [" + component + "] symbol: [" + symbol + "] distribution: [" + this.getDistributionTarget() + "]");
                    _log.throwing(InstallationValidator.class.getName(), "validateComponents", (Throwable)((Object)ex));
                    throw ex;
                }
                ComponentReference componentReference = new ComponentReference(component.getName(), component.getVersion());
                for (DistributionTarget distTarget : installedDistTargets) {
                    Set<ComponentReference> installedDistComps = distTarget.getInstalledComponents();
                    if (!installedDistComps.contains((Object)componentReference)) continue;
                    DirectoryMap installedDirMap = distTarget.getDirectoryMap();
                    Collection<String> installedCompRootDirs = DistributionHelper.getInstance().getRootDirsForSymbol(installedDirMap, symbol);
                    if (installedCompRootDirs == null || installedCompRootDirs.isEmpty()) {
                        InstallationValidationException ex2 = new InstallationValidationException("Unable to locate directory mapping for component. component: [" + component + " symbol: [" + symbol + "] distribution: [" + distTarget + "]");
                        _log.throwing(InstallationValidator.class.getName(), "validateComponents", (Throwable)((Object)ex2));
                        throw ex2;
                    }
                    if (compRootDirs.size() > 1 && !replicable) {
                        InstallationValidationException ex3 = new InstallationValidationException("Component which is not replicable has symbol mapped to multiple directories. component: [" + component + "] symbol: [" + symbol + "] distribution: [" + distTarget + "]");
                        _log.throwing(InstallationValidator.class.getName(), "validateComponents", (Throwable)((Object)ex3));
                        throw ex3;
                    }
                    if (replicable || installedCompRootDirs.containsAll(compRootDirs)) continue;
                    InstallationValidationException ex4 = new InstallationValidationException("Component which is not replicable has symbol mapped to multiple directories in different distributions. component: [" + component + "] symbol: [" + symbol + "] distribution: [" + this.getDistributionTarget() + "] conflicting distribution: [" + distTarget + "]");
                    _log.throwing(InstallationValidator.class.getName(), "validateComponents", (Throwable)((Object)ex4));
                    throw ex4;
                }
            }
        }
    }

    public void validateLanguages() {
        _log.info("Validating components languages");
        if (this._selectedFeatures == null) {
            return;
        }
        Set<Component> comps = this.getSelectedComponents();
        HashSet<String> allLangs = new HashSet<String>();
        for (Component c : comps) {
            List<FileMap> fileMaps = c.getFileMaps();
            for (FileMap f : fileMaps) {
                Set<String> locs = f.getLocales();
                Iterator<Object> iterator = locs.iterator();
                while (iterator.hasNext()) {
                    String l = iterator.next();
                    allLangs.add(l.toLowerCase());
                }
            }
            if (c.getComponentExtensions() == null) continue;
            for (Component e : c.getComponentExtensions()) {
                fileMaps = e.getFileMaps();
                for (FileMap f : fileMaps) {
                    Set<String> locs = f.getLocales();
                    Iterator iterator = locs.iterator();
                    while (iterator.hasNext()) {
                        String l = (String)iterator.next();
                        allLangs.add(l.toLowerCase());
                    }
                }
            }
        }
        for (Component c : comps) {
            HashSet<String> compLangs = new HashSet<String>();
            List<FileMap> fileMaps = c.getFileMaps();
            for (FileMap f : fileMaps) {
                Set<String> locs = f.getLocales();
                for (String l : locs) {
                    compLangs.add(l.toLowerCase());
                }
            }
            if (c.getComponentExtensions() != null) {
                for (Component e : c.getComponentExtensions()) {
                    fileMaps = e.getFileMaps();
                    for (FileMap f : fileMaps) {
                        Set<String> locs = f.getLocales();
                        for (String l : locs) {
                            compLangs.add(l.toLowerCase());
                        }
                    }
                }
            }
            for (String l : allLangs) {
                if (compLangs.contains(l)) continue;
                _log.fine("The component " + c.getName() + " does not contains language definition for " + l);
            }
        }
    }

    public Set<Component> getSelectedComponents() {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        if (this._componentLoader == null) {
            return components;
        }
        Set<FeatureSet> features = this.getSelectedFeatures();
        for (FeatureSet feature : features) {
            Set<Component> comps;
            if (feature.isFullyInstalled() || (comps = this._componentLoader.getComponents(feature)) == null || comps.isEmpty()) continue;
            for (Component comp : comps) {
                if (comp.isFullyInstalled()) continue;
                components.add(comp);
            }
        }
        return components;
    }
}

