/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.dao.rvd.ReleaseVersionDef;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class ReleaseVersionHelper
extends GdrHelper<ReleaseVersionDef> {
    private static final Logger _log = Logger.getLogger(ReleaseVersionHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/rvd";
    public static final String RELEASE_VERSION = "release-version-def";
    public static final String RELEASE_VERSION_DIR = "version";
    private static final String RELEASE_VERSION_FILE_NAME = "release-version";
    private static ReleaseVersionHelper _instance;

    public static ReleaseVersionHelper getInstance() {
        if (_instance == null) {
            _instance = new ReleaseVersionHelper(null);
        }
        return _instance;
    }

    public static ReleaseVersionHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return ReleaseVersionHelper.getInstance();
        }
        return new ReleaseVersionHelper(classLoader);
    }

    private ReleaseVersionHelper(ClassLoader classLoader) {
        super(ReleaseVersionDef.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getPath() {
        return RELEASE_VERSION_DIR;
    }

    public String getRootElement() {
        return RELEASE_VERSION;
    }

    public String getReleaseVersionFileName(String version) {
        return "release-version_" + version + ".xml";
    }

    public File getReleaseVersionFile(File metadataHome, String name, String version) throws FileNotFoundException {
        return this.getFileLocatorService(metadataHome).getFile(this.getPath(), this.getReleaseVersionFileName(version));
    }

    public List<File> getReleaseVersionFiles(File metaDataDir) {
        ArrayList<File> files = new ArrayList<File>();
        if (metaDataDir != null && metaDataDir.isDirectory()) {
            files.addAll(this.getFileLocatorService(metaDataDir).getFilesUnderPath(this.getPath()));
            Iterator it = files.iterator();
            while (it.hasNext()) {
                File f = (File)it.next();
                if (f.isFile() && f.getName().endsWith(".xml")) continue;
                it.remove();
            }
        }
        return files;
    }

    public ReleaseVersionDef getReleaseVersion(File releaseVersionFile) throws IOException, DataHandlerException, GdrException {
        ReleaseVersionDef releaseVersion = null;
        if (releaseVersionFile == null) {
            GdrException ex = new GdrException("The release-version file provided was null.");
            _log.throwing(ReleaseVersionHelper.class.getName(), "getReleaseVersion", ex);
            throw ex;
        }
        releaseVersion = (ReleaseVersionDef)this.getRootWrapper(releaseVersionFile);
        return releaseVersion;
    }

    public static void main(String[] args) throws IOException, DataHandlerException {
        ReleaseVersionHelper.getInstance().getRootWrapper(new File("D:\\ade\\depot\\src\\repository\\1.2\\dev-install\\src\\test\\carbstager\\localRepo\\com\\oracle\\cie\\gdr\\version\\release-version-def\\12.1.4.0.0-140919.1900\\release-version-def-12.1.4.0.0-140919.1900.xml"));
    }
}

