/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.ZipHelper;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.carbdiff.CarbDiffGenerator;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.pch.BugList;
import com.oracle.cie.gdr.dao.pch.Patch;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.helpers.PatchAttachmentInfoHelper;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.patch.MetadataPatchGenerator;
import com.oracle.cie.gdr.services.VariableResolverService;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.MaintenanceAliasUtils;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class PatchHelper
extends GdrHelper<Patch> {
    private static final Logger _log = Logger.getLogger(PatchHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/pch";
    public static final String PATCH_DEF = "patch-def";
    public static final String PATCHES_DIR = "patches";
    private static PatchHelper _instance;

    public static PatchHelper getInstance() {
        if (_instance == null) {
            _instance = new PatchHelper(null);
        }
        return _instance;
    }

    public static PatchHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return PatchHelper.getInstance();
        }
        return new PatchHelper(classLoader);
    }

    private PatchHelper(ClassLoader classLoader) {
        super(Patch.class, classLoader);
    }

    public Patch createPatch(String patchName, Set<Reference> compRefs) {
        Patch patch = new Patch(patchName);
        ArrayList<ComponentReference> refs = new ArrayList<ComponentReference>();
        for (Reference ref : compRefs) {
            if (refs.contains((Object)ref)) continue;
            refs.add(new ComponentReference(ref.getName(), ref.getVersion()));
        }
        patch.setComponents(refs);
        return patch;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return PATCH_DEF;
    }

    public String getPath() {
        return PATCHES_DIR;
    }

    public Patch getPatch(File patchFile) throws IOException, DataHandlerException, GdrException {
        return this.getPatch(NioHelper.getInstance().getPath(patchFile));
    }

    public Patch getPatch(Path patchPath) throws IOException, DataHandlerException, GdrException {
        Patch patch = null;
        if (patchPath != null) {
            patch = (Patch)this.getRootWrapper(patchPath);
            if (patch.getPatchId() == null || patch.getUniquePatchId() == null) {
                throw new GdrException("The patch id and the unique patch id are required for a patch.");
            }
            if (!patchPath.getFileName().toString().equals(this.getPatchFileName(patch))) {
                GdrException ex = new GdrException("The internal patch id is incorrect.  File name should be: " + this.getPatchFileName(patch) + " File name is: " + patchPath.getFileName());
                _log.throwing(PatchHelper.class.getName(), "getPatch", ex);
                throw ex;
            }
        }
        return patch;
    }

    public String getPatchFileName(Patch patch) {
        return this.getPatchFileName(patch.getPatchId());
    }

    public String getPatchFileName(String patchId) {
        return this.getPatchBaseFileName(patchId) + ".xml";
    }

    public String getPatchBaseFileName(String patchId) {
        return patchId;
    }

    public List<File> getPatchFiles(File metaDataDir) {
        List<Path> paths = this.getPatchPaths(NioHelper.getInstance().getPath(metaDataDir));
        ArrayList<File> files = new ArrayList<File>();
        for (Path path : paths) {
            files.add(path.toFile());
        }
        return files;
    }

    public List<Path> getPatchPaths(Path metaDataDir) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (metaDataDir != null && Files.isDirectory(metaDataDir, new LinkOption[0])) {
            paths.addAll(this.getFileLocatorService(metaDataDir).getPathsUnderPath(this.getPath()));
        }
        return paths;
    }

    public Set<Patch> getPatches(File metaDataDir) throws IOException, DataHandlerException, GdrException {
        return this.getPatches(NioHelper.getInstance().getPath(metaDataDir));
    }

    public Set<Patch> getPatches(Path metaDataDir) throws IOException, DataHandlerException, GdrException {
        LinkedHashSet<Patch> patches = new LinkedHashSet<Patch>();
        if (metaDataDir != null && Files.isDirectory(metaDataDir, new LinkOption[0])) {
            for (Path path : this.getPatchPaths(metaDataDir)) {
                patches.add(this.getPatch(path));
            }
        }
        return patches;
    }

    public void save(Patch dao, File file) throws DataHandlerException {
        this.save(dao, NioHelper.getInstance().getPath(file));
    }

    public void save(Patch dao, Path path) throws DataHandlerException {
        if (dao.getPatchId() == null || dao.getUniquePatchId() == null) {
            throw new DataHandlerException("The Patch Id and the Unique Patch Id are required for saving a patch.");
        }
        this.save(dao.getDataHandler(), path);
    }

    public void updatePatchDetails(String oracleHomeDir, String componentName, String componentVersion, String uniquePatchId, String patchId, Set<String> bugs, Boolean rollbackable) throws GdrException, IOException, DataHandlerException {
        Home home = Home.getHome(NioHelper.getInstance().getPath(oracleHomeDir, new String[0]));
        File patchFile = new File(new File(home.getInventoryDirectory(), PATCHES_DIR), this.getPatchFileName(patchId));
        Patch patch = this.createPatch(patchFile, componentName, componentVersion, uniquePatchId, patchId, bugs, rollbackable);
        RegistryHelper.getInstance(this.getClassLoader()).updatePatch(home, componentName, componentVersion, patch);
    }

    private Patch createPatch(File patchFile, String componentName, String componentVersion, String uniquePatchId, String patchId, Set<String> bugs, Boolean rollbackable) throws IOException, DataHandlerException, GdrException {
        ComponentReference compRef = new ComponentReference(componentName, componentVersion);
        Patch patch = null;
        BugList bugList = new BugList();
        if (patchFile.exists()) {
            patch = this.getPatch(patchFile);
            List<ComponentReference> components = patch.getComponents();
            if (!components.contains((Object)compRef)) {
                components.add(compRef);
                patch.setComponents(components);
            }
            bugs.addAll(Arrays.asList(patch.getBugList().getBugs()));
        } else {
            patch = new Patch(patchId);
            ArrayList<ComponentReference> refs = new ArrayList<ComponentReference>();
            refs.add(compRef);
            patch.setComponents(refs);
            patch.setUniquePatchId(uniquePatchId);
        }
        bugList.setBugs(bugs.toArray(new String[0]));
        patch.setBugList(bugList);
        patch.setInstallDate(Calendar.getInstance());
        patch.setRollbackable(rollbackable);
        this.save(patch, patchFile);
        return patch;
    }

    public void copyPatches(String patchesLocation, File destDir) throws GdrException {
        File patchesLocFile = null;
        if (!StringUtil.isNullOrEmpty((String)patchesLocation)) {
            String[] patches;
            patchesLocFile = new File(patchesLocation);
            if (!patchesLocFile.isDirectory() || patchesLocFile.isFile()) {
                GdrException ex = new GdrException("The patch attachment directory " + patchesLocFile + " is invalid or does not exist.");
                _log.throwing(PatchAttachmentInfoHelper.class.getName(), "init", ex);
                throw ex;
            }
            for (String patch : patches = patchesLocFile.list()) {
                try {
                    File patchZipFile = new File(patchesLocation, patch);
                    if (!ZipHelper.isZipFile((File)patchZipFile)) continue;
                    FileCopy.copy((File)patchZipFile, (File)new File(destDir, patch), (boolean)true);
                }
                catch (IOException e) {
                    GdrException ex = new GdrException("There was a problem while copying patch:  " + patch + " from location: " + patchesLocation, (Throwable)e);
                    _log.throwing(PatchAttachmentInfoHelper.class.getName(), "copyPatches", ex);
                    throw ex;
                }
            }
        }
    }

    public void extractPatches(File patchesLocation, File destDir) throws GdrException {
        String[] patches = patchesLocation.list();
        if (patches != null) {
            for (String patch : patches) {
                File patchZipFile = new File(patchesLocation, patch);
                this.extractPatch(patchZipFile, destDir);
            }
        }
        this.extractPatches(patchesLocation, destDir, false);
    }

    public List<File> extractPatches(File patchesLocation, File destDir, boolean createParentDirectory) throws GdrException {
        ArrayList<File> patches = new ArrayList<File>();
        for (String patch : patchesLocation.list()) {
            File patchDestDir = destDir;
            if (createParentDirectory) {
                patchDestDir = new File(destDir, patch.substring(0, patch.length() - 4));
            }
            File patchZipFile = new File(patchesLocation, patch);
            patchDestDir.mkdirs();
            this.extractPatch(patchZipFile, patchDestDir);
            patches.add(patchDestDir);
        }
        return patches;
    }

    public void extractPatch(File patchZipFile, File destDir) throws GdrException {
        try {
            if (ZipHelper.isZipFile((File)patchZipFile)) {
                ZipHelper.unzip((File)patchZipFile, (File)destDir);
            }
        }
        catch (IOException e) {
            GdrException ex = new GdrException("There was a problem while copying patch:  " + patchZipFile.getPath() + " from location: " + destDir.getPath(), (Throwable)e);
            _log.throwing(PatchAttachmentInfoHelper.class.getName(), "extractPatches", ex);
            throw ex;
        }
    }

    public boolean containsPatches(File patchesLocation) throws GdrException {
        if (patchesLocation.exists()) {
            String[] patches = patchesLocation.list();
            if (patches != null) {
                for (String patch : patches) {
                    try {
                        File patchZipFile = new File(patchesLocation, patch);
                        if (!ZipHelper.isZipFile((File)patchZipFile)) continue;
                        return true;
                    }
                    catch (IOException e) {
                        GdrException ex = new GdrException("There was a problem while reading patch:  " + patch + " from location: " + patchesLocation.getPath(), (Throwable)e);
                        _log.throwing(PatchAttachmentInfoHelper.class.getName(), "containsPatches", ex);
                        throw ex;
                    }
                }
            }
        } else {
            GdrException ex = new GdrException("The location did not exist:  " + patchesLocation.getPath());
            _log.throwing(PatchAttachmentInfoHelper.class.getName(), "containsPatches", ex);
            throw ex;
        }
        return false;
    }

    public Map<String, String> getPatchLocationMap(File patchesLocation) throws GdrException {
        HashMap<String, String> patchesList = new HashMap<String, String>();
        if (patchesLocation.exists()) {
            for (File patchBugNumberDir : patchesLocation.listFiles()) {
                if (!patchBugNumberDir.isDirectory()) continue;
                String location = "";
                if (!Pattern.matches("\\d+", patchBugNumberDir.getName())) continue;
                try {
                    for (File patchNumberDir : patchBugNumberDir.listFiles()) {
                        if (!(patchNumberDir.isDirectory() & Pattern.matches("\\d+", patchNumberDir.getName()))) continue;
                        try {
                            location = patchNumberDir.getCanonicalPath();
                        }
                        catch (NumberFormatException e) {
                            GdrException ex = new GdrException("There was a problem parsing patch number: " + patchBugNumberDir.getName() + ".", (Throwable)e);
                            _log.throwing(PatchHelper.class.getName(), "getPatchLocationMap", ex);
                            throw ex;
                        }
                    }
                    if (StringUtil.isNullOrEmpty((String)location)) {
                        location = patchBugNumberDir.getCanonicalPath();
                    }
                    patchesList.put(patchBugNumberDir.getName(), location);
                }
                catch (IOException e) {
                    GdrException ex = new GdrException("There was a problem obtaining the canonial path of patch: " + patchBugNumberDir.getName() + ".", (Throwable)e);
                    _log.throwing(PatchHelper.class.getName(), "getPatchLocationMap", ex);
                    throw ex;
                }
            }
        }
        return patchesList;
    }

    public void createMetaDataPatch(Path metadataPatchDir, Path carbDiffOutputDir, Map<String, String> bugs, VariableResolverService variableResolverService, List<Repository> repos) throws GdrException {
        this.createMetaDataPatch(metadataPatchDir, carbDiffOutputDir, bugs, variableResolverService, repos, null);
    }

    public void createMetaDataPatch(Path metadataPatchDir, Path carbDiffOutputDir, Map<String, String> bugs, VariableResolverService variableResolverService, List<Repository> repos, ClassLoader opackClassLoader) throws GdrException {
        boolean fileListCalculationEnabled = Boolean.parseBoolean(variableResolverService.get("FILE_LIST_CALCULATION"));
        String fileListPAD = variableResolverService.get("FILE_LIST_PAD");
        if (!StringUtil.isNullOrEmpty((String)variableResolverService.get("BUG_LIST"))) {
            File metadaPatch;
            CarbDiffGenerator carbDiffGen = null;
            if (fileListCalculationEnabled && !StringUtil.isNullOrEmpty((String)fileListPAD)) {
                carbDiffGen = new CarbDiffGenerator(fileListPAD, Boolean.parseBoolean(variableResolverService.get("FILE_LIST_PAD_USE_LATEST")));
                carbDiffGen.setDestination(carbDiffOutputDir.toFile());
                if (repos != null && !repos.isEmpty()) {
                    carbDiffGen.addRepos(repos);
                } else {
                    repos = new ArrayList<Repository>();
                    repos.add(RestFactory.getRepository(null, (String)variableResolverService.get("repoURL"), null, null));
                    carbDiffGen.addRepos(repos);
                }
                carbDiffGen.diff();
                if (carbDiffGen.getCarbDiffList().isEmpty()) {
                    return;
                }
            }
            String maintenanceAliasMappings = variableResolverService.get(MaintenanceAliasUtils.MAINTENANCE_ALIAS_MAPPING_PROPERTY);
            String maintenanceAlias = variableResolverService.get(MaintenanceAliasUtils.MAINTENANCE_ALIAS_PROPERTY);
            if (!StringUtil.isNullOrEmpty((String)maintenanceAlias)) {
                if (StringUtil.isNullOrEmpty((String)maintenanceAliasMappings)) {
                    _log.warning(MaintenanceAliasUtils.MAINTENANCE_ALIAS_MAPPING_PROPERTY + " information was not specified.");
                    return;
                }
            } else {
                _log.finest(MaintenanceAliasUtils.MAINTENANCE_ALIAS_PROPERTY + " information was not specified.");
            }
            if (!Files.exists(metadataPatchDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(metadataPatchDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new GdrException("Failed to create directory: " + metadataPatchDir, (Throwable)e);
                }
            }
            if ((metadaPatch = MetadataPatchGenerator.getInstance(opackClassLoader).createMetaDataPatch(metadataPatchDir.toFile(), bugs, carbDiffGen, maintenanceAlias, maintenanceAliasMappings)).exists()) {
                _log.finest("This shiphome contains a metadata patch located in: " + metadaPatch.getPath());
            } else {
                try {
                    Files.delete(metadataPatchDir);
                }
                catch (IOException e) {
                    _log.log(Level.FINE, "Failed to delete directory: " + metadataPatchDir, e);
                }
            }
        } else if (fileListCalculationEnabled && StringUtil.isNullOrEmpty((String)fileListPAD)) {
            _log.warning("The option FILE_LIST_PAD can not be used without option BUG_LIST");
        } else {
            _log.finest("Metadata patch was not generated because BUG_LIST was not specified.");
        }
    }
}

