/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.mns.Component;
import com.oracle.cie.gdr.dao.mns.Distribution;
import com.oracle.cie.gdr.dao.mns.FeatureSet;
import com.oracle.cie.gdr.dao.mns.MaintenanceSet;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class MaintenanceSetHelper
extends GdrHelper<MaintenanceSet> {
    private static final Logger _log = Logger.getLogger(MaintenanceSetHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/patchgen/maintenance-set";
    public static final String MAINTENANCE_SET = "maintenance-set";
    public static final String MAINTENANCE_SET_DIR = "maintenance-sets";
    private static MaintenanceSetHelper _instance;

    public static MaintenanceSetHelper getInstance() {
        if (_instance == null) {
            _instance = new MaintenanceSetHelper(null);
        }
        return _instance;
    }

    public static MaintenanceSetHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return MaintenanceSetHelper.getInstance();
        }
        return new MaintenanceSetHelper(classLoader);
    }

    private MaintenanceSetHelper(ClassLoader classLoader) {
        super(MaintenanceSet.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return MAINTENANCE_SET;
    }

    public String getMaintenanceSetXmlFileName(MaintenanceSet maintenanceSet) {
        return this.getMaintenanceSetFileName(maintenanceSet.getName(), maintenanceSet.getVersion(), "xml");
    }

    public String getMaintenanceSetJsonFileName(MaintenanceSet maintenanceSet) {
        return this.getMaintenanceSetFileName(maintenanceSet.getName(), maintenanceSet.getVersion(), "json");
    }

    public String getMaintenanceSetFileName(String name, String version, String extension) {
        return MaintenanceSetHelper.getFormattedNameVersion(name, version) + "." + extension;
    }

    public MaintenanceSet createMaintenanceSet(String name, String version, String distributions, String featureSets, String components) throws GdrException {
        NameVersionHolder nameVersion;
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            GdrException ex = new GdrException("The maintenance set name is required.");
            _log.throwing(MaintenanceSetHelper.class.getName(), "createMaintenanceSet", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            GdrException ex = new GdrException("The maintenance set version is required.");
            _log.throwing(MaintenanceSetHelper.class.getName(), "createMaintenanceSet", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)components, (boolean)true)) {
            GdrException ex = new GdrException("The maintenance set components are required.");
            _log.throwing(MaintenanceSetHelper.class.getName(), "createMaintenanceSet", ex);
            throw ex;
        }
        MaintenanceSet maintenanceSet = new MaintenanceSet();
        maintenanceSet.setName(name);
        maintenanceSet.setVersion(version);
        if (!StringUtil.isNullOrEmpty((String)distributions, (boolean)true)) {
            String[] dists;
            ArrayList<Distribution> maintenanceSetDistributions = new ArrayList<Distribution>();
            for (String dist : dists = distributions.split(",")) {
                try {
                    nameVersion = this.parseNameVersion(dist);
                }
                catch (GdrException e) {
                    GdrException ex = new GdrException("The distributions provided were not in the expected format \"name:version,...\" : " + distributions, (Throwable)e);
                    _log.throwing(MaintenanceSetHelper.class.getName(), "createMaintenanceSet", ex);
                    throw ex;
                }
                Distribution maintenanceSetDistribution = new Distribution();
                maintenanceSetDistribution.setName(nameVersion._name);
                maintenanceSetDistribution.setVersion(nameVersion._version);
                maintenanceSetDistributions.add(maintenanceSetDistribution);
            }
            maintenanceSet.setDistributions(maintenanceSetDistributions);
        }
        if (!StringUtil.isNullOrEmpty((String)featureSets, (boolean)true)) {
            String[] ftrs;
            ArrayList<FeatureSet> maintenanceSetFeatureSets = new ArrayList<FeatureSet>();
            for (String ftr : ftrs = featureSets.split(",")) {
                try {
                    nameVersion = this.parseNameVersion(ftr);
                }
                catch (GdrException e) {
                    GdrException ex = new GdrException("The feature sets provided were not in the expected format \"name:version,...\" : " + featureSets, (Throwable)e);
                    _log.throwing(MaintenanceSetHelper.class.getName(), "createMaintenanceSet", ex);
                    throw ex;
                }
                FeatureSet maintenanceSetFeatureSet = new FeatureSet();
                maintenanceSetFeatureSet.setName(nameVersion._name);
                maintenanceSetFeatureSet.setVersion(nameVersion._version);
                maintenanceSetFeatureSets.add(maintenanceSetFeatureSet);
            }
            maintenanceSet.setFeatureSets(maintenanceSetFeatureSets);
        }
        if (!StringUtil.isNullOrEmpty((String)components, (boolean)true)) {
            String[] comps;
            ArrayList<Component> maintenanceSetComponents = new ArrayList<Component>();
            for (String comp : comps = components.split(",")) {
                try {
                    nameVersion = this.parseNameVersion(comp);
                }
                catch (GdrException e) {
                    GdrException ex = new GdrException("The components provided were not in the expected format \"name:version,...\" : " + components, (Throwable)e);
                    _log.throwing(MaintenanceSetHelper.class.getName(), "createMaintenanceSet", ex);
                    throw ex;
                }
                Component maintenanceSetComponent = new Component();
                maintenanceSetComponent.setName(nameVersion._name);
                maintenanceSetComponent.setVersion(nameVersion._version);
                maintenanceSetComponents.add(maintenanceSetComponent);
            }
            maintenanceSet.setComponents(maintenanceSetComponents);
        }
        return maintenanceSet;
    }

    private NameVersionHolder parseNameVersion(String delimitedString) throws GdrException {
        NameVersionHolder result = new NameVersionHolder();
        String[] nameVersion = delimitedString.split(":");
        if (nameVersion.length < 2) {
            GdrException ex = new GdrException("The name:version string provided was not in the expected format : " + delimitedString);
            _log.throwing(DistributionHelper.class.getName(), "parseNameVersion", ex);
            throw ex;
        }
        if (nameVersion[1].contains("-")) {
            GdrException ex = new GdrException("The name:version string provided was not in the expected format : " + delimitedString);
            _log.throwing(DistributionHelper.class.getName(), "parseNameVersion", ex);
            throw ex;
        }
        result._name = nameVersion[0];
        String[] versionSplit = nameVersion[1].split("\\.");
        if (versionSplit.length != 5) {
            GdrException ex = new GdrException("The version string provided was not the expected length.  Only a 5 position versions may be provided : " + nameVersion[1]);
            _log.throwing(DistributionHelper.class.getName(), "parseNameVersion", ex);
            throw ex;
        }
        result._version = nameVersion[1];
        return result;
    }

    public MaintenanceSetKey getMaintenanceSetKey(String name, String version) {
        return new MaintenanceSetKey(name, version);
    }

    public String getPath() {
        return MAINTENANCE_SET_DIR;
    }

    class NameVersionHolder {
        String _name;
        String _version;

        NameVersionHolder() {
        }
    }

    public class MaintenanceSetKey {
        String _name;
        String _version;

        public MaintenanceSetKey(String name, String version) {
            this._name = name;
            this._version = version;
        }

        public String getName() {
            return this._name;
        }

        public String getVersion() {
            return this._version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MaintenanceSetKey that = (MaintenanceSetKey)o;
            return this._name.equals(that._name) && this._version.equals(that._version);
        }

        public int hashCode() {
            int result = this._name.hashCode();
            result = 31 * result + this._version.hashCode();
            return result;
        }

        public String toString() {
            return this._name + "_" + this._version;
        }
    }
}

