/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.dao.tree.TreeDataHandlerSpiImpl;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.VersionHelper;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfoHolder;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.dbd.InstallType;
import com.oracle.cie.gdr.dao.dbd.Mapping;
import com.oracle.cie.gdr.dao.dbd.MappingSymbol;
import com.oracle.cie.gdr.dao.dbd.RootMapping;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.external.InstallerConfig;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.OuiConstants;
import com.oracle.cie.nextgen.common.inputs.dao.variables.VariableDao;
import com.oracle.cie.nextgen.common.inputs.impl.InputHandlerException;
import com.oracle.cie.nextgen.common.inputs.parser.VariablesParser;
import com.oracle.cie.rest.Repository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DistributionHelper
extends GdrHelper<Distribution> {
    private static final Logger _log = Logger.getLogger(DistributionHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/dbd";
    public static final String DISTRIBUTION = "distribution";
    public static final String DISTRIBUTIONS_DIR = "distributions";
    public static final String DISTRIBUTIONS_PATCHES_UPGRADES_DIR = "upgrades";
    public static final String DEFAULT_INSTALL_TYPE = "Typical";
    private static DistributionHelper _instance;

    public static DistributionHelper getInstance() {
        if (_instance == null) {
            _instance = new DistributionHelper(null);
        }
        return _instance;
    }

    public static DistributionHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return DistributionHelper.getInstance();
        }
        return new DistributionHelper(classLoader);
    }

    private DistributionHelper(ClassLoader classLoader) {
        super(Distribution.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return DISTRIBUTION;
    }

    public String getPath() {
        return DISTRIBUTIONS_DIR;
    }

    public String getRepositoryPath() {
        return DISTRIBUTION;
    }

    public String getDistributionFileName(Distribution distribution) {
        return this.getDistributionFileName(distribution.getName(), distribution.getVersion());
    }

    public String getDistributionFileName(String name, String version) {
        return DistributionHelper.getFormattedNameVersion(name, version) + ".xml";
    }

    public Distribution getDistribution(MetaDataHome metaDataHome, String name, String version) throws IOException, DataHandlerException, GdrException {
        if (metaDataHome == null) {
            GdrException ex = new GdrException("The meta-data home provided was null.");
            _log.throwing(DistributionHelper.class.getName(), "getDistribution", ex);
            throw ex;
        }
        if (metaDataHome.isRepository()) {
            return this.getDistributionFromRepository(metaDataHome.getRepositoryService(), name, version);
        }
        return this.getDistribution(metaDataHome.getGdrMetaDataHomePath(), name, version);
    }

    public Distribution getDistribution(File metaDataDir, String name, String version) throws IOException, DataHandlerException, GdrException {
        return this.getDistribution(NioHelper.getInstance().getPath(metaDataDir), name, version);
    }

    public Distribution getDistribution(Path metaDataDir, String name, String version) throws IOException, DataHandlerException, GdrException {
        if (StringUtil.isNullOrEmpty((String)name)) {
            GdrException ex = new GdrException("The distribution name provided was invalid: " + name);
            _log.throwing(DistributionHelper.class.getName(), "getDistribution", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)version)) {
            GdrException ex = new GdrException("The distribution version provided was invalid: " + version);
            _log.throwing(DistributionHelper.class.getName(), "getDistribution", ex);
            throw ex;
        }
        if (metaDataDir == null) {
            GdrException ex = new GdrException("The meta-data directory provided was null.");
            _log.throwing(DistributionHelper.class.getName(), "getDistribution", ex);
            throw ex;
        }
        String distFileName = this.getDistributionFileName(name, version);
        Path distributionFile = this.getFileLocatorService(metaDataDir).getPath(this.getPath(), distFileName);
        return this.getDistribution(distributionFile);
    }

    public List<File> getDistributionFiles(File metaDataDir) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            MetaDataHome metaDataHome = new MetaDataHome(metaDataDir, false);
            files.addAll(this.getDistributionFiles(metaDataHome));
        }
        catch (GdrException e) {
            _log.warning("Error loading metadata directory : " + metaDataDir + ". " + e.getMessage());
        }
        return files;
    }

    public List<Path> getDistributionFiles(Path metaDataDir) {
        ArrayList<Path> files = new ArrayList<Path>();
        try {
            MetaDataHome metaDataHome = new MetaDataHome(metaDataDir, false);
            files.addAll(this.getDistributionFilePaths(metaDataHome));
        }
        catch (GdrException e) {
            _log.warning("Error loading metadata directory : " + metaDataDir + ". " + e.getMessage());
        }
        return files;
    }

    public List<File> getDistributionFiles(MetaDataHome metaDataHome) {
        List<Path> paths = this.getDistributionFilePaths(metaDataHome);
        ArrayList<File> files = new ArrayList<File>();
        for (Path path : paths) {
            files.add(path.toFile());
        }
        return files;
    }

    public List<Path> getDistributionFilePaths(MetaDataHome metaDataHome) {
        ArrayList<Path> files = new ArrayList<Path>();
        Path metaDataDir = metaDataHome.getGdrMetaDataHomePath();
        if (metaDataDir != null && Files.isDirectory(metaDataDir, new LinkOption[0])) {
            if (metaDataHome.isRepository()) {
                files.addAll(this.getFileLocatorService(metaDataDir).getPathsUnderPath(this.getRepositoryPath()));
            } else {
                files.addAll(this.getFileLocatorService(metaDataDir).getPathsUnderPath(this.getPath()));
            }
            if (files.isEmpty()) {
                Path distributionDir = metaDataHome.getGdrMetaDataHomePath().resolve(this.getRepositoryPath());
                if (!Files.isDirectory(distributionDir, new LinkOption[0])) {
                    distributionDir = metaDataHome.getGdrMetaDataHomePath().resolve(this.getPath());
                }
                try (DirectoryStream<Path> distributionDirDS = Files.newDirectoryStream(distributionDir);){
                    for (Path distributionNames : distributionDirDS) {
                        if (Files.isDirectory(distributionNames, new LinkOption[0])) {
                            try {
                                DirectoryStream<Path> distributionNamesDS = Files.newDirectoryStream(distributionNames);
                                try {
                                    for (Path distributionVersions : distributionNamesDS) {
                                        try {
                                            DirectoryStream<Path> distributionVersionsDS = Files.newDirectoryStream(distributionVersions);
                                            try {
                                                for (Path distirbutionVersion : distributionVersionsDS) {
                                                    files.add(distirbutionVersion);
                                                }
                                            }
                                            finally {
                                                if (distributionVersionsDS == null) continue;
                                                distributionVersionsDS.close();
                                            }
                                        }
                                        catch (IOException e) {
                                            _log.warning("Unable to read contents of directory " + distributionVersions);
                                        }
                                    }
                                }
                                finally {
                                    if (distributionNamesDS == null) continue;
                                    distributionNamesDS.close();
                                }
                            }
                            catch (IOException e) {
                                _log.warning("Unable to read contents of directory " + distributionNames);
                            }
                            continue;
                        }
                        files.add(distributionNames);
                    }
                }
                catch (IOException e) {
                    _log.warning("Unable to read contents of directory " + distributionDir);
                }
            }
            Iterator it = files.iterator();
            while (it.hasNext()) {
                Path f = (Path)it.next();
                if (Files.isRegularFile(f, new LinkOption[0]) && f.getFileName().toString().endsWith(".xml")) continue;
                it.remove();
            }
        }
        return files;
    }

    public Distribution getDistribution(File distributionFile) throws IOException, DataHandlerException, GdrException {
        return this.getDistribution(distributionFile, true);
    }

    public Distribution getDistribution(Path distributionFile) throws IOException, DataHandlerException, GdrException {
        return this.getDistribution(distributionFile, true);
    }

    public Distribution getDistribution(File distributionFile, boolean validateFileName) throws IOException, DataHandlerException, GdrException {
        return this.getDistribution(NioHelper.getInstance().getPath(distributionFile), validateFileName);
    }

    public Distribution getDistribution(Path distributionFile, boolean validateFileName) throws IOException, DataHandlerException, GdrException {
        Path metaDataRoot;
        Distribution distribution;
        if (distributionFile != null) {
            distribution = (Distribution)this.getRootWrapper(distributionFile);
            this.validateDistribution(distribution, distributionFile, validateFileName);
            distribution.setDistributionFileLocation(distributionFile);
            metaDataRoot = distributionFile.getParent();
            if (metaDataRoot != null) {
                metaDataRoot = metaDataRoot.getParent();
            }
        } else {
            GdrException ex = new GdrException("The distribution file provided was null.");
            _log.throwing(DistributionHelper.class.getName(), "getDistribution", ex);
            throw ex;
        }
        this.setResourcesBundleInfo((ResourceBundleInfoHolder)distribution, metaDataRoot);
        return distribution;
    }

    public Distribution getDistributionFromRepository(RepositoryService repositoryService, String distributionName, String distributionVersion) throws IOException, DataHandlerException, GdrException {
        Artifact distributionArtifact;
        if (repositoryService == null) {
            GdrException ex = new GdrException("The repository service provided was null.");
            _log.throwing(DistributionHelper.class.getName(), "getDistributionFromRepository", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)distributionName)) {
            GdrException ex = new GdrException("The distribution name provided was invalid: " + distributionName);
            _log.throwing(DistributionHelper.class.getName(), "getDistributionFromRepository", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)distributionVersion)) {
            GdrException ex = new GdrException("The distribution version provided was invalid: " + distributionVersion);
            _log.throwing(DistributionHelper.class.getName(), "getDistributionFromRepository", ex);
            throw ex;
        }
        try {
            distributionArtifact = repositoryService.getRepositoryVersionResolver().getDistributionArtifact(distributionName, distributionVersion);
        }
        catch (Exception e) {
            GdrException ex = new GdrException("Unable to resolve distribution.", (Throwable)e);
            _log.throwing(DistributionHelper.class.getName(), "getDistributionFromRepository", ex);
            throw ex;
        }
        Path distributionFile = NioHelper.getInstance().getPath(repositoryService.getArtifactLocation(distributionArtifact));
        Distribution distribution = (Distribution)this.getRootWrapper(distributionFile);
        this.validateDistribution(distribution, distributionFile, false);
        distribution.setDistributionFileLocation(distributionFile);
        Artifact resourceArtifact = null;
        try {
            resourceArtifact = repositoryService.getRepositoryVersionResolver().getDistributionResourcesArtifact(distributionName, distributionVersion);
        }
        catch (Exception e) {
            _log.log(Level.FINEST, "Failed to locate distribution resource artifact for " + distributionName + " " + distributionVersion + " under " + repositoryService.getLocalCacheRepositoryLocation());
        }
        if (resourceArtifact != null) {
            this.setResourcesBundleInfo((ResourceBundleInfoHolder)distribution, repositoryService, resourceArtifact, null);
        }
        return distribution;
    }

    public DistributionInfo getDistributionInfoFromRepository(RepositoryService repositoryService, String distributionName, String distributionVersion) throws IOException, DataHandlerException, GdrException {
        Artifact distributionInfoArtifact;
        if (repositoryService == null) {
            GdrException ex = new GdrException("The repository service provided was null.");
            _log.throwing(DistributionHelper.class.getName(), "getDistributionInfoFromRepository", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)distributionName)) {
            GdrException ex = new GdrException("The distribution name provided was invalid: " + distributionName);
            _log.throwing(DistributionHelper.class.getName(), "getDistributionInfoFromRepository", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)distributionVersion)) {
            GdrException ex = new GdrException("The distribution version provided was invalid: " + distributionVersion);
            _log.throwing(DistributionHelper.class.getName(), "getDistributionInfoFromRepository", ex);
            throw ex;
        }
        try {
            distributionInfoArtifact = repositoryService.getRepositoryVersionResolver().getDistributionInfoArtifact(distributionName, distributionVersion);
        }
        catch (Exception e) {
            GdrException ex = new GdrException("Unable to resolve distribution.", (Throwable)e);
            _log.throwing(DistributionHelper.class.getName(), "getDistributionFromRepository", ex);
            throw ex;
        }
        File distributionInfoFile = repositoryService.getArtifactLocation(distributionInfoArtifact);
        Path distributionInfoPath = NioHelper.getInstance().getPath(distributionInfoFile);
        DistributionInfo distributionInfo = (DistributionInfo)DistributionInfoHelper.getInstance().getRootWrapper(distributionInfoPath);
        distributionInfo.setDistributionInfoFileLocation(distributionInfoPath);
        return distributionInfo;
    }

    public Set<Distribution> getDistributions(File metaDataDir) throws IOException, DataHandlerException, GdrException {
        return this.getDistributions(NioHelper.getInstance().getPath(metaDataDir), false);
    }

    public Set<Distribution> getDistributions(Path metaDataDir) throws IOException, DataHandlerException, GdrException {
        return this.getDistributions(metaDataDir, false);
    }

    public Set<Distribution> getDistributions(MetaDataHome metaDataDir) throws IOException, DataHandlerException, GdrException {
        if (!metaDataDir.isRepository()) {
            return this.getDistributions(metaDataDir.getGdrMetaDataHomePath(), false);
        }
        LinkedHashSet<Distribution> distributions = new LinkedHashSet<Distribution>();
        for (File repositoryDistribution : this.getDistributionFiles(metaDataDir)) {
            Distribution distribution = this.getDistribution(repositoryDistribution, false);
            distributions.add(distribution);
        }
        return distributions;
    }

    public Set<Distribution> getDistributions(File metaDataDir, boolean ignoreParsingFailures) throws IOException, DataHandlerException, GdrException {
        return this.getDistributions(NioHelper.getInstance().getPath(metaDataDir), ignoreParsingFailures);
    }

    public Set<Distribution> getDistributions(Path metaDataDir, boolean ignoreParsingFailures) throws IOException, DataHandlerException, GdrException {
        LinkedHashSet<Distribution> distributions = new LinkedHashSet<Distribution>();
        if (metaDataDir != null && Files.isDirectory(metaDataDir, new LinkOption[0])) {
            for (Path f : this.getDistributionFiles(metaDataDir)) {
                Distribution distribution;
                try {
                    distribution = this.getDistribution(f);
                }
                catch (DataHandlerException dhe) {
                    if (!ignoreParsingFailures) {
                        throw dhe;
                    }
                    _log.log(Level.WARNING, "Error parsing distribution file " + f, dhe);
                    continue;
                }
                distributions.add(distribution);
            }
        }
        return distributions;
    }

    public void saveDistribution(Distribution distribution, File directory) throws DataHandlerException, GdrException, IOException {
        Path dirPath = null;
        try {
            dirPath = NioHelper.getInstance().getPath(directory);
        }
        catch (InvalidPathException e) {
            GdrException ex = new GdrException("The directory specified is invalid: " + directory);
            _log.throwing(DistributionHelper.class.getName(), "saveDistribution", ex);
            throw ex;
        }
        this.saveDistribution(distribution, dirPath);
    }

    public void saveDistribution(Distribution distribution, Path directory) throws DataHandlerException, GdrException, IOException {
        Path resourceLocation;
        if (distribution == null) {
            GdrException ex = new GdrException("The distribution specified was null.");
            _log.throwing(DistributionHelper.class.getName(), "saveDistribution", ex);
            throw ex;
        }
        if (directory == null) {
            GdrException ex = new GdrException("The directory specified was null.");
            _log.throwing(DistributionHelper.class.getName(), "saveDistribution", ex);
            throw ex;
        }
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
            if (!Files.exists(directory, new LinkOption[0])) {
                GdrException ex = new GdrException("The directory specified did not exist and could not be created: " + directory);
                _log.throwing(DistributionHelper.class.getName(), "saveDistribution", ex);
                throw ex;
            }
        } else if (!Files.isDirectory(directory, new LinkOption[0])) {
            GdrException ex = new GdrException("The directory specified was not a directory: " + directory);
            _log.throwing(DistributionHelper.class.getName(), "saveDistribution", ex);
            throw ex;
        }
        this.save((IDataHandlerWrapper)distribution, directory.resolve(this.getDistributionFileName(distribution)));
        ResourceBundleInfo rbi = distribution.getResourceBundleInfo();
        if (rbi != null && (resourceLocation = rbi.getResourceLocationPath()) != null && Files.exists(resourceLocation, new LinkOption[0]) && Files.isRegularFile(resourceLocation, new LinkOption[0])) {
            this.clearResourceBundleCache();
            Path destLocation = directory.resolve(this.getResourceLocation(distribution.getName(), distribution.getVersion()));
            NioCopy.copyFile((Path)resourceLocation, (Path)destLocation);
        }
    }

    public void saveDistribution(Distribution distribution, Repository repository) throws DataHandlerException, GdrException, IOException {
        if (distribution == null) {
            GdrException ex = new GdrException("The distribution specified was null.");
            _log.throwing(DistributionHelper.class.getName(), "saveDistribution", ex);
            throw ex;
        }
        if (repository == null) {
            GdrException ex = new GdrException("The repository specified was null.");
            _log.throwing(DistributionHelper.class.getName(), "saveDistribution", ex);
            throw ex;
        }
        if (!repository.getType().isCache()) {
            throw new GdrException("Cannot save distribution in repository of type " + repository.getType());
        }
        File repositoryDir = repository.getCacheLocation();
        if (!repositoryDir.exists() && !repositoryDir.mkdirs()) {
            GdrException ex = new GdrException("The repository directory specified did not exist and could not be created: " + repositoryDir);
            _log.throwing(DistributionHelper.class.getName(), "saveDistribution", ex);
            throw ex;
        }
        if (!repositoryDir.isDirectory()) {
            GdrException ex = new GdrException("The repository directory specified was not a directory: " + repositoryDir);
            _log.throwing(DistributionHelper.class.getName(), "saveDistribution", ex);
            throw ex;
        }
        Artifact artifact = distribution.getDistributionArtifact();
        if (artifact == null) {
            artifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution", distribution.getName(), distribution.getVersion(), "xml", new String[]{RepositoryService.getVersionQualifier()});
        }
        FileCopy.copy((File)distribution.getDistributionFileLocation(), (File)artifact.getLocalLocation(repository.getCacheLocation()));
        ResourceBundleInfo rbi = distribution.getResourceBundleInfo();
        if (rbi != null) {
            File resourceLocation = rbi.getResourceLocation();
            Artifact resourceArtifact = rbi.getResourceArtifact();
            if (resourceLocation != null && resourceLocation.exists() && resourceLocation.isFile() && resourceArtifact != null) {
                File destLocation = resourceArtifact.getLocalLocation(repositoryDir);
                FileCopy.copy((File)resourceLocation, (File)destLocation);
            }
        }
    }

    public void saveDistributionInfo(DistributionInfo distributionInfo, Repository repository) throws DataHandlerException, GdrException, IOException {
        if (distributionInfo == null) {
            GdrException ex = new GdrException("The distributionInfo specified was null.");
            _log.throwing(DistributionHelper.class.getName(), "saveDistributionInfo", ex);
            throw ex;
        }
        if (repository == null) {
            GdrException ex = new GdrException("The repository specified was null.");
            _log.throwing(DistributionHelper.class.getName(), "saveDistributionInfo", ex);
            throw ex;
        }
        if (!repository.getType().isCache()) {
            throw new GdrException("Cannot save distribution in repository of type " + repository.getType());
        }
        File repositoryDir = repository.getCacheLocation();
        if (!repositoryDir.exists() && !repositoryDir.mkdirs()) {
            GdrException ex = new GdrException("The repository directory specified did not exist and could not be created: " + repositoryDir);
            _log.throwing(DistributionHelper.class.getName(), "saveDistributionInfo", ex);
            throw ex;
        }
        if (!repositoryDir.isDirectory()) {
            GdrException ex = new GdrException("The repository directory specified was not a directory: " + repositoryDir);
            _log.throwing(DistributionHelper.class.getName(), "saveDistributionInfo", ex);
            throw ex;
        }
        Artifact artifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution.info", distributionInfo.getName(), distributionInfo.getVersion(), "xml", new String[]{RepositoryService.getVersionQualifier()});
        NioCopy.copyFile((Path)distributionInfo.getDistributionInfoPathLocation(), (Path)NioHelper.getInstance().getPath(artifact.getLocalLocation(repository.getCacheLocation())));
    }

    public void removeDistribution(Distribution distribution, File metaDataRoot) {
        this.removeDistribution(distribution, NioHelper.getInstance().getPath(metaDataRoot));
    }

    public void removeDistribution(Distribution distribution, Path metaDataRoot) {
        if (metaDataRoot != null) {
            Path distributionsDir = metaDataRoot.resolve(DISTRIBUTIONS_DIR);
            Path distributionFile = distributionsDir.resolve(this.getDistributionFileName(distribution));
            try {
                if (Files.exists(distributionFile, new LinkOption[0])) {
                    Files.delete(distributionFile);
                    if (Files.exists(distributionFile, new LinkOption[0])) {
                        _log.warning("Unable to delete distribution file " + distributionFile);
                    }
                }
            }
            catch (IOException e) {
                _log.warning("Unable to delete distribution file " + distributionFile);
            }
            this.clearResourceBundleCache();
            Path resourceJarLocation = distributionsDir.resolve(this.getResourceLocation(distribution.getName(), distribution.getVersion()));
            if (Files.exists(resourceJarLocation, new LinkOption[0])) {
                try {
                    Files.delete(resourceJarLocation);
                    if (Files.exists(resourceJarLocation, new LinkOption[0])) {
                        _log.warning("Unable to delete distribution resource file " + resourceJarLocation);
                    }
                }
                catch (IOException e) {
                    _log.warning("Unable to delete resource modules location " + resourceJarLocation);
                }
            }
            Path p = distributionsDir.resolve("resources").resolve("modules");
            try {
                if (Files.exists(p, new LinkOption[0]) && FileUtils.isDirectoryEmpty(p)) {
                    Files.delete(p);
                }
            }
            catch (IOException e) {
                _log.warning("Unable to delete resource modules location " + p);
            }
            p = distributionsDir.resolve("resources");
            try {
                if (Files.exists(p, new LinkOption[0]) && FileUtils.isDirectoryEmpty(p)) {
                    Files.delete(p);
                }
            }
            catch (IOException e) {
                _log.warning("Unable to delete resource location " + p);
            }
            try {
                if (Files.exists(distributionsDir, new LinkOption[0]) && FileUtils.isDirectoryEmpty(distributionsDir)) {
                    Files.delete(distributionsDir);
                    if (Files.exists(distributionsDir, new LinkOption[0])) {
                        _log.warning("Unable to delete distribution location " + distributionsDir);
                    }
                }
            }
            catch (IOException e) {
                _log.warning("Unable to delete distribution location " + distributionsDir);
            }
        }
    }

    public Set<FeatureSetReference> getFeatureSetReferences(Distribution distribution) {
        return this.getFeatureSetReferences(distribution, false);
    }

    public List<FeatureSetGroup> getFeatureSetGroups(Collection<FeatureSetGroup> featureGroups) {
        ArrayList<FeatureSetGroup> featureSetGroups = new ArrayList<FeatureSetGroup>();
        if (featureGroups != null && !featureGroups.isEmpty()) {
            for (FeatureSetGroup featureSetGroup : featureGroups) {
                featureSetGroups.add(featureSetGroup);
                featureSetGroups.addAll(this.getFeatureSetGroups(featureSetGroup.getFeatureSetGroups()));
            }
        }
        return featureSetGroups;
    }

    public Set<FeatureSetReference> getFeatureSetReferences(Distribution distribution, boolean filterExternal) {
        List<FeatureSetGroup> groups;
        LinkedHashSet<FeatureSetReference> featureRefs = new LinkedHashSet<FeatureSetReference>();
        if (distribution != null && (groups = this.getFeatureSetGroups(distribution.getFeatureSetGroups())) != null && !groups.isEmpty()) {
            for (FeatureSetGroup group : groups) {
                List<FeatureSetReference> refs = group.getFeatures();
                if (refs == null || refs.isEmpty()) continue;
                if (filterExternal) {
                    for (FeatureSetReference ref : refs) {
                        if (ref.isExternal()) continue;
                        featureRefs.add(ref);
                    }
                    continue;
                }
                featureRefs.addAll(refs);
            }
        }
        return featureRefs;
    }

    public Set<FeatureSetReference> getExternalFeatureSetReferences(Distribution distribution) {
        HashSet<FeatureSetReference> externalFeatureSetRefs = new HashSet<FeatureSetReference>();
        if (distribution != null) {
            List<FeatureSetGroup> featureSetGroups = this.getFeatureSetGroups(distribution.getFeatureSetGroups());
            for (FeatureSetGroup group : featureSetGroups) {
                List<FeatureSetReference> refs = group.getFeatures();
                for (FeatureSetReference ref : refs) {
                    if (!ref.isExternal()) continue;
                    externalFeatureSetRefs.add(ref);
                }
            }
        }
        return externalFeatureSetRefs;
    }

    public List<FeatureSetReference> getFeatureSetReferences(Collection<FeatureSet> features) {
        ArrayList<FeatureSetReference> featureRefs = new ArrayList<FeatureSetReference>();
        if (features != null && !features.isEmpty()) {
            for (FeatureSet feature : features) {
                FeatureSetReference fsr = new FeatureSetReference(this.getClassLoader());
                fsr.setName(feature.getName());
                fsr.setVersion(feature.getVersion());
                featureRefs.add(fsr);
            }
        }
        return featureRefs;
    }

    public boolean isMatchingDependencyReference(Reference ref, DependencyRef dependency) {
        return ref != null && this.isMatchingDependencyReference(ref.getName(), ref.getVersion(), dependency);
    }

    public boolean isMatchingDependencyReference(String name, String version, DependencyRef dependency) {
        if (name != null && version != null && dependency != null && dependency.getName().equals(name)) {
            String depVersion = dependency.getVersion();
            List ranges = dependency.getVersionRanges();
            Version refVersion = new Version(version);
            if (!StringUtil.isNullOrEmpty((String)depVersion, (boolean)true) && refVersion.equals((Object)new Version(depVersion)) || ranges != null && !ranges.isEmpty() && VersionHelper.isVersionWithinRanges((Version)refVersion, (List)ranges)) {
                return true;
            }
        }
        return false;
    }

    public Set<FeatureSet> getFeatureSets(Distribution distribution, File metaDataDir) throws IOException, DataHandlerException, GdrException {
        return this.getFeatureSets(distribution, NioHelper.getInstance().getPath(metaDataDir));
    }

    public Set<FeatureSet> getFeatureSets(Distribution distribution, Path metaDataDir) throws IOException, DataHandlerException, GdrException {
        Set<FeatureSet> featureSets = new LinkedHashSet<FeatureSet>();
        if (distribution != null) {
            HashSet<FeatureSetReference> featureRefs = new HashSet<FeatureSetReference>();
            List<FeatureSetGroup> groups = this.getFeatureSetGroups(distribution.getFeatureSetGroups());
            for (FeatureSetGroup group : groups) {
                featureRefs.addAll(group.getFeatures());
            }
            featureSets = new FeatureLoader(metaDataDir, featureRefs).getFeatureSets();
        } else {
            _log.warning("Distribution was null, no feature sets returned.");
        }
        return featureSets;
    }

    public Set<FeatureSet> getFeatureSets(Distribution distribution, MetaDataHome metaDataHome) throws IOException, DataHandlerException, GdrException {
        Set<FeatureSet> featureSets = new LinkedHashSet<FeatureSet>();
        if (distribution != null) {
            HashSet<FeatureSetReference> featureRefs = new HashSet<FeatureSetReference>();
            List<FeatureSetGroup> groups = this.getFeatureSetGroups(distribution.getFeatureSetGroups());
            for (FeatureSetGroup group : groups) {
                featureRefs.addAll(group.getFeatures());
            }
            featureSets = new FeatureLoader(metaDataHome, featureRefs).getFeatureSets();
        } else {
            _log.warning("Distribution was null, no feature sets returned.");
        }
        return featureSets;
    }

    public Collection<String> getRootDirsForSymbol(DirectoryMap dirMap, String symbol) throws GdrException {
        Collection<Mapping> mappings = this.getRootDirsMappingsForSymbol(dirMap, symbol);
        HashSet<String> dirs = new HashSet<String>();
        if (mappings != null && !mappings.isEmpty()) {
            for (Mapping mapping : mappings) {
                dirs.add(mapping.getDirectory());
            }
        }
        return dirs;
    }

    public Collection<Mapping> getRootDirsMappingsForSymbol(DirectoryMap dirMap, String symbol) throws GdrException {
        List<Mapping> mappings;
        if (dirMap == null) {
            GdrException ex = new GdrException("DirectoryMap provided was null.");
            _log.throwing(DistributionHelper.class.getName(), "getRootDirsMappingsForSymbol", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)symbol, (boolean)true)) {
            GdrException ex = new GdrException("The symbol provided was null or empty.");
            _log.throwing(DistributionHelper.class.getName(), "getRootDirsMappingsForSymbol", ex);
            throw ex;
        }
        ArrayList<Mapping> matches = new ArrayList<Mapping>();
        ArrayList<Mapping> regexMatches = new ArrayList<Mapping>();
        RootMapping rootMapping = dirMap.getRootMapping();
        if (rootMapping != null && !StringUtil.isNullOrEmpty((String)symbol)) {
            List<MappingSymbol> symbols = rootMapping.getMappingSymbols();
            for (MappingSymbol sym : symbols) {
                if (!sym.matches(symbol)) continue;
                Mapping mapping = new Mapping("");
                if (sym.isRegex()) {
                    if (regexMatches.contains((Object)mapping)) continue;
                    regexMatches.add(mapping);
                    continue;
                }
                if (matches.contains((Object)mapping)) continue;
                matches.add(mapping);
            }
        }
        if ((mappings = dirMap.getMappings()) != null && !mappings.isEmpty()) {
            for (Mapping mapping : mappings) {
                List<MappingSymbol> symbols = mapping.getMappingSymbols();
                for (MappingSymbol sym : symbols) {
                    if (!sym.matches(symbol)) continue;
                    if (sym.isRegex()) {
                        if (regexMatches.contains((Object)mapping)) continue;
                        regexMatches.add(mapping);
                        continue;
                    }
                    if (matches.contains((Object)mapping)) continue;
                    matches.add(mapping);
                }
            }
        }
        return !matches.isEmpty() ? matches : regexMatches;
    }

    public DirectoryMap createDirectoryMap(Map<String, Set<String>> dirMap) {
        return this.createDirectoryMap(dirMap, null);
    }

    public DirectoryMap createDirectoryMap(Map<String, Set<String>> dirMap, Map<String, String> modes) {
        LinkedHashSet<RootMapping> directoryMappings = new LinkedHashSet<RootMapping>();
        if (dirMap != null && !dirMap.isEmpty()) {
            for (String dir : dirMap.keySet()) {
                Set<String> symbols = dirMap.get(dir);
                if ("ORACLE_HOME".equals(dir)) {
                    RootMapping rootMapping = new RootMapping();
                    rootMapping.setSymbols(symbols.toArray(new String[symbols.size()]));
                    rootMapping.setMode(modes != null ? modes.get(dir) : null);
                    directoryMappings.add(rootMapping);
                    continue;
                }
                Mapping mapping = new Mapping();
                mapping.setDirectory(dir);
                mapping.setSymbols(symbols.toArray(new String[symbols.size()]));
                mapping.setMode(modes != null ? modes.get(dir) : null);
                directoryMappings.add(mapping);
            }
        }
        return this.createDirectoryMap(directoryMappings);
    }

    public DirectoryMap createDirectoryMap(Set<RootMapping> directoryMappings) {
        DirectoryMap directoryMap = new DirectoryMap();
        if (directoryMappings != null && !directoryMappings.isEmpty()) {
            ArrayList<Mapping> mappings = new ArrayList<Mapping>();
            for (RootMapping mapping : directoryMappings) {
                if (mapping instanceof Mapping) {
                    mappings.add((Mapping)mapping);
                    continue;
                }
                directoryMap.setRootMapping(mapping);
            }
            if (!mappings.isEmpty()) {
                directoryMap.setMappings(mappings);
            }
        }
        return directoryMap;
    }

    public DirectoryMap createRegexDirectoryMap(String directory, String mode) {
        DirectoryMap directoryMap = new DirectoryMap();
        if (!StringUtil.isNullOrEmpty((String)directory, (boolean)true)) {
            RootMapping rootMapping;
            if ("ORACLE_HOME".equals(directory)) {
                rootMapping = new RootMapping();
                directoryMap.setRootMapping(rootMapping);
            } else {
                Mapping mapping = directoryMap.addMapping();
                mapping.setDirectory(directory);
                rootMapping = mapping;
            }
            MappingSymbol mappingSymbol = rootMapping.getMappingSymbol(".*", true);
            ArrayList<MappingSymbol> mappingSymbols = new ArrayList<MappingSymbol>();
            mappingSymbols.add(mappingSymbol);
            rootMapping.setSymbols(mappingSymbols);
            if (!StringUtil.isNullOrEmpty((String)mode, (boolean)true)) {
                rootMapping.setMode(mode);
            }
        }
        return directoryMap;
    }

    public DirectoryMap mergeDirectoryMaps(Collection<Distribution> distributions, DirectoryMap ... directoryMaps) {
        ArrayList<DirectoryMap> allDirectoryMaps = new ArrayList<DirectoryMap>();
        if (distributions != null && !distributions.isEmpty()) {
            for (Distribution distribution : distributions) {
                allDirectoryMaps.add(distribution.getDirectoryMap());
            }
        }
        if (directoryMaps != null && directoryMaps.length > 0) {
            for (DirectoryMap directoryMap : directoryMaps) {
                if (directoryMap == null) continue;
                allDirectoryMaps.add(directoryMap);
            }
        }
        return this.mergeDirectoryMaps(allDirectoryMaps);
    }

    public DirectoryMap mergeDirectoryMaps(List<DirectoryMap> directoryMaps) {
        DirectoryMap directoryMap = new DirectoryMap(this.getClassLoader());
        if (directoryMaps != null && !directoryMaps.isEmpty()) {
            RootMapping rootMapping = null;
            LinkedHashMap<String, Mapping> directoryMappings = new LinkedHashMap<String, Mapping>();
            for (DirectoryMap dm : directoryMaps) {
                List<Mapping> mappings = dm.getMappings();
                for (Mapping mapping : mappings) {
                    Mapping existing = (Mapping)((Object)directoryMappings.get(mapping.getDirectory()));
                    if (existing != null) {
                        List<MappingSymbol> symbolList = existing.getMappingSymbols();
                        HashSet<MappingSymbol> symbols = new HashSet<MappingSymbol>();
                        if (symbolList != null) {
                            symbols.addAll(symbolList);
                        }
                        symbolList = mapping.getMappingSymbols();
                        symbols.addAll(symbolList);
                        existing.setSymbols(new ArrayList<MappingSymbol>(symbols));
                        continue;
                    }
                    directoryMappings.put(mapping.getDirectory(), mapping);
                }
                RootMapping rm = dm.getRootMapping();
                if (rm == null) continue;
                if (rootMapping == null) {
                    rootMapping = rm;
                    continue;
                }
                List<MappingSymbol> symbolList = rootMapping.getMappingSymbols();
                HashSet<MappingSymbol> symbols = new HashSet<MappingSymbol>();
                if (symbolList != null) {
                    symbols.addAll(symbolList);
                }
                symbolList = rm.getMappingSymbols();
                symbols.addAll(symbolList);
                rootMapping.setSymbols(new ArrayList<MappingSymbol>(symbols));
            }
            if (!directoryMappings.isEmpty()) {
                directoryMap.setMappings(new ArrayList<Mapping>(directoryMappings.values()));
            }
            if (rootMapping != null) {
                directoryMap.setRootMapping(rootMapping);
            }
        }
        return directoryMap;
    }

    public Set<FeatureSetReference> createFeatureSetReferences(Set<FeatureSet> features) {
        HashSet<FeatureSetReference> featureRefs = new HashSet<FeatureSetReference>();
        for (FeatureSet feature : features) {
            featureRefs.add(new FeatureSetReference(feature.getName(), feature.getVersion()));
        }
        return featureRefs;
    }

    public InstallType createDefaultInstallType() {
        InstallType installType = this.createInstallType(DEFAULT_INSTALL_TYPE);
        installType.setDefault(true);
        return installType;
    }

    public InstallType createInstallType(String name) {
        return new InstallType(name);
    }

    public Reference locateDistribution(MetaDataHome metaDataHome) throws GdrException {
        if (metaDataHome == null) {
            GdrException ex = new GdrException("The meta-data home was null.");
            _log.throwing(DistributionHelper.class.getName(), "getShipHomeDistributionInfo", ex);
            throw ex;
        }
        List<Path> files = this.getDistributionFilePaths(metaDataHome);
        if (files == null || files.size() == 0) {
            GdrException ex = new GdrException("Unable to find distribution xml file in distributions directory " + metaDataHome.getGdrMetaDataHome());
            _log.throwing(DistributionHelper.class.getName(), "locateDistribution", ex);
            throw ex;
        }
        if (files.size() > 1) {
            GdrException ex = new GdrException("Encountered multiple xml files in distributions directory " + Arrays.asList(files));
            _log.throwing(DistributionHelper.class.getName(), "locateDistribution", ex);
            throw ex;
        }
        Reference reference = null;
        try (InputStream is = Files.newInputStream(files.get(0), new OpenOption[0]);){
            IDataHandler dataHandler = new TreeDataHandlerSpiImpl().create(NAMESPACE, DISTRIBUTION, is);
            Distribution distribution = new Distribution(dataHandler);
            reference = metaDataHome.isRepository() ? InstallerConfig.createReference(distribution.getName(), files.get(0).getParent().getFileName().toString()) : InstallerConfig.createReference(distribution.getName(), distribution.getVersion());
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error getting distribution name and version from " + files.get(0), e);
        }
        if (reference == null) {
            String filename = files.get(0).getFileName().toString();
            int index = filename.lastIndexOf(".");
            if (index > -1) {
                filename = filename.substring(0, index);
            }
            if ((index = filename.lastIndexOf("_")) < 1 || index + 1 > filename.length()) {
                GdrException ex = new GdrException("Distribution definition xml file name format incorrect " + files.get(0));
                _log.throwing(DistributionHelper.class.getName(), "locateDistribution", ex);
                throw ex;
            }
            String name = filename.substring(0, index);
            String version = filename.substring(index + 1);
            return InstallerConfig.createReference(name, version);
        }
        return reference;
    }

    private void validateDistribution(Distribution distribution, Path distributionFile, boolean validateFileName) throws GdrException {
        List<InstallType> installTypes;
        if (distributionFile == null || distribution == null) {
            GdrException ex = new GdrException("Distribution object and file source should not have null values");
            _log.throwing(DistributionHelper.class.getName(), "validateDistribution", ex);
            throw ex;
        }
        if (validateFileName && !distributionFile.getFileName().toString().equals(this.getDistributionFileName(distribution))) {
            GdrException ex = new GdrException("The internal distribution name and version is incorrect.  File name should be: " + this.getDistributionFileName(distribution) + " File name is: " + distributionFile.getFileName());
            _log.throwing(DistributionHelper.class.getName(), "validateDistribution", ex);
            throw ex;
        }
        if (distribution.getDirectoryMap() != null) {
            for (Mapping mapping : distribution.getDirectoryMap().getMappings()) {
                String directory = mapping.getDirectory();
                if (!StringUtil.isNullOrEmpty((String)directory, (boolean)true) && !directory.startsWith(" ") && !directory.endsWith(" ") && !directory.contains("/") && !directory.contains("\\") && !directory.trim().matches("\\.+")) continue;
                GdrException ex = new GdrException("The directory mapping for \"" + directory + "\" contains an invalid directory name or path.");
                _log.throwing(DistributionHelper.class.getName(), "validateDistribution", ex);
                throw ex;
            }
        }
        if ((installTypes = distribution.getInstallType()) != null && !installTypes.isEmpty()) {
            boolean foundDefault = false;
            boolean foundCustom = false;
            for (InstallType installType : installTypes) {
                if (installType.isDefault()) {
                    if (foundDefault) {
                        GdrException ex = new GdrException("Distributions are not permitted to contain multiple \"default\" install types : " + distribution);
                        _log.throwing(DistributionHelper.class.getName(), "validateDistribution", ex);
                        throw ex;
                    }
                    foundDefault = true;
                }
                if (!installType.isCustom()) continue;
                if (foundCustom) {
                    GdrException ex = new GdrException("Distributions are not permitted to contain multiple \"custom\" install types : " + distribution);
                    _log.throwing(DistributionHelper.class.getName(), "validateDistribution", ex);
                    throw ex;
                }
                foundCustom = true;
            }
        }
    }

    public File saveProductVariables(File dir, Set<Component> components, String distName, String distVersion) throws DataHandlerException, InputHandlerException, IOException {
        Path productVariables = this.saveProductVariables(NioHelper.getInstance().getPath(dir), null, components, distName, distVersion);
        return productVariables != null ? productVariables.toFile() : null;
    }

    public Path saveProductVariables(Path dir, Set<Component> components, String distName, String distVersion) throws DataHandlerException, InputHandlerException, IOException {
        return this.saveProductVariables(dir, null, components, distName, distVersion);
    }

    public File updateProductVariables(File dir, HashMap<Component, Component> components, String distName, String distVersion) throws InputHandlerException, DataHandlerException, IOException {
        Path productVariables = this.updateProductVariables(NioHelper.getInstance().getPath(dir), components, distName, distVersion);
        return productVariables != null ? productVariables.toFile() : null;
    }

    public Path updateProductVariables(Path dir, HashMap<Component, Component> components, String name, String version) throws InputHandlerException, DataHandlerException, IOException {
        ArrayList existingProductVars = null;
        Path outputDir = dir.resolve("variables");
        String formattedName = GdrHelper.getFormattedName(name);
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(outputDir);){
            for (Path varFile : ds) {
                if (!varFile.getFileName().toString().startsWith(formattedName)) continue;
                existingProductVars = new ArrayList();
                for (List variableDaos : VariablesParser.getInstance().getVariableDaos(varFile).values()) {
                    existingProductVars.addAll(variableDaos);
                }
                for (Component prevComp : components.values()) {
                    List<VariableDao> prevVars;
                    if (prevComp == null || (prevVars = prevComp.getProductVariables()) == null || prevVars.size() <= 0) continue;
                    existingProductVars.removeAll(prevVars);
                }
                NioDelete.delete((Path)varFile);
                break;
            }
        }
        return this.saveProductVariables(dir, existingProductVars, components.keySet(), name, version);
    }

    public File saveProductVariables(File dir, List<VariableDao> existingProductVars, Set<Component> components, String distName, String distVersion) throws DataHandlerException, InputHandlerException, IOException {
        Path productVariables = this.saveProductVariables(NioHelper.getInstance().getPath(dir), existingProductVars, components, distName, distVersion);
        return productVariables != null ? productVariables.toFile() : null;
    }

    public Path saveProductVariables(Path dir, List<VariableDao> existingProductVars, Set<Component> components, String distName, String distVersion) throws DataHandlerException, InputHandlerException, IOException {
        HashMap<Component, Set<String>> compAndHelpIds = new HashMap<Component, Set<String>>();
        ArrayList<VariableDao> productVars = new ArrayList<VariableDao>();
        if (existingProductVars != null) {
            productVars.addAll(existingProductVars);
        }
        Path outputFile = null;
        for (Component comp : components) {
            HashSet<String> helpIds = new HashSet<String>();
            for (VariableDao var : comp.getProductVariables()) {
                if (productVars.contains(var)) {
                    throw new DataHandlerException("The variable " + var.getName() + " defined in " + comp.getName() + " is already defined in other component");
                }
                productVars.add(var);
                helpIds.add(var.getHelpId());
            }
            compAndHelpIds.put(comp, helpIds);
        }
        if (!productVars.isEmpty()) {
            outputFile = dir.resolve("variables").resolve(GdrHelper.getFormattedNameVersion(distName, distVersion) + ".xml");
            VariablesParser.getInstance().writeProductVariablesFile(productVars, outputFile, distName, distVersion, GdrHelper.getFormattedNameVersion(distName, distVersion));
            this.saveProductVariablesResourceBundle(compAndHelpIds, dir, GdrHelper.getFormattedNameVersion(distName, distVersion));
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProductVariablesResourceBundle(Map<Component, Set<String>> compAndResources, Path dir, String baseName) throws IOException {
        HashMap distResource = new HashMap();
        for (Component c : compAndResources.keySet()) {
            ResourceBundleInfo rbi = c.getResourceBundleInfo();
            if (rbi == null) continue;
            String resoruceDir = ComponentHelper.getInstance(this.getClassLoader()).getResourceLocation(rbi.getName(), rbi.getVersion());
            Path resDir = rbi.getResourceLocationPath().resolve(resoruceDir);
            if (!Files.exists(resDir, new LinkOption[0]) || !Files.isDirectory(resDir, new LinkOption[0])) continue;
            DirectoryStream.Filter<Path> filter = ComponentHelper.getInstance(this.getClassLoader()).getGlobalExcludeFilter();
            DirectoryStream<Path> allFiles = Files.newDirectoryStream(resDir, filter);
            try {
                for (Path p : allFiles) {
                    String fileName = p.getFileName().toString();
                    if (!fileName.matches("component[_a-zA-Z]*.properties")) continue;
                    String locale = fileName.replace("component", "").replace(".properties", "");
                    if (locale.isEmpty()) {
                        locale = "Default";
                    }
                    Map prop = distResource.containsKey(locale) ? (Map)distResource.get(locale) : new HashMap();
                    try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                        PropertyResourceBundle bundle = new PropertyResourceBundle(is);
                        for (String key : compAndResources.get(c)) {
                            if (!bundle.containsKey(key)) continue;
                            prop.put(key, bundle.getString(key));
                        }
                    }
                    distResource.put(locale, prop);
                }
            }
            finally {
                if (allFiles == null) continue;
                allFiles.close();
            }
        }
        for (String loc : distResource.keySet()) {
            Properties prop = new Properties();
            String locale = loc.equals("Default") ? "" : loc;
            Path outputFile = dir.resolve(OuiConstants.VARIABLES_RESOURCES_DIR).resolve(baseName + locale + ".properties");
            if (outputFile.getParent() != null) {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            }
            prop.putAll((Map<?, ?>)((Map)distResource.get(loc)));
            OutputStream os = null;
            try {
                os = Files.newOutputStream(outputFile, new OpenOption[0]);
                prop.store(os, "This file is automatically generated");
            }
            finally {
                if (os == null) continue;
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException e) {
                    _log.fine("An exception occurred while closing properties file: " + outputFile);
                }
            }
        }
    }
}

