/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.tree.TreeDataHandler;
import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.XMLTreeDataFactory;
import com.oracle.cie.gdr.dao.facfg.ConfigFiles;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class ConfigFilesHelper
extends GdrHelper<ConfigFiles> {
    private static final Logger _log = Logger.getLogger(ConfigFilesHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/facfg";
    public final String CONFIG_FILES = "config-files";
    private static ConfigFilesHelper _instance;

    protected ConfigFilesHelper(ClassLoader classLoader) {
        super(ConfigFiles.class, classLoader);
    }

    public static ConfigFilesHelper getInstance() {
        if (_instance == null) {
            _instance = new ConfigFilesHelper(null);
        }
        return _instance;
    }

    public String getRootElement() {
        return "config-files";
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getPath() {
        return null;
    }

    public ConfigFiles getConfigFiles(File configFilesFile) throws IOException, DataHandlerException, GdrException {
        ConfigFiles configFiles = new ConfigFiles();
        if (configFilesFile == null || !configFilesFile.isFile()) {
            GdrException e = new GdrException("Config file specified was invalid: " + configFilesFile);
            _log.throwing(ConfigFiles.class.getName(), "getConfigFiles", e);
            throw e;
        }
        TreeDataHandler dataHandler = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(configFilesFile);
            Tree tree1 = XMLTreeDataFactory.create((InputStream)fis, (boolean)true);
            dataHandler = new TreeDataHandler(tree1, tree1.getId(), tree1.getId(), this.getNamespace(), null);
            configFiles = new ConfigFiles((IDataHandler)dataHandler);
        }
        return configFiles;
    }
}

