/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.generation;

import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.generation.ComponentGenerationConfig;
import com.oracle.cie.gdr.generation.DistributionGenerationConfig;
import com.oracle.cie.gdr.generation.DistributionInfoGenerationConfig;
import com.oracle.cie.gdr.generation.FeatureSetGenerationConfig;
import com.oracle.cie.gdr.generation.GenerationConfig;
import com.oracle.cie.gdr.generation.GenerationType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class MetadataGenerationConfig {
    private static final Logger _log = Logger.getLogger(MetadataGenerationConfig.class.getName());
    Map<String, GenerationConfig> _componentConfigs = new HashMap<String, GenerationConfig>();
    Map<String, GenerationConfig> _featuresetConfigs = new HashMap<String, GenerationConfig>();
    DistributionGenerationConfig _distributionConfig;
    DistributionInfoGenerationConfig _distributionInfoConfig;
    private static final String DEFAULT_GEN_PROPERTIES_PATH = "/resources/default_generation.properties";
    private Properties _generationProperties = this.loadDefaultProperties();
    private File _sourceDirectory;

    public MetadataGenerationConfig(String defaultName, File customePropFile, File sourceDirectory) throws BuilderException {
        Properties overridenProps;
        this._sourceDirectory = sourceDirectory;
        if (customePropFile != null && (overridenProps = this.loadOverridePropertiesFile(customePropFile)) != null && !overridenProps.isEmpty()) {
            this._generationProperties.putAll((Map<?, ?>)overridenProps);
        }
        this.createGenerationConfigurations(defaultName);
    }

    public DistributionGenerationConfig getDistributionGenerationConfig() {
        return this._distributionConfig;
    }

    public DistributionInfoGenerationConfig getDistributionInfoGenerationConfig() {
        return this._distributionInfoConfig;
    }

    public Map<String, GenerationConfig> getFeatureSetGenerationConfigs() {
        return this._featuresetConfigs;
    }

    public Map<String, GenerationConfig> getComponentGenerationConfigs() {
        return this._componentConfigs;
    }

    private void createGenerationConfigurations(String defaultName) throws BuilderException {
        HashMap<String, Map<String, String>> componentProps = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> featuresetProps = new HashMap<String, Map<String, String>>();
        HashMap<String, String> distributionProps = new HashMap<String, String>();
        HashMap<String, String> distributionInfoProps = new HashMap<String, String>();
        for (String propertyName : this._generationProperties.stringPropertyNames()) {
            int index = propertyName.indexOf(".");
            if (index == -1) {
                throw new BuilderException("Failure while attempting to create MetadaGenerationConfig. Unrecognized property \"" + propertyName + "\".");
            }
            String genType = propertyName.substring(0, index);
            String keyProperty = propertyName.substring(index + 1);
            String value = this._generationProperties.getProperty(propertyName);
            switch (GenerationType.getGenerationType(genType)) {
                case DISTRIBUTION: {
                    distributionProps.put(keyProperty, value);
                    break;
                }
                case DISTRIBUTION_INFO: {
                    distributionInfoProps.put(keyProperty, value);
                    break;
                }
                case FEATURESET: {
                    this.processProperty(featuresetProps, keyProperty, value);
                    break;
                }
                case COMPONENT: {
                    this.processProperty(componentProps, keyProperty, value);
                    break;
                }
            }
        }
        this._distributionConfig = new DistributionGenerationConfig(defaultName, distributionProps);
        this._distributionInfoConfig = new DistributionInfoGenerationConfig(defaultName, distributionInfoProps);
        this.createConfigurations(componentProps, defaultName, GenerationType.COMPONENT, this._componentConfigs);
        this.createConfigurations(featuresetProps, defaultName, GenerationType.FEATURESET, this._featuresetConfigs);
    }

    private void createConfigurations(Map<String, Map<String, String>> compProps, String defaultName, GenerationType type, Map<String, GenerationConfig> configurations) throws BuilderException {
        for (Map.Entry<String, Map<String, String>> entry : compProps.entrySet()) {
            Map<String, String> props = entry.getValue();
            if (!props.containsKey("isValid")) {
                if (entry.getKey().equals("defaultName")) continue;
                throw new BuilderException("Configuration with id  \"" + entry.getKey() + "\" was not declared properly");
            }
            props.remove("isValid");
            GenerationConfig generationConfig = null;
            if (type.equals((Object)GenerationType.COMPONENT)) {
                generationConfig = new ComponentGenerationConfig(defaultName, props, this._sourceDirectory);
            } else if (type.equals((Object)GenerationType.FEATURESET)) {
                generationConfig = new FeatureSetGenerationConfig(defaultName, props);
            }
            if (generationConfig == null) continue;
            configurations.put(generationConfig.getName() + ":" + generationConfig.getVersion(), generationConfig);
        }
    }

    private void processProperty(Map<String, Map<String, String>> props, String keyProp, String value) throws BuilderException {
        String[] keyValues = keyProp.split("\\.");
        if (keyValues.length == 1) {
            String[] ids;
            if (!keyValues[0].equals("Ids")) {
                throw new BuilderException("Property \"" + keyValues[0] + "\" is not recognized for MetadataGeneration");
            }
            for (String id : ids = value.split("\\,")) {
                if (id.equals("@defaultName@")) {
                    id = "defaultName";
                }
                if (!props.containsKey(id)) {
                    props.put(id, new HashMap());
                }
                props.get(id).put("isValid", id);
            }
        } else if (keyValues.length == 2) {
            String id = keyValues[0];
            String propertyName = keyValues[1];
            if (!props.containsKey(id)) {
                props.put(id, new HashMap());
            }
            Map<String, String> genProps = props.get(id);
            genProps.put(propertyName.toLowerCase(), value);
        }
    }

    private Properties loadDefaultProperties() throws BuilderException {
        Properties properties = null;
        properties = new Properties();
        InputStream is = MetadataGenerationConfig.class.getResourceAsStream(DEFAULT_GEN_PROPERTIES_PATH);
        if (is == null) {
            throw new BuilderException("Unable to locate default component group id properties.");
        }
        try {
            properties.load(is);
        }
        catch (IOException e) {
            throw new BuilderException(e);
        }
        return properties;
    }

    private Properties loadOverridePropertiesFile(File propertiesFile) throws BuilderException {
        _log.fine("Loading properties file: " + propertiesFile.getPath());
        FileInputStream fis = null;
        Properties properties = new Properties();
        try {
            fis = new FileInputStream(propertiesFile.getPath());
            properties.load(fis);
        }
        catch (IOException e) {
            throw new BuilderException("An exception occurred while trying to load properties file: " + propertiesFile.getPath(), e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    _log.fine("An exception occurred while closing properties file: " + propertiesFile.getPath());
                }
            }
        }
        return properties;
    }
}

