/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.generation;

import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.DirectoryBuilder;
import com.oracle.cie.gdr.external.builder.FileBuilder;
import com.oracle.cie.gdr.external.builder.PermissionBuilder;
import com.oracle.cie.gdr.external.builder.impl.DirectoryBuilderImpl;
import com.oracle.cie.gdr.external.builder.impl.FileBuilderImpl;
import com.oracle.cie.gdr.external.builder.impl.PermissionBuilderImpl;
import com.oracle.cie.gdr.generation.GenerationConfig;
import com.oracle.cie.gdr.generation.GenerationProperty;
import com.oracle.cie.gdr.generation.GenerationType;
import com.oracle.cie.gdr.libraries.LibraryType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComponentGenerationConfig
extends GenerationConfig {
    private List<DirectoryBuilder> _directories;
    private List<FileBuilder> _files;

    public ComponentGenerationConfig(String defaultName, Map<String, String> props, File sourceDirectory) throws BuilderException {
        super(defaultName, props, sourceDirectory);
    }

    @Override
    protected GenerationType getGenerationType() {
        return GenerationType.COMPONENT;
    }

    public List<DirectoryBuilder> getDirectories() {
        return this._directories;
    }

    public List<FileBuilder> getFiles() {
        return this._files;
    }

    public String getBootstrap() {
        return this.getGenerationProperty(GenerationProperty.COMPONENT_BOOTSTRAP);
    }

    public String getSingleton() {
        return this.getGenerationProperty(GenerationProperty.COMPONENT_SINGLETON);
    }

    public String getPomGen() {
        return this.getGenerationProperty(GenerationProperty.COMPONENT_POMGEN);
    }

    public String getReplicable() {
        return this.getGenerationProperty(GenerationProperty.COMPONENT_REPLICABLE);
    }

    public String getSymbol() {
        return this.getGenerationProperty(GenerationProperty.COMPONENT_SYMBOL);
    }

    public String getLibraryName() {
        return this.getGenerationProperty(GenerationProperty.COMPONENT_LIBRARY_NAME);
    }

    public String getLibraryType() {
        return this.getGenerationProperty(GenerationProperty.COMPONENT_LIBRARY_TYPE);
    }

    public String getDescription() {
        return this.getGenerationProperty(GenerationProperty.COMPONENT_DESCRIPTION);
    }

    public String getDescriptionKey() {
        return this.getGenerationProperty(GenerationProperty.COMPONENT_DESCRIPTION_KEY);
    }

    public Set<String> getPlatforms() {
        return this.createSetFromString(this.getGenerationProperty(GenerationProperty.COMPONENT_PLATFORMS), ",");
    }

    public Set<String> getLocales() {
        return this.createSetFromString(this.getGenerationProperty(GenerationProperty.COMPONENT_LOCALES), ",");
    }

    public List<String> getStringsubsFiles() {
        return this.createListFromString(this.getGenerationProperty(GenerationProperty.COMPONENT_STRINGSUBS_FILES), ",");
    }

    public List<String> getLibraryEntries() {
        return this.createListFromString(this.getGenerationProperty(GenerationProperty.COMPONENT_LIBRARY_ENTRIES), ",");
    }

    public List<String> getStringsubsChangePairs() {
        return this.createListFromString(this.getGenerationProperty(GenerationProperty.COMPONENT_STRINGSUBS_CHANGE_PAIRS), ",");
    }

    public Map<String, String> getVariables() {
        return this.createMapFromString(this.getGenerationProperty(GenerationProperty.COMPONENT_VARIABLES), ",", ":");
    }

    public Set<String> getPayload() {
        return this.createSetFromString(this.getGenerationProperty(GenerationProperty.COMPONENT_PAYLOAD), ",");
    }

    @Override
    protected String validateGenerationProperty(String property, String value) throws BuilderException {
        String validValue = value.toLowerCase();
        try {
            switch (GenerationProperty.getGenerationProperty(property, this.getGenerationType())) {
                case COMPONENT_REPLICABLE: 
                case COMPONENT_POMGEN: 
                case COMPONENT_BOOTSTRAP: 
                case COMPONENT_SINGLETON: {
                    if (!validValue.matches("true|false")) {
                        throw new BuilderException("Invalid \"" + property + "\" attribute value, a boolean value is expected");
                    }
                    break;
                }
                case COMPONENT_LIBRARY_TYPE: {
                    if (!validValue.matches(LibraryType.none.name().toLowerCase() + "|" + LibraryType.manifest.name().toLowerCase() + "|" + LibraryType.runtime.name().toLowerCase() + "|" + LibraryType.client.name().toLowerCase() + "|" + LibraryType.mergedJar.name().toLowerCase())) {
                        throw new BuilderException("Invalid \"" + property + "\" attribute value. Expected values are: none, runtime, interface, client or mergedjar.");
                    }
                    if (validValue.equalsIgnoreCase("mergedJar")) {
                        validValue = "mergedJar";
                    }
                    break;
                }
                case COMPONENT_STRINGSUBS_CHANGE_PAIRS: {
                    Set<String> substringChangePairs = this.createSetFromString(value, ",");
                    for (String subStringChangePair : substringChangePairs) {
                        if (subStringChangePair.split(":").length == 3) continue;
                        throw new BuilderException("Invalid \"" + property + "\" attribute value format. Expected format is: \"ID_NAME:BEFORE_VALUE:AFTER_VALUE\" ");
                    }
                    validValue = value;
                    break;
                }
                case COMPONENT_PAYLOAD: {
                    this.parsePayload(value);
                    break;
                }
                default: {
                    validValue = value;
                    break;
                }
            }
        }
        catch (BuilderException e) {
            throw new BuilderException("Error while processing COMPONENT property: \n" + property + "=" + value, e);
        }
        return validValue;
    }

    public void setSourceDirectory(File sorceDirectory) {
        this._sourceDirectory = sorceDirectory;
    }

    private void parsePayload(String value) throws BuilderException {
        this._directories = new ArrayList<DirectoryBuilder>();
        this._files = new ArrayList<FileBuilder>();
        if (this._sourceDirectory == null) {
            throw new BuilderException("The source directory cannot be null in order to parse component payload");
        }
        Map<String, Object> payloadMap = this.parsePropertiesToMap(value);
        for (Map.Entry<String, Object> payload : payloadMap.entrySet()) {
            File absolutePayloadFile = new File(this._sourceDirectory, payload.getKey());
            if (!absolutePayloadFile.exists()) {
                throw new BuilderException(" Invalid payload file: \"" + payload + "\". File \"" + absolutePayloadFile.getAbsolutePath() + "\" does not exists");
            }
            if (absolutePayloadFile.isDirectory()) {
                this.parseDirectoryPayload(absolutePayloadFile.getAbsolutePath(), (Map)payload.getValue());
                continue;
            }
            this.parseFilePayload(absolutePayloadFile.getAbsolutePath(), (Map)payload.getValue());
        }
    }

    private void parseFilePayload(String source, Map<String, Object> properties) throws BuilderException {
        FileBuilderImpl file = new FileBuilderImpl();
        file.setSource(source);
        if (properties != null && !properties.isEmpty()) {
            block10: for (Map.Entry<String, Object> property : properties.entrySet()) {
                String[] nameValue = property.getKey().split(":");
                if (nameValue.length != 2) {
                    throw new BuilderException("Invalid property payload format: \"" + property.getKey() + "\". Expected format: property:value");
                }
                switch (nameValue[0].toLowerCase()) {
                    case "dest": {
                        file.setDest(nameValue[1]);
                        continue block10;
                    }
                    case "mode": {
                        file.setMode(nameValue[1]);
                        continue block10;
                    }
                    case "os-family": {
                        file.setOsFamiliy(nameValue[1]);
                        continue block10;
                    }
                }
                throw new BuilderException("Unrecognized payload property: \"" + property.getKey() + "\" ");
            }
        }
        this._files.add(file);
    }

    private void parseDirectoryPayload(String source, Map<String, Object> properties) throws BuilderException {
        DirectoryBuilderImpl directory = new DirectoryBuilderImpl();
        directory.setSource(source);
        if (properties != null && !properties.isEmpty()) {
            block8: for (Map.Entry<String, Object> property : properties.entrySet()) {
                String[] nameValue = property.getKey().split(":");
                switch (nameValue[0].toLowerCase()) {
                    case "dest": {
                        directory.setDest(nameValue[1]);
                        continue block8;
                    }
                    case "file-perms": {
                        ArrayList<PermissionBuilder> permListBuilder = new ArrayList<PermissionBuilder>();
                        this.parseFilePerms((Map)property.getValue(), permListBuilder);
                        directory.setPermissionBuilder(permListBuilder);
                        continue block8;
                    }
                }
                throw new BuilderException("Unrecognized payload property: \"" + property.getKey() + "\" ");
            }
        }
        this._directories.add(directory);
    }

    private void parseFilePerms(Map<String, Object> properties, List<PermissionBuilder> permListBuilder) throws BuilderException {
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                PermissionBuilderImpl permBuilder = new PermissionBuilderImpl("");
                block11: for (String attValue : property.getKey().split(",")) {
                    String[] nameValue = attValue.split(":");
                    if (nameValue.length != 2) {
                        throw new BuilderException("Invalid file-perms declaration:\"" + property.getKey() + "\".Expected format: \"PropertyName:Value\"");
                    }
                    switch (nameValue[0].toLowerCase()) {
                        case "mode": {
                            permBuilder.setMode(nameValue[1]);
                            continue block11;
                        }
                        case "match-dirs": {
                            permBuilder.setMatchDirs(Boolean.valueOf(nameValue[1]));
                            continue block11;
                        }
                        case "regex": {
                            permBuilder.setRegex(nameValue[1]);
                            continue block11;
                        }
                        default: {
                            throw new BuilderException("Unrecognized  property for file-perms: \"" + property.getKey() + "\" ");
                        }
                    }
                }
                permListBuilder.add(permBuilder);
            }
        }
    }
}

