/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureReference;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.impl.FeatureSetImpl;
import com.oracle.cie.gdr.external.impl.InventoryCache;
import com.oracle.cie.gdr.external.impl.RepositoryComponentImpl;
import com.oracle.cie.gdr.repository.RepositoryProcessor;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.rest.Repository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class RepositoryFeatureSetImpl
extends FeatureSetImpl
implements FeatureSet {
    private String _name;
    private String _version;
    private RepositoryProcessor _repositoryProcessor;
    private RepositoryVersionResolver _versionResolver;
    private Repository _repository;

    private RepositoryFeatureSetImpl(com.oracle.cie.gdr.dao.ftr.FeatureSet feature, RepositoryProcessor repositoryProcessor, RepositoryVersionResolver versionResolver, Repository repository) throws InventoryException {
        this._featureSet = feature;
        this._repositoryProcessor = repositoryProcessor;
        this._versionResolver = versionResolver;
        this._repository = repository;
    }

    private RepositoryFeatureSetImpl(String name, String version, RepositoryProcessor repositoryProcessor, RepositoryVersionResolver versionResolver, Repository repository) throws InventoryException {
        this._name = name;
        this._version = version;
        this._repositoryProcessor = repositoryProcessor;
        this._versionResolver = versionResolver;
        this._repository = repository;
        this.loadFeature();
    }

    static RepositoryFeatureSetImpl newInstance(String name, String version, RepositoryProcessor repositoryProcessor, RepositoryVersionResolver versionResolver, Repository repository) throws InventoryException {
        return new RepositoryFeatureSetImpl(name, version, repositoryProcessor, versionResolver, repository);
    }

    static RepositoryFeatureSetImpl newInstance(com.oracle.cie.gdr.dao.ftr.FeatureSet feature, RepositoryProcessor repositoryProcessor, RepositoryVersionResolver versionResolver, Repository repository) throws InventoryException {
        return new RepositoryFeatureSetImpl(feature, repositoryProcessor, versionResolver, repository);
    }

    private void loadFeature() throws InventoryException {
        if (this._featureSet == null) {
            try {
                Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> features = this._repositoryProcessor.getFeatures(new LinkedHashSet<FeatureSetReference>(Arrays.asList(new FeatureSetReference(this._name, this._version))), false, false);
                if (features == null || features.isEmpty()) {
                    throw new InventoryException();
                }
                this._featureSet = features.iterator().next();
            }
            catch (Exception anyException) {
                throw new InventoryException(anyException);
            }
        }
    }

    @Override
    public List<Component> getComponents() throws InventoryException {
        ArrayList<Component> components = new ArrayList<Component>();
        for (ComponentReference compRef : this._featureSet.getComponentReferences()) {
            components.add(RepositoryComponentImpl.newInstance(compRef.getName(), compRef.getVersion(), this._repositoryProcessor, this._versionResolver));
        }
        return components;
    }

    @Override
    public List<FeatureSet> getCompatibleFeatures() throws InventoryException {
        LinkedHashSet<FeatureSetReference> featureSetRefs = new LinkedHashSet<FeatureSetReference>();
        for (FeatureReference ftrRef : this._featureSet.getCompatibleFeatures()) {
            featureSetRefs.add(new FeatureSetReference(ftrRef.getName(), ftrRef.getVersion()));
        }
        try {
            return RepositoryFeatureSetImpl.getFeatureSetsFromSet(this._repositoryProcessor.getFeatures(featureSetRefs), this._repositoryProcessor, this._versionResolver, this._repository);
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
    }

    static List<FeatureSet> getFeatureSetsFromSet(Collection<com.oracle.cie.gdr.dao.ftr.FeatureSet> featureSets, RepositoryProcessor repositoryProcessor, RepositoryVersionResolver versionResolver, Repository repository) throws InventoryException {
        ArrayList<FeatureSet> featureSetsWrappers = new ArrayList<FeatureSet>();
        for (com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet : featureSets) {
            String featureName = featureSet.getName();
            String featureVersion = featureSet.getVersion();
            FeatureSet cachedFeatureSet = InventoryCache.getInstance().getFeatureSet(repository, featureName, featureVersion);
            if (null == cachedFeatureSet) {
                cachedFeatureSet = RepositoryFeatureSetImpl.newInstance(featureSet, repositoryProcessor, versionResolver, repository);
                InventoryCache.getInstance().putFeatureSet(repository, cachedFeatureSet);
            }
            featureSetsWrappers.add(cachedFeatureSet);
        }
        return featureSetsWrappers;
    }
}

