/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.impl.ArtifactImpl;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.Patch;
import com.oracle.cie.gdr.external.impl.ComponentImpl;
import com.oracle.cie.gdr.repository.RepositoryProcessor;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class RepositoryComponentImpl
extends ComponentImpl
implements Component {
    private RepositoryProcessor _repositoryProcessor;
    private RepositoryVersionResolver _versionResolver;

    private RepositoryComponentImpl(com.oracle.cie.gdr.dao.cpd.Component component) throws InventoryException {
        this._component = component;
    }

    private RepositoryComponentImpl(String name, String version, RepositoryProcessor repositoryProcessor, RepositoryVersionResolver versionResolver) throws InventoryException {
        this._name = name;
        this._version = version;
        this._repositoryProcessor = repositoryProcessor;
        this._versionResolver = versionResolver;
    }

    static RepositoryComponentImpl newInstance(String name, String version, RepositoryProcessor repositoryProcessor, RepositoryVersionResolver versionResolver) throws InventoryException {
        return new RepositoryComponentImpl(name, version, repositoryProcessor, versionResolver);
    }

    static RepositoryComponentImpl newInstance(com.oracle.cie.gdr.dao.cpd.Component component) throws InventoryException {
        return new RepositoryComponentImpl(component);
    }

    @Override
    protected void loadComponent() throws InventoryException {
        if (this._component == null) {
            try {
                LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
                artifacts.add((Artifact)new ArtifactImpl("com.oracle.cie.gdr.carb", this._name, this._versionResolver.getComponentArchiveVersion(this._name, this._version), "carb"));
                Set<com.oracle.cie.gdr.dao.cpd.Component> components = this._repositoryProcessor.getComponents(artifacts);
                if (components == null || components.isEmpty()) {
                    throw new InventoryException("The component can not be loaded from the repository.");
                }
                this._component = components.iterator().next();
            }
            catch (Exception anyException) {
                throw new InventoryException(anyException);
            }
        }
    }

    @Override
    public Set<File> getProductDirs() throws InventoryException {
        return null;
    }

    @Override
    public List<Patch> getPatches() throws InventoryException {
        return null;
    }
}

