/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.common.SecureUnmarshaller;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.gdr.aru.ARUResult;
import com.oracle.cie.gdr.aru.PatchDownloadQuery;
import com.oracle.cie.gdr.aru.PatchQuery;
import com.oracle.cie.gdr.aru.PatchType;
import com.oracle.cie.gdr.aru.QueryGenerator;
import com.oracle.cie.gdr.dao.di.Patch;
import com.oracle.cie.gdr.dao.pmd.PatchMetadata;
import com.oracle.cie.gdr.external.ARUPatchMetadata;
import com.oracle.cie.gdr.external.impl.ARUConfiguration;
import com.oracle.cie.gdr.external.impl.ARUDownloadProgressHolder;
import com.oracle.cie.gdr.external.impl.ARUPatchMetadataImpl;
import com.oracle.cie.gdr.helpers.PatchHelper;
import com.oracle.cie.gdr.helpers.PatchMetadataHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.rest.impl.RestConnection;
import com.oracle.cie.rest.impl.RestQuery;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class PatchDownloader {
    private static final Logger _log = Logger.getLogger(PatchDownloader.class.getName());
    private static final PatchDownloader _instance = new PatchDownloader();
    private RestConnection _restConnectionInstance = RestConnection.getInstance();
    private final int MAX_DOWNLOAD_ATTEMPTS = 3;
    private final String AVAILABLE_STATUS = "available";

    private PatchDownloader() {
    }

    public static PatchDownloader getInstance() {
        return _instance;
    }

    public boolean verifyConnection(ARUConfiguration configuration) {
        RestQuery query = QueryGenerator.getInstance().generateQuery(1);
        return this._restConnectionInstance.getInputstream(query, configuration.getRestConfiguration()) != null;
    }

    public List<ARUPatchMetadata> getAvailablePatches(List<Patch> patches, Set<Integer> platforms, ARUConfiguration configuration) throws GdrException {
        if (!PatchDownloader.getInstance().verifyConnection(configuration)) {
            throw new GdrException("MOS connection failed.");
        }
        ArrayList<ARUPatchMetadata> ARUPatches = new ArrayList<ARUPatchMetadata>();
        for (Integer platform : platforms) {
            ARUPatches.addAll(this.retrievePatchesFromARU(patches, platform, configuration));
        }
        return ARUPatches;
    }

    private List<ARUPatchMetadata> retrievePatchesFromARU(List<Patch> patchInfos, int platform, ARUConfiguration configuration) {
        ArrayList<ARUPatchMetadata> patches = new ArrayList<ARUPatchMetadata>();
        ArrayList<ARUPatchMetadataImpl> patchesFromMetadata = new ArrayList<ARUPatchMetadataImpl>();
        PatchMetadata patchMetadataXML = null;
        for (Patch patchInfo : patchInfos) {
            _log.info("Analyzing bug Id " + patchInfo.getId() + ".");
            int aruId = PlatformInfoHelper.getInstance().getPlatformInfoHolder(platform).getARUId();
            ArrayList<ARUPatchMetadataImpl> tmpPatches = new ArrayList<ARUPatchMetadataImpl>();
            List<PatchType> patchesInARU = this.getPatchesFromBug(patchInfo.getId(), aruId, patchInfo.getRelease(), configuration);
            boolean foundPatchMetadata = false;
            for (PatchType patch : patchesInARU) {
                ARUPatchMetadataImpl patchMetadata = new ARUPatchMetadataImpl(patch);
                _log.info("Searching for patch-metadada.xml...");
                this.downloadPatch(patchMetadata, configuration, new ARUDownloadProgressHolder());
                Path zipFile = NioHelper.getInstance().getPath(configuration.getDownloadLocation(), new String[0]).resolve(patchMetadata.getFileName());
                try {
                    PatchHelper.getInstance().extractPatch(zipFile.toFile(), zipFile.getParent().toFile());
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(zipFile.getParent());){
                        for (Path path : directoryStream) {
                            if (!path.getFileName().toString().contains(".xml")) continue;
                            try {
                                foundPatchMetadata = true;
                                patchMetadataXML = PatchMetadataHelper.getInstance().getPatchMetadata(path.toFile());
                                _log.info("Found patch-metadada.xml in bug Id " + patchMetadata.getBug());
                                for (com.oracle.cie.gdr.dao.pmd.Patch pch : patchMetadataXML.getPatches().getPatchList()) {
                                    if (!patchInfo.getRelease().contains(pch.getRelease()) || pch.getARUPlatformId() != platform && pch.getARUPlatformId() != 289) continue;
                                    for (PatchType patchResult : this.getPatchesFromBug(pch.getId(), pch.getARUPlatformId(), pch.getRelease(), configuration)) {
                                        ARUPatchMetadataImpl aruPatch = new ARUPatchMetadataImpl(patchResult);
                                        aruPatch.setBootstrap(pch.isBootstrap());
                                        aruPatch.setComponents(pch.getComponents());
                                        aruPatch.setDescription(pch.getDescription());
                                        patchesFromMetadata.add(aruPatch);
                                    }
                                }
                            }
                            catch (DataHandlerException | GdrException | IOException e) {
                                _log.warning("The patch-metadata.xml was invalid. File name:" + patchMetadata.getFileName() + " Bug Id:" + patchMetadata.getBug());
                                _log.throwing("PatchDownloaderImpl", "retrievePatchesFromARU", e);
                            }
                        }
                    }
                    catch (IOException ex) {
                        _log.warning("An I/O Exception occurred while trying to read directory: " + zipFile.getParent() + ". File name:" + patchMetadata.getFileName() + " Bug Id:" + patchMetadata.getBug());
                    }
                    NioDelete.delete((Path)zipFile);
                    if (foundPatchMetadata) {
                        if (!patchesFromMetadata.isEmpty()) continue;
                        _log.info("No patches found in patch-metadata.xml.");
                        continue;
                    }
                    _log.info("No patch-metadata.xml found in bug Id " + patchMetadata.getBug());
                    tmpPatches.add(patchMetadata);
                }
                catch (GdrException e1) {
                    _log.info("There was a problem extracting patch " + patchMetadata.getFileName());
                }
            }
            if (foundPatchMetadata) {
                if (patchMetadataXML != null) {
                    try {
                        PatchMetadataHelper.getInstance().save((IDataHandlerWrapper)patchMetadataXML, NioHelper.getInstance().getPath(configuration.getDownloadLocation(), new String[0]).resolve("patch-metadata.xml"));
                    }
                    catch (DataHandlerException e) {
                        _log.warning("Unable to save patch-metadata.xml under download location due error:" + e.getMessage());
                    }
                }
                patches.addAll(patchesFromMetadata);
                break;
            }
            patches.addAll(tmpPatches);
        }
        return patches;
    }

    private List<PatchType> getPatchesFromBug(String bugId, int platform, String release, ARUConfiguration configuration) {
        ArrayList<PatchType> patches = new ArrayList<PatchType>();
        PatchQuery query = (PatchQuery)QueryGenerator.getInstance().generateQuery(1);
        query.addParameter("bug", bugId);
        query.addParameter("platform", String.valueOf(platform));
        try (InputStream is = this._restConnectionInstance.getInputstream((RestQuery)query, configuration.getRestConfiguration());){
            _log.info("Retrieving patches in bug Id " + bugId + ".");
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ARUResult.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ARUResult result = (ARUResult)SecureUnmarshaller.unmarshal((Unmarshaller)unmarshaller, (InputStream)is);
            if (result.getError() == null) {
                for (PatchType patch : result.getPatch()) {
                    if (!patch.getStatus().equals("available") || release != null && !release.equals(patch.getRelease())) continue;
                    _log.info("Found patch: " + patch.getPatchId() + " - " + patch.getAbstract());
                    patches.add(patch);
                }
            } else {
                _log.warning("Query returned error " + result.getError().getId() + ": " + result.getError().getMessage());
            }
        }
        catch (IOException | JAXBException e) {
            _log.warning("There was a problem retrieving patches in bug Id " + bugId);
            _log.throwing("PatchDownloaderImpl", "getPatchesFromBug", e);
        }
        return patches;
    }

    public boolean downloadPatch(ARUPatchMetadata patch, ARUConfiguration configuration, ARUDownloadProgressHolder progressHolder) {
        _log.info("Downloading Patch " + patch.getFileName());
        int downloadAttempts = 0;
        do {
            PatchDownloadQuery dQuery = (PatchDownloadQuery)QueryGenerator.getInstance().generateQuery(2);
            dQuery.addRawPath(patch.getPatchUrl(), true);
            try {
                if (this.downloadPatch(dQuery, patch.getSize().longValue(), configuration, progressHolder)) {
                    _log.info("Patch " + patch.getPatchId() + " successfully downloaded.");
                    return true;
                }
                _log.warning("Attempt number " + ++downloadAttempts + " failed for download patch file " + dQuery.getFileName());
            }
            catch (Exception e) {
                ++downloadAttempts;
                _log.warning("There was a problem while downloading patch " + patch.toString());
                _log.warning(e.getMessage());
            }
        } while (downloadAttempts < 3);
        _log.warning("Download for patch " + patch.getBug() + " failed.");
        return false;
    }

    private boolean downloadPatch(PatchDownloadQuery dQuery, long patchSize, ARUConfiguration configuration, ARUDownloadProgressHolder progressHolder) throws Exception {
        String fullFileName = this._restConnectionInstance.downloadFile((RestQuery)dQuery, dQuery.getFileName(), configuration.getRestConfiguration(), progressHolder.getDownloadProgressStatusHolder());
        Path patchFile = NioHelper.getInstance().getPath(fullFileName, new String[0]);
        return Files.exists(patchFile, new LinkOption[0]) && Files.size(patchFile) == patchSize;
    }
}

