/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.external.LibraryGenerator;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.HomeHelper;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.installation.RegenInstallerWrapper;
import com.oracle.cie.gdr.libraries.LibraryException;
import com.oracle.cie.gdr.libraries.LibraryProcessor;
import com.oracle.cie.gdr.libraries.LibraryProcessorManager;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.maven.PomProcessor;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.patch.PatchHandlerFactory;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.inputs.apis.Inputs;
import com.oracle.cie.nextgen.common.inputs.apis.Option;
import com.oracle.cie.nextgen.common.inputs.helpers.InputHandler;
import com.oracle.cie.nextgen.common.inputs.impl.InputHandlerException;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LibraryGeneratorImpl
implements LibraryGenerator {
    private static final Logger _log = Logger.getLogger(LibraryGeneratorImpl.class.getName());
    private String _logPath;
    private FileHandler _handler;
    private Path _oracleHome;
    private Map<Distribution, Set<FeatureSet>> _featureSetsToAdd = new HashMap<Distribution, Set<FeatureSet>>();
    private Map<Distribution, Map<FeatureSet, Set<Component>>> _extraComponents = new HashMap<Distribution, Map<FeatureSet, Set<Component>>>();

    public LibraryGeneratorImpl(File oracleHome) {
        this(NioHelper.getInstance().getPath(oracleHome));
    }

    public LibraryGeneratorImpl(Path oracleHome) {
        this._oracleHome = oracleHome;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss-a");
        Path logParent = oracleHome.toAbsolutePath().resolve("cfgtoollogs").resolve("oui");
        if (!Files.exists(logParent, new LinkOption[0])) {
            try {
                Files.createDirectories(logParent, new FileAttribute[0]);
            }
            catch (IOException e) {
                _log.log(Level.SEVERE, "Unable to create path " + logParent, e);
            }
        }
        this._logPath = logParent.resolve("libraryRegeneration" + df.format(new Date()) + ".log").toString();
        _log.setLevel(Level.FINEST);
    }

    public void configureLog() {
        try {
            this._handler = new FileHandler(this._logPath);
            SimpleFormatter formatterTxt = new SimpleFormatter();
            this._handler.setFormatter(formatterTxt);
            _log.addHandler(this._handler);
        }
        catch (Exception e) {
            _log.fine("Unable to configure the log");
        }
    }

    public void closeLog() {
        if (this._handler != null) {
            _log.removeHandler(this._handler);
            this._handler.close();
        }
    }

    @Override
    public String getLogFile() {
        return this._logPath;
    }

    @Override
    public Set<File> queryLibraries(Map<File, Set<String>> modifiedFiles) throws LibraryException {
        return this.queryLibraries(modifiedFiles, false);
    }

    @Override
    public Set<Path> queryLibraryPaths(Map<Path, Set<String>> modifiedFiles) throws LibraryException {
        return this.queryLibraryPaths(modifiedFiles, false);
    }

    @Override
    public Set<File> queryLibraries(Map<File, Set<String>> modifiedFiles, boolean processInventoryPatches) throws LibraryException {
        HashMap<Path, Set<String>> modifiedFilePaths = new HashMap<Path, Set<String>>();
        for (File file : modifiedFiles.keySet()) {
            Set<String> value = modifiedFiles.get(file);
            modifiedFilePaths.put(Paths.get(file.toString(), new String[0]), value);
        }
        Set<Path> paths = this.queryLibraryPaths(modifiedFilePaths, processInventoryPatches);
        HashSet<File> files = new HashSet<File>();
        for (Path path : paths) {
            files.add(path.toFile());
        }
        return files;
    }

    @Override
    public Set<Path> queryLibraryPaths(Map<Path, Set<String>> modifiedFiles, boolean processInventoryPatches) throws LibraryException {
        Set<Path> sourceFiles;
        this.processLibraryQuery(modifiedFiles, processInventoryPatches);
        HashSet<Path> filesToRegenerate = new HashSet<Path>();
        Set<Path> singleFiles = RegenerationHelper.getInstance().getFilesToRegenerate();
        if (singleFiles != null && !singleFiles.isEmpty()) {
            filesToRegenerate.addAll(singleFiles);
        }
        if ((sourceFiles = RegenerationHelper.getInstance().getSourceFilesToRegenerate().keySet()) != null && !sourceFiles.isEmpty()) {
            filesToRegenerate.addAll(sourceFiles);
        }
        return filesToRegenerate;
    }

    @Override
    public Map<Path, Set<Path>> queryLibrarySource(Set<Path> modifiedFilePaths) throws LibraryException {
        return this.processLibraryQuery(modifiedFilePaths, true);
    }

    @Override
    public Map<Path, Set<Path>> queryLibrarySource(Set<Path> modifiedFilePaths, Set<Path> modifiedCompPaths) throws LibraryException {
        Map<Path, Set<Path>> sourceMap;
        HashSet<Path> createdFiles = new HashSet<Path>();
        String fileSeparator = "/";
        try {
            if (modifiedCompPaths != null && !modifiedCompPaths.isEmpty()) {
                String separator = "inventory" + fileSeparator + "Components" + fileSeparator;
                for (Path compPath : modifiedCompPaths) {
                    if (compPath.isAbsolute()) {
                        String absolutePath = FileUtils.formatPath(compPath.toString(), fileSeparator);
                        String[] pathParts = absolutePath.split(separator);
                        if (pathParts.length != 2) {
                            throw new LibraryException("Could not parse component path: " + compPath);
                        }
                        Path compPathDest = this._oracleHome.resolve("inventory").resolve("Components").resolve(pathParts[1]);
                        if (Files.exists(compPathDest.getParent().getParent().getParent().resolve("compDef.xml"), new LinkOption[0])) {
                            _log.info("Copying component patch file to " + compPathDest);
                            Files.createDirectories(compPathDest.getParent(), new FileAttribute[0]);
                            Files.copy(compPath, compPathDest, StandardCopyOption.REPLACE_EXISTING);
                            createdFiles.add(compPathDest);
                            continue;
                        }
                        _log.info("Ignoring component patch file " + compPathDest + " since component is not installed.");
                        continue;
                    }
                    throw new LibraryException("Provided modified component path was not absolute: " + compPath);
                }
            }
            sourceMap = this.queryLibrarySource(modifiedFilePaths);
        }
        catch (IOException e) {
            throw new LibraryException(e);
        }
        finally {
            block25: {
                try {
                    if (createdFiles.isEmpty()) break block25;
                    for (Path createdFile : createdFiles) {
                        Files.deleteIfExists(createdFile);
                        Path patchDir = createdFile.getParent();
                        DirectoryStream<Path> dirStream = Files.newDirectoryStream(patchDir);
                        try {
                            if (dirStream.iterator().hasNext()) continue;
                            Files.delete(patchDir);
                        }
                        finally {
                            if (dirStream == null) continue;
                            dirStream.close();
                        }
                    }
                    this.processInventoryPatches();
                }
                catch (GdrException | IOException e) {
                    throw new LibraryException(e);
                }
            }
        }
        return sourceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Path, Set<Path>> queryLibraryRollbackSource(Set<Path> modifiedFilePaths, Set<String> patchUPIs) throws LibraryException {
        Map<Path, Set<Path>> sourceMap;
        try {
            RegenerationHelper.getInstance().rollBackMetadata(this._oracleHome, patchUPIs);
            sourceMap = this.processLibraryQuery(modifiedFilePaths, false);
        }
        finally {
            try {
                RegenerationHelper.getInstance().restorePatchRollbackBackupPaths();
                this.processInventoryPatches();
            }
            catch (GdrException | IOException e) {
                throw new LibraryException("Failed to restore backup metadata patches.", e);
            }
        }
        return sourceMap;
    }

    private Map<Path, Set<Path>> processLibraryQuery(Set<Path> modifiedFilePaths, boolean processInventoryPatches) throws LibraryException {
        try {
            HashSet modifiedClasses = new HashSet();
            HashMap<Path, Set<String>> modifiedFilesMap = new HashMap<Path, Set<String>>();
            for (Path modifiedFile : modifiedFilePaths) {
                modifiedFilesMap.put(modifiedFile, modifiedClasses);
            }
            this.processLibraryQuery(modifiedFilesMap, processInventoryPatches);
            return RegenerationHelper.getInstance().getSourceFilesToRegenerate();
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    private void processLibraryQuery(Map<Path, Set<String>> modifiedFiles, boolean processInventoryPatches) throws LibraryException {
        try {
            RegenerationHelper.setUp(modifiedFiles, true, null);
            if (processInventoryPatches) {
                this.processInventoryPatches();
            }
            this.regenerateLibrary();
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    @Override
    public boolean regenerateLibrary(Map<File, Set<String>> modifiedFiles, String patchID) throws LibraryException {
        return this.regenerateLibrary(modifiedFiles, patchID, true);
    }

    @Override
    public boolean regenerateLibraryPaths(Map<Path, Set<String>> modifiedFiles, String patchID) throws LibraryException {
        return this.regenerateLibraryPaths(modifiedFiles, patchID, true);
    }

    @Override
    public boolean regenerateLibrary(Map<File, Set<String>> modifiedFiles, String patchID, boolean processInventoryPatches) throws LibraryException {
        HashMap<Path, Set<String>> modifiedFilePaths = new HashMap<Path, Set<String>>();
        for (File file : modifiedFiles.keySet()) {
            Set<String> value = modifiedFiles.get(file);
            modifiedFilePaths.put(Paths.get(file.toString(), new String[0]), value);
        }
        return this.regenerateLibraryPaths(modifiedFilePaths, patchID, processInventoryPatches);
    }

    @Override
    public boolean regenerateLibraryPaths(Map<Path, Set<String>> modifiedFiles, String patchID, boolean processInventoryPatches) throws LibraryException {
        return this.regenerateLibrary(modifiedFiles, patchID, null, processInventoryPatches);
    }

    @Override
    public boolean regenerateLibrary(Map<File, Set<String>> modifiedFiles, String patchID, String targetLibraryTypes) throws LibraryException {
        HashMap<Path, Set<String>> modifiedFilePaths = new HashMap<Path, Set<String>>();
        for (File file : modifiedFiles.keySet()) {
            Set<String> value = modifiedFiles.get(file);
            modifiedFilePaths.put(Paths.get(file.toString(), new String[0]), value);
        }
        return this.regenerateLibraryPaths(modifiedFilePaths, patchID, targetLibraryTypes);
    }

    @Override
    public boolean regenerateLibraryPaths(Map<Path, Set<String>> modifiedFiles, String patchID, String targetLibraryTypes) throws LibraryException {
        return this.regenerateLibrary(modifiedFiles, patchID, targetLibraryTypes, true);
    }

    public boolean regenerateLibrary(Map<Path, Set<String>> modifiedFiles, String patchID, String targetLibraryTypes, boolean processInventoryPatches) throws LibraryException {
        this.configureLog();
        try {
            if (!modifiedFiles.isEmpty()) {
                RegenerationHelper.setUp(modifiedFiles, false, targetLibraryTypes);
                if (processInventoryPatches) {
                    this.processInventoryPatches();
                }
                this.regenerateLibrary();
                _log.info("Successfully regenerated libraries.");
            } else {
                _log.info("Modified files is empty, there are no libraries to be regenerated.");
            }
        }
        catch (Exception e) {
            _log.fine("Library regeneration failed.");
            if (processInventoryPatches && !StringUtil.isNullOrEmpty((String)patchID, (boolean)true)) {
                RegenerationHelper.getInstance().rollBackMetadata(this._oracleHome, patchID);
            }
            LibraryException libraryException = new LibraryException(e);
            _log.throwing(this.getClass().getName(), "regenerateLibrary", (Throwable)((Object)libraryException));
            throw libraryException;
        }
        finally {
            this.closeLog();
        }
        return true;
    }

    public void regenerateLibraries() throws LibraryException {
        if (RegenerationHelper.hasModifiedMetaData()) {
            try {
                this.regenerateLibrary();
            }
            catch (LibraryException e) {
                _log.throwing(this.getClass().getName(), "regenerateLibraries", (Throwable)((Object)e));
                throw e;
            }
        }
    }

    public void processInventoryPatches() throws GdrException {
        PatchHandlerFactory.getPatchHandler(this._oracleHome).processUpdatePatch("unknown", false, RegenerationHelper.getInstance());
    }

    public static Set<FeatureSet> getInstalledFeatures(Home home) throws GdrException {
        ArrayList<FeatureSet> installed = new ArrayList<FeatureSet>();
        ArrayList<FeatureSet> copied = new ArrayList<FeatureSet>();
        Collection<DistributionTarget> installedDists = home.getInstalledDistributions();
        if (installedDists != null && !installedDists.isEmpty()) {
            for (DistributionTarget target : installedDists) {
                for (FeatureSet featureSet : target.getInstalledFeatureSets()) {
                    int index = installed.indexOf(featureSet);
                    if (index > -1) {
                        Collection<FeatureSet> upgrades;
                        if (!featureSet.isUpgrades()) continue;
                        FeatureSet existing = (FeatureSet)installed.get(index);
                        if (!copied.contains(existing)) {
                            FeatureSet copy = existing.copy();
                            copied.add(copy);
                            installed.remove(index);
                            installed.add(copy);
                            existing = copy;
                        }
                        if ((upgrades = featureSet.getUpgrades()) != null) {
                            for (FeatureSet upgraded : upgrades) {
                                existing.addUpgrades(upgraded);
                            }
                        }
                        if ((upgrades = featureSet.getUpgradesInHome()) == null) continue;
                        for (FeatureSet upgraded : upgrades) {
                            existing.addUpgradesInHome(upgraded);
                        }
                        continue;
                    }
                    installed.add(featureSet);
                }
            }
        }
        return new HashSet<FeatureSet>(installed);
    }

    public void addFeatureSetToAdd(Distribution dist, FeatureSet feature) {
        if (!this._featureSetsToAdd.containsKey(dist)) {
            HashSet<FeatureSet> features = new HashSet<FeatureSet>();
            features.add(feature);
            this._featureSetsToAdd.put(dist, features);
        } else {
            this._featureSetsToAdd.get(dist).add(feature);
        }
    }

    public void addExtraComponents(Distribution dist, Map<FeatureSet, Set<Component>> components) {
        if (!this._extraComponents.containsKey(dist)) {
            this._extraComponents.put(dist, components);
        } else {
            this._extraComponents.get(dist).putAll(components);
        }
    }

    private void regenerateLibrary() throws LibraryException {
        try {
            Map<FeatureSet, LibraryTargetHolder> libraryTargets;
            Home oraHome = Home.getHome(this._oracleHome);
            ServiceHolder serviceHolder = new ServiceHolder();
            LinkedHashMap<DistributionTarget, Map<FeatureSet, LibraryTargetHolder>> distributionLibraryTargets = new LinkedHashMap<DistributionTarget, Map<FeatureSet, LibraryTargetHolder>>();
            final LinkedHashMap<FeatureSet, LibraryTargetHolder> globalLibraryTargets = new LinkedHashMap<FeatureSet, LibraryTargetHolder>();
            HashMap<FeatureSet, Collection<Component>> globalComponents = new HashMap<FeatureSet, Collection<Component>>();
            FeatureSetHelper featureHelper = FeatureSetHelper.getInstance(oraHome.getClassLoader());
            for (DistributionTarget dist : oraHome.getInstalledDistributions()) {
                Map<FeatureSet, Collection<Component>> installedComponents = HomeHelper.getInstalledComponents(dist, serviceHolder, oraHome.getMetaDataHome());
                if (this._extraComponents.containsKey(dist.getDistribution()) && !this._extraComponents.get(dist.getDistribution()).isEmpty()) {
                    installedComponents.putAll(this._extraComponents.get(dist.getDistribution()));
                }
                Set<FeatureSet> installedFeaturesets = HomeHelper.getInstalledFeaturesets(dist, featureHelper, LibraryGeneratorImpl.getInstalledFeatures(oraHome));
                for (Map.Entry<Distribution, Set<FeatureSet>> entry : this._featureSetsToAdd.entrySet()) {
                    if (!entry.getKey().getName().equals(dist.getDistributionName()) || entry.getValue().isEmpty()) continue;
                    installedFeaturesets.addAll((Collection<FeatureSet>)entry.getValue());
                }
                Set<FeatureSet> externalDummyFeatures = null;
                if (oraHome.isFederatedHome()) {
                    externalDummyFeatures = HomeHelper.getExternalDummyFeatures(oraHome.getInstalledDistributions());
                }
                libraryTargets = featureHelper.getLibraryTargets(installedFeaturesets, externalDummyFeatures, oraHome, installedComponents, serviceHolder, dist.getDirectoryMap());
                distributionLibraryTargets.put(dist, libraryTargets);
                for (Map.Entry<FeatureSet, LibraryTargetHolder> entry : libraryTargets.entrySet()) {
                    if (globalLibraryTargets.containsKey(entry.getKey()) && (entry.getValue() == null || entry.getValue().getLibraryKeys() == null || entry.getValue().getLibraryKeys().isEmpty())) continue;
                    globalLibraryTargets.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<FeatureSet, Object> entry : installedComponents.entrySet()) {
                    if (globalComponents.containsKey(entry.getKey()) && (entry.getValue() == null || ((Collection)entry.getValue()).isEmpty())) continue;
                    globalComponents.put(entry.getKey(), (Collection)entry.getValue());
                }
            }
            RegenInstallerWrapper installerWrapper = new RegenInstallerWrapper(oraHome){

                @Override
                public Map<FeatureSet, LibraryTargetHolder> getLibraryTargets() throws GdrException, DataHandlerException, DependencyException, IOException {
                    return globalLibraryTargets;
                }
            };
            installerWrapper.addMetadataCache(globalComponents);
            boolean globalPomGen = false;
            for (Map.Entry entry : distributionLibraryTargets.entrySet()) {
                boolean distPomGen = ((DistributionTarget)entry.getKey()).getDistribution().hasPomGen();
                libraryTargets = (Map<FeatureSet, LibraryTargetHolder>)entry.getValue();
                if (libraryTargets == null || libraryTargets.isEmpty()) continue;
                FeatureSelectionTarget selectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(((DistributionTarget)entry.getKey()).getFeatureSets(), null);
                for (FeatureSet feature : selectionTarget.getOrderedItems()) {
                    if (!feature.getStatus().isInstalled()) continue;
                    LibraryTargetHolder holder = libraryTargets.get(feature);
                    if (holder == null) {
                        throw new LibraryException("Library target holder for feature set did not exist " + feature);
                    }
                    LibraryProcessor.process(holder, oraHome, installerWrapper, Mode.DEINSTALL);
                    if (distPomGen) {
                        globalPomGen = true;
                        PomProcessor.process(feature, installerWrapper, selectionTarget, Mode.DEINSTALL, ((DistributionTarget)entry.getKey()).getDirectoryMap(), holder, true);
                        continue;
                    }
                    _log.info("POM generation for distribution " + ((DistributionTarget)entry.getKey()).getDistribution() + " has been disabled. Skipping POM generation for FeatureSet " + feature);
                }
                LibraryProcessorManager.processLibraries();
            }
            if (globalPomGen) {
                PomProcessor.processPendingPOMs(installerWrapper, Mode.DEINSTALL);
            } else {
                _log.info("POM generation disabled for all distributions in the current Oracle Home. Skipping POM generation post processing.");
            }
            NioDelete.delete((Path)this._oracleHome.resolve("tempInventory"));
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    @Override
    public boolean rollbackLibraries(String patchID) throws LibraryException {
        this.configureLog();
        RegenerationHelper.getInstance().rollBackMetadata(this._oracleHome, patchID);
        try {
            this.regenerateLibrary();
        }
        catch (LibraryException e) {
            _log.throwing(this.getClass().getName(), "rollbackLibraries", (Throwable)((Object)e));
            throw e;
        }
        finally {
            this.closeLog();
        }
        return true;
    }

    public static void main(String ... args) throws LibraryException {
        String oracleHome = "";
        String patchID = "";
        LinkedHashMap<Path, Set<String>> libraryFiles = new LinkedHashMap<Path, Set<String>>();
        boolean query = false;
        String libraryType = "";
        _log.info("Invoked libraries regeneration.");
        Inputs inputs = InputHandler.getInputs();
        try {
            ArrayList<String> cmdWithOpMode = new ArrayList<String>(Arrays.asList(args));
            cmdWithOpMode.add("-regenerateLibraries");
            boolean success = inputs.parseCommandLineArgs(cmdWithOpMode.toArray(new String[cmdWithOpMode.size()]), false);
            if (success) {
                String log = "stdout";
                String logLevel = Level.INFO.getName();
                if (inputs.isHelpRequested()) {
                    _log.info("Basic regeneration example:");
                    _log.info("LibraryGeneratorImpl -oracleHome <OracleHome> -patchID <patchString> -modifiedFiles <comma separated list of paths that were modified>");
                    _log.info("Query example:");
                    _log.info("LibraryGeneratorImpl -oracleHome <OracleHome> -modifiedFiles <comma separated list of paths that were modified> -query");
                } else {
                    if (!((Option)inputs.getOptions().getValidOptions().get("oracleHome")).isValueSet()) {
                        throw new LibraryException("-oracleHome parameter must be set.");
                    }
                    oracleHome = ((Option)inputs.getOptions().getValidOptions().get("oracleHome")).getValue().toString();
                    if (((Option)inputs.getOptions().getValidOptions().get("patchID")).isValueSet()) {
                        patchID = ((Option)inputs.getOptions().getValidOptions().get("patchID")).getValue().toString();
                    }
                    query = ((Option)inputs.getOptions().getValidOptions().get("query")).isValueSet();
                    if (((Option)inputs.getOptions().getValidOptions().get("libraryType")).isValueSet()) {
                        libraryType = ((Option)inputs.getOptions().getValidOptions().get("libraryType")).getValue().toString();
                    }
                    if (((Option)inputs.getOptions().getValidOptions().get("modifiedFiles")).isValueSet()) {
                        String modifiedFiles = ((Option)inputs.getOptions().getValidOptions().get("modifiedFiles")).getValue().toString();
                        for (Iterator<Object> iterator : modifiedFiles.split(",")) {
                            libraryFiles.put(NioHelper.getInstance().getPath(iterator, new String[0]), new LinkedHashSet());
                        }
                    }
                    if (((Option)inputs.getOptions().getValidOptions().get("logLevel")).isValueSet()) {
                        logLevel = ((Option)inputs.getOptions().getValidOptions().get("logLevel")).getValue().toString();
                    }
                }
                LogFactory.getFactory().setupLogging(log, logLevel, new String[0]);
                LibraryGeneratorImpl generator = new LibraryGeneratorImpl(NioHelper.getInstance().getPath(oracleHome, new String[0]));
                _log.info("Processing libraries at " + FileUtils.formatPath(oracleHome));
                if (libraryFiles.size() > 0) {
                    String msg = "Files to be proccessed: \n\r";
                    for (Path file : libraryFiles.keySet()) {
                        msg = msg + file + "\n\r";
                    }
                    _log.info(msg);
                }
                if (query) {
                    Set<Path> result = generator.queryLibraryPaths(libraryFiles);
                    if (result.size() > 0) {
                        _log.info("Libraries that need regeneration: ");
                        for (Path library : result) {
                            _log.info(library.toString());
                        }
                    } else {
                        _log.info("There aren't any libraries that need regeneration.");
                    }
                } else {
                    generator.regenerateLibraryPaths(libraryFiles, patchID, libraryType);
                }
                _log.info("Completed library regeneration at " + FileUtils.formatPath(oracleHome));
            } else {
                _log.info("Failed to parse library regeneration arguments: " + inputs.getErrorMessages());
            }
        }
        catch (InputHandlerException e) {
            e.printStackTrace();
        }
    }
}

